/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.job.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.common.api.sysCalendar.dto.DayTypeDto;
import com.jxdinfo.crm.common.api.sysCalendar.dto.RecycleReasonDate;
import com.jxdinfo.crm.common.api.sysCalendar.service.ISysCalendarBoService;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.PublicPoolRule;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.WhiteListMember;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.service.IPublicPoolRuleService;
import com.jxdinfo.crm.core.customer.constant.CustomerPoolEditConstant;
import com.jxdinfo.crm.core.customer.dao.CustomerMapper;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.customerpool.customerpool.model.CustomerPoolEntity;
import com.jxdinfo.crm.core.customerpool.customerpool.model.CustomerPoolMemberEntity;
import com.jxdinfo.crm.core.customerpool.customerpool.service.ICustomerPoolMemberService;
import com.jxdinfo.crm.core.customerpool.customerpool.service.ICustomerPoolService;
import com.jxdinfo.crm.core.customerpool.customerpool.vo.RecycleCustomerReasonTimeVo;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.model.CustomerRecycleRule;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.model.PoolCustomerEntity;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.model.RuleCondition;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.service.IPoolCustomerService;
import com.jxdinfo.crm.core.job.model.CustomerEntityRecycle;
import com.jxdinfo.crm.core.job.model.CustomerFieldEntity;
import com.jxdinfo.crm.core.job.service.CustomerRecycleService;
import com.jxdinfo.crm.core.job.service.ICustomerRecycleFieldService;
import com.jxdinfo.crm.core.marketingactivity.service.MarketingActivityService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CustomerRecycleServiceImpl
implements CustomerRecycleService {
    @Resource
    private IPoolCustomerService poolCustomerService;
    @Resource
    private CustomerService customerService;
    @Resource
    private ICrmBaseConfigBoService baseConfigBoService;
    @Resource
    private ISysCalendarBoService calendarBoService;
    @Resource
    private IPublicPoolRuleService publicPoolRuleService;
    @Resource
    private ICustomerPoolService customerPoolService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private ICustomerRecycleFieldService dataMonitorFieldService;
    @Resource
    private CustomerMapper customerMapper;
    @Resource
    private IOrganUserBoService organUserBoService;
    @Resource
    private MarketingActivityService marketingActivityService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private ICustomerPoolMemberService customerPoolMemberService;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;

    @Override
    public ProcessResult customerRecycle() {
        boolean oldPoolFirst = "1".equals(this.crmBaseConfigBoService.getCrmBaseConfigByKey("customer_old_pool_first").getConfigValue());
        HashMap<Long, CustomerEntityRecycle> customerIdTargetPoolIdMap = new HashMap<Long, CustomerEntityRecycle>();
        List publicPoolRuleList = this.publicPoolRuleService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PublicPoolRule::getDelFlag, (Object)"0")).eq(PublicPoolRule::getPublicPoolRuleModule, (Object)"customerPool")).eq(PublicPoolRule::getPublicPoolRuleRecycleSwitch, (Object)"1"));
        if (CollectionUtils.isEmpty((Collection)publicPoolRuleList)) {
            return new ProcessResult(true);
        }
        List customerPoolEntityList = this.customerPoolService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CustomerPoolEntity::getCustomerPoolRuleId, (Collection)publicPoolRuleList.stream().map(PublicPoolRule::getPublicPoolRuleId).collect(Collectors.toList()))).eq(CustomerPoolEntity::getDelFlag, (Object)"0")).orderByAsc(CustomerPoolEntity::getCustomerPoolOrder));
        HashMap<Long, CustomerRecycleRule> poolIdRuleMap = new HashMap<Long, CustomerRecycleRule>();
        HashMap<Long, CustomerRecycleRule> poolIdRuleMap2 = new HashMap<Long, CustomerRecycleRule>();
        block0: for (CustomerPoolEntity customerPoolEntity : customerPoolEntityList) {
            for (Object publicPoolRule : publicPoolRuleList) {
                if (!publicPoolRule.getPublicPoolRuleId().equals(customerPoolEntity.getCustomerPoolRuleId())) continue;
                CustomerRecycleRule customerRecycleRule = (CustomerRecycleRule)JsonUtil.parse((String)publicPoolRule.getPublicPoolRuleRecycle(), CustomerRecycleRule.class);
                CustomerRecycleRule customerRecycleRule2 = (CustomerRecycleRule)JsonUtil.parse((String)publicPoolRule.getPublicPoolRuleRecycle(), CustomerRecycleRule.class);
                poolIdRuleMap.put(customerPoolEntity.getCustomerPoolId(), customerRecycleRule);
                poolIdRuleMap2.put(customerPoolEntity.getCustomerPoolId(), customerRecycleRule2);
                continue block0;
            }
        }
        List customerEntityList = this.customerService.list((Wrapper)new LambdaQueryWrapper().eq(CustomerEntity::getDelFlag, (Object)"0"));
        LocalDateTime dateTime = LocalDateTime.now();
        LocalDate dateNow = LocalDate.now();
        for (CustomerPoolEntity customerPool : customerPoolEntityList) {
            Set<Long> memberSet = this.getMemberSet(customerPool.getCustomerPoolId());
            if (CollectionUtils.isEmpty(memberSet)) continue;
            Long customerPoolId = customerPool.getCustomerPoolId();
            CustomerRecycleRule recycleRule = (CustomerRecycleRule)poolIdRuleMap.get(customerPoolId);
            ArrayList<CustomerEntity> customerListTemp = new ArrayList<CustomerEntity>(customerEntityList);
            customerListTemp.removeIf(customerEntity -> !memberSet.contains(customerEntity.getChargePersonId()));
            if (!"1".equals(recycleRule.getRecycleRange())) {
                RuleCondition rangeRule = recycleRule.getRangeRule();
                for (RuleCondition condition : rangeRule.getChildren()) {
                    if (!"8".equals(condition.getMatch())) continue;
                    ArrayList<DayTypeDto> list = new ArrayList<DayTypeDto>();
                    DayTypeDto dto = new DayTypeDto();
                    dto.setDateType(recycleRule.getTimeType());
                    dto.setDay(Integer.valueOf(Integer.parseInt(condition.getValue1())));
                    dto.setSwitchFlag("1");
                    list.add(dto);
                    LocalDate date = (LocalDate)this.calendarBoService.getStartDate(list, LocalDate.now()).get(0);
                    condition.setValue1(String.valueOf(ChronoUnit.DAYS.between(date, dateNow)));
                }
                List<Long> customerIdList = this.getCustomer(rangeRule);
                customerListTemp.removeIf(customerEntity -> !customerIdList.contains(customerEntity.getCustomerId()));
            }
            if (CollectionUtils.isEmpty(customerListTemp)) continue;
            List<RuleCondition> recycleConditions = recycleRule.getCondition();
            boolean firstRuleFlag = true;
            HashSet<Long> filterCustomerIdSet = new HashSet<Long>();
            HashMap<Long, String> idReasonMap = new HashMap<Long, String>();
            for (RuleCondition condition : recycleConditions) {
                List<RuleCondition> childrenCondition = condition.getChildren();
                for (RuleCondition ruleCondition : childrenCondition) {
                    if (!"8".equals(ruleCondition.getMatch())) continue;
                    ArrayList<DayTypeDto> list = new ArrayList<DayTypeDto>();
                    DayTypeDto dto = new DayTypeDto();
                    dto.setDateType(recycleRule.getTimeType());
                    dto.setDay(Integer.valueOf(Integer.parseInt(ruleCondition.getValue1())));
                    dto.setSwitchFlag("1");
                    list.add(dto);
                    LocalDate date = (LocalDate)this.calendarBoService.getStartDate(list, LocalDate.now()).get(0);
                    ruleCondition.setValue1(String.valueOf(ChronoUnit.DAYS.between(date, dateNow)));
                }
                List<Long> tempIdList = this.getCustomer(condition);
                if (!CollectionUtils.isEmpty(tempIdList)) {
                    for (Long customerId : tempIdList) {
                        String reason;
                        if (idReasonMap.get(customerId) != null) {
                            reason = (String)idReasonMap.get(customerId);
                            idReasonMap.put(customerId, reason + "," + condition.getRuleName());
                            continue;
                        }
                        reason = condition.getRuleName();
                        idReasonMap.put(customerId, reason);
                    }
                }
                if (firstRuleFlag) {
                    if (!CollectionUtils.isEmpty(tempIdList)) {
                        filterCustomerIdSet.addAll(tempIdList);
                    }
                    if (CollectionUtils.isEmpty(tempIdList) && "and".equals(condition.getRelation())) break;
                    firstRuleFlag = false;
                    continue;
                }
                if ("and".equals(condition.getRelation())) {
                    if (CollectionUtils.isEmpty(tempIdList)) {
                        filterCustomerIdSet.clear();
                        continue;
                    }
                    filterCustomerIdSet.removeIf(o -> !tempIdList.contains(o));
                    continue;
                }
                if (CollectionUtils.isEmpty(tempIdList)) continue;
                filterCustomerIdSet.addAll(tempIdList);
            }
            customerListTemp.removeIf(customerEntity -> !filterCustomerIdSet.contains(customerEntity.getCustomerId()));
            if (CollectionUtils.isEmpty(customerListTemp)) continue;
            if (!CollectionUtils.isEmpty(recycleRule.getWhiteList())) {
                List whiteUserIdList = recycleRule.getWhiteList().stream().map(WhiteListMember::getValue).collect(Collectors.toList());
                List whiteCustomerIdList = this.customerService.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{CustomerEntity::getCustomerId}).in(CustomerEntity::getChargePersonId, whiteUserIdList)).eq(CustomerEntity::getDelFlag, (Object)"0"), o -> (Long)o);
                if (!CollectionUtils.isEmpty((Collection)whiteCustomerIdList)) {
                    customerListTemp.removeIf(customerEntity -> !whiteCustomerIdList.contains(customerEntity.getCustomerId()));
                }
            }
            if (CollectionUtils.isEmpty(customerListTemp)) continue;
            if (oldPoolFirst) {
                ArrayList<Long> intoOldPoolIdList = new ArrayList<Long>();
                for (CustomerEntity customer : customerListTemp) {
                    Long customerId = customer.getCustomerId();
                    if (customer.getResourcePoolId() != null && !customer.getResourcePoolId().equals(customerPoolId)) {
                        if (customerIdTargetPoolIdMap.containsKey(customerId)) continue;
                        CustomerEntityRecycle customerEntityRecycle = new CustomerEntityRecycle();
                        customerEntityRecycle.setReason((String)idReasonMap.get(customerId));
                        customerEntityRecycle.setCustomerPoolId(customerPoolId);
                        customerIdTargetPoolIdMap.put(customerId, customerEntityRecycle);
                        intoOldPoolIdList.add(customerId);
                        continue;
                    }
                    if (customer.getResourcePoolId() == null || !customer.getResourcePoolId().equals(customerPoolId)) continue;
                    ((CustomerEntityRecycle)customerIdTargetPoolIdMap.get(customerId)).setCustomerPoolId(-1L);
                }
                customerListTemp.removeIf(customerEntity -> intoOldPoolIdList.contains(customerEntity.getCustomerId()));
            }
            this.recycle(customerListTemp, idReasonMap, customerPoolId, dateTime);
            List recycleIdList = customerListTemp.stream().map(CustomerEntity::getCustomerId).collect(Collectors.toList());
            customerEntityList.removeIf(customerEntity -> recycleIdList.contains(customerEntity.getCustomerId()));
        }
        if (oldPoolFirst) {
            HashMap poolIdCustomerListMap = new HashMap();
            ArrayList recycleToOldPoolId = new ArrayList();
            Map<Long, String> idReasonMap = customerIdTargetPoolIdMap.values().stream().collect(Collectors.toMap(CustomerEntityRecycle::getCustomerId, CustomerEntityRecycle::getReason));
            Map<Long, CustomerEntity> customerEntityMap = customerEntityList.stream().collect(Collectors.toMap(CustomerEntity::getCustomerId, customerEntity -> customerEntity));
            for (Map.Entry entry : customerIdTargetPoolIdMap.entrySet()) {
                Long customerId = (Long)entry.getKey();
                if (((CustomerEntityRecycle)entry.getValue()).getCustomerPoolId() == -1L) continue;
                recycleToOldPoolId.add(entry.getKey());
                CustomerEntity customerEntity2 = customerEntityMap.get(customerId);
                if (!poolIdCustomerListMap.containsKey(customerId)) {
                    ArrayList<CustomerEntity> list = new ArrayList<CustomerEntity>();
                    list.add(customerEntity2);
                    poolIdCustomerListMap.put(((CustomerEntityRecycle)entry.getValue()).getCustomerPoolId(), list);
                    continue;
                }
                ((List)poolIdCustomerListMap.get(((CustomerEntityRecycle)entry.getValue()).getCustomerPoolId())).add(customerEntity2);
            }
            for (Map.Entry entry : poolIdCustomerListMap.entrySet()) {
                this.recycle((List)entry.getValue(), idReasonMap, (Long)entry.getKey(), dateTime);
            }
        }
        this.updateRecycleTime(customerEntityList, customerPoolEntityList, poolIdRuleMap2);
        return new ProcessResult(true);
    }

    @Nullable
    private Set<Long> getMemberSet(Long poolId) {
        List<Long> roleId;
        List memberEntityList = this.customerPoolMemberService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerPoolMemberEntity::getCustomerPoolId, (Object)poolId)).eq(CustomerPoolMemberEntity::getMemberRole, (Object)"1"));
        if (CollectionUtils.isEmpty((Collection)memberEntityList)) {
            return null;
        }
        Set<Long> memberSet = memberEntityList.stream().filter(customerPoolMemberEntity -> "1".equals(customerPoolMemberEntity.getMemberType())).map(CustomerPoolMemberEntity::getMemberId).collect(Collectors.toSet());
        List deptId = memberEntityList.stream().filter(customerPoolMemberEntity -> "2".equals(customerPoolMemberEntity.getMemberType())).map(CustomerPoolMemberEntity::getMemberId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(deptId)) {
            deptId = this.organUserBoService.getOrganByParentIdContainsParent(deptId);
            deptId = deptId.stream().distinct().collect(Collectors.toList());
            List userList = this.hussarBaseUserBoService.getStruUserByStruIds(deptId);
            memberSet.addAll(userList.stream().map(SysStruUser::getUserId).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(roleId = memberEntityList.stream().filter(customerPoolMemberEntity -> "3".equals(customerPoolMemberEntity.getMemberType())).map(CustomerPoolMemberEntity::getMemberId).collect(Collectors.toList()))) {
            List<Long> userList = this.commonMapper.getUserByRoleIdBatch(roleId);
            memberSet.addAll(userList);
        }
        return memberSet;
    }

    private void updateRecycleTime(List<CustomerEntity> customerEntityList, List<CustomerPoolEntity> customerPoolEntityList, Map<Long, CustomerRecycleRule> poolIdRuleMap) {
        HashMap<Long, RecycleCustomerReasonTimeVo> customerIdRecycleMap = new HashMap<Long, RecycleCustomerReasonTimeVo>();
        List timeFieldIds = this.dataMonitorFieldService.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{CustomerFieldEntity::getFieldId}).eq(CustomerFieldEntity::getTargetType, (Object)"1")).eq(CustomerFieldEntity::getConditionType, (Object)"4"), String::valueOf);
        Map<String, String> fieldNameMap = this.dataMonitorFieldService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerFieldEntity::getTargetType, (Object)"1")).eq(CustomerFieldEntity::getConditionType, (Object)"4")).stream().collect(Collectors.toMap(c -> String.valueOf(c.getFieldId()), CustomerFieldEntity::getFieldName));
        for (CustomerPoolEntity customerPool : customerPoolEntityList) {
            Set<Long> memberSet = this.getMemberSet(customerPool.getCustomerPoolId());
            if (CollectionUtils.isEmpty(memberSet)) continue;
            ArrayList<CustomerEntity> customers = new ArrayList<CustomerEntity>(customerEntityList);
            customers.removeIf(customerEntity -> !memberSet.contains(customerEntity.getChargePersonId()));
            CustomerRecycleRule recycleRule = poolIdRuleMap.get(customerPool.getCustomerPoolId());
            String string = recycleRule.getTimeType();
            HashMap<String, List<CustomerEntity>> groupListMap = new HashMap<String, List<CustomerEntity>>();
            List<Object> timeConditions = new ArrayList();
            if (!"1".equals(recycleRule.getRecycleRange())) {
                RuleCondition rangeRule = recycleRule.getRangeRule();
                List<RuleCondition> childCondition = rangeRule.getChildren();
                String relation = childCondition.get(0).getRelation();
                String rangeRuleRelation = childCondition.get(0).getRelation();
                timeConditions = childCondition.stream().filter(ruleCondition -> timeFieldIds.contains(ruleCondition.getFieldId()) && "8".equals(ruleCondition.getMatch())).collect(Collectors.toList());
                List<RuleCondition> otherConditions = childCondition.stream().filter(ruleCondition -> !timeFieldIds.contains(ruleCondition.getFieldId()) || !"8".equals(ruleCondition.getMatch())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(otherConditions)) {
                    ((RuleCondition)otherConditions.get(0)).setRelation(rangeRuleRelation);
                    rangeRule.setChildren(otherConditions);
                    List<Long> matchOtherList = !CollectionUtils.isEmpty(otherConditions) ? this.getCustomer(rangeRule) : new ArrayList<Long>();
                    List customerMatchOtherList = customers.stream().filter(customerEntity -> matchOtherList.contains(customerEntity.getCustomerId())).collect(Collectors.toList());
                    if ("or".equals(relation) && !CollectionUtils.isEmpty(timeConditions)) {
                        groupListMap.put("time", customers);
                    }
                    groupListMap.put("other", customerMatchOtherList);
                }
            } else {
                groupListMap.put("other", customers);
            }
            List<RuleCondition> recycleConditions = recycleRule.getCondition();
            String relation = recycleConditions.get(0).getChildren().get(0).getRelation();
            ArrayList mapList = new ArrayList();
            for (RuleCondition recycleCondition : recycleConditions) {
                List customerList;
                HashMap childMap;
                List<Long> recycleCustomerIds;
                List<RuleCondition> childrenRecycleConditions = recycleCondition.getChildren();
                List recycleTimeConditions = childrenRecycleConditions.stream().filter(ruleCondition -> timeFieldIds.contains(ruleCondition.getFieldId()) && "8".equals(ruleCondition.getMatch())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(timeConditions) && CollectionUtils.isEmpty(recycleTimeConditions)) continue;
                List<RuleCondition> recycleOtherConditions = childrenRecycleConditions.stream().filter(ruleCondition -> !timeFieldIds.contains(ruleCondition.getFieldId()) || !"8".equals(ruleCondition.getMatch())).collect(Collectors.toList());
                HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
                if ("and".equals(relation)) {
                    if (!CollectionUtils.isEmpty(recycleOtherConditions)) {
                        ((RuleCondition)recycleOtherConditions.get(0)).setRelation(relation);
                        recycleCondition.setChildren(recycleOtherConditions);
                        recycleCustomerIds = this.getCustomer(recycleCondition);
                    } else {
                        recycleCustomerIds = null;
                    }
                    childMap = new HashMap();
                    if (recycleCustomerIds != null) {
                        for (Map.Entry entry : groupListMap.entrySet()) {
                            customerList = ((List)entry.getValue()).stream().filter(customerEntity -> recycleCustomerIds.contains(customerEntity.getCustomerId())).collect(Collectors.toList());
                            childMap.put(entry.getKey(), customerList);
                        }
                        stringObjectMap.put("listMap", childMap);
                        stringObjectMap.put("reason", recycleCondition.getRuleName());
                        stringObjectMap.put("timeRule", recycleTimeConditions);
                    } else {
                        stringObjectMap.put("listMap", groupListMap);
                        stringObjectMap.put("reason", recycleCondition.getRuleName());
                        stringObjectMap.put("timeRule", recycleTimeConditions);
                    }
                } else if (CollectionUtils.isEmpty(timeConditions)) {
                    stringObjectMap.put("listMap", groupListMap);
                    stringObjectMap.put("reason", recycleCondition.getRuleName());
                    stringObjectMap.put("timeRule", recycleTimeConditions);
                } else {
                    recycleCondition.setChildren(recycleOtherConditions);
                    recycleCustomerIds = !CollectionUtils.isEmpty(recycleOtherConditions) ? this.getCustomer(recycleCondition) : new ArrayList<Long>();
                    childMap = new HashMap();
                    for (Map.Entry entry : groupListMap.entrySet()) {
                        customerList = ((List)entry.getValue()).stream().filter(customerEntity -> recycleCustomerIds.contains(customerEntity.getCustomerId())).collect(Collectors.toList());
                        childMap.put(entry.getKey(), customerList);
                    }
                    stringObjectMap.put("listMap", childMap);
                    stringObjectMap.put("reason", recycleCondition.getRuleName());
                    stringObjectMap.put("timeRule", recycleTimeConditions);
                }
                List ruleTimeConditions = (List)stringObjectMap.get("timeRule");
                String reason = (String)stringObjectMap.get("reason");
                for (Map.Entry listEntry : ((Map)stringObjectMap.get("listMap")).entrySet()) {
                    Long id;
                    List customerEntities = (List)listEntry.getValue();
                    HashMap<Long, LocalDate> idDateMapRange = new HashMap<Long, LocalDate>();
                    HashMap<Long, LocalDate> idDateMap = new HashMap<Long, LocalDate>();
                    for (RuleCondition ruleCondition2 : timeConditions) {
                        HashMap dtoListMap = new HashMap();
                        ArrayList<DayTypeDto> dtos = new ArrayList<DayTypeDto>();
                        DayTypeDto dto = new DayTypeDto();
                        dto.setDay(Integer.valueOf(Integer.parseInt(ruleCondition2.getValue1())));
                        dto.setDateType(string);
                        dtos.add(dto);
                        HashMap<Long, LocalDate> dateMap = new HashMap<Long, LocalDate>();
                        for (CustomerEntity customerEntity2 : customerEntities) {
                            Object value;
                            LocalDateTime maxDateTime;
                            Object field = null;
                            String fieldName = fieldNameMap.get(ruleCondition2.getFieldId());
                            if ("createTime".equals(fieldName)) {
                                maxDateTime = customerEntity2.getCreateTime();
                                if (customerEntity2.getClaimTime() != null && customerEntity2.getClaimTime().isAfter(maxDateTime)) {
                                    maxDateTime = customerEntity2.getClaimTime();
                                }
                                if (customerEntity2.getAllocateTime() != null && customerEntity2.getAllocateTime().isAfter(maxDateTime)) {
                                    maxDateTime = customerEntity2.getAllocateTime();
                                }
                                value = maxDateTime;
                            } else if ("trackTime".equals(fieldName)) {
                                maxDateTime = customerEntity2.getCreateTime();
                                if (customerEntity2.getTrackTime() != null && customerEntity2.getTrackTime().isAfter(maxDateTime)) {
                                    maxDateTime = customerEntity2.getTrackTime();
                                }
                                if (customerEntity2.getClaimTime() != null && customerEntity2.getClaimTime().isAfter(maxDateTime)) {
                                    maxDateTime = customerEntity2.getClaimTime();
                                }
                                if (customerEntity2.getAllocateTime() != null && customerEntity2.getAllocateTime().isAfter(maxDateTime)) {
                                    maxDateTime = customerEntity2.getAllocateTime();
                                }
                                value = maxDateTime;
                            } else {
                                try {
                                    field = CustomerEntity.class.getDeclaredField(fieldName);
                                    ((Field)field).setAccessible(true);
                                    value = ((Field)field).get(customerEntity2);
                                    if (value == null) {
                                        continue;
                                    }
                                }
                                catch (IllegalAccessException | NoSuchFieldException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            LocalDate date = LocalDate.from((TemporalAccessor)value);
                            dateMap.put(customerEntity2.getCustomerId(), date);
                            dtoListMap.put(customerEntity2.getCustomerId(), dtos);
                        }
                        Map recycleReasonDateMap = this.calendarBoService.getRecycleTime(dtoListMap, dateMap);
                        boolean orFlag = "or".equals(recycleRule.getRangeRule().getChildren().get(0).getRelation());
                        for (Map.Entry entry : recycleReasonDateMap.entrySet()) {
                            id = (Long)entry.getKey();
                            if (idDateMapRange.get(id) == null) {
                                idDateMapRange.put(id, ((RecycleReasonDate)entry.getValue()).getDate());
                                continue;
                            }
                            if (orFlag) {
                                if (!((LocalDate)idDateMapRange.get(id)).isBefore(((RecycleReasonDate)entry.getValue()).getDate())) continue;
                                idDateMapRange.put(id, ((RecycleReasonDate)entry.getValue()).getDate());
                                continue;
                            }
                            if (!((LocalDate)idDateMapRange.get(id)).isAfter(((RecycleReasonDate)entry.getValue()).getDate())) continue;
                            idDateMapRange.put(id, ((RecycleReasonDate)entry.getValue()).getDate());
                        }
                    }
                    if (!CollectionUtils.isEmpty((Collection)ruleTimeConditions)) {
                        boolean orFlag = "or".equals(((RuleCondition)ruleTimeConditions.get(0)).getRelation());
                        for (RuleCondition timeCondition2 : ruleTimeConditions) {
                            HashMap dtoListMap = new HashMap();
                            ArrayList<DayTypeDto> dtos = new ArrayList<DayTypeDto>();
                            DayTypeDto dto = new DayTypeDto();
                            dto.setDay(Integer.valueOf(Integer.parseInt(timeCondition2.getValue1())));
                            dto.setDateType(string);
                            dtos.add(dto);
                            HashMap<Long, LocalDate> dateMap = new HashMap<Long, LocalDate>();
                            for (CustomerEntity customerEntity3 : customerEntities) {
                                Object value;
                                LocalDateTime maxDateTime;
                                String fieldName = fieldNameMap.get(timeCondition2.getFieldId());
                                if ("createTime".equals(fieldName)) {
                                    maxDateTime = customerEntity3.getCreateTime();
                                    if (customerEntity3.getClaimTime() != null && customerEntity3.getClaimTime().isAfter(maxDateTime)) {
                                        maxDateTime = customerEntity3.getClaimTime();
                                    }
                                    if (customerEntity3.getAllocateTime() != null && customerEntity3.getAllocateTime().isAfter(maxDateTime)) {
                                        maxDateTime = customerEntity3.getAllocateTime();
                                    }
                                    value = maxDateTime;
                                } else if ("trackTime".equals(fieldName)) {
                                    maxDateTime = customerEntity3.getCreateTime();
                                    if (customerEntity3.getTrackTime() != null && customerEntity3.getTrackTime().isAfter(maxDateTime)) {
                                        maxDateTime = customerEntity3.getTrackTime();
                                    }
                                    if (customerEntity3.getClaimTime() != null && customerEntity3.getClaimTime().isAfter(maxDateTime)) {
                                        maxDateTime = customerEntity3.getClaimTime();
                                    }
                                    if (customerEntity3.getAllocateTime() != null && customerEntity3.getAllocateTime().isAfter(maxDateTime)) {
                                        maxDateTime = customerEntity3.getAllocateTime();
                                    }
                                    value = maxDateTime;
                                } else {
                                    try {
                                        Field field = CustomerEntity.class.getDeclaredField(fieldName);
                                        field.setAccessible(true);
                                        value = field.get(customerEntity3);
                                    }
                                    catch (IllegalAccessException | NoSuchFieldException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                                if (value == null) continue;
                                LocalDate date = LocalDate.from((TemporalAccessor)value);
                                dateMap.put(customerEntity3.getCustomerId(), date);
                                dtoListMap.put(customerEntity3.getCustomerId(), dtos);
                            }
                            Map recycleReasonDateMap = this.calendarBoService.getRecycleTime(dtoListMap, dateMap);
                            for (Map.Entry entry : recycleReasonDateMap.entrySet()) {
                                id = (Long)entry.getKey();
                                if (idDateMap.get(id) == null) {
                                    idDateMap.put(id, ((RecycleReasonDate)entry.getValue()).getDate());
                                    continue;
                                }
                                if (orFlag) {
                                    if (!((LocalDate)idDateMap.get(id)).isBefore(((RecycleReasonDate)entry.getValue()).getDate())) continue;
                                    idDateMap.put(id, ((RecycleReasonDate)entry.getValue()).getDate());
                                    continue;
                                }
                                if (!((LocalDate)idDateMap.get(id)).isAfter(((RecycleReasonDate)entry.getValue()).getDate())) continue;
                                idDateMap.put(id, ((RecycleReasonDate)entry.getValue()).getDate());
                            }
                        }
                        for (Map.Entry entry : idDateMap.entrySet()) {
                            LocalDate recycleDate = (LocalDate)idDateMapRange.get(entry.getKey());
                            if (recycleDate != null && !recycleDate.isBefore((ChronoLocalDate)entry.getValue())) continue;
                            idDateMapRange.put((Long)entry.getKey(), (LocalDate)entry.getValue());
                        }
                    }
                    for (Map.Entry entry : idDateMapRange.entrySet()) {
                        RecycleCustomerReasonTimeVo reasonTimeVo;
                        Long id2 = (Long)entry.getKey();
                        if (customerIdRecycleMap.get(id2) == null) {
                            reasonTimeVo = new RecycleCustomerReasonTimeVo();
                            reasonTimeVo.setRecycleReason(reason);
                            reasonTimeVo.setCustomerId(id2);
                            reasonTimeVo.setRecycleTime((LocalDate)entry.getValue());
                            customerIdRecycleMap.put(reasonTimeVo.getCustomerId(), reasonTimeVo);
                            continue;
                        }
                        if (!((LocalDate)entry.getValue()).isBefore(((RecycleCustomerReasonTimeVo)customerIdRecycleMap.get(id2)).getRecycleTime())) continue;
                        reasonTimeVo = (RecycleCustomerReasonTimeVo)customerIdRecycleMap.get(id2);
                        reasonTimeVo.setRecycleTime((LocalDate)entry.getValue());
                        reasonTimeVo.setRecycleReason(reason);
                        customerIdRecycleMap.put(id2, reasonTimeVo);
                    }
                }
            }
        }
        ArrayList<CustomerEntityRecycle> customerEntities = new ArrayList<CustomerEntityRecycle>();
        ArrayList<CustomerEntity> customerUpdateList = new ArrayList<CustomerEntity>();
        Map<Long, CustomerEntity> customerMap = customerEntityList.stream().collect(Collectors.toMap(CustomerEntity::getCustomerId, customerEntity -> customerEntity));
        List customerIdList = customerEntityList.stream().map(CustomerEntity::getCustomerId).collect(Collectors.toList());
        for (Map.Entry entry : customerIdRecycleMap.entrySet()) {
            Long chargePersonId;
            if (!customerIdList.contains(entry.getKey()) || (chargePersonId = customerMap.get(entry.getKey()).getChargePersonId()) == null) continue;
            CustomerEntityRecycle customerEntity4 = new CustomerEntityRecycle();
            CustomerEntity customer = new CustomerEntity();
            customer.setCustomerId((Long)entry.getKey());
            customerEntity4.setCustomerId((Long)entry.getKey());
            customer.setRecycleTime(((RecycleCustomerReasonTimeVo)entry.getValue()).getRecycleTime());
            customerEntity4.setRecycleReasonAndDate(((RecycleCustomerReasonTimeVo)entry.getValue()).getRecycleReason() + "\uffe5\uff01\uffe5\uff01\uffe5" + ((RecycleCustomerReasonTimeVo)entry.getValue()).getRecycleTime().toString() + "\uffe5\uff01\uffe5\uff01\uffe5" + customerMap.get(entry.getKey()).getChargePersonId());
            customerEntities.add(customerEntity4);
            customerUpdateList.add(customer);
        }
        this.customerService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(CustomerEntity::getDelFlag, (Object)"0")).set(CustomerEntity::getRecycleTime, null));
        this.customerService.updateBatchById(customerUpdateList);
        Map<String, List<CustomerEntityRecycle>> map = customerEntities.stream().collect(Collectors.groupingBy(CustomerEntityRecycle::getRecycleReasonAndDate));
        LocalDateTime localDateTime = LocalDateTime.now();
        for (Map.Entry<String, List<CustomerEntityRecycle>> entry : map.entrySet()) {
            String[] strings = entry.getKey().split("\uffe5\uff01\uffe5\uff01\uffe5");
            if (strings.length < 3) continue;
            List<CustomerEntityRecycle> customer = entry.getValue();
            String title = "\u5212\u5165\u516c\u6d77\u6c60\u9884\u8b66";
            String content = "\u60a8\u6709" + customer.size() + "\u6761\u5ba2\u6237\uff0c\u9884\u8ba1\u5c06\u5728" + strings[1] + "\u88ab\u7cfb\u7edf\u56de\u6536\u81f3\u516c\u6d77\u6c60\uff0c\u56de\u6536\u539f\u56e0\uff1a" + strings[0] + "\u3002\u8bf7\u53ca\u65f6\u5904\u7406\u3002";
            EimPushUtil.pushJqxArticleMessage(title, content, "/crm/sy/yddsy", null, Collections.singletonList(strings[2]));
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/index";
            String contentUnify = "\u3010\u5212\u5165\u516c\u6d77\u6c60\u9884\u8b66\u3011\u60a8\u6709" + customer.size() + "\u6761\u5ba2\u6237\uff0c\u9884\u8ba1\u5c06\u5728" + strings[1] + "\u88ab\u7cfb\u7edf\u56de\u6536\u81f3\u516c\u6d77\u6c60\uff0c\u56de\u6536\u539f\u56e0\uff1a" + strings[0] + "\u3002\u8bf7\u53ca\u65f6\u5904\u7406\u3002";
            SecurityUser user = new SecurityUser();
            user.setUserId(Long.valueOf(1450756958461300737L));
            user.setDeptId(Long.valueOf(-1L));
            UnifyUtil.defaultMessage(addSysMessageType, contentUnify, localDateTime, user, strings[2], "\u7cfb\u7edf", unifyWebUrl, "");
            UnifyUtil.sendMessage(addSysMessageType);
        }
    }

    private void recycle(List<CustomerEntity> customerList, Map<Long, String> reasonMap, Long targetPoolId, LocalDateTime dateTime) {
        CustomerPoolEntity customerPool = (CustomerPoolEntity)this.customerPoolService.getById(targetPoolId);
        ArrayList<PoolCustomerEntity> poolCustomerList = new ArrayList<PoolCustomerEntity>();
        for (CustomerEntity customerEntity2 : customerList) {
            PoolCustomerEntity poolCustomer = (PoolCustomerEntity)BeanUtil.copy((Object)customerEntity2, PoolCustomerEntity.class);
            poolCustomer.setCustomerPoolId(targetPoolId);
            poolCustomer.setOldChargePerson(customerEntity2.getChargePersonId());
            poolCustomer.setOldChargePersonName(customerEntity2.getChargePersonName());
            poolCustomer.setLastJoinTime(dateTime);
            poolCustomer.setLastJoinType("1");
            poolCustomer.setLastJoinUser(null);
            poolCustomer.setLastJoinUserName("\u7cfb\u7edf");
            poolCustomer.setLastJoinReason(reasonMap.get(customerEntity2.getCustomerId()));
            poolCustomer.setOldOwnDepartment(customerEntity2.getOwnDepartment());
            poolCustomer.setOldOwnDepartmentName(customerEntity2.getOwnDepartmentName());
            poolCustomer.setChangeTime(dateTime);
            poolCustomer.setChangePerson(null);
            poolCustomer.setChangePersonName("\u7cfb\u7edf");
            poolCustomer.setOwnDepartment(null);
            poolCustomer.setOwnDepartmentName(null);
            poolCustomer.setChargePersonId(null);
            poolCustomer.setChargePersonName(null);
            poolCustomer.setClaimApproval("0");
            poolCustomer.setLastClaimTime(customerEntity2.getClaimTime());
            poolCustomerList.add(poolCustomer);
        }
        this.poolCustomerService.saveBatch(poolCustomerList);
        this.customerService.removeByIds(customerList.stream().map(CustomerEntity::getCustomerId).collect(Collectors.toList()));
        List recordList = customerList.stream().map(customerEntity -> {
            HashMap<String, String> field = new HashMap<String, String>();
            ArrayList<HashMap<String, String>> changeField = new ArrayList<HashMap<String, String>>();
            HashMap<String, Object> before = new HashMap<String, Object>();
            HashMap<String, Object> after = new HashMap<String, Object>();
            before.put(CustomerPoolEditConstant.CHARGE_PERSON_TO_POOL_ID.getField(), customerEntity.getChargePersonId());
            after.put(CustomerPoolEditConstant.CHARGE_PERSON_TO_POOL_ID.getField(), customerPool.getCustomerPoolId());
            before.put(CustomerPoolEditConstant.CHARGE_PERSON_TO_POOL_NAME.getField(), customerEntity.getChargePersonName());
            after.put(CustomerPoolEditConstant.CHARGE_PERSON_TO_POOL_NAME.getField(), customerPool.getCustomerPoolName());
            field.put("field", CustomerPoolEditConstant.CHARGE_PERSON_TO_POOL_NAME.getField());
            field.put("fieldName", CustomerPoolEditConstant.CHARGE_PERSON_TO_POOL_NAME.getName());
            changeField.add(field);
            return this.customerService.getTrackRecord(customerEntity.getCustomerId(), customerEntity.getCustomerName(), CrmBusinessTypeEnum.CUSTOMER.getId(), dateTime, null, "\u7cfb\u7edf", JSON.toJSONString(before), JSON.toJSONString(after), JSON.toJSONString(changeField), RecordProductTypeEnum.PRODUCE_POOL_AUTO_RECYCLE.getId(), (String)reasonMap.get(customerEntity.getCustomerId()));
        }).collect(Collectors.toList());
        this.operateRecordAPIService.saveOperateLogBatch(recordList);
        Map<Long, List<PoolCustomerEntity>> chargePersonCustomerMap = poolCustomerList.stream().collect(Collectors.groupingBy(PoolCustomerEntity::getOldChargePerson));
        for (Map.Entry<Long, List<PoolCustomerEntity>> entry : chargePersonCustomerMap.entrySet()) {
            Map<String, List<PoolCustomerEntity>> resonEntryMap = entry.getValue().stream().collect(Collectors.groupingBy(PoolCustomerEntity::getLastJoinReason));
            for (Map.Entry<String, List<PoolCustomerEntity>> entry2 : resonEntryMap.entrySet()) {
                String title = "\u5212\u5165\u516c\u6d77\u6c60\u63d0\u9192";
                String content = "\u60a8\u6709" + entry2.getValue().size() + "\u6761\u5ba2\u6237\uff0c\u56e0\u89e6\u53d1\u81ea\u52a8\u56de\u6536\u89c4\u5219\uff1a\u3010" + entry2.getKey() + "\u3011\uff0c\u88ab\u7cfb\u7edf\u56de\u6536\u81f3" + customerPool.getCustomerPoolName() + "\u516c\u6d77\u6c60\u4e2d\uff0c\u8bf7\u77e5\u6089\u3002";
                EimPushUtil.pushJqxArticleMessage(title, content, "/crm/sy/yddsy", null, Collections.singletonList(String.valueOf(entry.getKey())));
                AddSysMessageType addSysMessageType = new AddSysMessageType();
                String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/index";
                String contentUnify = "\u3010\u5212\u5165\u516c\u6d77\u6c60\u63d0\u9192\u3011\u60a8\u6709" + entry2.getValue().size() + "\u6761\u5ba2\u6237\uff0c\u56e0\u89e6\u53d1\u81ea\u52a8\u56de\u6536\uff1a\u3010" + entry2.getKey() + "\u3011\uff0c\u88ab\u7cfb\u7edf\u56de\u6536\u81f3" + customerPool.getCustomerPoolName() + "\u516c\u6d77\u6c60\u4e2d\uff0c\u8bf7\u77e5\u6089\u3002";
                SecurityUser user = new SecurityUser();
                user.setUserId(Long.valueOf(1450756958461300737L));
                user.setDeptId(Long.valueOf(-1L));
                UnifyUtil.defaultMessage(addSysMessageType, contentUnify, dateTime, user, String.valueOf(entry.getKey()), "\u7cfb\u7edf", unifyWebUrl, "");
                UnifyUtil.sendMessage(addSysMessageType);
            }
        }
    }

    private List<Long> getCustomer(RuleCondition condition) {
        String tableName = "CRM_CUSTOMER";
        StringBuffer tableReferredName = new StringBuffer("cc");
        StringBuffer querySQL = new StringBuffer("SELECT cc.CUSTOMER_ID");
        querySQL.append(", ").append(tableReferredName).append(".").append("CHARGE_PERSON_ID").append(" AS ").append("HIDDEN_CHARGE_PERSON_ID");
        querySQL.append(" FROM ").append(tableName).append(" ").append(tableReferredName).append(" WHERE ");
        querySQL.append("(").append(tableReferredName).append(".DEL_FLAG = '0') AND ");
        ObjectMapper mapper = new ObjectMapper();
        condition.setRelation(null);
        if (!CollectionUtils.isEmpty(condition.getChildren())) {
            condition.getChildren().get(condition.getChildren().size() - 1).setRelation(null);
        }
        Map<String, Object> configMap = this.analysisConditionRelationTree(condition);
        List conditionEntityList = (List)configMap.get("conditionList");
        StringBuffer equation = (StringBuffer)configMap.get("equation");
        for (RuleCondition conditionEntity : conditionEntityList) {
            StringBuffer sql = this.generateSQL(conditionEntity, tableReferredName);
            int index = equation.indexOf(conditionEntity.getNodeId());
            if (index == -1) continue;
            int lengthToDelete = conditionEntity.getNodeId().length();
            equation.delete(index, index + lengthToDelete);
            equation.insert(index, sql);
        }
        querySQL.append(equation);
        try {
            List<Map<String, Object>> list = this.customerMapper.selectBySql(querySQL.toString());
            return list.stream().map(map -> (Long)map.get("CUSTOMER_ID")).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public Map<String, Object> analysisConditionRelationTree(RuleCondition rootCondition) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<RuleCondition> conditionEntityList = new ArrayList<RuleCondition>();
        LinkedList<RuleCondition> queue = new LinkedList<RuleCondition>();
        queue.offer(rootCondition);
        while (!queue.isEmpty()) {
            RuleCondition conditionEntity = (RuleCondition)queue.poll();
            if (ToolUtil.isNotEmpty((Object)conditionEntity.getFieldId())) {
                conditionEntity.setNodeId(CommonUtills.generateAssignId());
                conditionEntityList.add(conditionEntity);
            }
            if (!ToolUtil.isNotEmpty(conditionEntity.getChildren())) continue;
            for (RuleCondition child : conditionEntity.getChildren()) {
                queue.offer(child);
            }
        }
        resultMap.put("conditionList", conditionEntityList);
        StringBuffer equation = new StringBuffer();
        equation = this.conditionTreeDP(rootCondition, equation);
        resultMap.put("equation", equation);
        return resultMap;
    }

    private StringBuffer conditionTreeDP(RuleCondition condition, StringBuffer equation) {
        equation.append("(");
        for (RuleCondition child : condition.getChildren()) {
            equation = this.conditionTreeDP(child, equation);
        }
        if (ToolUtil.isNotEmpty((Object)condition.getFieldId())) {
            equation.append(condition.getNodeId());
        }
        equation.append(")");
        if (ToolUtil.isNotEmpty((Object)condition.getRelation())) {
            equation.append(condition.getRelation());
        }
        return equation;
    }

    private StringBuffer generateSQL(RuleCondition condition, StringBuffer tableReferredName) {
        StringBuffer sqlStr;
        block223: {
            CustomerFieldEntity customerFieldEntity;
            block222: {
                customerFieldEntity = (CustomerFieldEntity)this.dataMonitorFieldService.getOne((Wrapper)new LambdaQueryWrapper().eq(CustomerFieldEntity::getFieldId, (Object)Long.parseLong(condition.getFieldId())));
                if ("8".equals(condition.getMatch())) {
                    if ("createTime".equals(customerFieldEntity.getFieldName())) {
                        customerFieldEntity.setFieldDatabaseName("GREATEST(cc.CREATE_TIME,cc.CREATE_TIME, case when cc.CLAIM_TIME is not null then cc.CLAIM_TIME else '2000-01-01' end  , case when cc.ALLOCATE_TIME is not null then cc.ALLOCATE_TIME else '2000-01-01' end)");
                    }
                    if ("trackTime".equals(customerFieldEntity.getFieldName())) {
                        customerFieldEntity.setFieldDatabaseName("GREATEST(case when cc.TRACK_TIME is not null then cc.TRACK_TIME else '2000-01-01' end ,cc.CREATE_TIME , case when cc.CLAIM_TIME is not null then cc.CLAIM_TIME else '2000-01-01' end  , case when cc.ALLOCATE_TIME is not null then cc.ALLOCATE_TIME else '2000-01-01' end)");
                    }
                }
                sqlStr = new StringBuffer();
                if (!customerFieldEntity.getFieldType().equals("1")) break block222;
                List dicSingleList = new ArrayList();
                DicSingle dicSingle = new DicSingle();
                block9 : switch (customerFieldEntity.getConditionType()) {
                    case "1": {
                        dicSingleList = this.sysDicRefService.getDictByType("numerical_field_condition");
                        dicSingle = (DicSingle)dicSingleList.stream().filter(dic -> dic.getValue().equals(condition.getMatch())).collect(Collectors.toList()).get(0);
                        switch (dicSingle.getValue()) {
                            case "1": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ").append(condition.getValue1());
                                break block9;
                            }
                            case "2": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" != ").append(condition.getValue1());
                                break block9;
                            }
                            case "3": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" > ").append(condition.getValue1());
                                break block9;
                            }
                            case "4": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" < ").append(condition.getValue1());
                                break block9;
                            }
                            case "5": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" >= ").append(condition.getValue1());
                                break block9;
                            }
                            case "6": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" <= ").append(condition.getValue1());
                                break block9;
                            }
                            case "7": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" IS NOT NULL");
                                break block9;
                            }
                            case "8": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" IS NULL");
                                break block9;
                            }
                            case "9": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" >= ").append(condition.getValue1()).append(" AND ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" <= ").append(condition.getValue2());
                                break block9;
                            }
                        }
                        break;
                    }
                    case "2": {
                        dicSingleList = this.sysDicRefService.getDictByType("text_field_condition");
                        dicSingle = (DicSingle)dicSingleList.stream().filter(dic -> dic.getValue().equals(condition.getMatch())).collect(Collectors.toList()).get(0);
                        StringBuffer fieldStr = new StringBuffer("");
                        if (customerFieldEntity.getFieldName().equals("recordContent")) {
                            Object fromValue = customerFieldEntity.getDatasourceFromValue().split(",");
                            fieldStr.append("(SELECT RECORD_CONTENT FROM CRM_RECORD WHERE ").append(tableReferredName).append(".").append(fromValue[1]).append(" = TYPE_ID AND DEL_FLAG = '0' AND PRODUCE_TYPE = '1' ORDER BY CREATE_TIME DESC LIMIT 1)");
                        } else if (customerFieldEntity.getTargetType().equals("2") && customerFieldEntity.getFieldName().equals("customerReferredName")) {
                            fieldStr.append("(SELECT CUSTOMER_REFERRED_NAME FROM CRM_CUSTOMER WHERE ").append(tableReferredName).append(".").append("CUSTOMER_ID").append(" = CUSTOMER_ID)");
                        } else {
                            fieldStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName());
                        }
                        switch (dicSingle.getValue()) {
                            case "1": {
                                sqlStr.append(fieldStr).append(" = '").append(condition.getValue1()).append("'");
                                break block9;
                            }
                            case "2": {
                                sqlStr.append(fieldStr).append(" != '").append(condition.getValue1()).append("'");
                                break block9;
                            }
                            case "3": {
                                sqlStr.append(fieldStr).append(" LIKE '%").append(condition.getValue1()).append("%'");
                                break block9;
                            }
                            case "4": {
                                sqlStr.append(fieldStr).append(" IS NOT NULL AND ").append(fieldStr).append(" != ''");
                                break block9;
                            }
                            case "5": {
                                sqlStr.append(fieldStr).append(" IS NULL OR ").append(fieldStr).append(" = ''");
                                break block9;
                            }
                            case "6": {
                                String regexpStrMatch = "";
                                if (condition.getValue1() != null && condition.getValue1().length() >= 2) {
                                    regexpStrMatch = condition.getValue1().substring(1, condition.getValue1().length() - 1);
                                }
                                sqlStr.append(fieldStr).append(" REGEXP '").append(regexpStrMatch).append("'");
                                break block9;
                            }
                            case "7": {
                                String regexpStr = "";
                                if (condition.getValue1() != null && condition.getValue1().length() >= 2) {
                                    regexpStr = condition.getValue1().substring(1, condition.getValue1().length() - 1);
                                }
                                sqlStr.append(fieldStr).append(" NOT REGEXP '").append(regexpStr).append("'");
                                break block9;
                            }
                        }
                        break;
                    }
                    case "3": {
                        dicSingleList = this.sysDicRefService.getDictByType("enum_field_condition");
                        dicSingle = (DicSingle)dicSingleList.stream().filter(dic -> dic.getValue().equals(condition.getMatch())).collect(Collectors.toList()).get(0);
                        switch (dicSingle.getValue()) {
                            case "1": {
                                if (customerFieldEntity.getFieldName().equals("customerStageId")) {
                                    sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" IN (SELECT CUSTOMER_STAGE_ID FROM CRM_OPPORTUNITY_STAGE WHERE STAGE_NAME_VALUE = '").append(condition.getValue1()).append("')");
                                    break;
                                }
                                if (customerFieldEntity.getFieldName().equals("dealStates")) {
                                    sqlStr.append(tableReferredName).append(".").append("CUSTOMER_ID ").append(" IN (select win.CUSTOMER_ID from( SELECT (case when COUNT(OPPORTUNITY_ID) = 0 then 1 when COUNT(OPPORTUNITY_ID) = 1 then 2 else 3 end )winAmount, cc1.CUSTOMER_ID FROM crm_customer cc1 left join CRM_OPPORTUNITY CO on co.customer_id = cc1.customer_id and CO.DEL_FLAG = '0' LEFT JOIN CRM_OPPORTUNITY_STAGE COS ON COS.CUSTOMER_STAGE_ID = CO.CUSTOMER_STAGE_ID AND COS.STAGE_TYPE = '20' GROUP BY cc1.CUSTOMER_ID) win where win.winAmount = '").append(condition.getValue1()).append("')");
                                    break;
                                }
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = '").append(condition.getValue1()).append("'");
                                break;
                            }
                            case "2": {
                                if (customerFieldEntity.getFieldName().equals("customerStageId")) {
                                    sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" NOT IN (SELECT CUSTOMER_STAGE_ID FROM CRM_OPPORTUNITY_STAGE WHERE STAGE_NAME_VALUE = '").append(condition.getValue1()).append("')");
                                    break;
                                }
                                if (customerFieldEntity.getFieldName().equals("dealStates")) {
                                    sqlStr.append(tableReferredName).append(".").append("CUSTOMER_ID ").append(" IN (select win.CUSTOMER_ID from( SELECT (case when COUNT(OPPORTUNITY_ID) = 0 then 1 when COUNT(OPPORTUNITY_ID) = 1 then 2 else 3 end )winAmount, cc1.CUSTOMER_ID FROM crm_customer cc1 left join CRM_OPPORTUNITY CO on co.customer_id = cc1.customer_id and CO.DEL_FLAG = '0' LEFT JOIN CRM_OPPORTUNITY_STAGE COS ON COS.CUSTOMER_STAGE_ID = CO.CUSTOMER_STAGE_ID AND COS.STAGE_TYPE = '20' GROUP BY cc1.CUSTOMER_ID) win where win.winAmount != '").append(condition.getValue1()).append("')");
                                    break;
                                }
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" != '").append(condition.getValue1()).append("'");
                                break;
                            }
                            case "3": {
                                if (customerFieldEntity.getFieldName().equals("customerStageId")) {
                                    List enumIdList = Arrays.stream(condition.getValue1().split(",")).collect(Collectors.toList());
                                    String enumId = enumIdList.stream().map(s -> "'" + s + "'").collect(Collectors.joining(","));
                                    sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" IN (SELECT CUSTOMER_STAGE_ID FROM CRM_OPPORTUNITY_STAGE WHERE STAGE_NAME_VALUE IN (").append(enumId).append("))");
                                    break;
                                }
                                if (customerFieldEntity.getFieldName().equals("dealStates")) {
                                    sqlStr.append(tableReferredName).append(".").append("CUSTOMER_ID").append(" IN (select win.CUSTOMER_ID from( SELECT (case when COUNT(OPPORTUNITY_ID) = 0 then 1 when COUNT(OPPORTUNITY_ID) = 1 then 2 else 3 end )winAmount, cc1.CUSTOMER_ID FROM crm_customer cc1 left join CRM_OPPORTUNITY CO on co.customer_id = cc1.customer_id and CO.DEL_FLAG = '0' LEFT JOIN CRM_OPPORTUNITY_STAGE COS ON COS.CUSTOMER_STAGE_ID = CO.CUSTOMER_STAGE_ID AND COS.STAGE_TYPE = '20' GROUP BY cc1.CUSTOMER_ID) win where win.winAmount IN (").append(condition.getValue1()).append("))");
                                    break;
                                }
                                List enumIdList = Arrays.stream(condition.getValue1().split(",")).collect(Collectors.toList());
                                for (int i = 0; i < enumIdList.size(); ++i) {
                                    if (i != 0) {
                                        sqlStr.append(" OR ");
                                    }
                                    sqlStr.append("INSTR(").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(", '").append((String)enumIdList.get(i)).append("') > 0");
                                }
                                break block223;
                            }
                            case "4": {
                                if (customerFieldEntity.getFieldName().equals("customerStageId")) {
                                    List enumIdList = Arrays.stream(condition.getValue1().split(",")).collect(Collectors.toList());
                                    String enumId = enumIdList.stream().map(s -> "'" + s + "'").collect(Collectors.joining(","));
                                    sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" NOT IN (SELECT CUSTOMER_STAGE_ID FROM CRM_OPPORTUNITY_STAGE WHERE STAGE_NAME_VALUE IN (").append(enumId).append("))");
                                    break;
                                }
                                if (customerFieldEntity.getFieldName().equals("dealStates")) {
                                    sqlStr.append(tableReferredName).append(".").append("CUSTOMER_ID").append(" IN (select win.CUSTOMER_ID from( SELECT (case when COUNT(OPPORTUNITY_ID) = 0 then 1 when COUNT(OPPORTUNITY_ID) = 1 then 2 else 3 end )winAmount, cc1.CUSTOMER_ID FROM crm_customer cc1 left join CRM_OPPORTUNITY CO on co.customer_id = cc1.customer_id and CO.DEL_FLAG = '0' LEFT JOIN CRM_OPPORTUNITY_STAGE COS ON COS.CUSTOMER_STAGE_ID = CO.CUSTOMER_STAGE_ID AND COS.STAGE_TYPE = '20' GROUP BY cc1.CUSTOMER_ID) win where win.winAmount NOT IN (").append(condition.getValue1()).append("))");
                                    break;
                                }
                                List enumIds = Arrays.stream(condition.getValue1().split(",")).collect(Collectors.toList());
                                for (int i = 0; i < enumIds.size(); ++i) {
                                    if (i != 0) {
                                        sqlStr.append(" AND ");
                                    }
                                    sqlStr.append("INSTR(").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(", '").append((String)enumIds.get(i)).append("') = 0");
                                }
                                break block223;
                            }
                            case "5": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" IS NOT NULL AND ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" != ''");
                                break;
                            }
                            case "6": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" IS NULL OR ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ''");
                                break;
                            }
                        }
                        break block223;
                    }
                    case "4": {
                        dicSingleList = this.sysDicRefService.getDictByType("time_field_condition");
                        dicSingle = (DicSingle)dicSingleList.stream().filter(dic -> dic.getValue().equals(condition.getMatch())).collect(Collectors.toList()).get(0);
                        LocalDateTime time1 = null;
                        LocalDateTime time2 = null;
                        switch (dicSingle.getValue()) {
                            case "1": {
                                time1 = LocalDateTime.parse(condition.getValue1());
                                String timeStr1 = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(time1);
                                sqlStr.append("STR_TO_DATE(DATE_FORMAT(").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(", '%Y-%m-%d'), '%Y-%m-%d')").append(" = ").append("STR_TO_DATE('").append(timeStr1).append("', '%Y-%m-%d')");
                                break block9;
                            }
                            case "2": {
                                time1 = LocalDateTime.parse(condition.getValue1());
                                String timeStr1 = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(time1);
                                sqlStr.append("STR_TO_DATE(DATE_FORMAT(").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(", '%Y-%m-%d'), '%Y-%m-%d')").append(" != ").append("STR_TO_DATE('").append(timeStr1).append("', '%Y-%m-%d')");
                                break block9;
                            }
                            case "3": {
                                time1 = LocalDateTime.parse(condition.getValue1());
                                String timeStr1 = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(time1);
                                sqlStr.append("STR_TO_DATE(DATE_FORMAT(").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(", '%Y-%m-%d'), '%Y-%m-%d')").append(" > ").append("STR_TO_DATE('").append(timeStr1).append("', '%Y-%m-%d')");
                                break block9;
                            }
                            case "4": {
                                time1 = LocalDateTime.parse(condition.getValue1());
                                String timeStr1 = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(time1);
                                sqlStr.append("STR_TO_DATE(DATE_FORMAT(").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(", '%Y-%m-%d'), '%Y-%m-%d')").append(" < ").append("STR_TO_DATE('").append(timeStr1).append("', '%Y-%m-%d')");
                                break block9;
                            }
                            case "5": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" IS NOT NULL");
                                break block9;
                            }
                            case "6": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" IS NULL");
                                break block9;
                            }
                            case "7": {
                                time1 = LocalDateTime.parse(condition.getValue1());
                                String timeStr1 = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(time1);
                                time2 = LocalDateTime.parse(condition.getValue2());
                                String timeStr2 = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(time2);
                                sqlStr.append("STR_TO_DATE(DATE_FORMAT(").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(", '%Y-%m-%d'), '%Y-%m-%d')").append(" >= ").append("STR_TO_DATE('").append(timeStr1).append("', '%Y-%m-%d')").append(" AND ").append("STR_TO_DATE(DATE_FORMAT(").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(", '%Y-%m-%d'), '%Y-%m-%d')").append(" <= ").append("STR_TO_DATE('").append(timeStr2).append("', '%Y-%m-%d')");
                                break block9;
                            }
                            case "8": {
                                if (Arrays.asList("successDate", "endTime").contains(customerFieldEntity.getFieldName())) {
                                    int beforeDays = Integer.parseInt(condition.getValue1());
                                    String timeStr1 = "NOW() - INTERVAL '" + beforeDays + "' day";
                                    sqlStr.append("STR_TO_DATE(DATE_FORMAT(").append(customerFieldEntity.getFieldDatabaseName()).append(", '%Y-%m-%d'), '%Y-%m-%d')").append(" <= ").append("DATE_FORMAT(").append(timeStr1).append(", '%Y-%m-%d')");
                                    break block9;
                                }
                                int beforeDays = Integer.parseInt(condition.getValue1());
                                String timeStr1 = "NOW() - INTERVAL '" + beforeDays + "' day";
                                sqlStr.append("STR_TO_DATE(DATE_FORMAT(").append(customerFieldEntity.getFieldDatabaseName()).append(", '%Y-%m-%d'), '%Y-%m-%d')").append(" <= ").append("DATE_FORMAT(").append(timeStr1).append(", '%Y-%m-%d')");
                                break block9;
                            }
                            case "9": {
                                if (Arrays.asList("successDate", "endTime").contains(customerFieldEntity.getFieldName())) {
                                    int afterDays = Integer.parseInt(condition.getValue1());
                                    String timeStr1 = "NOW() + INTERVAL '" + afterDays + "' day";
                                    sqlStr.append("STR_TO_DATE(DATE_FORMAT(").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(", '%Y-%m-%d'), '%Y-%m-%d')").append(" > ").append("DATE_FORMAT(").append(timeStr1).append(", '%Y-%m-%d')");
                                    break block9;
                                }
                                int afterDays = Integer.parseInt(condition.getValue1());
                                String timeStr1 = "NOW() + INTERVAL '" + afterDays + "' day";
                                sqlStr.append("STR_TO_DATE(DATE_FORMAT(").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(", '%Y-%m-%d %H:%i:%s'), '%Y-%m-%d %H:%i:%s')").append(" > ").append("DATE_FORMAT(").append(timeStr1).append(", '%Y-%m-%d %H:%i:%s')");
                                break block9;
                            }
                        }
                        break;
                    }
                    case "5": {
                        dicSingleList = this.sysDicRefService.getDictByType("dept_field_condition");
                        dicSingle = (DicSingle)dicSingleList.stream().filter(dic -> dic.getValue().equals(condition.getMatch())).collect(Collectors.toList()).get(0);
                        switch (dicSingle.getValue()) {
                            case "1": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = '").append(condition.getValue1()).append("'");
                                break block9;
                            }
                            case "2": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" != '").append(condition.getValue1()).append("'");
                                break block9;
                            }
                            case "3": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" IN (").append(condition.getValue1()).append(")");
                                break block9;
                            }
                            case "4": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" NOT IN (").append(condition.getValue1()).append(")");
                                break block9;
                            }
                            case "5": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" IS NOT NULL");
                                break block9;
                            }
                            case "6": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" IS NULL");
                                break block9;
                            }
                            case "7": {
                                if ("ownDepartment".equals(customerFieldEntity.getFieldName())) {
                                    sqlStr.append("((select COUNT(*) FROM SYS_STRU WHERE STRU_ID = ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" AND DEL_FLAG = '0') = 0").append(" OR (select count(*) from SYS_STRU WHERE ORGAN_ALIAS = ").append(tableReferredName).append(".OWN_DEPARTMENT_NAME").append(" AND DEL_FLAG = '0'").append(")").append(")");
                                    break block9;
                                }
                                if ("createDepartmentName".equals(customerFieldEntity.getFieldName())) {
                                    sqlStr.append("((select COUNT(*) FROM SYS_STRU WHERE STRU_ID = ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" AND DEL_FLAG = '0') = 0").append(" OR (select count(*) from SYS_STRU WHERE ORGAN_ALIAS = ").append(tableReferredName).append(".CREATE_DEPARTMENT_NAME").append(" AND DEL_FLAG = '0'").append(")").append(")");
                                    break block9;
                                }
                                sqlStr.append("(select COUNT(*) FROM SYS_STRU WHERE STRU_ID = ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" AND DEL_FLAG = '0') = 0");
                                break block9;
                            }
                            case "8": {
                                String str = customerFieldEntity.getTargetType().equals("17") ? "CHARGE_PERSON" : "CHARGE_PERSON_ID";
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" NOT IN (select STRU_ID FROM SYS_STRU_USER WHERE ").append(tableReferredName).append(".").append(str).append(" = USER_ID)");
                                break block9;
                            }
                        }
                        break;
                    }
                    case "6": {
                        dicSingleList = this.sysDicRefService.getDictByType("user_field_condition");
                        dicSingle = (DicSingle)dicSingleList.stream().filter(dic -> dic.getValue().equals(condition.getMatch())).collect(Collectors.toList()).get(0);
                        switch (dicSingle.getValue()) {
                            case "1": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = '").append(condition.getValue1()).append("'");
                                break block9;
                            }
                            case "2": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" != '").append(condition.getValue1()).append("'");
                                break block9;
                            }
                            case "3": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" IN (").append(condition.getValue1()).append(")");
                                break block9;
                            }
                            case "4": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" NOT IN (").append(condition.getValue1()).append(")");
                                break block9;
                            }
                            case "5": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" IS NOT NULL");
                                break block9;
                            }
                            case "6": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" IS NULL");
                                break block9;
                            }
                            case "7": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" IN (SELECT USER_ID FROM SYS_STRU_USER WHERE STRU_ID IN (").append(condition.getValue1()).append("))");
                                break block9;
                            }
                            case "8": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" IN (SELECT USER_ID FROM SYS_STRU_USER ssu LEFT JOIN SYS_STRU ss ON ssu.STRU_ID = ss.STRU_ID WHERE ss.ORGAN_ALIAS = '\u79bb\u804c\u4eba\u5458' OR ss.STRU_ID = 100122)");
                                break block9;
                            }
                        }
                        break;
                    }
                    case "7": {
                        dicSingleList = this.sysDicRefService.getDictByType("relation_field_condition");
                        dicSingle = (DicSingle)dicSingleList.stream().filter(dic -> dic.getValue().equals(condition.getMatch())).collect(Collectors.toList()).get(0);
                        switch (dicSingle.getValue()) {
                            case "1": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = '").append(condition.getValue1()).append("'");
                                break block9;
                            }
                            case "2": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" != '").append(condition.getValue1()).append("'");
                                break block9;
                            }
                            case "3": {
                                List wordlist = Arrays.stream(customerFieldEntity.getDatasourceFromValue().split(",")).collect(Collectors.toList());
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" IN (SELECT ").append((String)wordlist.get(1)).append(" FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(customerFieldEntity.getFuzzyMatchingField()).append(" LIKE '%").append(condition.getValue2()).append("%')");
                                break block9;
                            }
                            case "4": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" IS NOT NULL");
                                break block9;
                            }
                            case "5": {
                                sqlStr.append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" IS NULL");
                                break block9;
                            }
                        }
                        break;
                    }
                }
                break block223;
            }
            if (customerFieldEntity.getFieldType().equals("2")) {
                List dicSingleList = this.sysDicRefService.getDictByType("numerical_field_condition");
                DicSingle dicSingle = (DicSingle)dicSingleList.stream().filter(dic -> dic.getValue().equals(condition.getMatch())).collect(Collectors.toList()).get(0);
                List wordlist = Arrays.stream(customerFieldEntity.getDatasourceFromValue().split(",")).collect(Collectors.toList());
                StringBuffer queryStr = new StringBuffer();
                if (!customerFieldEntity.getDatasourceFromType().equals("10")) {
                    queryStr.append(" AND DEL_FLAG = '0')");
                    switch (dicSingle.getValue()) {
                        case "1": {
                            sqlStr.append("(SELECT COUNT(*) FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" = ").append(condition.getValue1());
                            break;
                        }
                        case "2": {
                            sqlStr.append("(SELECT COUNT(*) FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" != ").append(condition.getValue1());
                            break;
                        }
                        case "3": {
                            sqlStr.append("(SELECT COUNT(*) FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" > ").append(condition.getValue1());
                            break;
                        }
                        case "4": {
                            sqlStr.append("(SELECT COUNT(*) FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" < ").append(condition.getValue1());
                            break;
                        }
                        case "5": {
                            sqlStr.append("(SELECT COUNT(*) FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" >= ").append(condition.getValue1());
                            break;
                        }
                        case "6": {
                            sqlStr.append("(SELECT COUNT(*) FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" <= ").append(condition.getValue1());
                            break;
                        }
                        case "7": {
                            sqlStr.append("(SELECT COUNT(*) FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" > 0");
                            break;
                        }
                        case "8": {
                            sqlStr.append("(SELECT COUNT(*) FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" = 0");
                            break;
                        }
                        case "9": {
                            sqlStr.append("(SELECT COUNT(*) FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" >= ").append(condition.getValue1()).append(" AND ").append("(SELECT COUNT(*) FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" <= ").append(condition.getValue2());
                            break;
                        }
                    }
                } else {
                    queryStr.append(" AND DEL_FLAG = '0')");
                    switch (dicSingle.getValue()) {
                        case "1": {
                            sqlStr.append("(SELECT COUNT(*) FROM CRM_RECORD_RELATION WHERE ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" = ").append(condition.getValue1());
                            break;
                        }
                        case "2": {
                            sqlStr.append("(SELECT COUNT(*) FROM CRM_RECORD_RELATION WHERE ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" != ").append(condition.getValue1());
                            break;
                        }
                        case "3": {
                            sqlStr.append("(SELECT COUNT(*) FROM CRM_RECORD_RELATION WHERE ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" > ").append(condition.getValue1());
                            break;
                        }
                        case "4": {
                            sqlStr.append("(SELECT COUNT(*) FROM CRM_RECORD_RELATION WHERE ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" < ").append(condition.getValue1());
                            break;
                        }
                        case "5": {
                            sqlStr.append("(SELECT COUNT(*) FROM CRM_RECORD_RELATION WHERE ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" >= ").append(condition.getValue1());
                            break;
                        }
                        case "6": {
                            sqlStr.append("(SELECT COUNT(*) FROM CRM_RECORD_RELATION WHERE ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" <= ").append(condition.getValue1());
                            break;
                        }
                        case "7": {
                            sqlStr.append("(SELECT COUNT(*) FROM CRM_RECORD_RELATION WHERE ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" > 0");
                            break;
                        }
                        case "8": {
                            sqlStr.append("(SELECT COUNT(*) FROM CRM_RECORD_RELATION WHERE ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" = 0");
                            break;
                        }
                        case "9": {
                            sqlStr.append("(SELECT COUNT(*) FROM CRM_RECORD_RELATION WHERE ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" >= ").append(condition.getValue1()).append(" AND ").append("(SELECT COUNT(*) FROM CRM_RECORD_RELATION  WHERE ").append(tableReferredName).append(".").append(customerFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" <= ").append(condition.getValue2());
                            break;
                        }
                    }
                }
            }
        }
        return sqlStr;
    }
}

