/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.customerpool.customerpool.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.common.api.organUser.IUserBoService;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.common.vo.PersonWithDepInfo;
import com.jxdinfo.crm.core.common.vo.UserRoleVo;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.contact.service.ContactService;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.model.PublicPoolRule;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.service.IPublicPoolRuleService;
import com.jxdinfo.crm.core.customer.constant.CustomerPoolEditConstant;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.customerpool.customerpool.dao.CustomerPoolMapper;
import com.jxdinfo.crm.core.customerpool.customerpool.dto.CustomerPoolDto;
import com.jxdinfo.crm.core.customerpool.customerpool.dto.CustomerPoolMemberDto;
import com.jxdinfo.crm.core.customerpool.customerpool.dto.PoolTransferDto;
import com.jxdinfo.crm.core.customerpool.customerpool.model.CustomerPoolEntity;
import com.jxdinfo.crm.core.customerpool.customerpool.model.CustomerPoolMemberEntity;
import com.jxdinfo.crm.core.customerpool.customerpool.service.ICustomerPoolMemberService;
import com.jxdinfo.crm.core.customerpool.customerpool.service.ICustomerPoolService;
import com.jxdinfo.crm.core.customerpool.customerpool.vo.CustomerPoolAndCountVo;
import com.jxdinfo.crm.core.customerpool.customerpool.vo.CustomerPoolByOperateVo;
import com.jxdinfo.crm.core.customerpool.customerpool.vo.CustomerPoolVo;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.dto.PoolCustomerDto;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.model.CustomerPoolClaimRule;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.model.PoolCustomerEntity;
import com.jxdinfo.crm.core.customerpool.customerpoolcustomer.service.IPoolCustomerService;
import com.jxdinfo.crm.core.jxdIM.dto.CrmTeamAdminInfoDto;
import com.jxdinfo.crm.core.jxdIM.service.ImGroupMemberService;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.teammeber.dao.TeamMeberMapper;
import com.jxdinfo.crm.core.teammeber.dto.TeamMeberDto;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerPoolServiceImpl
extends ServiceImpl<CustomerPoolMapper, CustomerPoolEntity>
implements ICustomerPoolService {
    @Resource
    private CustomerPoolMapper customerPoolMapper;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private ICustomerPoolMemberService customerPoolMemberService;
    @Resource
    private IPoolCustomerService poolCustomerService;
    @Resource
    private IPublicPoolRuleService publicPoolRuleService;
    @Resource
    private IOrganUserBoService organUserBoService;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private IUserBoService userBoService;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private ImGroupMemberService imGroupMemberService;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private TeamMeberMapper teamMeberMapper;
    @Resource
    private ContactService contactService;
    @Resource
    private CustomerService customerService;

    @Override
    public ApiResponse<String> customerPoolSwitch(String switchFlag) {
        long countPool;
        if ("2".equals(switchFlag) && (countPool = this.count((Wrapper)new LambdaQueryWrapper().eq(CustomerPoolEntity::getDelFlag, (Object)"0"))) > 0L) {
            throw new HussarException("\u5df2\u521b\u5efa\u516c\u6d77\u6c60\uff0c\u65e0\u6cd5\u5173\u95ed");
        }
        this.crmBaseConfigBoService.updateConfigValue(switchFlag, "customer_pool_switch");
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Page<CustomerPoolVo>> selectList(CustomerPoolDto dto) {
        Page page = new Page();
        page.setSize((long)dto.getSize().intValue());
        page.setCurrent((long)dto.getCurrent().intValue());
        List<CustomerPoolVo> list = this.customerPoolMapper.selectCustomerPoolList((Page<CustomerPoolVo>)page, dto);
        if (CollectionUtil.isEmpty(list)) {
            return ApiResponse.success((Object)page);
        }
        List memberEntityList = this.customerPoolMemberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CustomerPoolMemberEntity::getCustomerPoolId, (Collection)list.stream().map(CustomerPoolVo::getCustomerPoolId).collect(Collectors.toList()))).orderByAsc(CustomerPoolMemberEntity::getCreateTime)).orderByAsc(CustomerPoolMemberEntity::getMemberName));
        Map<Long, List<CustomerPoolMemberEntity>> map = memberEntityList.stream().collect(Collectors.groupingBy(CustomerPoolMemberEntity::getCustomerPoolId));
        for (CustomerPoolVo vo : list) {
            List<CustomerPoolMemberEntity> listTemp = map.get(vo.getCustomerPoolId());
            if (!CollectionUtil.isNotEmpty(listTemp)) continue;
            ArrayList<String> member = new ArrayList<String>();
            ArrayList<String> admin = new ArrayList<String>();
            for (CustomerPoolMemberEntity memberEntity : listTemp) {
                if ("1".equals(memberEntity.getMemberRole())) {
                    member.add(memberEntity.getMemberName());
                    continue;
                }
                if (!"2".equals(memberEntity.getMemberRole())) continue;
                admin.add(memberEntity.getMemberName());
            }
            if (!member.isEmpty()) {
                vo.setPoolMember(String.join((CharSequence)"\u3001", member));
            }
            if (admin.isEmpty()) continue;
            vo.setPoolAdmin(String.join((CharSequence)"\u3001", admin));
        }
        page.setRecords(list);
        return ApiResponse.success((Object)page);
    }

    @Override
    public Page<CustomerPoolByOperateVo> poolList(CustomerPoolDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Page page = new Page();
        page.setSize((long)dto.getSize().intValue());
        page.setCurrent((long)dto.getCurrent().intValue());
        List<Long> customerPoolIdList = this.customerPoolMemberService.getCustomerPoolIdByUser(user);
        dto.setCustomerPoolIdList(customerPoolIdList);
        List<CustomerPoolByOperateVo> list = this.customerPoolMapper.poolList(page, dto, dto.getTimeOrder());
        this.updateCustomerPoolInfo(list);
        page.setRecords(list);
        return page;
    }

    private void updateCustomerPoolInfo(List<CustomerPoolByOperateVo> list) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        List<Long> customerPoolIdList = list.stream().map(CustomerPoolByOperateVo::getCustomerPoolId).collect(Collectors.toList());
        List memberEntityList = this.customerPoolMemberService.list((Wrapper)new LambdaUpdateWrapper().in(CustomerPoolMemberEntity::getCustomerPoolId, customerPoolIdList));
        List<Map<String, Long>> customerCountList = this.customerPoolMemberService.getCountByCustomerPoolId(customerPoolIdList);
        HashMap<Long, Long> customerCountMap = new HashMap<Long, Long>();
        if (CollectionUtil.isNotEmpty(customerCountList)) {
            for (Map<String, Long> customerCount : customerCountList) {
                Long poolId = customerCount.get("poolId");
                if (poolId == null) continue;
                Long count = customerCount.get("customerCount") == null ? Long.valueOf(0L) : customerCount.get("customerCount");
                customerCountMap.put(poolId, count);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)memberEntityList)) {
            Map<Long, List<CustomerPoolMemberEntity>> memberListMap = memberEntityList.stream().collect(Collectors.groupingBy(CustomerPoolMemberEntity::getCustomerPoolId));
            for (CustomerPoolByOperateVo customerPoolByOperateVo : list) {
                Long customerPoolId = customerPoolByOperateVo.getCustomerPoolId();
                List<CustomerPoolMemberEntity> poolMemberEntityList = memberListMap.get(customerPoolId);
                long customerCount = 0L;
                if (CollectionUtil.isNotEmpty(customerCountMap)) {
                    customerCount = customerCountMap.get(customerPoolId) == null ? 0L : (Long)customerCountMap.get(customerPoolId);
                }
                customerPoolByOperateVo.setCustomerCount(customerCount);
                if (!CollectionUtil.isNotEmpty(poolMemberEntityList)) continue;
                String mangerNames = poolMemberEntityList.stream().filter(customerPoolMemberEntity -> "2".equals(customerPoolMemberEntity.getMemberRole())).map(CustomerPoolMemberEntity::getMemberName).collect(Collectors.joining(","));
                String teamMemberNames = poolMemberEntityList.stream().filter(customerPoolMemberEntity -> "1".equals(customerPoolMemberEntity.getMemberRole())).map(CustomerPoolMemberEntity::getMemberName).collect(Collectors.joining(","));
                customerPoolByOperateVo.setManagerUsers(mangerNames);
                customerPoolByOperateVo.setMemberUsers(teamMemberNames);
            }
        }
    }

    @Override
    public ApiResponse<CustomerPoolAndCountVo> getPoolCustomerCount(CustomerPoolDto dto) {
        Long count = this.poolCustomerService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PoolCustomerEntity::getCustomerPoolId, (Object)dto.getCustomerPoolId())).eq(PoolCustomerEntity::getDelFlag, (Object)"0"));
        CustomerPoolAndCountVo vo = new CustomerPoolAndCountVo();
        vo.setCount(count);
        List customerPoolEntityList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerPoolEntity::getDelFlag, (Object)"0")).ne(CustomerPoolEntity::getCustomerPoolId, (Object)dto.getCustomerPoolId()));
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        customerPoolEntityList.forEach(customerPool -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("customerPoolId", customerPool.getCustomerPoolId());
            map.put("customerPoolName", customerPool.getCustomerPoolName());
            mapList.add(map);
        });
        vo.setPoolList(mapList);
        return ApiResponse.success((Object)vo);
    }

    @Override
    @Transactional
    public ApiResponse<String> addCustomerPool(CustomerPoolDto dto) {
        LocalDateTime dateTime = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        CustomerPoolEntity customerPoolEntity = (CustomerPoolEntity)BeanUtil.copyProperties((Object)dto, CustomerPoolEntity.class);
        customerPoolEntity.setCreator(user.getUserId());
        customerPoolEntity.setCreatorName(user.getUserName());
        customerPoolEntity.setCreateDepartmentId(user.getDeptId());
        customerPoolEntity.setCreateDepartmentName(user.getDeptName());
        customerPoolEntity.setLastEditor(user.getUserId());
        customerPoolEntity.setLastEditorName(user.getUserName());
        customerPoolEntity.setLastTime(dateTime);
        customerPoolEntity.setCreateTime(dateTime);
        customerPoolEntity.setDelFlag("0");
        Integer maxOrderNumber = this.customerPoolMapper.getMaxOrderNumber();
        if (maxOrderNumber == null) {
            maxOrderNumber = 0;
        }
        customerPoolEntity.setCustomerPoolOrder(maxOrderNumber + 1);
        Long customerPoolId = Long.valueOf(CommonUtills.generateAssignId());
        customerPoolEntity.setCustomerPoolId(customerPoolId);
        PublicPoolRule poolRule = new PublicPoolRule();
        poolRule.setPublicPoolRuleId(Long.valueOf(CommonUtills.generateAssignId()));
        poolRule.setCreateTime(dateTime);
        poolRule.setCreator(user.getUserId());
        poolRule.setLastTime(dateTime);
        poolRule.setLastEditor(user.getUserId());
        poolRule.setPublicPoolRuleModule("customerPool");
        poolRule.setPublicPoolRuleRecycleSwitch(dto.getRecycleRuleSwitch());
        poolRule.setPublicPoolRuleRecycle(dto.getRecycleRuleContent());
        poolRule.setPublicPoolRuleClaimSwitch(dto.getClaimRuleSwitch());
        poolRule.setPublicPoolRuleClaim(dto.getClaimRuleContent());
        poolRule.setDelFlag("0");
        this.publicPoolRuleService.save((Object)poolRule);
        customerPoolEntity.setCustomerPoolRuleId(poolRule.getPublicPoolRuleId());
        ArrayList<CustomerPoolMemberDto> memberDtos = new ArrayList<CustomerPoolMemberDto>();
        if (CollectionUtil.isNotEmpty(dto.getMemberDtoList())) {
            memberDtos.addAll(dto.getMemberDtoList());
        }
        if (CollectionUtil.isNotEmpty(dto.getManagerDtoList())) {
            memberDtos.addAll(dto.getManagerDtoList());
        }
        if (CollectionUtil.isNotEmpty(memberDtos)) {
            List customerPoolMemberEntityList = memberDtos.stream().map(e -> {
                CustomerPoolMemberEntity customerPoolMemberEntity = new CustomerPoolMemberEntity();
                customerPoolMemberEntity.setCustomerPoolId(customerPoolId);
                customerPoolMemberEntity.setMemberId(e.getMemberId());
                customerPoolMemberEntity.setMemberName(e.getMemberName());
                customerPoolMemberEntity.setMemberType(e.getMemberType());
                customerPoolMemberEntity.setMemberRole(e.getMemberRole());
                customerPoolMemberEntity.setCreator(user.getUserId());
                customerPoolMemberEntity.setCreateTime(dateTime);
                customerPoolMemberEntity.setLastEditor(user.getUserId());
                customerPoolMemberEntity.setLastTime(dateTime);
                return customerPoolMemberEntity;
            }).collect(Collectors.toList());
            this.customerPoolMemberService.saveBatch(customerPoolMemberEntityList);
        }
        this.save(customerPoolEntity);
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f");
    }

    @Override
    @Transactional
    public ApiResponse<String> changeCustomerPool(CustomerPoolDto dto) {
        LocalDateTime dateTime = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        CustomerPoolEntity customerPoolEntity = (CustomerPoolEntity)BeanUtil.copyProperties((Object)dto, CustomerPoolEntity.class);
        CustomerPoolEntity oldPoolEntity = (CustomerPoolEntity)this.getById(dto.getCustomerPoolId());
        customerPoolEntity.setLastTime(dateTime);
        customerPoolEntity.setLastEditor(user.getUserId());
        customerPoolEntity.setLastEditorName(user.getUserName());
        customerPoolEntity.setDelFlag("0");
        this.updateById(customerPoolEntity);
        PublicPoolRule poolRule = new PublicPoolRule();
        poolRule.setPublicPoolRuleId(oldPoolEntity.getCustomerPoolRuleId());
        poolRule.setLastTime(dateTime);
        poolRule.setLastEditor(user.getUserId());
        poolRule.setPublicPoolRuleModule("customerPool");
        poolRule.setPublicPoolRuleRecycleSwitch(dto.getRecycleRuleSwitch());
        poolRule.setPublicPoolRuleRecycle(dto.getRecycleRuleContent());
        poolRule.setPublicPoolRuleClaimSwitch(dto.getClaimRuleSwitch());
        poolRule.setPublicPoolRuleClaim(dto.getClaimRuleContent());
        poolRule.setDelFlag("0");
        this.publicPoolRuleService.updateById((Object)poolRule);
        ArrayList<CustomerPoolMemberDto> memberDtos = new ArrayList<CustomerPoolMemberDto>();
        if (CollectionUtil.isNotEmpty(dto.getMemberDtoList())) {
            memberDtos.addAll(dto.getMemberDtoList());
        }
        if (CollectionUtil.isNotEmpty(dto.getManagerDtoList())) {
            memberDtos.addAll(dto.getManagerDtoList());
        }
        this.customerPoolMemberService.remove((Wrapper)new LambdaQueryWrapper().eq(CustomerPoolMemberEntity::getCustomerPoolId, (Object)dto.getCustomerPoolId()));
        if (CollectionUtil.isNotEmpty(memberDtos)) {
            List customerPoolMemberEntityList = memberDtos.stream().map(e -> {
                CustomerPoolMemberEntity customerPoolMemberEntity = new CustomerPoolMemberEntity();
                customerPoolMemberEntity.setCustomerPoolId(dto.getCustomerPoolId());
                customerPoolMemberEntity.setMemberId(e.getMemberId());
                customerPoolMemberEntity.setMemberName(e.getMemberName());
                customerPoolMemberEntity.setMemberType(e.getMemberType());
                customerPoolMemberEntity.setMemberRole(e.getMemberRole());
                customerPoolMemberEntity.setCreator(user.getUserId());
                customerPoolMemberEntity.setCreateTime(dateTime);
                customerPoolMemberEntity.setLastEditor(user.getUserId());
                customerPoolMemberEntity.setLastTime(dateTime);
                return customerPoolMemberEntity;
            }).collect(Collectors.toList());
            this.customerPoolMemberService.saveBatch(customerPoolMemberEntityList);
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @Override
    @Transactional
    public ApiResponse<String> delCustomerPool(CustomerPoolDto dto) {
        List<Long> delPoolIds = dto.getCustomerPoolIdList();
        Long countCustomer = this.poolCustomerService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(PoolCustomerEntity::getCustomerPoolId, delPoolIds)).eq(PoolCustomerEntity::getDelFlag, (Object)"0"));
        if (countCustomer > 0L) {
            throw new HussarException("\u516c\u6d77\u6c60\u5185\u6709" + countCustomer + "\u6761\u5ba2\u6237\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        List customerPoolEntityList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CustomerPoolEntity::getCustomerPoolId, delPoolIds)).eq(CustomerPoolEntity::getDelFlag, (Object)"0"));
        this.customerPoolMemberService.remove((Wrapper)new LambdaQueryWrapper().in(CustomerPoolMemberEntity::getCustomerPoolId, delPoolIds));
        this.publicPoolRuleService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(PublicPoolRule::getPublicPoolRuleId, (Collection)customerPoolEntityList.stream().map(CustomerPoolEntity::getCustomerPoolRuleId).collect(Collectors.toList()))).set(PublicPoolRule::getDelFlag, (Object)"1"));
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(CustomerPoolEntity::getCustomerPoolId, delPoolIds)).set(CustomerPoolEntity::getDelFlag, (Object)"1"));
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    @Transactional
    public ApiResponse<String> changeOrder(String configFlag, List<CustomerPoolDto> orderList) {
        this.crmBaseConfigBoService.updateConfigValue(configFlag, "customer_old_pool_first");
        List customerPoolEntityList = BeanUtil.copyToList(orderList, CustomerPoolEntity.class);
        this.updateBatchById(customerPoolEntityList);
        return ApiResponse.success((String)"\u6392\u5e8f\u4fee\u6539\u6210\u529f");
    }

    @Override
    public ApiResponse<CustomerPoolVo> formQuery(CustomerPoolDto dto) {
        CustomerPoolVo customerPoolVo = this.customerPoolMapper.formQuery(dto.getCustomerPoolId());
        List customerPoolMemberEntityList = this.customerPoolMemberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerPoolMemberEntity::getCustomerPoolId, (Object)dto.getCustomerPoolId())).orderByAsc(CustomerPoolMemberEntity::getCreateTime)).orderByAsc(CustomerPoolMemberEntity::getMemberName));
        if (CollectionUtil.isNotEmpty((Collection)customerPoolMemberEntityList)) {
            customerPoolVo.setMemberList(customerPoolMemberEntityList.stream().filter(c -> "1".equals(c.getMemberRole())).collect(Collectors.toList()));
            customerPoolVo.setManagerList(customerPoolMemberEntityList.stream().filter(c -> "2".equals(c.getMemberRole())).collect(Collectors.toList()));
        }
        return ApiResponse.success((Object)customerPoolVo);
    }

    @Override
    @Transactional
    public ApiResponse<String> transfer(PoolTransferDto dto) {
        List poolCustomerEntityList = this.poolCustomerService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PoolCustomerEntity::getCustomerPoolId, (Object)dto.getSourceCustomerPoolId())).eq(PoolCustomerEntity::getDelFlag, (Object)"0"));
        if (CollectionUtil.isEmpty((Collection)poolCustomerEntityList)) {
            throw new HussarException("\u6240\u9009\u516c\u6d77\u6c60\u4e2d\u65e0\u5ba2\u6237");
        }
        LocalDateTime dateTime = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        CustomerPoolEntity newPool = (CustomerPoolEntity)this.getById(dto.getTargetCustomerPoolId());
        CustomerPoolEntity oldPool = (CustomerPoolEntity)this.getById(dto.getSourceCustomerPoolId());
        if (newPool == null) {
            throw new HussarException("\u76ee\u6807\u516c\u6d77\u6c60\u4e0d\u5b58\u5728");
        }
        this.poolCustomerService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PoolCustomerEntity::getCustomerPoolId, (Object)dto.getSourceCustomerPoolId())).set(PoolCustomerEntity::getCustomerPoolId, (Object)dto.getTargetCustomerPoolId()));
        List recordList = poolCustomerEntityList.stream().map(customer -> {
            HashMap<String, String> field = new HashMap<String, String>();
            ArrayList<HashMap<String, String>> changeField = new ArrayList<HashMap<String, String>>();
            HashMap<String, Object> before = new HashMap<String, Object>();
            HashMap<String, Object> after = new HashMap<String, Object>();
            before.put(CustomerPoolEditConstant.CUSTOMER_POOL_ID.getField(), oldPool.getCustomerPoolId());
            after.put(CustomerPoolEditConstant.CUSTOMER_POOL_ID.getField(), newPool.getCustomerPoolId());
            before.put(CustomerPoolEditConstant.CUSTOMER_POOL_NAME.getField(), oldPool.getCustomerPoolName());
            after.put(CustomerPoolEditConstant.CUSTOMER_POOL_NAME.getField(), newPool.getCustomerPoolName());
            field.put("field", CustomerPoolEditConstant.CUSTOMER_POOL_NAME.getField());
            field.put("fieldName", CustomerPoolEditConstant.CUSTOMER_POOL_NAME.getName());
            changeField.add(field);
            return this.getTrackRecord(customer.getCustomerId(), customer.getCustomerName(), CrmBusinessTypeEnum.CUSTOMER.getId(), dateTime, user.getUserId(), user.getUserName(), JSON.toJSONString(before), JSON.toJSONString(after), JSON.toJSONString(changeField), RecordProductTypeEnum.PRODUCE_POOL_TRANSFER.getId(), null);
        }).collect(Collectors.toList());
        this.operateRecordAPIService.saveOperateLogBatch(recordList);
        return ApiResponse.success((String)"\u8f6c\u79fb\u6210\u529f");
    }

    @Override
    @NotNull
    public OperateRecordAPIVo getTrackRecord(Long typeId, String businessName, String businessType, LocalDateTime date, Long userId, String userName, String before, String after, String changeField, String produceId, String content) {
        OperateRecordAPIVo record = new OperateRecordAPIVo();
        record.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
        record.setProduceType(produceId);
        record.setBusinessType(businessType);
        record.setTypeId(typeId);
        record.setBusinessName(businessName);
        record.setChangeBefore(before);
        record.setChangeAfter(after);
        record.setChangeField(changeField);
        record.setCreateTime(date);
        record.setChangeTime(date);
        record.setCreatePerson(userId);
        record.setChangePerson(userId);
        record.setCreatePersonName(userName);
        record.setChangePersonName(userName);
        record.setChangePerson(userId);
        record.setChangePersonName(userName);
        record.setRecordContent(content);
        record.setChangeBatch(1);
        record.setDelflag("0");
        return record;
    }

    @Override
    public ApiResponse<List<CustomerPoolVo>> selectableReleaseList() {
        SecurityUser user = BaseSecurityUtil.getUser();
        List deptId = this.organUserBoService.getParentOrganIncludeOneself(Collections.singletonList(user.getDeptId()));
        List<UserRoleVo> voList = this.commonMapper.getUsersRolesByUserIds(Collections.singletonList(user.getUserId()));
        List<String> roleList = voList.stream().map(UserRoleVo::getUserRoles).collect(Collectors.toList());
        List<CustomerPoolVo> customerPoolVoList = this.customerPoolMapper.selectCustomerPoolListPermission(user.getUserId(), deptId, roleList);
        return ApiResponse.success(customerPoolVoList);
    }

    @Override
    @Transactional
    public ApiResponse<String> distribute(PoolCustomerDto dto) {
        CustomerPoolClaimRule customerPoolClaimRule;
        String publicRuleClaim;
        SecurityUser user = BaseSecurityUtil.getUser();
        List poolCustomerEntityList = this.poolCustomerService.listByIds(dto.getCustomerIdList());
        boolean inClaimProcess = poolCustomerEntityList.stream().map(PoolCustomerEntity::getClaimApproval).collect(Collectors.toList()).contains("1");
        if (inClaimProcess) {
            throw new HussarException("\u5b58\u5728\u8ba4\u9886\u5ba1\u6279\u4e2d\u6570\u636e\uff0c\u65e0\u6cd5\u5206\u914d");
        }
        if (CollectionUtil.isEmpty((Collection)poolCustomerEntityList)) {
            throw new HussarException("\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        CustomerPoolEntity customerPool = (CustomerPoolEntity)this.getById(((PoolCustomerEntity)poolCustomerEntityList.get(0)).getCustomerPoolId());
        List adminList = this.customerPoolMemberService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerPoolMemberEntity::getMemberRole, (Object)"2")).eq(CustomerPoolMemberEntity::getCustomerPoolId, (Object)customerPool.getCustomerPoolId()));
        boolean permissionFlag = false;
        for (CustomerPoolMemberEntity memberEntity : adminList) {
            if ("1".equals(memberEntity.getMemberType()) && user.getUserId().equals(memberEntity.getMemberId())) {
                permissionFlag = true;
                break;
            }
            if (!"3".equals(memberEntity.getMemberType()) || !user.getRolesList().contains(memberEntity.getMemberId())) continue;
            permissionFlag = true;
            break;
        }
        if (!permissionFlag) {
            throw new HussarException("\u7528\u6237\u65e0\u5206\u914d\u6743\u9650");
        }
        LocalDateTime dateTime = LocalDateTime.now();
        SecurityUser chargeUser = this.userBoService.selectSecurityByUserId(dto.getChargePersonId());
        PersonWithDepInfo mapDepartment = CommonUtills.selectDepIdName(String.valueOf(dto.getChargePersonId()));
        String newOwnDepartment = mapDepartment.getDepartmentId().toString();
        String newOwnDepartmentName = mapDepartment.getDepartmentName();
        if (HussarUtils.isNotEmpty((Object)newOwnDepartment)) {
            chargeUser.setDeptId(Long.valueOf(newOwnDepartment));
        }
        chargeUser.setDeptName(newOwnDepartmentName);
        Long chargeUserId = chargeUser.getUserId();
        String chargeUserName = chargeUser.getUserName();
        ArrayList<CustomerEntity> customerEntityList = new ArrayList<CustomerEntity>();
        for (PoolCustomerEntity poolCustomerEntity : poolCustomerEntityList) {
            CustomerEntity customer2 = (CustomerEntity)BeanUtil.copyProperties((Object)poolCustomerEntity, CustomerEntity.class);
            customer2.setChargePersonId(chargeUserId);
            customer2.setChargePersonName(chargeUserName);
            customer2.setOwnDepartment(chargeUser.getDeptId());
            customer2.setOwnDepartmentName(chargeUser.getDeptName());
            customer2.setAllocateTime(dateTime);
            customer2.setAllocateUserId(user.getUserId());
            customer2.setAllocateUserName(user.getUserName());
            customer2.setResourcePoolId(customerPool.getCustomerPoolId());
            customer2.setChangePerson(user.getUserId());
            customer2.setChangePersonName(user.getUserName());
            customer2.setChangeTime(dateTime);
            customerEntityList.add(customer2);
        }
        this.customerService.saveOrUpdateBatch(customerEntityList);
        this.poolCustomerService.removeByIds(dto.getCustomerIdList());
        this.teamMeberService.insertTeamMemberBatch(chargeUserName, chargeUserId, customerEntityList.stream().map(CustomerEntity::getCustomerId).collect(Collectors.toList()), "1", "1", dateTime, "1");
        List customerRecordList = poolCustomerEntityList.stream().map(customer -> {
            HashMap<String, String> field = new HashMap<String, String>();
            ArrayList<HashMap<String, String>> changeField = new ArrayList<HashMap<String, String>>();
            HashMap<String, Object> before = new HashMap<String, Object>();
            HashMap<String, Object> after = new HashMap<String, Object>();
            before.put(CustomerPoolEditConstant.CUSTOMER_POOL_ID.getField(), customerPool.getCustomerPoolId());
            after.put(CustomerPoolEditConstant.POOL_TO_CHARGE_PERSON_ID.getField(), chargeUserId);
            before.put(CustomerPoolEditConstant.CUSTOMER_POOL_NAME.getField(), customerPool.getCustomerPoolName());
            after.put(CustomerPoolEditConstant.POOL_TO_CHARGE_PERSON_NAME.getField(), chargeUserName);
            field.put("field", CustomerPoolEditConstant.POOL_TO_CHARGE_PERSON_NAME.getField());
            field.put("fieldName", CustomerPoolEditConstant.POOL_TO_CHARGE_PERSON_NAME.getName());
            changeField.add(field);
            return this.getTrackRecord(customer.getCustomerId(), customer.getCustomerName(), CrmBusinessTypeEnum.CUSTOMER.getId(), dateTime, user.getUserId(), user.getUserName(), JSON.toJSONString(before), JSON.toJSONString(after), JSON.toJSONString(changeField), RecordProductTypeEnum.PRODUCE_POOL_ALLOCATE.getId(), null);
        }).collect(Collectors.toList());
        this.operateRecordAPIService.saveOperateLogBatch(customerRecordList);
        boolean transOpportunityFlag = false;
        PublicPoolRule publicPoolRule = (PublicPoolRule)((Object)this.publicPoolRuleService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PublicPoolRule::getPublicPoolRuleId, (Object)customerPool.getCustomerPoolRuleId())).eq(PublicPoolRule::getDelFlag, (Object)"0")));
        if ("1".equals(publicPoolRule.getPublicPoolRuleClaimSwitch()) && HussarUtils.isNotEmpty((Object)(publicRuleClaim = publicPoolRule.getPublicPoolRuleClaim())) && "1".equals((customerPoolClaimRule = (CustomerPoolClaimRule)JSONObject.parseObject((String)publicRuleClaim, CustomerPoolClaimRule.class)).getCirculateRule())) {
            transOpportunityFlag = true;
        }
        if (transOpportunityFlag) {
            List contactEntityList;
            List opportunityEntityList = this.opportunityService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(OpportunityEntity::getCustomerId, dto.getCustomerIdList())).eq(OpportunityEntity::getDelFlag, (Object)"0")).and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.ne(OpportunityEntity::getIsUnassigned, (Object)"1")).or()).isNull(OpportunityEntity::getIsUnassigned);
            }));
            if (CollectionUtil.isNotEmpty((Collection)opportunityEntityList)) {
                user.setUserName("\u7cfb\u7edf");
                this.opportunityTransferBatch(opportunityEntityList, chargeUser, dateTime, user, "\u6240\u5c5e\u5ba2\u6237\u5728\u516c\u6d77\u6c60\u4e2d\u88ab\u5206\u914d");
            }
            if (CollectionUtil.isNotEmpty((Collection)(contactEntityList = this.contactService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ContactEntity::getCustomerId, (Collection)customerEntityList.stream().map(CustomerEntity::getCustomerId).collect(Collectors.toList()))).eq(ContactEntity::getDelFlag, (Object)"0"))))) {
                user.setUserName("\u7cfb\u7edf");
                this.contactTransferBatch(contactEntityList, chargeUser, dateTime, user, "\u6240\u5c5e\u5ba2\u6237\u5728\u516c\u6d77\u6c60\u4e2d\u88ab\u5206\u914d");
            }
        }
        for (PoolCustomerEntity customer3 : poolCustomerEntityList) {
            String contentUnify;
            String content;
            String title;
            if (transOpportunityFlag) {
                title = "\u3010\u5206\u914d\u63d0\u9192\u3011" + user.getUserName() + "\u5c06\u5ba2\u6237\u53ca\u5176\u5546\u673a\u3001\u8054\u7cfb\u4eba\u5206\u914d\u7ed9\u4f60";
                content = "\u5ba2\u6237\u540d\u79f0\u3010" + customer3.getCustomerName() + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
                contentUnify = "\u3010\u5206\u914d\u63d0\u9192\u3011" + user.getUserName() + "\u5c06\u5ba2\u6237\u53ca\u5176\u5546\u673a\u3001\u8054\u7cfb\u4eba\u5206\u914d\u7ed9\u4f60\uff0c\u5ba2\u6237\u540d\u79f0\u3010" + customer3.getCustomerName() + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
            } else {
                title = "\u3010\u5206\u914d\u63d0\u9192\u3011" + user.getUserName() + "\u5c06\u5ba2\u6237\u5206\u914d\u7ed9\u4f60";
                content = "\u5ba2\u6237\u540d\u79f0\u3010" + customer3.getCustomerName() + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
                contentUnify = "\u3010\u5206\u914d\u63d0\u9192\u3011" + user.getUserName() + "\u5c06\u5ba2\u6237\u5206\u914d\u7ed9\u4f60\uff0c\u5ba2\u6237\u540d\u79f0\u3010" + customer3.getCustomerName() + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
            }
            EimPushUtil.pushJqxArticleMessage(title, content, "/crm/kh/khxq", customer3.getCustomerId().toString(), Collections.singletonList(String.valueOf(chargeUserId)));
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/clientDetails?row=" + "\"" + customer3.getCustomerId() + "\"";
            UnifyUtil.defaultMessage(addSysMessageType, contentUnify, dateTime, user, String.valueOf(chargeUserId), user.getUserName(), unifyWebUrl, "");
            UnifyUtil.sendMessage(addSysMessageType);
        }
        return ApiResponse.success();
    }

    @Override
    public void contactTransferBatch(List<ContactEntity> contactEntityList, SecurityUser chargeUser, LocalDateTime dateTime, SecurityUser user, String reason) {
        Long newChargePersonId = chargeUser.getUserId();
        String newChargePersonName = chargeUser.getUserName();
        ArrayList<CrmTeamAdminInfoDto> crmTeamAdminInfoDtoList = new ArrayList<CrmTeamAdminInfoDto>();
        ArrayList<ContactEntity> updateList = new ArrayList<ContactEntity>();
        ArrayList<TeamMeberDto> teamMeberDtoList = new ArrayList<TeamMeberDto>();
        for (ContactEntity contactEntity : contactEntityList) {
            ContactEntity contactEntity2 = contactEntityList.stream().filter(object -> Objects.equals(object.getContactId(), contactEntity.getContactId())).findFirst().get();
            String oldChargePersonName = contactEntity.getChargePersonName();
            Long oldChargePersonId = contactEntity.getChargePersonId();
            if (newChargePersonId.equals(oldChargePersonId)) continue;
            updateList.add(contactEntity);
            TeamMeberDto teamMeberDto = new TeamMeberDto();
            teamMeberDto.setBusinessId(contactEntity.getContactId());
            teamMeberDto.setPersonId(newChargePersonId);
            teamMeberDto.setDelFlag("0");
            teamMeberDtoList.add(teamMeberDto);
        }
        if (updateList.isEmpty()) {
            return;
        }
        this.contactService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(ContactEntity::getContactId, (Collection)updateList.stream().map(ContactEntity::getContactId).collect(Collectors.toList()))).set(ContactEntity::getChargePersonId, (Object)newChargePersonId)).set(ContactEntity::getChargePersonName, (Object)newChargePersonName)).set(ContactEntity::getChangeTime, (Object)dateTime)).set(ContactEntity::getChangePerson, null)).set(ContactEntity::getChangePersonName, (Object)"\u7cfb\u7edf")).set(ContactEntity::getOwnDepartment, (Object)chargeUser.getDeptId())).set(ContactEntity::getOwnDepartmentName, (Object)chargeUser.getDeptName()));
        ArrayList<TeamMeberEntity> teamMeberList = new ArrayList<TeamMeberEntity>();
        for (ContactEntity contact : updateList) {
            TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
            teamMeberEntity.setBusinessId(contact.getContactId());
            teamMeberEntity.setDelFlag("1");
            teamMeberEntity.setPersonId(contact.getChargePersonId());
            teamMeberList.add(teamMeberEntity);
        }
        this.teamMeberMapper.deleteChargePersonBatch(teamMeberList);
        List<Map<String, Object>> list = this.teamMeberMapper.selectTeamMeberListBatch(teamMeberDtoList);
        ArrayList<ContactEntity> insertMemberDtoList = new ArrayList<ContactEntity>();
        ArrayList<ContactEntity> updateChargeDtoList = new ArrayList<ContactEntity>();
        for (ContactEntity contact : updateList) {
            boolean flag = true;
            for (Map<String, Object> map : list) {
                if (!map.get("BUSINESS_ID").equals(contact.getContactId())) continue;
                updateChargeDtoList.add(contact);
                flag = false;
                break;
            }
            if (!flag) continue;
            insertMemberDtoList.add(contact);
        }
        if (ToolUtil.isNotEmpty(updateChargeDtoList)) {
            ArrayList<TeamMeberEntity> teamMeberEntityList = new ArrayList<TeamMeberEntity>();
            for (ContactEntity contact : updateChargeDtoList) {
                TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
                teamMeberEntity.setBusinessId(contact.getContactId());
                teamMeberEntity.setPersonId(newChargePersonId);
                teamMeberEntity.setIsCharge("1");
                teamMeberEntity.setMemberRole(null);
                teamMeberEntity.setModifyPower("1");
                teamMeberEntityList.add(teamMeberEntity);
            }
            this.teamMeberMapper.updateIsChargeBatch(teamMeberEntityList);
        }
        if (ToolUtil.isNotEmpty(insertMemberDtoList)) {
            this.teamMeberService.insertTeamMemberBatch(newChargePersonName, newChargePersonId, insertMemberDtoList.stream().map(ContactEntity::getContactId).collect(Collectors.toList()), "1", "1", ((ContactEntity)insertMemberDtoList.get(0)).getChangeTime(), "3");
        }
        ArrayList<OperateRecordAPIVo> trackRecordList = new ArrayList<OperateRecordAPIVo>();
        for (ContactEntity contact : updateList) {
            OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
            operateRecordDO.setContactId(newChargePersonId);
            operateRecordDO.setContactName(newChargePersonName);
            operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_TRANSFER.getId());
            operateRecordDO.setOldContactId(contact.getChargePersonId());
            operateRecordDO.setOldContactName(contact.getChargePersonName());
            operateRecordDO.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
            operateRecordDO.setBusinessType(CrmBusinessTypeEnum.CONTACT.getId());
            operateRecordDO.setTypeId(contact.getContactId());
            operateRecordDO.setBusinessName(contact.getContactName());
            operateRecordDO.setCreatePerson(null);
            operateRecordDO.setCreatePersonName("\u7cfb\u7edf");
            operateRecordDO.setCreateTime(dateTime);
            operateRecordDO.setChangePerson(null);
            operateRecordDO.setChangeTime(dateTime);
            operateRecordDO.setChangePersonName("\u7cfb\u7edf");
            operateRecordDO.setRecordContent(reason);
            operateRecordDO.setDelflag("0");
            if (operateRecordDO.getProduceType() == null) {
                operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
            }
            trackRecordList.add(operateRecordDO);
        }
        this.operateRecordAPIService.saveOperateLogBatch(trackRecordList);
        for (ContactEntity contact : updateList) {
            String contactName = contact.getContactName();
            Long contactId = contact.getContactId();
            Long oldChargePersonId = contact.getChargePersonId();
            String title = "\u7cfb\u7edf\u8f6c\u79fb\u4e86\u60a8\u8d1f\u8d23\u7684\u8054\u7cfb\u4eba";
            String content = "\u8054\u7cfb\u4eba\u540d\u79f0\u3010" + contactName + "\u3011\uff0c\u8f6c\u79fb\u7ed9" + chargeUser.getDeptName() + "-" + newChargePersonName + "\uff0c\u8bf7\u77e5\u6089\u3002";
            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/contactDetails?row=" + "\"" + contactId + "\"";
            EimPushUtil.pushJqxArticleMessage(title, content, "/crm/lxr/lxrxq", contactId.toString(), Collections.singletonList(String.valueOf(oldChargePersonId)));
            AddSysMessageType oldAddSysMessageType = new AddSysMessageType();
            String contentUnify = "\u3010\u8f6c\u79fb\u63d0\u9192\u3011\u7cfb\u7edf\u5c06\u60a8\u8d1f\u8d23\u7684\u8054\u7cfb\u4eba\u3010" + contactName + "\u3011\u8f6c\u79fb\u7ed9" + chargeUser.getDeptName() + "-" + newChargePersonName + "\uff0c\u8bf7\u77e5\u6089\u3002";
            UnifyUtil.defaultMessage(oldAddSysMessageType, contentUnify, dateTime, user, String.valueOf(oldChargePersonId), user.getUserName(), unifyWebUrl, "");
            UnifyUtil.sendMessage(oldAddSysMessageType);
            CrmTeamAdminInfoDto crmTeamAdminInfoDto = new CrmTeamAdminInfoDto();
            crmTeamAdminInfoDto.setBusinessType("3");
            crmTeamAdminInfoDto.setBusinessId(contactId);
            crmTeamAdminInfoDto.setNewChargePersonId(String.valueOf(newChargePersonId));
            crmTeamAdminInfoDto.setOldChargePersonId(String.valueOf(oldChargePersonId));
            crmTeamAdminInfoDto.setKeepFlag("0");
            crmTeamAdminInfoDtoList.add(crmTeamAdminInfoDto);
        }
        this.imGroupMemberService.transferAdmin(crmTeamAdminInfoDtoList);
    }

    @Override
    public void opportunityTransferBatch(List<OpportunityEntity> opportunityEntityList, SecurityUser chargeUser, LocalDateTime dateTime, SecurityUser user, String reason) {
        Long newChargePersonId = chargeUser.getUserId();
        String newOwnDepartmentName = chargeUser.getDeptName();
        String newChargePersonName = chargeUser.getUserName();
        ArrayList<CrmTeamAdminInfoDto> crmTeamAdminInfoDtoList = new ArrayList<CrmTeamAdminInfoDto>();
        ArrayList<OpportunityEntity> updateList = new ArrayList<OpportunityEntity>();
        ArrayList<TeamMeberDto> teamMeberDtoList = new ArrayList<TeamMeberDto>();
        for (OpportunityEntity opportunityEntity : opportunityEntityList) {
            Long oldChargePersonId = opportunityEntity.getChargePersonId();
            if (newChargePersonId.equals(oldChargePersonId)) continue;
            updateList.add(opportunityEntity);
            TeamMeberDto teamMeberDto = new TeamMeberDto();
            teamMeberDto.setBusinessId(opportunityEntity.getOpportunityId());
            teamMeberDto.setPersonId(newChargePersonId);
            teamMeberDto.setDelFlag("0");
            teamMeberDtoList.add(teamMeberDto);
        }
        if (updateList.isEmpty()) {
            return;
        }
        this.opportunityService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(OpportunityEntity::getOpportunityId, (Collection)updateList.stream().map(OpportunityEntity::getOpportunityId).collect(Collectors.toList()))).set(OpportunityEntity::getChargePersonId, (Object)newChargePersonId)).set(OpportunityEntity::getChargePersonName, (Object)newChargePersonName)).set(OpportunityEntity::getChangeTime, (Object)dateTime)).set(OpportunityEntity::getChangePerson, null)).set(OpportunityEntity::getChangePersonName, (Object)"\u7cfb\u7edf")).set(OpportunityEntity::getOwnDepartment, (Object)chargeUser.getDeptId())).set(OpportunityEntity::getOwnDepartmentName, (Object)chargeUser.getDeptName()));
        if (CollectionUtil.isNotEmpty(teamMeberDtoList)) {
            ArrayList<TeamMeberEntity> teamMeberEntityList = new ArrayList<TeamMeberEntity>();
            for (OpportunityEntity opportunity : updateList) {
                TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
                teamMeberEntity.setBusinessId(opportunity.getOpportunityId());
                teamMeberEntity.setDelFlag("1");
                teamMeberEntity.setPersonId(opportunity.getChargePersonId());
                teamMeberEntityList.add(teamMeberEntity);
            }
            this.teamMeberMapper.deleteChargePersonBatch(teamMeberEntityList);
        }
        List<Map<String, Object>> existTeamMemberList = this.teamMeberMapper.selectTeamMeberListBatch(teamMeberDtoList);
        ArrayList<OpportunityEntity> arrayList = new ArrayList<OpportunityEntity>();
        ArrayList<OpportunityEntity> updateChargeDtoList = new ArrayList<OpportunityEntity>();
        for (OpportunityEntity opportunity : updateList) {
            boolean flag = true;
            for (Map<String, Object> map : existTeamMemberList) {
                if (!map.get("BUSINESS_ID").equals(opportunity.getOpportunityId())) continue;
                updateChargeDtoList.add(opportunity);
                flag = false;
                break;
            }
            if (!flag) continue;
            arrayList.add(opportunity);
        }
        if (ToolUtil.isNotEmpty(updateChargeDtoList)) {
            ArrayList<TeamMeberEntity> teamMeberEntityList = new ArrayList<TeamMeberEntity>();
            for (OpportunityEntity opportunity : updateChargeDtoList) {
                TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
                teamMeberEntity.setBusinessId(opportunity.getOpportunityId());
                teamMeberEntity.setPersonId(newChargePersonId);
                teamMeberEntity.setIsCharge("1");
                teamMeberEntity.setMemberRole(null);
                teamMeberEntity.setModifyPower("1");
                teamMeberEntityList.add(teamMeberEntity);
            }
            this.teamMeberMapper.updateIsChargeBatch(teamMeberEntityList);
        }
        if (ToolUtil.isNotEmpty(arrayList)) {
            this.teamMeberService.insertTeamMemberBatch(newChargePersonName, newChargePersonId, arrayList.stream().map(OpportunityEntity::getOpportunityId).collect(Collectors.toList()), "1", "1", ((OpportunityEntity)arrayList.get(0)).getChangeTime(), "2");
        }
        ArrayList<OperateRecordAPIVo> operateRecordDOList = new ArrayList<OperateRecordAPIVo>();
        for (OpportunityEntity updateOpportunity : updateList) {
            OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
            operateRecordDO.setContactId(newChargePersonId);
            operateRecordDO.setContactName(newChargePersonName);
            operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_TRANSFER.getId());
            operateRecordDO.setOldContactId(updateOpportunity.getChargePersonId());
            operateRecordDO.setOldContactName(updateOpportunity.getChargePersonName());
            operateRecordDO.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
            operateRecordDO.setBusinessType(CrmBusinessTypeEnum.OPPORTUNITY.getId());
            operateRecordDO.setTypeId(updateOpportunity.getOpportunityId());
            operateRecordDO.setBusinessName(updateOpportunity.getOpportunityName());
            operateRecordDO.setCreatePerson(null);
            operateRecordDO.setCreatePersonName("\u7cfb\u7edf");
            operateRecordDO.setCreateTime(dateTime);
            operateRecordDO.setChangePerson(null);
            operateRecordDO.setChangeTime(dateTime);
            operateRecordDO.setChangePersonName("\u7cfb\u7edf");
            operateRecordDO.setDelflag("0");
            operateRecordDO.setRecordContent(reason);
            if (operateRecordDO.getProduceType() == null) {
                operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
            }
            operateRecordDOList.add(operateRecordDO);
        }
        this.operateRecordAPIService.saveOperateLogBatch(operateRecordDOList);
        for (OpportunityEntity opportunity : updateList) {
            Long opportunityId = opportunity.getOpportunityId();
            String opportunityName = opportunity.getOpportunityName();
            Long oldChargePersonId = opportunity.getChargePersonId();
            String oldTitle = "\u7cfb\u7edf\u8f6c\u79fb\u4e86\u60a8\u8d1f\u8d23\u7684\u5546\u673a";
            String oldContent = "\u5546\u673a\u540d\u79f0\u3010" + opportunityName + "\u3011\uff0c\u8f6c\u79fb\u7ed9" + newOwnDepartmentName + "-" + newChargePersonName + "\uff0c\u8bf7\u77e5\u6089\u3002";
            EimPushUtil.pushJqxArticleMessage(oldTitle, oldContent, "/crm/sj/sjxq/xxzl", opportunityId.toString(), Collections.singletonList(String.valueOf(oldChargePersonId)));
            AddSysMessageType oldAddSysMessageType = new AddSysMessageType();
            String oldContentUnify = "\u3010\u8f6c\u79fb\u63d0\u9192\u3011\u7cfb\u7edf\u5c06\u60a8\u8d1f\u8d23\u7684\u5546\u673a\u3010" + opportunityName + "\u3011\u8f6c\u79fb\u7ed9" + newOwnDepartmentName + "-" + newChargePersonName + "\uff0c\u8bf7\u77e5\u6089\u3002";
            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + opportunityId + "\"";
            UnifyUtil.defaultMessage(oldAddSysMessageType, oldContentUnify, dateTime, user, String.valueOf(oldChargePersonId), "\u7cfb\u7edf", unifyWebUrl, "");
            UnifyUtil.sendMessage(oldAddSysMessageType);
            CrmTeamAdminInfoDto crmTeamAdminInfoDto = new CrmTeamAdminInfoDto();
            crmTeamAdminInfoDto.setBusinessType("2");
            crmTeamAdminInfoDto.setBusinessId(opportunityId);
            crmTeamAdminInfoDto.setNewChargePersonId(String.valueOf(newChargePersonId));
            crmTeamAdminInfoDto.setOldChargePersonId(String.valueOf(opportunity.getChargePersonId()));
            crmTeamAdminInfoDto.setKeepFlag("0");
            crmTeamAdminInfoDtoList.add(crmTeamAdminInfoDto);
        }
        this.imGroupMemberService.transferAdmin(crmTeamAdminInfoDtoList);
    }
}

