/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.customer.service.impl;

import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeFiledQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeLabelVo;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.dict.IDictBoService;
import com.jxdinfo.crm.common.api.label.common.LabelModuleEnum;
import com.jxdinfo.crm.core.associateQuery.service.ICommonAssociateQueryService;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.customer.dto.CustomerAssociativeQueryDto;
import com.jxdinfo.crm.core.customer.dto.CustomerDto;
import com.jxdinfo.crm.core.customer.service.ICustomerAssociativeQueryService;
import com.jxdinfo.crm.core.customer.vo.CustomerAssociativeQueryEnum;
import com.jxdinfo.crm.core.opportunity.service.IOpportunityAssociativeQueryService;
import com.jxdinfo.crm.product.api.vo.AssociateProductVo;
import com.jxdinfo.crm.product.service.IAssociateProductService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CustomerAssociativeQueryServiceImpl
implements ICustomerAssociativeQueryService {
    @Resource
    private IAssociativeFiledQueryAPIService associativeFiledQueryAPIService;
    @Resource
    private IAssociateProductService associateProductService;
    @Resource
    private ICommonAssociateQueryService commonAssociateQueryService;
    @Resource
    private IDictBoService dictBoService;
    @Resource
    private CommonService commonService;
    @Resource
    private IOpportunityAssociativeQueryService opportunityAssociativeQueryService;

    public List<AssociativeQueryVo> getAssociativeQueryVo(String keyword, AssociativeQueryDto associativeQueryDto, Map<String, List<String>> excludeInfoMap) {
        ArrayList<AssociativeQueryVo> associativeQueryVoList = new ArrayList<AssociativeQueryVo>();
        CustomerAssociativeQueryDto customerAssociativeQueryDto = null;
        if (associativeQueryDto instanceof CustomerAssociativeQueryDto) {
            customerAssociativeQueryDto = (CustomerAssociativeQueryDto)associativeQueryDto;
        }
        assert (customerAssociativeQueryDto != null);
        CustomerDto customerDto = customerAssociativeQueryDto.getDto();
        List<String> labelList = null;
        String overdue = null;
        List<String> customerTypeList = null;
        List<String> custLevelList = null;
        List<String> customerOriginList = null;
        List<String> customerAttributeList = null;
        List<String> tradeList = null;
        List<Long> provinceList = null;
        List<String> dealStates = null;
        String createTimeTage = null;
        String trackTimeFlag = null;
        List<String> ownDepartmentList = null;
        List<String> chargePersonIdList = null;
        List<String> teamMemberIdList = null;
        List<String> customerStageList = null;
        List<String> corporateScaleList = null;
        List<String> corporateImpactList = null;
        List<String> listingStatusList = null;
        List<String> customerRelationList = null;
        List<String> customerRiskList = null;
        List<String> customerRiskPointList = null;
        List<String> stageProcessIds = null;
        List<String> customerStageIds = null;
        String recycleTimeFlag = null;
        String claimTimeFlag = null;
        String allocateTimeFlag = null;
        if (customerDto != null) {
            labelList = customerDto.getLabelIds();
            overdue = customerDto.getOverdueFollow();
            customerTypeList = customerDto.getCustomerIds();
            custLevelList = customerDto.getCustLevels();
            customerOriginList = customerDto.getCustomerOrigins();
            customerAttributeList = customerDto.getCustomerAttributes();
            tradeList = customerDto.getTrades();
            provinceList = customerDto.getProvinces();
            dealStates = customerDto.getDealStates();
            createTimeTage = customerDto.getCreateTimeFlag();
            trackTimeFlag = customerDto.getTrackTimeFlag();
            ownDepartmentList = customerDto.getOwnDepartments();
            chargePersonIdList = customerDto.getChargePersonIds();
            teamMemberIdList = customerDto.getTeamMemberIds();
            customerStageList = customerDto.getCustStageList();
            corporateScaleList = customerDto.getCorpScaleList();
            corporateImpactList = customerDto.getCorpImpactList();
            listingStatusList = customerDto.getListingStatusList();
            customerRelationList = customerDto.getCustRelationList();
            customerRiskList = customerDto.getCustRiskList();
            customerRiskPointList = customerDto.getRiskPointList();
            stageProcessIds = customerDto.getStageProcessIds();
            customerStageIds = customerDto.getCustomerIds();
            recycleTimeFlag = customerDto.getRecycleTimeFlag();
            claimTimeFlag = customerDto.getClaimTimeFlag();
            allocateTimeFlag = customerDto.getAllocateTimeFlag();
        }
        String moduleId = LabelModuleEnum.CUSTOMER.getModuleId();
        List selectedLabels = excludeInfoMap.get("selectedLabels");
        selectedLabels = this.associativeFiledQueryAPIService.getLabelAssociativeQuery(associativeQueryVoList, keyword, selectedLabels, labelList, moduleId);
        excludeInfoMap.put("selectedLabels", selectedLabels);
        List<String> selectedOverdues = excludeInfoMap.get("selectedOverdues");
        selectedOverdues = this.commonAssociateQueryService.getOverdueAssociativeQuery(associativeQueryVoList, keyword, selectedOverdues, overdue);
        excludeInfoMap.put("selectedOverdues", selectedOverdues);
        List selectedCustomerTypes = excludeInfoMap.get("selectedCustomerTypes");
        selectedCustomerTypes = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCustomerTypes, customerTypeList, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_TYPE));
        excludeInfoMap.put("selectedCustomerTypes", selectedCustomerTypes);
        List selectedCustLevel = excludeInfoMap.get("selectedCustLevel");
        selectedCustLevel = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCustLevel, custLevelList, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_LEVEL));
        excludeInfoMap.put("selectedCustLevel", selectedCustLevel);
        List selectedCustomerOrigins = excludeInfoMap.get("selectedCustomerOrigins");
        selectedCustomerOrigins = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCustomerOrigins, customerOriginList, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_SOURCE));
        excludeInfoMap.put("selectedCustomerOrigins", selectedCustomerOrigins);
        List selectedCustomerAttributes = excludeInfoMap.get("selectedCustomerAttributes");
        selectedCustomerAttributes = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCustomerAttributes, customerAttributeList, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_ATTRIBUTE));
        excludeInfoMap.put("selectedCustomerAttributes", selectedCustomerAttributes);
        List selectedTrades = excludeInfoMap.get("selectedTrades");
        selectedTrades = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedTrades, tradeList, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_INDUSTRY));
        excludeInfoMap.put("selectedTrades", selectedTrades);
        List selectedProvinces = excludeInfoMap.get("selectedProvinces");
        selectedProvinces = this.associativeFiledQueryAPIService.getProvinceAssociativeQuery(associativeQueryVoList, keyword, selectedProvinces, provinceList, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_PROVINCE));
        excludeInfoMap.put("selectedProvinces", selectedProvinces);
        List<String> selectDealStates = excludeInfoMap.get("selectDealStates");
        selectDealStates = this.getDealStateAssociativeQuery(associativeQueryVoList, keyword, selectDealStates, dealStates);
        excludeInfoMap.put("selectDealStates", selectDealStates);
        List selectedCreateTimes = excludeInfoMap.get("selectedCreateTimes");
        selectedCreateTimes = this.associativeFiledQueryAPIService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedCreateTimes, createTimeTage, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_CREATE_TIME));
        excludeInfoMap.put("selectedCreateTimes", selectedCreateTimes);
        List selectedTrackTimes = excludeInfoMap.get("selectedTrackTimes");
        selectedTrackTimes = this.associativeFiledQueryAPIService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedTrackTimes, trackTimeFlag, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_TRACK_TIME));
        excludeInfoMap.put("selectedTrackTimes", selectedTrackTimes);
        List selectedOwnDepartments = excludeInfoMap.get("selectedOwnDepartments");
        selectedOwnDepartments = this.associativeFiledQueryAPIService.getDepartmentAssociativeQuery(associativeQueryVoList, keyword, selectedOwnDepartments, ownDepartmentList, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_OWN_DEPARTMENTS));
        excludeInfoMap.put("selectedOwnDepartments", selectedOwnDepartments);
        List selectedChargePersonIds = excludeInfoMap.get("selectedChargePersonIds");
        selectedChargePersonIds = this.associativeFiledQueryAPIService.getUsersAssociativeQuery(associativeQueryVoList, keyword, selectedChargePersonIds, chargePersonIdList, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_CHARGE_PERSON));
        excludeInfoMap.put("selectedChargePersonIds", selectedChargePersonIds);
        List selectedTeamMemberIds = excludeInfoMap.get("selectedTeamMemberIds");
        selectedTeamMemberIds = this.associativeFiledQueryAPIService.getUsersAssociativeQuery(associativeQueryVoList, keyword, selectedTeamMemberIds, teamMemberIdList, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_TEAM_MEMBER));
        excludeInfoMap.put("selectedTeamMemberIds", selectedTeamMemberIds);
        List<String> selectedOpptyStageProcesses = excludeInfoMap.get("selectedOpptyStageProcesses");
        selectedOpptyStageProcesses = this.commonAssociateQueryService.getOpptyStageProcessAssociativeQuery(associativeQueryVoList, keyword, selectedOpptyStageProcesses, stageProcessIds, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_OPPORTUNITY_STAGE_PROCESS));
        excludeInfoMap.put("selectedOpptyStageProcesses", selectedOpptyStageProcesses);
        List<String> selectedStageId = excludeInfoMap.get("selectedStageId");
        selectedStageId = this.commonAssociateQueryService.getCustomerStageIdAssociativeQuery(associativeQueryVoList, keyword, selectedStageId, customerStageIds, stageProcessIds, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_OPPORTUNITY_STAGE));
        excludeInfoMap.put("selectedStageId", selectedStageId);
        List<String> selectedRelationProduct = excludeInfoMap.get("selectedRelationProduct");
        selectedRelationProduct = this.getRelationProductAssociativeQuery(associativeQueryVoList, keyword, selectedRelationProduct, customerDto, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_PRODUCT_TYPES));
        excludeInfoMap.put("selectedRelationProduct", selectedRelationProduct);
        List selectedCustomerStages = excludeInfoMap.get("selectedCustomerStages");
        selectedCustomerStages = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCustomerStages, customerStageList, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_STAGE));
        excludeInfoMap.put("selectedCustomerStages", selectedCustomerStages);
        List selectedCorporateScales = excludeInfoMap.get("selectedCorporateScales");
        selectedCorporateScales = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCorporateScales, corporateScaleList, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CORPORATE_SCALE));
        excludeInfoMap.put("selectedCorporateScales", selectedCorporateScales);
        List selectedCorporateImpacts = excludeInfoMap.get("selectedCorporateImpacts");
        selectedCorporateImpacts = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCorporateImpacts, corporateImpactList, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CORPORATE_IMPACT));
        excludeInfoMap.put("selectedCorporateImpacts", selectedCorporateImpacts);
        List selectedListingStatusList = excludeInfoMap.get("selectedListingStatusList");
        selectedListingStatusList = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedListingStatusList, listingStatusList, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_LISTING_STATUS));
        excludeInfoMap.put("selectedListingStatusList", selectedListingStatusList);
        List selectedCustomerRelations = excludeInfoMap.get("selectedCustomerRelations");
        selectedCustomerRelations = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCustomerRelations, customerRelationList, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_RELATION));
        excludeInfoMap.put("selectedCustomerRelations", selectedCustomerRelations);
        List selectedCustomerRiskLisk = excludeInfoMap.get("selectedCustomerRiskLisk");
        selectedCustomerRiskLisk = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCustomerRiskLisk, customerRiskList, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_RISK));
        excludeInfoMap.put("selectedCustomerRiskLisk", selectedCustomerRiskLisk);
        List selectedCustomerRiskPointLisk = excludeInfoMap.get("selectedCustomerRiskPointLisk");
        selectedCustomerRiskPointLisk = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCustomerRiskPointLisk, customerRiskPointList, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_RISK_POINT));
        excludeInfoMap.put("selectedCustomerRiskPointLisk", selectedCustomerRiskPointLisk);
        List<String> recycleTimes = excludeInfoMap.get("recycleTimes");
        recycleTimes = this.opportunityAssociativeQueryService.getRecycleTimeTageAssociativeQuery(associativeQueryVoList, keyword, recycleTimes, recycleTimeFlag, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_RECYCLE_TIME));
        excludeInfoMap.put("recycleTimes", recycleTimes);
        List claimTimes = excludeInfoMap.get("claimTimes");
        claimTimes = this.associativeFiledQueryAPIService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, claimTimes, claimTimeFlag, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_CLAIM_TIME));
        excludeInfoMap.put("claimTimes", claimTimes);
        List allocateTimes = excludeInfoMap.get("allocateTimes");
        allocateTimes = this.associativeFiledQueryAPIService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, allocateTimes, allocateTimeFlag, this.getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum.CUSTOMER_ALLOCATE_TIME));
        excludeInfoMap.put("allocateTimes", allocateTimes);
        return associativeQueryVoList;
    }

    private AssociativeLabelVo getAssociateLabelVoByEnum(CustomerAssociativeQueryEnum queryEnum) {
        return new AssociativeLabelVo(queryEnum.getLabelName(), queryEnum.getDataName(), queryEnum.getDictTypeName(), queryEnum.getMultiOption());
    }

    public List<String> getRelationProductAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedRelationProduct, CustomerDto dto, AssociativeLabelVo associativeLabelVo) {
        List productList;
        if (ToolUtil.isNotEmpty((Object)dto) && ToolUtil.isEmpty((Object)dto.getRelationProduct()) && ToolUtil.isNotEmpty((Object)(productList = this.associateProductService.getProductList(keyword, new ArrayList())))) {
            for (AssociateProductVo product : productList) {
                AssociativeQueryVo productAssociative = this.associativeFiledQueryAPIService.getAssociativeQueryVo(associativeLabelVo, product.getProductName(), String.valueOf(product.getProductId()));
                associativeQueryVoList.add(productAssociative);
                if (CollectionUtil.isEmpty(selectedRelationProduct)) {
                    selectedRelationProduct = new ArrayList<String>();
                }
                selectedRelationProduct.add(String.valueOf(product.getProductId()));
            }
        }
        return selectedRelationProduct;
    }

    public List<String> getDealStateAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectDealStates, List<String> dealStates) {
        ArrayList<String> states = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(dealStates)) {
            states.addAll(dealStates);
        }
        if (CollectionUtil.isEmpty(selectDealStates)) {
            selectDealStates = new ArrayList<String>();
        }
        states.addAll(selectDealStates);
        List opportunityTypeDicVoList = this.dictBoService.getDicValue("deal_state", keyword, states);
        if (ToolUtil.isNotEmpty((Object)opportunityTypeDicVoList)) {
            for (DicVo dicVo : opportunityTypeDicVoList) {
                AssociativeQueryVo customerTypeAssociative = new AssociativeQueryVo();
                customerTypeAssociative.setLabelName("\u6210\u4ea4\u72b6\u6001\uff1a");
                customerTypeAssociative.setDataName("dealStates");
                customerTypeAssociative.setMultiOption(Boolean.valueOf(true));
                customerTypeAssociative.setTips("\u6210\u4ea4\u72b6\u6001\uff1a " + dicVo.getLabel());
                customerTypeAssociative.setOptionName(dicVo.getLabel());
                customerTypeAssociative.setOptionValue(dicVo.getValue());
                associativeQueryVoList.add(customerTypeAssociative);
                selectDealStates.add(dicVo.getValue());
            }
        }
        return selectDealStates;
    }
}

