/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.crm.agent.api.service.IAgentApiService;
import com.jxdinfo.crm.agent.api.vo.AgentApiVo;
import com.jxdinfo.crm.common.api.label.dto.SaveLabelDto;
import com.jxdinfo.crm.common.api.label.service.ILabelService;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.dao.CrmOpportunity2Mapper;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.dto.CrmOpportunity2Crmopportunity2dataset1;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.dto.CrmOpportunity2Crmopportunity2dataset2;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.model.CrmOpportunity2;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.service.CrmOpportunity2Service;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.vo.CrmOpportunity2PageVO;
import com.jxdinfo.crm.core.customer.model.CustomerIncludePool;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.customer.service.ICustomerIncludePoolService;
import com.jxdinfo.crm.core.focus.dao.FocusMapper;
import com.jxdinfo.crm.core.leads.dao.LeadsMapper;
import com.jxdinfo.crm.core.leads.service.LeadsService;
import com.jxdinfo.crm.core.opportunity.constant.OpportunityEditConstant;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.opportunitystage.model.StageProcessEntity;
import com.jxdinfo.crm.core.opportunitystage.service.IStageProcessService;
import com.jxdinfo.crm.core.teammeber.dao.TeamMeberMapper;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.region.model.SysRegion;
import com.jxdinfo.hussar.region.service.IHussarBaseRegionService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="crm.datasourcefolder.customer.crmopportunity2.CrmOpportunity2ServiceImpl")
@HussarDs(value="master")
public class CrmOpportunity2ServiceImpl
extends HussarServiceImpl<CrmOpportunity2Mapper, CrmOpportunity2>
implements CrmOpportunity2Service {
    private static final Logger logger = LoggerFactory.getLogger(CrmOpportunity2ServiceImpl.class);
    private static final String RETURN_CODE = "0";
    @Autowired
    private CrmOpportunity2Mapper crmOpportunity2Mapper;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private FocusMapper focusMapper;
    @Resource
    private TeamMeberMapper teamMeberMapper;
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private LeadsService leadsService;
    @Resource
    private LeadsMapper leadsMapper;
    @Resource
    private CustomerService customerService;
    @Resource
    private IHussarBaseRegionService iHussarBaseRegionService;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private ILabelService labelService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private IAgentApiService agentApiService;
    @Resource
    private IStageProcessService stageProcessService;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private ICustomerIncludePoolService customerIncludePoolService;

    @Override
    @DSTransactional
    public ApiResponse<String> insertOrUpdate(CrmOpportunity2 crmOpportunity2) {
        SaveLabelDto saveLabelDto;
        List<String> productManagerIds;
        List<String> focusId;
        List<String> userIds;
        StageProcessEntity stageProcess;
        boolean labelFlag = true;
        if (HussarUtils.isNotEmpty((Object)crmOpportunity2.getOpportunityId())) {
            labelFlag = false;
            crmOpportunity2.setState(null);
        }
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        if (crmOpportunity2.getTelephone() != null) {
            crmOpportunity2.setTelephone(crmOpportunity2.getTelephone().replace(" ", ""));
        }
        if (crmOpportunity2.getMobilePhone() != null) {
            crmOpportunity2.setMobilePhone(crmOpportunity2.getMobilePhone().replace(" ", ""));
        }
        if (crmOpportunity2.getEmail() != null) {
            crmOpportunity2.setEmail(crmOpportunity2.getEmail().replace(" ", ""));
        }
        CrmOpportunity2 opportunity = (CrmOpportunity2)this.getById(crmOpportunity2.getOpportunityId());
        if (crmOpportunity2.getStageProcessId() != null && !opportunity.getStageProcessId().equals(crmOpportunity2.getStageProcessId()) && ((stageProcess = (StageProcessEntity)this.stageProcessService.getById(crmOpportunity2.getStageProcessId())) == null || Objects.equals(stageProcess.getDelFlag(), "1"))) {
            throw new HussarException("\u6240\u9009\u6d41\u7a0b\u4e0d\u5b58\u5728");
        }
        crmOpportunity2.setTrackTime(null);
        String oldAmount = String.valueOf(opportunity.getOpportunityAmount());
        String newAmount = String.valueOf(crmOpportunity2.getOpportunityAmount());
        String oldDate = "\u7a7a";
        if (ToolUtil.isNotEmpty((Object)opportunity.getEndTime())) {
            oldDate = String.valueOf(opportunity.getEndTime()).substring(0, 10);
        }
        String newDate = "\u7a7a";
        if (ToolUtil.isNotEmpty((Object)crmOpportunity2.getEndTime())) {
            newDate = String.valueOf(crmOpportunity2.getEndTime()).substring(0, 10);
        }
        if (!oldAmount.equals(newAmount)) {
            Double oldOpportunityAmount = opportunity.getOpportunityAmount() == null ? 0.0 : opportunity.getOpportunityAmount() / 10000.0;
            Double newOpportunityAmount = crmOpportunity2.getOpportunityAmount() == null ? 0.0 : crmOpportunity2.getOpportunityAmount() / 10000.0;
            DecimalFormat df = new DecimalFormat("#,##0.00");
            df.setRoundingMode(RoundingMode.HALF_UP);
            String oldOppAmount = df.format(oldOpportunityAmount);
            String newOppAmount = df.format(newOpportunityAmount);
            List<String> focusId2 = this.focusMapper.selectCreateId("2", crmOpportunity2.getOpportunityId());
            List<String> productManagerIds2 = this.opportunityMapper.opportunityProductManagerList(crmOpportunity2.getOpportunityId(), RETURN_CODE, null);
            List<String> userIds2 = Stream.of(focusId2, productManagerIds2).flatMap(Collection::stream).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(userIds2)) {
                String title = "\u3010" + crmOpportunity2.getOpportunityName() + "\u3011\u5546\u673a\u91d1\u989d\u53d8\u5316";
                String content = "\u5546\u673a\u91d1\u989d\u7531" + oldOppAmount + "\u4e07\u5143\u8c03\u6574\u4e3a" + newOppAmount + "\u4e07\u5143";
                EimPushUtil.pushJqxArticleMessage(title, content, "/crm/sj/sjxq/xxzl", String.valueOf(crmOpportunity2.getOpportunityId()), userIds2);
                AddSysMessageType addSysMessageType = new AddSysMessageType();
                String userIdToString = StringUtil.join(userIds2, (String)",");
                String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + crmOpportunity2.getOpportunityId() + "\"";
                String contentUnify = "\u3010\u5546\u673a\u52a8\u6001\u3011\u3010" + crmOpportunity2.getOpportunityName() + "\u3011\u5546\u673a\u91d1\u989d\u7531" + oldOppAmount + "\u4e07\u5143\u8c03\u6574\u4e3a" + newOppAmount + "\u4e07\u5143";
                UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, userIdToString, user.getUserName(), unifyWebUrl, "");
                UnifyUtil.sendMessage(addSysMessageType);
            }
        }
        if (!oldDate.equals(newDate) && CollectionUtil.isNotEmpty(userIds = Stream.of(focusId = this.focusMapper.selectCreateId("2", crmOpportunity2.getOpportunityId()), productManagerIds = this.opportunityMapper.opportunityProductManagerList(crmOpportunity2.getOpportunityId(), RETURN_CODE, null)).flatMap(Collection::stream).collect(Collectors.toList()))) {
            String title = "\u3010" + crmOpportunity2.getOpportunityName() + "\u3011\u9884\u8ba1\u6210\u4ea4\u65e5\u671f\u53d8\u5316";
            String content = "\u9884\u8ba1\u6210\u4ea4\u65e5\u671f\u7531" + oldDate + "\u8c03\u6574\u4e3a" + newDate;
            EimPushUtil.pushJqxArticleMessage(title, content, "/crm/sj/sjxq/xxzl", String.valueOf(crmOpportunity2.getOpportunityId()), userIds);
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            String userIdToString = StringUtil.join(userIds, (String)",");
            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + crmOpportunity2.getOpportunityId() + "\"";
            String contentUnify = "\u3010\u5546\u673a\u52a8\u6001\u3011\u3010" + crmOpportunity2.getOpportunityName() + "\u3011\u9884\u8ba1\u6210\u4ea4\u65e5\u671f\u7531" + oldDate + "\u8c03\u6574\u4e3a" + newDate;
            UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, userIdToString, user.getUserName(), unifyWebUrl, "");
            UnifyUtil.sendMessage(addSysMessageType);
        }
        if (crmOpportunity2.getOpportunityAmount() == null) {
            crmOpportunity2.setOpportunityAmount(0.0);
        }
        if (crmOpportunity2.getCustomerBudget() == null) {
            crmOpportunity2.setCustomerBudget(0.0);
        }
        StringBuilder sb = new StringBuilder();
        if (ToolUtil.isEmpty((Object)crmOpportunity2.getProvince())) {
            crmOpportunity2.setProvince(null);
        } else {
            SysRegion province = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(crmOpportunity2.getProvince()));
            if (ToolUtil.isNotEmpty((Object)province)) {
                sb.append(province.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)crmOpportunity2.getCity())) {
            crmOpportunity2.setCity(null);
        } else {
            SysRegion city = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(crmOpportunity2.getCity()));
            if (ToolUtil.isNotEmpty((Object)city)) {
                sb.append("/").append(city.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)crmOpportunity2.getCounty())) {
            crmOpportunity2.setCounty(null);
        } else {
            SysRegion county = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(crmOpportunity2.getCounty()));
            if (ToolUtil.isNotEmpty((Object)county)) {
                sb.append("/").append(county.getName());
            }
        }
        crmOpportunity2.setRegionLabel(sb.toString());
        LambdaUpdateWrapper lambdaUpdate = Wrappers.lambdaUpdate();
        lambdaUpdate.eq(CrmOpportunity2::getOpportunityId, (Object)crmOpportunity2.getOpportunityId());
        if (crmOpportunity2.getAgentId() == null) {
            lambdaUpdate.set(CrmOpportunity2::getAgentId, null);
        }
        this.saveOrUpdate(crmOpportunity2, (Wrapper)lambdaUpdate);
        if (labelFlag && HussarUtils.isNotEmpty((Object)(saveLabelDto = crmOpportunity2.getSaveLabelDto())) && HussarUtils.isNotEmpty((Object)saveLabelDto.getBusinessId())) {
            saveLabelDto.setChooseBatch(Boolean.valueOf(false));
            saveLabelDto.setModuleId("opportunity");
            this.labelService.userSaveLabel(saveLabelDto);
        }
        CrmOpportunity2 opportunityForOperateRecord = (CrmOpportunity2)this.getById(crmOpportunity2.getOpportunityId());
        this.opportunitySaveTrackRecord(opportunity, opportunityForOperateRecord);
        return ApiResponse.success((Object)String.valueOf(crmOpportunity2.getOpportunityId()), (String)"");
    }

    @Override
    public void opportunitySaveTrackRecord(CrmOpportunity2 oldOpportunity, CrmOpportunity2 newOpportunity) {
        HashMap<String, String> field;
        boolean changeFlag = false;
        LocalDateTime date = LocalDateTime.now();
        ArrayList changeField = new ArrayList();
        HashMap<String, Object> before = new HashMap<String, Object>();
        HashMap<String, Object> after = new HashMap<String, Object>();
        String oldOpportunityName = oldOpportunity.getOpportunityName();
        String newOpportunityName = newOpportunity.getOpportunityName();
        if (!(ToolUtil.isEmpty((Object)oldOpportunityName) && ToolUtil.isEmpty((Object)newOpportunityName) || !ToolUtil.isEmpty((Object)oldOpportunityName) && oldOpportunityName.equals(newOpportunityName))) {
            HashMap<String, String> field2 = new HashMap<String, String>();
            field2.put("field", OpportunityEditConstant.OPPORTUNITY_NAME.getField());
            field2.put("fieldName", OpportunityEditConstant.OPPORTUNITY_NAME.getName());
            changeField.add(field2);
            before.put(OpportunityEditConstant.OPPORTUNITY_NAME.getField(), oldOpportunityName);
            after.put(OpportunityEditConstant.OPPORTUNITY_NAME.getField(), newOpportunityName);
            changeFlag = true;
        }
        String oldCustomerName = oldOpportunity.getCustomerName();
        String newCustomerName = newOpportunity.getCustomerName();
        if (!(ToolUtil.isEmpty((Object)oldCustomerName) && ToolUtil.isEmpty((Object)newCustomerName) || !ToolUtil.isEmpty((Object)oldCustomerName) && oldCustomerName.equals(newCustomerName))) {
            HashMap<String, String> field3 = new HashMap<String, String>();
            field3.put("field", OpportunityEditConstant.CUSTOMER_NAME.getField());
            field3.put("fieldName", OpportunityEditConstant.CUSTOMER_NAME.getName());
            changeField.add(field3);
            before.put(OpportunityEditConstant.CUSTOMER_NAME.getField(), oldCustomerName);
            after.put(OpportunityEditConstant.CUSTOMER_NAME.getField(), newCustomerName);
            changeFlag = true;
        }
        Long oldStageProcessId = oldOpportunity.getStageProcessId();
        Long newStageProcessId = newOpportunity.getStageProcessId();
        if (!(ToolUtil.isEmpty((Object)oldStageProcessId) && ToolUtil.isEmpty((Object)newStageProcessId) || !ToolUtil.isEmpty((Object)oldStageProcessId) && oldStageProcessId.equals(newStageProcessId))) {
            StageProcessEntity oldStageProcess = (StageProcessEntity)this.stageProcessService.getById(oldStageProcessId);
            StageProcessEntity newStageProcess = (StageProcessEntity)this.stageProcessService.getById(newStageProcessId);
            HashMap<String, String> field4 = new HashMap<String, String>();
            field4.put("field", OpportunityEditConstant.OPPORTUNITY_STAGE_PROCESS_NAME.getField());
            field4.put("fieldName", OpportunityEditConstant.OPPORTUNITY_STAGE_PROCESS_NAME.getName());
            changeField.add(field4);
            before.put(OpportunityEditConstant.OPPORTUNITY_STAGE_PROCESS_NAME.getField(), oldStageProcess.getProcessName());
            after.put(OpportunityEditConstant.OPPORTUNITY_STAGE_PROCESS_NAME.getField(), newStageProcess.getProcessName());
            before.put(OpportunityEditConstant.OPPORTUNITY_STAGE_PROCESS_ID.getField(), oldStageProcessId);
            after.put(OpportunityEditConstant.OPPORTUNITY_STAGE_PROCESS_ID.getField(), newStageProcessId);
            changeFlag = true;
        }
        String oldOpportunityType = oldOpportunity.getOpopportunityType();
        String newOpportunityType = newOpportunity.getOpopportunityType();
        if (!(ToolUtil.isEmpty((Object)oldOpportunityType) && ToolUtil.isEmpty((Object)newOpportunityType) || !ToolUtil.isEmpty((Object)oldOpportunityType) && oldOpportunityType.equals(newOpportunityType))) {
            List list = this.sysDicRefService.getDictByType("oppport_type");
            String oldOpportunityTypeLabel = "";
            String newOpportunityTypeLabel = "";
            for (DicSingle dicSingle : list) {
                if (dicSingle.getValue().equals(oldOpportunityType)) {
                    oldOpportunityTypeLabel = dicSingle.getLabel();
                }
                if (!dicSingle.getValue().equals(newOpportunityType)) continue;
                newOpportunityTypeLabel = dicSingle.getLabel();
            }
            field = new HashMap<String, String>();
            field.put("field", OpportunityEditConstant.OPOPPORTUNITY_TYPE.getField());
            field.put("fieldName", OpportunityEditConstant.OPOPPORTUNITY_TYPE.getName());
            changeField.add(field);
            before.put(OpportunityEditConstant.OPOPPORTUNITY_TYPE.getField(), oldOpportunityTypeLabel);
            after.put(OpportunityEditConstant.OPOPPORTUNITY_TYPE.getField(), newOpportunityTypeLabel);
            changeFlag = true;
        }
        Double oldOpportunityAmount = oldOpportunity.getOpportunityAmount();
        Double newOpportunityAmount = newOpportunity.getOpportunityAmount();
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
        oldOpportunityAmount = oldOpportunityAmount == null ? 0.0 : oldOpportunityAmount;
        newOpportunityAmount = newOpportunityAmount == null ? 0.0 : newOpportunityAmount;
        if (!(ToolUtil.isEmpty((Object)oldOpportunityAmount) && ToolUtil.isEmpty((Object)newOpportunityAmount) || !ToolUtil.isEmpty((Object)oldOpportunityAmount) && oldOpportunityAmount.equals(newOpportunityAmount))) {
            field = new HashMap();
            field.put("field", OpportunityEditConstant.OPPORTUNITY_AMOUNT.getField());
            field.put("fieldName", OpportunityEditConstant.OPPORTUNITY_AMOUNT.getName());
            changeField.add(field);
            String oldAmount = decimalFormat.format(oldOpportunityAmount);
            String newAmount = decimalFormat.format(newOpportunityAmount);
            before.put(OpportunityEditConstant.OPPORTUNITY_AMOUNT.getField(), oldAmount);
            after.put(OpportunityEditConstant.OPPORTUNITY_AMOUNT.getField(), newAmount);
            changeFlag = true;
        }
        LocalDateTime oldDate = oldOpportunity.getEndTime();
        LocalDateTime newDate = newOpportunity.getEndTime();
        String oldEndTime = "\u7a7a";
        String newEndTime = "\u7a7a";
        if (ToolUtil.isNotEmpty((Object)oldDate)) {
            oldEndTime = String.valueOf(oldDate).substring(0, 10);
        }
        if (ToolUtil.isNotEmpty((Object)newDate)) {
            newEndTime = String.valueOf(newDate).substring(0, 10);
        }
        if (!(ToolUtil.isEmpty((Object)oldEndTime) && ToolUtil.isEmpty((Object)newEndTime) || !ToolUtil.isEmpty((Object)oldEndTime) && oldEndTime.equals(newEndTime))) {
            HashMap<String, String> field5 = new HashMap<String, String>();
            field5.put("field", OpportunityEditConstant.END_TIME.getField());
            field5.put("fieldName", OpportunityEditConstant.END_TIME.getName());
            changeField.add(field5);
            before.put(OpportunityEditConstant.END_TIME.getField(), oldEndTime);
            after.put(OpportunityEditConstant.END_TIME.getField(), newEndTime);
            changeFlag = true;
        }
        String oldOpportunityFrom = oldOpportunity.getOpopportunityFrom();
        String newOpportunityFrom = newOpportunity.getOpopportunityFrom();
        if (!(ToolUtil.isEmpty((Object)oldOpportunityFrom) && ToolUtil.isEmpty((Object)newOpportunityFrom) || !ToolUtil.isEmpty((Object)oldOpportunityFrom) && oldOpportunityFrom.equals(newOpportunityFrom))) {
            HashMap<String, String> field6 = new HashMap<String, String>();
            field6.put("field", OpportunityEditConstant.OPOPPORTUNITY_FROM.getField());
            field6.put("fieldName", OpportunityEditConstant.OPOPPORTUNITY_FROM.getName());
            changeField.add(field6);
            List list = this.sysDicRefService.getDictByType("opportunity_from");
            for (DicSingle dicSingle : list) {
                if (dicSingle.getValue().equals(oldOpportunityFrom)) {
                    oldOpportunityFrom = dicSingle.getLabel();
                }
                if (!dicSingle.getValue().equals(newOpportunityFrom)) continue;
                newOpportunityFrom = dicSingle.getLabel();
            }
            before.put(OpportunityEditConstant.OPOPPORTUNITY_FROM.getField(), oldOpportunityFrom);
            after.put(OpportunityEditConstant.OPOPPORTUNITY_FROM.getField(), newOpportunityFrom);
            changeFlag = true;
        }
        String oldCampaign = oldOpportunity.getCampaignName();
        String newCampaign = newOpportunity.getCampaignName();
        if (!(ToolUtil.isEmpty((Object)oldCampaign) && ToolUtil.isEmpty((Object)newCampaign) || !ToolUtil.isEmpty((Object)oldCampaign) && oldCampaign.equals(newCampaign))) {
            HashMap<String, String> field7 = new HashMap<String, String>();
            field7.put("field", OpportunityEditConstant.CAMPAIGN_NAME.getField());
            field7.put("fieldName", OpportunityEditConstant.CAMPAIGN_NAME.getName());
            changeField.add(field7);
            before.put(OpportunityEditConstant.CAMPAIGN_NAME.getField(), oldCampaign);
            after.put(OpportunityEditConstant.CAMPAIGN_NAME.getField(), newCampaign);
            changeFlag = true;
        }
        String oldAgentName = oldOpportunity.getAgentName();
        String newAgentName = newOpportunity.getAgentName();
        if (!(ToolUtil.isEmpty((Object)oldAgentName) && ToolUtil.isEmpty((Object)newAgentName) || !ToolUtil.isEmpty((Object)oldAgentName) && oldAgentName.equals(newAgentName))) {
            HashMap<String, String> field8 = new HashMap<String, String>();
            field8.put("field", OpportunityEditConstant.AGENT_NAME.getField());
            field8.put("fieldName", OpportunityEditConstant.AGENT_NAME.getName());
            changeField.add(field8);
            before.put(OpportunityEditConstant.AGENT_NAME.getField(), oldAgentName);
            after.put(OpportunityEditConstant.AGENT_NAME.getField(), newAgentName);
            before.put(OpportunityEditConstant.AGENT_ID.getField(), oldOpportunity.getAgentId());
            after.put(OpportunityEditConstant.AGENT_ID.getField(), newOpportunity.getAgentId());
            changeFlag = true;
        }
        String oldImportance = oldOpportunity.getImportance();
        String newImportance = newOpportunity.getImportance();
        if (!(ToolUtil.isEmpty((Object)oldImportance) && ToolUtil.isEmpty((Object)newImportance) || !ToolUtil.isEmpty((Object)oldImportance) && oldImportance.equals(newImportance))) {
            HashMap<String, String> field9 = new HashMap<String, String>();
            field9.put("field", OpportunityEditConstant.IMPORTANCE.getField());
            field9.put("fieldName", OpportunityEditConstant.IMPORTANCE.getName());
            changeField.add(field9);
            before.put(OpportunityEditConstant.IMPORTANCE.getField(), oldImportance);
            after.put(OpportunityEditConstant.IMPORTANCE.getField(), newImportance);
            changeFlag = true;
        }
        String oldTrade = oldOpportunity.getTrade();
        String newTrade = newOpportunity.getTrade();
        String oldOtherTrade = oldOpportunity.getOtherTrade();
        String newOtherTrade = newOpportunity.getOtherTrade();
        if (!(ToolUtil.isEmpty((Object)oldTrade) && ToolUtil.isEmpty((Object)newTrade) || ToolUtil.isEmpty((Object)oldTrade) && "19".equals(newTrade) && ToolUtil.isEmpty((Object)newOtherTrade) || ToolUtil.isEmpty((Object)newTrade) && "19".equals(oldTrade) && ToolUtil.isEmpty((Object)oldOtherTrade) || oldTrade != null && oldTrade.equals(newTrade) && Objects.equals(oldOtherTrade, newOtherTrade))) {
            HashMap<String, String> field10 = new HashMap<String, String>();
            field10.put("field", OpportunityEditConstant.TRADE.getField());
            field10.put("fieldName", OpportunityEditConstant.TRADE.getName());
            changeField.add(field10);
            List list = this.sysDicRefService.getDictByType("industry");
            for (DicSingle dicSingle : list) {
                if (dicSingle.getValue().equals(oldTrade)) {
                    oldTrade = dicSingle.getLabel();
                }
                if (!dicSingle.getValue().equals(newTrade)) continue;
                newTrade = dicSingle.getLabel();
            }
            before.put(OpportunityEditConstant.TRADE.getField(), "\u5176\u4ed6".equals(oldTrade) ? oldOtherTrade : oldTrade);
            after.put(OpportunityEditConstant.TRADE.getField(), "\u5176\u4ed6".equals(newTrade) ? newOtherTrade : newTrade);
            changeFlag = true;
        }
        oldDate = oldOpportunity.getFindTime();
        newDate = newOpportunity.getFindTime();
        String oldFindTime = "\u7a7a";
        String newFindTime = "\u7a7a";
        if (ToolUtil.isNotEmpty((Object)oldDate)) {
            oldFindTime = String.valueOf(oldDate).substring(0, 10);
        }
        if (ToolUtil.isNotEmpty((Object)newDate)) {
            newFindTime = String.valueOf(newDate).substring(0, 10);
        }
        oldFindTime = oldFindTime.replace('T', ' ');
        newFindTime = newFindTime.replace('T', ' ');
        if (!(ToolUtil.isEmpty((Object)oldFindTime) && ToolUtil.isEmpty((Object)newFindTime) || !ToolUtil.isEmpty((Object)oldFindTime) && oldFindTime.equals(newFindTime))) {
            HashMap<String, String> field11 = new HashMap<String, String>();
            field11.put("field", OpportunityEditConstant.FIND_TIME.getField());
            field11.put("fieldName", OpportunityEditConstant.FIND_TIME.getName());
            changeField.add(field11);
            before.put(OpportunityEditConstant.FIND_TIME.getField(), oldFindTime);
            after.put(OpportunityEditConstant.FIND_TIME.getField(), newFindTime);
            changeFlag = true;
        }
        String oldCustomerDemand = oldOpportunity.getCustomerDemand();
        String newCustomerDemand = newOpportunity.getCustomerDemand();
        if (!(ToolUtil.isEmpty((Object)oldCustomerDemand) && ToolUtil.isEmpty((Object)newCustomerDemand) || !ToolUtil.isEmpty((Object)oldCustomerDemand) && oldCustomerDemand.equals(newCustomerDemand))) {
            HashMap<String, String> field12 = new HashMap<String, String>();
            field12.put("field", OpportunityEditConstant.CUSTOMER_DEMAND.getField());
            field12.put("fieldName", OpportunityEditConstant.CUSTOMER_DEMAND.getName());
            changeField.add(field12);
            before.put(OpportunityEditConstant.CUSTOMER_DEMAND.getField(), oldCustomerDemand);
            after.put(OpportunityEditConstant.CUSTOMER_DEMAND.getField(), newCustomerDemand);
            changeFlag = true;
        }
        String oldAddressDetail = oldOpportunity.getAddressDetail();
        String newAddressDetail = newOpportunity.getAddressDetail();
        if (!(ToolUtil.isEmpty((Object)oldAddressDetail) && ToolUtil.isEmpty((Object)newAddressDetail) || !ToolUtil.isEmpty((Object)oldAddressDetail) && oldAddressDetail.equals(newAddressDetail))) {
            HashMap<String, String> field13 = new HashMap<String, String>();
            field13.put("field", OpportunityEditConstant.ADDRESS_DETAIL.getField());
            field13.put("fieldName", OpportunityEditConstant.ADDRESS_DETAIL.getName());
            changeField.add(field13);
            before.put(OpportunityEditConstant.ADDRESS_DETAIL.getField(), oldAddressDetail);
            after.put(OpportunityEditConstant.ADDRESS_DETAIL.getField(), newAddressDetail);
            changeFlag = true;
        }
        String oldRegionLabel = oldOpportunity.getRegionLabel();
        String newRegionLabel = newOpportunity.getRegionLabel();
        if (!(ToolUtil.isEmpty((Object)oldRegionLabel) && ToolUtil.isEmpty((Object)newRegionLabel) || !ToolUtil.isEmpty((Object)oldRegionLabel) && oldRegionLabel.equals(newRegionLabel))) {
            HashMap<String, String> field14 = new HashMap<String, String>();
            field14.put("field", OpportunityEditConstant.REGION_LABEL.getField());
            field14.put("fieldName", OpportunityEditConstant.REGION_LABEL.getName());
            changeField.add(field14);
            before.put(OpportunityEditConstant.REGION_LABEL.getField(), oldRegionLabel);
            after.put(OpportunityEditConstant.REGION_LABEL.getField(), newRegionLabel);
            changeFlag = true;
        }
        String oldCustomerContractName = oldOpportunity.getName();
        String newCustomerContractName = newOpportunity.getName();
        if (!(ToolUtil.isEmpty((Object)oldCustomerContractName) && ToolUtil.isEmpty((Object)newCustomerContractName) || !ToolUtil.isEmpty((Object)oldCustomerContractName) && oldCustomerContractName.equals(newCustomerContractName))) {
            HashMap<String, String> field15 = new HashMap<String, String>();
            field15.put("field", OpportunityEditConstant.NAME.getField());
            field15.put("fieldName", OpportunityEditConstant.NAME.getName());
            changeField.add(field15);
            before.put(OpportunityEditConstant.NAME.getField(), oldCustomerContractName);
            after.put(OpportunityEditConstant.NAME.getField(), newCustomerContractName);
            changeFlag = true;
        }
        String oldContactDepartment = oldOpportunity.getContactDepartment();
        String newContactDepartment = newOpportunity.getContactDepartment();
        if (!(ToolUtil.isEmpty((Object)oldContactDepartment) && ToolUtil.isEmpty((Object)newContactDepartment) || !ToolUtil.isEmpty((Object)oldContactDepartment) && oldContactDepartment.equals(newContactDepartment))) {
            HashMap<String, String> field16 = new HashMap<String, String>();
            field16.put("field", OpportunityEditConstant.CONTACT_DEPARTMENT.getField());
            field16.put("fieldName", OpportunityEditConstant.CONTACT_DEPARTMENT.getName());
            changeField.add(field16);
            before.put(OpportunityEditConstant.CONTACT_DEPARTMENT.getField(), oldContactDepartment);
            after.put(OpportunityEditConstant.CONTACT_DEPARTMENT.getField(), newContactDepartment);
            changeFlag = true;
        }
        String oldContactPosition = oldOpportunity.getPosition();
        String newContactPosition = newOpportunity.getPosition();
        if (!(ToolUtil.isEmpty((Object)oldContactPosition) && ToolUtil.isEmpty((Object)newContactPosition) || !ToolUtil.isEmpty((Object)oldContactPosition) && oldContactPosition.equals(newContactPosition))) {
            HashMap<String, String> field17 = new HashMap<String, String>();
            field17.put("field", OpportunityEditConstant.POSITION.getField());
            field17.put("fieldName", OpportunityEditConstant.POSITION.getName());
            changeField.add(field17);
            before.put(OpportunityEditConstant.POSITION.getField(), oldContactPosition);
            after.put(OpportunityEditConstant.POSITION.getField(), newContactPosition);
            changeFlag = true;
        }
        String oldContactMobilePhone = oldOpportunity.getMobilePhone();
        String newContactMobilePhone = newOpportunity.getMobilePhone();
        if (!(ToolUtil.isEmpty((Object)oldContactMobilePhone) && ToolUtil.isEmpty((Object)newContactMobilePhone) || !ToolUtil.isEmpty((Object)oldContactMobilePhone) && oldContactMobilePhone.equals(newContactMobilePhone))) {
            HashMap<String, String> field18 = new HashMap<String, String>();
            field18.put("field", OpportunityEditConstant.MOBILE_PHONE.getField());
            field18.put("fieldName", OpportunityEditConstant.MOBILE_PHONE.getName());
            changeField.add(field18);
            before.put(OpportunityEditConstant.MOBILE_PHONE.getField(), oldContactMobilePhone);
            after.put(OpportunityEditConstant.MOBILE_PHONE.getField(), newContactMobilePhone);
            changeFlag = true;
        }
        String oldContactTelephone = oldOpportunity.getTelephone();
        String newContactTelephone = newOpportunity.getTelephone();
        if (!(ToolUtil.isEmpty((Object)oldContactTelephone) && ToolUtil.isEmpty((Object)newContactTelephone) || !ToolUtil.isEmpty((Object)oldContactTelephone) && oldContactTelephone.equals(newContactTelephone))) {
            HashMap<String, String> field19 = new HashMap<String, String>();
            field19.put("field", OpportunityEditConstant.TELEPHONE.getField());
            field19.put("fieldName", OpportunityEditConstant.TELEPHONE.getName());
            changeField.add(field19);
            before.put(OpportunityEditConstant.TELEPHONE.getField(), oldContactTelephone);
            after.put(OpportunityEditConstant.TELEPHONE.getField(), newContactTelephone);
            changeFlag = true;
        }
        String oldContactSex = oldOpportunity.getSex();
        String newContactSex = newOpportunity.getSex();
        if (!(ToolUtil.isEmpty((Object)oldContactSex) && ToolUtil.isEmpty((Object)newContactSex) || !ToolUtil.isEmpty((Object)oldContactSex) && oldContactSex.equals(newContactSex))) {
            List list = this.sysDicRefService.getDictByType("sex");
            HashMap<String, String> field20 = new HashMap<String, String>();
            for (DicSingle dicSingle : list) {
                if (dicSingle.getValue().equals(oldContactSex)) {
                    oldContactSex = dicSingle.getLabel();
                }
                if (!dicSingle.getValue().equals(newContactSex)) continue;
                newContactSex = dicSingle.getLabel();
            }
            field20.put("field", OpportunityEditConstant.SEX.getField());
            field20.put("fieldName", OpportunityEditConstant.SEX.getName());
            changeField.add(field20);
            before.put(OpportunityEditConstant.SEX.getField(), oldContactSex);
            after.put(OpportunityEditConstant.SEX.getField(), newContactSex);
            changeFlag = true;
        }
        String oldContactEmail = oldOpportunity.getEmail();
        String newContactEmail = newOpportunity.getEmail();
        if (!(ToolUtil.isEmpty((Object)oldContactEmail) && ToolUtil.isEmpty((Object)newContactEmail) || !ToolUtil.isEmpty((Object)oldContactEmail) && oldContactEmail.equals(newContactEmail))) {
            HashMap<String, String> field21 = new HashMap<String, String>();
            field21.put("field", OpportunityEditConstant.EMAIL.getField());
            field21.put("fieldName", OpportunityEditConstant.EMAIL.getName());
            changeField.add(field21);
            before.put(OpportunityEditConstant.EMAIL.getField(), oldContactEmail);
            after.put(OpportunityEditConstant.EMAIL.getField(), newContactEmail);
            changeFlag = true;
        }
        String oldIsConfirmBudget = oldOpportunity.getIsConfirmBudget();
        String newIsConfirmBudget = newOpportunity.getIsConfirmBudget();
        if (!(ToolUtil.isEmpty((Object)oldIsConfirmBudget) && ToolUtil.isEmpty((Object)newIsConfirmBudget) || !ToolUtil.isEmpty((Object)oldIsConfirmBudget) && oldIsConfirmBudget.equals(newIsConfirmBudget))) {
            HashMap<String, String> field22 = new HashMap<String, String>();
            oldIsConfirmBudget = HussarUtils.isNotEmpty((Object)oldIsConfirmBudget) ? ("1".equals(oldIsConfirmBudget) ? "\u662f" : "\u5426") : "\u7a7a";
            newIsConfirmBudget = HussarUtils.isNotEmpty((Object)newIsConfirmBudget) ? ("1".equals(newIsConfirmBudget) ? "\u662f" : "\u5426") : "\u7a7a";
            field22.put("field", OpportunityEditConstant.IS_CONFIRM_BUDGET.getField());
            field22.put("fieldName", OpportunityEditConstant.IS_CONFIRM_BUDGET.getName());
            changeField.add(field22);
            before.put(OpportunityEditConstant.IS_CONFIRM_BUDGET.getField(), oldIsConfirmBudget);
            after.put(OpportunityEditConstant.IS_CONFIRM_BUDGET.getField(), newIsConfirmBudget);
            changeFlag = true;
        }
        Double oldCustomerBudget = oldOpportunity.getCustomerBudget();
        Double newCustomerBudget = newOpportunity.getCustomerBudget();
        oldCustomerBudget = oldCustomerBudget == null ? 0.0 : oldCustomerBudget;
        newCustomerBudget = newCustomerBudget == null ? 0.0 : newCustomerBudget;
        if (!(ToolUtil.isEmpty((Object)oldCustomerBudget) && ToolUtil.isEmpty((Object)newCustomerBudget) || !ToolUtil.isEmpty((Object)oldCustomerBudget) && oldCustomerBudget.equals(newCustomerBudget))) {
            HashMap<String, String> field23 = new HashMap<String, String>();
            field23.put("field", OpportunityEditConstant.CUSTOMER_BUDGET.getField());
            field23.put("fieldName", OpportunityEditConstant.CUSTOMER_BUDGET.getName());
            changeField.add(field23);
            String oldCustomerBudgetStr = decimalFormat.format(oldCustomerBudget);
            String newCustomerBudgetStr = decimalFormat.format(newCustomerBudget);
            before.put(OpportunityEditConstant.CUSTOMER_BUDGET.getField(), oldCustomerBudgetStr);
            after.put(OpportunityEditConstant.CUSTOMER_BUDGET.getField(), newCustomerBudgetStr);
            changeFlag = true;
        }
        String oldPurchaseMethod = oldOpportunity.getPurchaseMethod();
        String newPurchaseMethod = newOpportunity.getPurchaseMethod();
        if (!(ToolUtil.isEmpty((Object)oldPurchaseMethod) && ToolUtil.isEmpty((Object)newPurchaseMethod) || !ToolUtil.isEmpty((Object)oldPurchaseMethod) && oldPurchaseMethod.equals(newPurchaseMethod))) {
            List list = this.sysDicRefService.getDictByType("purchase_method");
            HashMap<String, String> field24 = new HashMap<String, String>();
            for (DicSingle dicSingle : list) {
                if (dicSingle.getValue().equals(oldPurchaseMethod)) {
                    oldPurchaseMethod = dicSingle.getLabel();
                }
                if (!dicSingle.getValue().equals(newPurchaseMethod)) continue;
                newPurchaseMethod = dicSingle.getLabel();
            }
            field24.put("field", OpportunityEditConstant.PURCHASE_METHOD.getField());
            field24.put("fieldName", OpportunityEditConstant.PURCHASE_METHOD.getName());
            changeField.add(field24);
            before.put(OpportunityEditConstant.PURCHASE_METHOD.getField(), oldPurchaseMethod);
            after.put(OpportunityEditConstant.PURCHASE_METHOD.getField(), newPurchaseMethod);
            changeFlag = true;
        }
        String oldIsConfirmTime = oldOpportunity.getIsConfirmTime();
        String newIsConfirmTime = newOpportunity.getIsConfirmTime();
        if (!(ToolUtil.isEmpty((Object)oldIsConfirmTime) && ToolUtil.isEmpty((Object)newIsConfirmTime) || !ToolUtil.isEmpty((Object)oldIsConfirmTime) && oldIsConfirmTime.equals(newIsConfirmTime))) {
            HashMap<String, String> field25 = new HashMap<String, String>();
            if (ToolUtil.isNotEmpty((Object)oldIsConfirmTime)) {
                String string = oldIsConfirmTime = "1".equals(oldIsConfirmTime) ? "\u662f" : "\u5426";
            }
            if (ToolUtil.isNotEmpty((Object)newIsConfirmTime)) {
                newIsConfirmTime = "1".equals(newIsConfirmTime) ? "\u662f" : "\u5426";
            }
            field25.put("field", OpportunityEditConstant.IS_CONFIRM_TIME.getField());
            field25.put("fieldName", OpportunityEditConstant.IS_CONFIRM_TIME.getName());
            changeField.add(field25);
            before.put(OpportunityEditConstant.IS_CONFIRM_TIME.getField(), oldIsConfirmTime);
            after.put(OpportunityEditConstant.IS_CONFIRM_TIME.getField(), newIsConfirmTime);
            changeFlag = true;
        }
        oldDate = oldOpportunity.getLaunchDatePlan();
        newDate = newOpportunity.getLaunchDatePlan();
        String oldLaunchDatePlan = "\u7a7a";
        String newLaunchDatePlan = "\u7a7a";
        if (ToolUtil.isNotEmpty((Object)oldDate)) {
            oldLaunchDatePlan = String.valueOf(oldDate).substring(0, 10);
        }
        if (ToolUtil.isNotEmpty((Object)newDate)) {
            newLaunchDatePlan = String.valueOf(newDate).substring(0, 10);
        }
        if (!(ToolUtil.isEmpty((Object)oldLaunchDatePlan) && ToolUtil.isEmpty((Object)newLaunchDatePlan) || !ToolUtil.isEmpty((Object)oldLaunchDatePlan) && oldLaunchDatePlan.equals(newLaunchDatePlan))) {
            HashMap<String, String> field26 = new HashMap<String, String>();
            field26.put("field", OpportunityEditConstant.LAUNCH_DATE_PLAN.getField());
            field26.put("fieldName", OpportunityEditConstant.LAUNCH_DATE_PLAN.getName());
            changeField.add(field26);
            before.put(OpportunityEditConstant.LAUNCH_DATE_PLAN.getField(), oldLaunchDatePlan);
            after.put(OpportunityEditConstant.LAUNCH_DATE_PLAN.getField(), newLaunchDatePlan);
            changeFlag = true;
        }
        String oldTenderDate = oldOpportunity.getTenderDate();
        String newTenderDate = newOpportunity.getTenderDate();
        if (ToolUtil.isNotEmpty((Object)oldTenderDate)) {
            oldTenderDate = String.valueOf(oldTenderDate).substring(0, 10);
        }
        if (ToolUtil.isNotEmpty((Object)newTenderDate)) {
            newTenderDate = String.valueOf(newTenderDate).substring(0, 10);
        }
        if (!(ToolUtil.isEmpty((Object)oldTenderDate) && ToolUtil.isEmpty((Object)newTenderDate) || !ToolUtil.isEmpty((Object)oldTenderDate) && oldTenderDate.equals(newTenderDate))) {
            HashMap<String, String> field27 = new HashMap<String, String>();
            field27.put("field", OpportunityEditConstant.TENDER_DATE.getField());
            field27.put("fieldName", OpportunityEditConstant.TENDER_DATE.getName());
            changeField.add(field27);
            before.put(OpportunityEditConstant.TENDER_DATE.getField(), oldTenderDate);
            after.put(OpportunityEditConstant.TENDER_DATE.getField(), newTenderDate);
            changeFlag = true;
        }
        String oldPkContent = oldOpportunity.getPkContent();
        String newPkContent = newOpportunity.getPkContent();
        if (!(ToolUtil.isEmpty((Object)oldPkContent) && ToolUtil.isEmpty((Object)newPkContent) || !ToolUtil.isEmpty((Object)oldPkContent) && oldPkContent.equals(newPkContent))) {
            HashMap<String, String> field28 = new HashMap<String, String>();
            field28.put("field", OpportunityEditConstant.PK_CONTENT.getField());
            field28.put("fieldName", OpportunityEditConstant.PK_CONTENT.getName());
            changeField.add(field28);
            before.put(OpportunityEditConstant.PK_CONTENT.getField(), oldPkContent);
            after.put(OpportunityEditConstant.PK_CONTENT.getField(), newPkContent);
            changeFlag = true;
        }
        String oldKeyword = oldOpportunity.getKeyword();
        String newKeyword = newOpportunity.getKeyword();
        if (!(ToolUtil.isEmpty((Object)oldKeyword) && ToolUtil.isEmpty((Object)newKeyword) || !ToolUtil.isEmpty((Object)oldKeyword) && oldKeyword.equals(newKeyword))) {
            HashMap<String, String> field29 = new HashMap<String, String>();
            field29.put("field", OpportunityEditConstant.KEYWORD.getField());
            field29.put("fieldName", OpportunityEditConstant.KEYWORD.getName());
            changeField.add(field29);
            before.put(OpportunityEditConstant.KEYWORD.getField(), oldKeyword);
            after.put(OpportunityEditConstant.KEYWORD.getField(), newKeyword);
            changeFlag = true;
        }
        String oldSearchTerm = oldOpportunity.getSearchTerm();
        String newSearchTerm = newOpportunity.getSearchTerm();
        if (!(ToolUtil.isEmpty((Object)oldSearchTerm) && ToolUtil.isEmpty((Object)newSearchTerm) || !ToolUtil.isEmpty((Object)oldSearchTerm) && oldSearchTerm.equals(newSearchTerm))) {
            HashMap<String, String> field30 = new HashMap<String, String>();
            field30.put("field", OpportunityEditConstant.SEARCH_TERM.getField());
            field30.put("fieldName", OpportunityEditConstant.SEARCH_TERM.getName());
            changeField.add(field30);
            before.put(OpportunityEditConstant.SEARCH_TERM.getField(), oldSearchTerm);
            after.put(OpportunityEditConstant.SEARCH_TERM.getField(), newSearchTerm);
            changeFlag = true;
        }
        String oldAdvantage = oldOpportunity.getAdvantage();
        String newAdvantage = newOpportunity.getAdvantage();
        if (!(ToolUtil.isEmpty((Object)oldAdvantage) && ToolUtil.isEmpty((Object)newAdvantage) || !ToolUtil.isEmpty((Object)oldAdvantage) && oldAdvantage.equals(newAdvantage))) {
            HashMap<String, String> field31 = new HashMap<String, String>();
            field31.put("field", OpportunityEditConstant.ADVANTAGE.getField());
            field31.put("fieldName", OpportunityEditConstant.ADVANTAGE.getName());
            changeField.add(field31);
            before.put(OpportunityEditConstant.ADVANTAGE.getField(), oldAdvantage);
            after.put(OpportunityEditConstant.ADVANTAGE.getField(), newAdvantage);
            changeFlag = true;
        }
        String oldRemark = oldOpportunity.getRemark();
        String newRemark = newOpportunity.getRemark();
        if (!(ToolUtil.isEmpty((Object)oldRemark) && ToolUtil.isEmpty((Object)newRemark) || !ToolUtil.isEmpty((Object)oldRemark) && oldRemark.equals(newRemark))) {
            HashMap<String, String> field32 = new HashMap<String, String>();
            field32.put("field", OpportunityEditConstant.REMARK.getField());
            field32.put("fieldName", OpportunityEditConstant.REMARK.getName());
            changeField.add(field32);
            before.put(OpportunityEditConstant.REMARK.getField(), oldRemark);
            after.put(OpportunityEditConstant.REMARK.getField(), newRemark);
            changeFlag = true;
        }
        String oldICM = oldOpportunity.getConsultationMethods();
        String newICM = newOpportunity.getConsultationMethods();
        if (!(ToolUtil.isEmpty((Object)oldICM) && ToolUtil.isEmpty((Object)newICM) || !ToolUtil.isEmpty((Object)oldICM) && oldICM.equals(newICM))) {
            List list = this.sysDicRefService.getDictByType("consultation_methods");
            HashMap<String, String> field33 = new HashMap<String, String>();
            for (DicSingle dicSingle : list) {
                if (dicSingle.getValue().equals(oldICM)) {
                    oldICM = dicSingle.getLabel();
                }
                if (!dicSingle.getValue().equals(newICM)) continue;
                newICM = dicSingle.getLabel();
            }
            field33.put("field", OpportunityEditConstant.CONSULTATION_METHODS.getField());
            field33.put("fieldName", OpportunityEditConstant.CONSULTATION_METHODS.getName());
            changeField.add(field33);
            before.put(OpportunityEditConstant.CONSULTATION_METHODS.getField(), oldICM);
            after.put(OpportunityEditConstant.CONSULTATION_METHODS.getField(), newICM);
            changeFlag = true;
        }
        String oldRate = oldOpportunity.getOpportunityWinRate();
        String newRate = newOpportunity.getOpportunityWinRate();
        if (!(ToolUtil.isEmpty((Object)oldRate) && ToolUtil.isEmpty((Object)newRate) || !ToolUtil.isEmpty((Object)oldRate) && oldRate.equals(newRate))) {
            List list = this.sysDicRefService.getDictByType("opportunity_win_rate");
            HashMap<String, String> field34 = new HashMap<String, String>();
            for (DicSingle dicSingle : list) {
                if (dicSingle.getValue().equals(oldRate)) {
                    oldRate = dicSingle.getLabel();
                }
                if (!dicSingle.getValue().equals(newRate)) continue;
                newRate = dicSingle.getLabel();
            }
            field34.put("field", OpportunityEditConstant.OPPORTUNITY_WIN_RATE.getField());
            field34.put("fieldName", OpportunityEditConstant.OPPORTUNITY_WIN_RATE.getName());
            changeField.add(field34);
            before.put(OpportunityEditConstant.OPPORTUNITY_WIN_RATE.getField(), oldRate);
            after.put(OpportunityEditConstant.OPPORTUNITY_WIN_RATE.getField(), newRate);
            changeFlag = true;
        }
        String oldLoseReason = oldOpportunity.getLoseReason();
        String newLoseReason = newOpportunity.getLoseReason();
        if (!(ToolUtil.isEmpty((Object)oldLoseReason) && ToolUtil.isEmpty((Object)newLoseReason) || !ToolUtil.isEmpty((Object)oldLoseReason) && oldLoseReason.equals(newLoseReason))) {
            Map<String, String> dicMap = this.sysDicRefService.getDictByType("lost_type").stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
            HashMap<String, String> field35 = new HashMap<String, String>();
            StringBuilder oldLoseReasonTrans = new StringBuilder();
            StringBuilder newLoseReasonTrans = new StringBuilder();
            if (HussarUtils.isNotEmpty((Object)oldLoseReason)) {
                for (String loseReason : oldLoseReason.split(",")) {
                    if (!HussarUtils.isNotEmpty((Object)loseReason)) continue;
                    if (oldLoseReasonTrans.length() == 0) {
                        oldLoseReasonTrans.append(dicMap.get(loseReason));
                        continue;
                    }
                    oldLoseReasonTrans.append("\u3001").append(dicMap.get(loseReason));
                }
            }
            if (HussarUtils.isNotEmpty((Object)newLoseReason)) {
                for (String loseReason : newLoseReason.split(",")) {
                    if (!HussarUtils.isNotEmpty((Object)loseReason)) continue;
                    if (newLoseReasonTrans.length() == 0) {
                        newLoseReasonTrans.append(dicMap.get(loseReason));
                        continue;
                    }
                    newLoseReasonTrans.append("\u3001").append(dicMap.get(loseReason));
                }
            }
            field35.put("field", OpportunityEditConstant.LOSE_REASON.getField());
            field35.put("fieldName", OpportunityEditConstant.LOSE_REASON.getName());
            changeField.add(field35);
            before.put(OpportunityEditConstant.LOSE_REASON.getField(), oldLoseReasonTrans);
            after.put(OpportunityEditConstant.LOSE_REASON.getField(), newLoseReasonTrans);
            changeFlag = true;
        }
        String oldLoseReasonDetail = oldOpportunity.getLoseReasonDetail();
        String newLoseReasonDetail = newOpportunity.getLoseReasonDetail();
        if (!(ToolUtil.isEmpty((Object)oldLoseReasonDetail) && ToolUtil.isEmpty((Object)newLoseReasonDetail) || !ToolUtil.isEmpty((Object)oldLoseReasonDetail) && oldLoseReasonDetail.equals(newLoseReasonDetail))) {
            HashMap<String, String> field36 = new HashMap<String, String>();
            field36.put("field", OpportunityEditConstant.LOSE_REASON_DETAIL.getField());
            field36.put("fieldName", OpportunityEditConstant.LOSE_REASON_DETAIL.getName());
            changeField.add(field36);
            before.put(OpportunityEditConstant.LOSE_REASON_DETAIL.getField(), oldLoseReasonDetail);
            after.put(OpportunityEditConstant.LOSE_REASON_DETAIL.getField(), newLoseReasonDetail);
            changeFlag = true;
        }
        String oldWinningElements = oldOpportunity.getWinningElements();
        String newWinningElements = newOpportunity.getWinningElements();
        if (!(ToolUtil.isEmpty((Object)oldWinningElements) && ToolUtil.isEmpty((Object)newWinningElements) || !ToolUtil.isEmpty((Object)oldWinningElements) && oldWinningElements.equals(newWinningElements))) {
            Map<String, String> dicMap = this.sysDicRefService.getDictByType("winning_elements").stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
            HashMap<String, String> field37 = new HashMap<String, String>();
            StringBuilder oldW = new StringBuilder();
            StringBuilder newW = new StringBuilder();
            if (HussarUtils.isNotEmpty((Object)oldWinningElements)) {
                for (String winningElement : oldWinningElements.split(",")) {
                    if (!HussarUtils.isNotEmpty((Object)winningElement)) continue;
                    if (oldW.length() == 0) {
                        oldW.append(dicMap.get(winningElement));
                        continue;
                    }
                    oldW.append("\u3001").append(dicMap.get(winningElement));
                }
            }
            if (HussarUtils.isNotEmpty((Object)newWinningElements)) {
                for (String winningElement : newWinningElements.split(",")) {
                    if (!HussarUtils.isNotEmpty((Object)winningElement)) continue;
                    if (newW.length() == 0) {
                        newW.append(dicMap.get(winningElement));
                        continue;
                    }
                    newW.append("\u3001").append(dicMap.get(winningElement));
                }
            }
            field37.put("field", OpportunityEditConstant.WINNING_ELEMENTS.getField());
            field37.put("fieldName", OpportunityEditConstant.WINNING_ELEMENTS.getName());
            changeField.add(field37);
            before.put(OpportunityEditConstant.WINNING_ELEMENTS.getField(), oldW.toString());
            after.put(OpportunityEditConstant.WINNING_ELEMENTS.getField(), newW.toString());
            changeFlag = true;
        }
        String oldAbandonedReason = oldOpportunity.getAbandonedReason();
        String newAbandonedReason = newOpportunity.getAbandonedReason();
        if (!(ToolUtil.isEmpty((Object)oldAbandonedReason) && ToolUtil.isEmpty((Object)newAbandonedReason) || !ToolUtil.isEmpty((Object)oldAbandonedReason) && oldAbandonedReason.equals(newAbandonedReason))) {
            List list = this.sysDicRefService.getDictByType("abandon_reason");
            HashMap<String, String> field38 = new HashMap<String, String>();
            for (DicSingle dicSingle : list) {
                if (dicSingle.getValue().equals(oldAbandonedReason)) {
                    oldAbandonedReason = dicSingle.getLabel();
                }
                if (!dicSingle.getValue().equals(newAbandonedReason)) continue;
                newAbandonedReason = dicSingle.getLabel();
            }
            field38.put("field", OpportunityEditConstant.ABANDONED_REASON.getField());
            field38.put("fieldName", OpportunityEditConstant.ABANDONED_REASON.getName());
            changeField.add(field38);
            before.put(OpportunityEditConstant.ABANDONED_REASON.getField(), oldAbandonedReason);
            after.put(OpportunityEditConstant.ABANDONED_REASON.getField(), newAbandonedReason);
            changeFlag = true;
        }
        String oldAbandonedDescribe = oldOpportunity.getAbandonedDescribe();
        String newAbandonedDescribe = newOpportunity.getAbandonedDescribe();
        if (!(ToolUtil.isEmpty((Object)oldAbandonedDescribe) && ToolUtil.isEmpty((Object)newAbandonedDescribe) || !ToolUtil.isEmpty((Object)oldAbandonedDescribe) && oldAbandonedDescribe.equals(newAbandonedDescribe))) {
            HashMap<String, String> field39 = new HashMap<String, String>();
            field39.put("field", OpportunityEditConstant.ABANDONED_DESCRIBE.getField());
            field39.put("fieldName", OpportunityEditConstant.ABANDONED_DESCRIBE.getName());
            changeField.add(field39);
            before.put(OpportunityEditConstant.ABANDONED_DESCRIBE.getField(), oldAbandonedDescribe);
            after.put(OpportunityEditConstant.ABANDONED_DESCRIBE.getField(), newAbandonedDescribe);
            changeFlag = true;
        }
        String oldSuccessDate = oldOpportunity.getSuccessDate();
        String newSuccessDate = newOpportunity.getSuccessDate();
        if (ToolUtil.isNotEmpty((Object)oldSuccessDate)) {
            oldSuccessDate = oldSuccessDate.substring(0, 10);
        }
        if (ToolUtil.isNotEmpty((Object)newSuccessDate)) {
            newSuccessDate = newSuccessDate.substring(0, 10);
        }
        if (!(ToolUtil.isEmpty((Object)oldSuccessDate) && ToolUtil.isEmpty((Object)newSuccessDate) || !ToolUtil.isEmpty((Object)oldSuccessDate) && oldSuccessDate.equals(newSuccessDate))) {
            HashMap<String, String> field40 = new HashMap<String, String>();
            field40.put("field", OpportunityEditConstant.SUCCESS_DATE.getField());
            field40.put("fieldName", OpportunityEditConstant.SUCCESS_DATE.getName());
            changeField.add(field40);
            before.put(OpportunityEditConstant.SUCCESS_DATE.getField(), oldSuccessDate);
            after.put(OpportunityEditConstant.SUCCESS_DATE.getField(), newSuccessDate);
            changeFlag = true;
        }
        String oldLoseDate = oldOpportunity.getLoseDate();
        String newLoseDate = newOpportunity.getLoseDate();
        if (ToolUtil.isNotEmpty((Object)oldLoseDate)) {
            oldLoseDate = oldLoseDate.substring(0, 10);
        }
        if (ToolUtil.isNotEmpty((Object)newLoseDate)) {
            newLoseDate = newLoseDate.substring(0, 10);
        }
        if (!(ToolUtil.isEmpty((Object)oldLoseDate) && ToolUtil.isEmpty((Object)newLoseDate) || !ToolUtil.isEmpty((Object)oldLoseDate) && oldLoseDate.equals(newLoseDate))) {
            HashMap<String, String> field41 = new HashMap<String, String>();
            field41.put("field", OpportunityEditConstant.LOSE_DATE.getField());
            field41.put("fieldName", OpportunityEditConstant.LOSE_DATE.getName());
            changeField.add(field41);
            before.put(OpportunityEditConstant.LOSE_DATE.getField(), oldLoseDate);
            after.put(OpportunityEditConstant.LOSE_DATE.getField(), newLoseDate);
            changeFlag = true;
        }
        String oldIsConfirmBusiness = oldOpportunity.getIsConfirmBusiness();
        String newIsConfirmBusiness = newOpportunity.getIsConfirmBusiness();
        if (!(ToolUtil.isEmpty((Object)oldIsConfirmBusiness) && ToolUtil.isEmpty((Object)newIsConfirmBusiness) || !ToolUtil.isEmpty((Object)oldIsConfirmBusiness) && oldIsConfirmBusiness.equals(newIsConfirmBusiness))) {
            Map<String, String> dicMap = this.sysDicRefService.getDictByType("yes_no").stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
            HashMap<String, String> field42 = new HashMap<String, String>();
            field42.put("field", OpportunityEditConstant.IS_CONFIRM_BUSINESS.getField());
            field42.put("fieldName", OpportunityEditConstant.IS_CONFIRM_BUSINESS.getName());
            changeField.add(field42);
            before.put(OpportunityEditConstant.IS_CONFIRM_BUSINESS.getField(), dicMap.get(oldIsConfirmBusiness));
            after.put(OpportunityEditConstant.IS_CONFIRM_BUSINESS.getField(), dicMap.get(newIsConfirmBusiness));
            changeFlag = true;
        }
        String oldIsConfirmPerson = oldOpportunity.getIsConfirmPerson();
        String newIsConfirmPerson = newOpportunity.getIsConfirmPerson();
        if (!(ToolUtil.isEmpty((Object)oldIsConfirmPerson) && ToolUtil.isEmpty((Object)newIsConfirmPerson) || !ToolUtil.isEmpty((Object)oldIsConfirmPerson) && oldIsConfirmPerson.equals(newIsConfirmPerson))) {
            Map<String, String> dicMap = this.sysDicRefService.getDictByType("yes_no").stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
            HashMap<String, String> field43 = new HashMap<String, String>();
            field43.put("field", OpportunityEditConstant.IS_CONFIRM_PERSON.getField());
            field43.put("fieldName", OpportunityEditConstant.IS_CONFIRM_PERSON.getName());
            changeField.add(field43);
            before.put(OpportunityEditConstant.IS_CONFIRM_PERSON.getField(), dicMap.get(oldIsConfirmPerson));
            after.put(OpportunityEditConstant.IS_CONFIRM_PERSON.getField(), dicMap.get(newIsConfirmPerson));
            changeFlag = true;
        }
        String oldIsConfirmScheme = oldOpportunity.getIsConfirmScheme();
        String newIsConfirmScheme = newOpportunity.getIsConfirmScheme();
        if (!(ToolUtil.isEmpty((Object)oldIsConfirmScheme) && ToolUtil.isEmpty((Object)newIsConfirmScheme) || !ToolUtil.isEmpty((Object)oldIsConfirmScheme) && oldIsConfirmScheme.equals(newIsConfirmScheme))) {
            Map<String, String> dicMap = this.sysDicRefService.getDictByType("yes_no").stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
            HashMap<String, String> field44 = new HashMap<String, String>();
            field44.put("field", OpportunityEditConstant.IS_CONFIRM_SCHEME.getField());
            field44.put("fieldName", OpportunityEditConstant.IS_CONFIRM_SCHEME.getName());
            changeField.add(field44);
            before.put(OpportunityEditConstant.IS_CONFIRM_SCHEME.getField(), dicMap.get(oldIsConfirmScheme));
            after.put(OpportunityEditConstant.IS_CONFIRM_SCHEME.getField(), dicMap.get(newIsConfirmScheme));
            changeFlag = true;
        }
        String oldIsProjectApproval = oldOpportunity.getIsProjectApproval();
        String newIsProjectApproval = newOpportunity.getIsProjectApproval();
        if (!(ToolUtil.isEmpty((Object)oldIsProjectApproval) && ToolUtil.isEmpty((Object)newIsProjectApproval) || !ToolUtil.isEmpty((Object)oldIsProjectApproval) && oldIsProjectApproval.equals(newIsProjectApproval))) {
            Map<String, String> dicMap = this.sysDicRefService.getDictByType("yes_no").stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
            HashMap<String, String> field45 = new HashMap<String, String>();
            field45.put("field", OpportunityEditConstant.IS_PROJECT_APPROVAL.getField());
            field45.put("fieldName", OpportunityEditConstant.IS_PROJECT_APPROVAL.getName());
            changeField.add(field45);
            before.put(OpportunityEditConstant.IS_PROJECT_APPROVAL.getField(), dicMap.get(oldIsProjectApproval));
            after.put(OpportunityEditConstant.IS_PROJECT_APPROVAL.getField(), dicMap.get(newIsProjectApproval));
            changeFlag = true;
        }
        String oldSalesCommitment = oldOpportunity.getSalesCommitment();
        String newSalesCommitment = newOpportunity.getSalesCommitment();
        if (!(ToolUtil.isEmpty((Object)oldSalesCommitment) && ToolUtil.isEmpty((Object)newSalesCommitment) || !ToolUtil.isEmpty((Object)oldSalesCommitment) && oldSalesCommitment.equals(newSalesCommitment))) {
            Map<String, String> dicMap = this.sysDicRefService.getDictByType("sales_commitment").stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
            HashMap<String, String> field46 = new HashMap<String, String>();
            field46.put("field", OpportunityEditConstant.SALES_COMMITMENT.getField());
            field46.put("fieldName", OpportunityEditConstant.SALES_COMMITMENT.getName());
            changeField.add(field46);
            before.put(OpportunityEditConstant.SALES_COMMITMENT.getField(), dicMap.get(oldSalesCommitment));
            after.put(OpportunityEditConstant.SALES_COMMITMENT.getField(), dicMap.get(newSalesCommitment));
            changeFlag = true;
        }
        String oldCommitmentRemark = oldOpportunity.getCommitmentRemark();
        String newCommitmentRemark = newOpportunity.getCommitmentRemark();
        if (!(ToolUtil.isEmpty((Object)oldCommitmentRemark) && ToolUtil.isEmpty((Object)newCommitmentRemark) || !ToolUtil.isEmpty((Object)oldCommitmentRemark) && oldCommitmentRemark.equals(newCommitmentRemark))) {
            HashMap<String, String> field47 = new HashMap<String, String>();
            field47.put("field", OpportunityEditConstant.COMMITMENT_REMARK.getField());
            field47.put("fieldName", OpportunityEditConstant.COMMITMENT_REMARK.getName());
            changeField.add(field47);
            before.put(OpportunityEditConstant.COMMITMENT_REMARK.getField(), oldCommitmentRemark);
            after.put(OpportunityEditConstant.COMMITMENT_REMARK.getField(), newCommitmentRemark);
            changeFlag = true;
        }
        if (changeFlag) {
            String oldJson = JSON.toJSONString(before);
            String newJson = JSON.toJSONString(after);
            String changeFieldStr = JSON.toJSONString(changeField);
            OperateRecordAPIVo operateRecordDO = this.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), oldJson, newJson, changeFieldStr);
            operateRecordDO.setChangeBatch(1);
            this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.OPPORTUNITY, newOpportunity.getOpportunityId(), newOpportunity.getOpportunityName(), date, false, Arrays.asList(newOpportunity.getOpportunityId(), newOpportunity.getCustomerId()));
        }
    }

    @Override
    public ApiResponse<CrmOpportunity2> formQuery(String id) {
        try {
            CrmOpportunity2 crmOpportunity2 = (CrmOpportunity2)this.getById((Serializable)((Object)id));
            if (ToolUtil.isNotEmpty((Object)crmOpportunity2.getCustomerId())) {
                CustomerIncludePool customer = (CustomerIncludePool)this.customerIncludePoolService.getById(crmOpportunity2.getCustomerId());
                crmOpportunity2.setCustomerName(customer.getCustomerName());
            }
            if (HussarUtils.isNotEmpty((Object)crmOpportunity2.getAgentId())) {
                AgentApiVo agentApiVo = this.agentApiService.getById((Serializable)crmOpportunity2.getAgentId());
                if (!"1".equals(agentApiVo.getDelFlag())) {
                    crmOpportunity2.setAgentName(agentApiVo.getAgentName());
                } else {
                    crmOpportunity2.setAgentName("");
                }
            }
            if (HussarUtils.isNotEmpty((Object)crmOpportunity2.getStageProcessId())) {
                StageProcessEntity stageProcess = (StageProcessEntity)this.stageProcessService.getById(crmOpportunity2.getStageProcessId());
                crmOpportunity2.setProcessName(stageProcess.getProcessName());
            }
            return ApiResponse.success((Object)crmOpportunity2);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u8868\u5355\u67e5\u8be2\u5931\u8d25");
        }
    }

    @Override
    public ApiResponse<CrmOpportunity2PageVO> hussarQuerycrmOpportunity2Condition_1(CrmOpportunity2Crmopportunity2dataset1 crmopportunity2dataset1) {
        try {
            CrmOpportunity2PageVO crmOpportunity2PageVO = new CrmOpportunity2PageVO();
            List<CrmOpportunity2> list = this.crmOpportunity2Mapper.hussarQuerycrmOpportunity2Condition_1(crmopportunity2dataset1);
            crmOpportunity2PageVO.setData(list);
            if (HussarUtils.isNotEmpty(list)) {
                crmOpportunity2PageVO.setCount(Long.valueOf(list.size()));
            }
            crmOpportunity2PageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)crmOpportunity2PageVO);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5931\u8d25");
        }
    }

    @Override
    public ApiResponse<CrmOpportunity2PageVO> hussarQuery() {
        try {
            CrmOpportunity2PageVO crmOpportunity2PageVO = new CrmOpportunity2PageVO();
            List list = this.list();
            crmOpportunity2PageVO.setData(list);
            if (HussarUtils.isNotEmpty((Object)list)) {
                crmOpportunity2PageVO.setCount(Long.valueOf(list.size()));
            }
            crmOpportunity2PageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)crmOpportunity2PageVO);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5931\u8d25");
        }
    }

    @Override
    public ApiResponse<CrmOpportunity2PageVO> hussarQuerycrmOpportunity2Condition_2(CrmOpportunity2Crmopportunity2dataset2 crmopportunity2dataset2) {
        try {
            CrmOpportunity2PageVO crmOpportunity2PageVO = new CrmOpportunity2PageVO();
            List<CrmOpportunity2> list = this.crmOpportunity2Mapper.hussarQuerycrmOpportunity2Condition_2(crmopportunity2dataset2);
            crmOpportunity2PageVO.setData(list);
            if (HussarUtils.isNotEmpty(list)) {
                crmOpportunity2PageVO.setCount(Long.valueOf(list.size()));
            }
            crmOpportunity2PageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)crmOpportunity2PageVO);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5931\u8d25");
        }
    }

    @Override
    public OperateRecordAPIVo initializeOperateLog(String produceType, String changeBefore, String changeAfter, String changeField) {
        OperateRecordAPIVo trackRecord = new OperateRecordAPIVo();
        trackRecord.setProduceType(produceType);
        trackRecord.setChangeBefore(changeBefore);
        trackRecord.setChangeAfter(changeAfter);
        trackRecord.setChangeField(changeField);
        return trackRecord;
    }
}

