/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.competitoranalysis.external.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.core.api.competitoranalysis.service.ICompetitorAnalysisAPIService;
import com.jxdinfo.crm.core.api.competitoranalysis.vo.CompetitorAnalysisAPIVo;
import com.jxdinfo.crm.core.competitor.dao.CompetitorMapper;
import com.jxdinfo.crm.core.competitoranalysis.dao.CompetitorAnalysisMapper;
import com.jxdinfo.crm.core.competitoranalysis.model.CompetitorAnalysis;
import com.jxdinfo.crm.core.competitoranalysis.service.CompetitorAnalysisService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CompetitorAnalysisAPIServiceImpl
implements ICompetitorAnalysisAPIService {
    @Resource
    private CompetitorAnalysisService competitorAnalysisService;
    @Resource
    private CompetitorAnalysisMapper competitorAnalysisMapper;
    @Resource
    private CompetitorMapper competitorMapper;

    public List<CompetitorAnalysisAPIVo> getAllCompetitor() {
        return BeanUtil.copy((Collection)this.competitorAnalysisService.list((Wrapper)new LambdaQueryWrapper().eq(CompetitorAnalysis::getDelFlag, (Object)"0")), CompetitorAnalysisAPIVo.class);
    }

    public Boolean updateCompetitorAnalysis(Map<String, Object> map) {
        CompetitorAnalysis competitorAnalysis;
        Map childMap = (Map)map.get("data");
        Map user = (Map)childMap.get("createUser_user");
        String userId = user.get("id") == null ? null : String.valueOf(user.get("id"));
        String userName = (String)user.get("label");
        String organId = user.get("id") == null ? null : String.valueOf(user.get("id"));
        String organName = (String)user.get("label");
        String opportunityId = (String)childMap.get("OPPORTUNITY_ID");
        String opportunityName = (String)((Map)childMap.get("OPPORTUNITY_NAME")).get("value");
        List competitorList = (List)childMap.get("COMPETITORS_INFO");
        List updateList = competitorList.stream().filter(a -> a.get("COMPETITOR_ANALYSIS_ID") != null).collect(Collectors.toList());
        List insertList = competitorList.stream().filter(a -> a.get("COMPETITOR_ANALYSIS_ID") == null).collect(Collectors.toList());
        LocalDateTime dateTime = LocalDateTime.now();
        for (Map objectMap : updateList) {
            if (objectMap.get("COMPETITOR_ID") == null) continue;
            competitorAnalysis = new CompetitorAnalysis();
            competitorAnalysis.setCompetitorId(Long.valueOf((String)objectMap.get("COMPETITOR_ID")));
            competitorAnalysis.setCompetitorName((String)((Map)objectMap.get("COMPETITOR_NAME")).get("value"));
            competitorAnalysis.setOpportunityId(Long.valueOf(opportunityId));
            competitorAnalysis.setOpportunityName(opportunityName);
            competitorAnalysis.setIsSuccess((String)((Map)objectMap.get("IS_WIN")).get("value"));
            competitorAnalysis.setQuoteAmount(objectMap.get("QUOTATION_PRICE") == null ? null : String.valueOf(objectMap.get("QUOTATION_PRICE")));
            competitorAnalysis.setChangePerson(Long.valueOf(userId));
            competitorAnalysis.setChangePersonName(userName);
            competitorAnalysis.setOwnDepartment(Long.valueOf(organId));
            competitorAnalysis.setOwnDepartmentName(organName);
            competitorAnalysis.setChangeTime(dateTime);
            this.competitorAnalysisMapper.update(competitorAnalysis, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CompetitorAnalysis::getCompetitorId, (Object)competitorAnalysis.getCompetitorId())).eq(CompetitorAnalysis::getOpportunityId, (Object)opportunityId));
        }
        for (Map objectMap : insertList) {
            if (objectMap.get("COMPETITOR_ID") == null) continue;
            competitorAnalysis = new CompetitorAnalysis();
            competitorAnalysis.setCompetitorId(Long.valueOf((String)objectMap.get("COMPETITOR_ID")));
            competitorAnalysis.setCompetitorName((String)((Map)objectMap.get("COMPETITOR_NAME")).get("value"));
            competitorAnalysis.setOpportunityId(Long.valueOf(opportunityId));
            competitorAnalysis.setOpportunityName(opportunityName);
            competitorAnalysis.setIsSuccess((String)((Map)objectMap.get("IS_WIN")).get("value"));
            competitorAnalysis.setQuoteAmount(objectMap.get("QUOTATION_PRICE") == null ? null : String.valueOf(objectMap.get("QUOTATION_PRICE")));
            competitorAnalysis.setCreatePerson(Long.valueOf(userId));
            competitorAnalysis.setCreatePersonName(userName);
            competitorAnalysis.setChangePerson(Long.valueOf(userId));
            competitorAnalysis.setChangePersonName(userName);
            competitorAnalysis.setOwnDepartment(Long.valueOf(organId));
            competitorAnalysis.setOwnDepartmentName(organName);
            competitorAnalysis.setDelFlag("0");
            competitorAnalysis.setCreateTime(dateTime);
            competitorAnalysis.setChangeTime(dateTime);
            this.competitorAnalysisMapper.insert(competitorAnalysis);
        }
        return true;
    }

    public long countByOpportunityIdAndCompetitorId(Long opportunityId, Long competitorId) {
        long count = this.competitorAnalysisService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CompetitorAnalysis::getDelFlag, (Object)"0")).eq(CompetitorAnalysis::getOpportunityId, (Object)opportunityId)).eq(CompetitorAnalysis::getCompetitorId, (Object)competitorId));
        return count;
    }

    public Boolean addCompetitorAnalysis(CompetitorAnalysisAPIVo competitorAnalysisAPIVo) {
        CompetitorAnalysis competitorAnalysis = (CompetitorAnalysis)BeanUtil.copy((Object)competitorAnalysisAPIVo, CompetitorAnalysis.class);
        this.competitorAnalysisMapper.insert(competitorAnalysis);
        return true;
    }

    public List<CompetitorAnalysisAPIVo> selectByOpportunityId(Long opportunityId) {
        List competitorAnalysisList = this.competitorAnalysisService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CompetitorAnalysis::getOpportunityId, (Object)opportunityId)).eq(CompetitorAnalysis::getDelFlag, (Object)"0"));
        return BeanUtil.copy((Collection)competitorAnalysisList, CompetitorAnalysisAPIVo.class);
    }

    public void addCompetitorAnalysisBatch(List<CompetitorAnalysisAPIVo> competitorAnalysisAPIVoList) {
        List competitorAnalysisList = BeanUtil.copy(competitorAnalysisAPIVoList, CompetitorAnalysis.class);
        this.competitorAnalysisService.saveBatch(competitorAnalysisList);
    }
}

