/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.common.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.associativeQuery.vo.ProvinceVo;
import com.jxdinfo.crm.core.common.dto.CommonDto;
import com.jxdinfo.crm.core.common.dto.TianYanChaDto;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.common.vo.BackfillInfoVo;
import com.jxdinfo.crm.core.common.vo.CompanyBaseInfo;
import com.jxdinfo.crm.core.common.vo.CrmStruVo;
import com.jxdinfo.crm.core.common.vo.DeptUserTreeVo;
import com.jxdinfo.crm.core.common.vo.SearchCustomersVo;
import com.jxdinfo.crm.core.common.vo.StruVo;
import com.jxdinfo.crm.core.common.vo.TianYanChaVo;
import com.jxdinfo.crm.core.common.vo.UserInfoVo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"common"})
public class CommonController {
    @Resource
    private CommonService commonService;

    @PostMapping(value={"/selectByParentId"})
    public ApiResponse selectStruByParentId(@RequestBody CommonDto dto) {
        String struId = dto.getStruId();
        List<StruVo> list = this.commonService.selectStruByParentId(struId);
        return ApiResponse.success(list);
    }

    @PostMapping(value={"/getUserRoleIsManage"})
    public ApiResponse getUserRoleIsManage() {
        boolean flag = this.commonService.getUserRoleIsManage();
        return ApiResponse.success((Object)flag);
    }

    @PostMapping(value={"/getAllSecondStru"})
    public ApiResponse getAllSecondStru() {
        List<Map<String, Object>> list = this.commonService.getAllSecondStru();
        return ApiResponse.success(list);
    }

    @GetMapping(value={"/user/{userId}"})
    public ApiResponse<UserInfoVo> getUserInfo(@PathVariable(value="userId") Long userId) {
        return ApiResponse.success((Object)this.commonService.getUserInfo(userId));
    }

    @GetMapping(value={"/user/head/{userId}"})
    public void getUserHead(@PathVariable(value="userId") String userId, HttpServletResponse response) throws IOException {
        this.commonService.getUserHead(userId, response);
    }

    @GetMapping(value={"/user/list"})
    public ApiResponse<List<UserInfoVo>> getUserInfoList(@RequestParam(value="searchKey", required=false) String searchKey) {
        return ApiResponse.success(this.commonService.getUserInfoList(searchKey));
    }

    @GetMapping(value={"/organization"})
    public ApiResponse<List<CrmStruVo>> getOrganList(@RequestParam(value="organId", required=false) String organId, @RequestParam(value="searchKey", required=false) String searchKey) {
        return ApiResponse.success(this.commonService.getOrganList(organId, searchKey));
    }

    @PostMapping(value={"/company/information"})
    public ApiResponse<Page<TianYanChaVo>> getCompanyByTianyancha(@RequestBody TianYanChaDto tianYanChaDto) {
        return ApiResponse.success(this.commonService.getCompanyByTianyancha(tianYanChaDto));
    }

    @GetMapping(value={"/user/sales"})
    public ApiResponse<Integer> isSales() {
        return ApiResponse.success((Object)this.commonService.isSales());
    }

    @GetMapping(value={"/getChargePersonDetailed"})
    public ApiResponse<Map<String, Object>> getChargePersonDetailed(@RequestParam String userId, @RequestParam String userName) {
        Map<String, Object> map = this.commonService.getChargePersonDetailed(userId, userName);
        return ApiResponse.success(map);
    }

    @GetMapping(value={"/selectProvinceList"})
    public ApiResponse<List<ProvinceVo>> selectProvinceList() {
        return ApiResponse.success(this.commonService.getProvinceList());
    }

    @GetMapping(value={"/getDeptUserTree"})
    @ApiOperation(value="\u6839\u636e\u6743\u9650\u67e5\u8be2\u90e8\u95e8\u4eba\u5458\u6811", notes="\u6839\u636e\u6743\u9650\u67e5\u8be2\u90e8\u95e8\u4eba\u5458\u6811")
    @AuditLog(moduleName="\u516c\u5171\u65b9\u6cd5", eventDesc="\u516c\u5171\u65b9\u6cd5", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<DeptUserTreeVo>> getDeptUserTree(@RequestParam(value="StruId", required=false) @ApiParam(value="\u7ec4\u7ec7id") Long StruId) {
        return ApiResponse.success(this.commonService.getDeptUserTree(StruId, null));
    }

    @GetMapping(value={"/getDeptUserList"})
    @ApiOperation(value="\u6839\u636e\u6743\u9650\u67e5\u8be2\u90e8\u95e8\u4eba\u5458\u96c6\u5408", notes="\u6839\u636e\u6743\u9650\u67e5\u8be2\u90e8\u95e8\u4eba\u5458\u96c6\u5408")
    @AuditLog(moduleName="\u516c\u5171\u65b9\u6cd5", eventDesc="\u516c\u5171\u65b9\u6cd5", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<DeptUserTreeVo>> getDeptUserList(@RequestParam(value="searchKey") @ApiParam(value="\u5173\u952e\u5b57") String searchKey) {
        return ApiResponse.success(this.commonService.getDeptUserList(searchKey, null));
    }

    @GetMapping(value={"/getUserInfoByYyzcStrId"})
    @ApiOperation(value="\u6839\u636e\u8fd0\u8425\u652f\u6491\u7528\u6237id\u67e5\u8be2\u7cfb\u7edf\u7528\u6237\u4fe1\u606f", notes="\u6839\u636e\u8fd0\u8425\u652f\u6491\u7528\u6237id\u67e5\u8be2\u7cfb\u7edf\u7528\u6237\u4fe1\u606f")
    @AuditLog(moduleName="\u516c\u5171\u65b9\u6cd5", eventDesc="\u516c\u5171\u65b9\u6cd5", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysUsers> getUserIdByYyzcStrId(@RequestParam(value="userIdStr") @ApiParam(value="\u8fd0\u8425\u652f\u6491\u7528\u6237id") String userIdStr) {
        return ApiResponse.success((Object)this.commonService.getUserIdByYyzcStrId(userIdStr));
    }

    @PostMapping(value={"/company/getBaseInfo"})
    public ApiResponse<CompanyBaseInfo> getBaseInfoByTianyancha(@RequestBody TianYanChaDto tianYanChaDto) {
        return ApiResponse.success((Object)this.commonService.getBaseInfoByTianyancha(tianYanChaDto));
    }

    @GetMapping(value={"/company/getBackfillInfoByName"})
    public ApiResponse<BackfillInfoVo> getBackfillInfoByName(@RequestParam String name) {
        return ApiResponse.success((Object)this.commonService.getBackfillInfoByName(name));
    }

    @GetMapping(value={"/company/getShortName"})
    public ApiResponse<String> getShortName(@RequestParam String name) {
        return ApiResponse.success((String)this.commonService.companySimplify(name));
    }

    @GetMapping(value={"searchCustomers"})
    public ApiResponse<SearchCustomersVo> searchCustomers(@RequestParam String word, @RequestParam int pageNum, @RequestParam int pageSize, @RequestParam String region, @RequestParam Integer regCapital_min, @RequestParam Integer regCapital_max) {
        return ApiResponse.success((Object)this.commonService.searchCustomers(word, pageNum, pageSize, region, regCapital_min, regCapital_max));
    }
}

