/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.product.service.Impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.core.product.dao.ProductManagerMapper;
import com.jxdinfo.crm.core.product.dto.ProductManagerDto;
import com.jxdinfo.crm.core.product.model.ProductManager;
import com.jxdinfo.crm.core.product.service.ProductManagerService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ProductManagerServiceImpl
extends ServiceImpl<ProductManagerMapper, ProductManager>
implements ProductManagerService {
    @Resource
    private ProductManagerMapper productManagerMapper;

    @Override
    public Page<ProductManager> list(ProductManagerDto dto) {
        Page page = dto.getPage();
        dto.setDelFlag("0");
        List<ProductManager> list = this.productManagerMapper.queryProduceManagerList(dto, page);
        page.setRecords(list);
        return page;
    }

    @Override
    public boolean saveProductManager(ProductManager productManager) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        if (productManager.getProductManagerId() == null) {
            productManager.setDelFlag("0");
            productManager.setCreateTime(date);
            productManager.setCreatePerson(user.getUserId());
            productManager.setCreatePersonName(user.getUserName());
        }
        return this.saveOrUpdate(productManager);
    }

    @Override
    public boolean deleteProductManager(List<String> productManagerIds) {
        if (CollectionUtil.isEmpty(productManagerIds)) {
            throw new BaseException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<ProductManager> list = new ArrayList<ProductManager>();
        for (String productManagerId : productManagerIds) {
            ProductManager manager = new ProductManager();
            manager.setDelFlag("1");
            manager.setProductManagerId(Long.valueOf(productManagerId));
            list.add(manager);
        }
        return this.updateBatchById(list);
    }
}

