/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.job.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.civiw.biz.ms.hd.civiwhdsdk.api.ClueOpenDataApi;
import com.civiw.biz.ms.hd.civiwhdsdk.entity.ClueResult;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.job.dao.ClueResultSyncMapper;
import com.jxdinfo.crm.core.job.model.ClueResultSync;
import com.jxdinfo.crm.core.job.model.InterfaceUrlProduct;
import com.jxdinfo.crm.core.job.service.ClueResultSyncService;
import com.jxdinfo.crm.core.leads.model.Leads;
import com.jxdinfo.crm.core.leads.service.LeadsService;
import com.jxdinfo.crm.core.marketingactivity.model.SourceMarketingActivityEntity;
import com.jxdinfo.crm.core.marketingactivity.service.SourceMarketingActivityService;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.os.sdk.common.utils.JsonUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClueResultSyncServiceImpl
extends ServiceImpl<ClueResultSyncMapper, ClueResultSync>
implements ClueResultSyncService {
    @Resource
    private ClueOpenDataApi clueOpenDataApi;
    @Resource
    private LeadsService leadsService;
    @Resource
    private ClueResultSyncMapper clueResultSyncMapper;
    @Resource
    private SourceMarketingActivityService sourceMarketingActivityService;
    @Resource
    private CrmCommonProperties crmCommonProperties;

    @Override
    @Transactional
    public ProcessResult saveLeadsInfo() {
        LocalDateTime dateTime = LocalDateTime.now();
        try {
            List clueResultList = this.clueOpenDataApi.queryUnreadClueResult(this.crmCommonProperties.getSwhudong().getUserName(), this.crmCommonProperties.getSwhudong().getPassword(), this.crmCommonProperties.getSwhudong().getRefresh().booleanValue());
            if (CollectionUtil.isEmpty((Collection)clueResultList)) {
                return new ProcessResult(true);
            }
            ArrayList<ClueResultSync> clueResultSyncList = new ArrayList<ClueResultSync>();
            List sourceCampaignList = this.sourceMarketingActivityService.list();
            Map<String, SourceMarketingActivityEntity> sourceCampaignNameMap = sourceCampaignList.stream().collect(Collectors.toMap(SourceMarketingActivityEntity::getSourceName, s -> s));
            List<InterfaceUrlProduct> interfaceUrlProductList = this.clueResultSyncMapper.selectInterfaceUrlProductList();
            List clueResultIdList = this.listObjs((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{ClueResultSync::getId}).in(ClueResultSync::getId, (Collection)clueResultList.stream().map(ClueResult::getClueId).collect(Collectors.toList())), String::valueOf);
            for (ClueResult clueResult : clueResultList) {
                if (clueResultIdList.contains(clueResult.getClueId())) continue;
                ClueResultSync clueResultSync = new ClueResultSync();
                clueResultSync.setId(clueResult.getClueId());
                clueResultSync.setUpdateTime(dateTime);
                clueResultSync.setObjectJson(JsonUtil.toJson((Object)clueResult));
                clueResultSyncList.add(clueResultSync);
                boolean urlFindFlag = false;
                if (clueResult.getInterfaceUrl() != null) {
                    for (InterfaceUrlProduct interfaceUrlProduct : interfaceUrlProductList) {
                        if (!clueResult.getInterfaceUrl().contains(interfaceUrlProduct.getInterfaceUrl())) continue;
                        Leads leads = new Leads();
                        leads.setCompanyName(clueResult.getCompany());
                        leads.setName(clueResult.getContactor());
                        leads.setMobilePhone(clueResult.getPhone());
                        leads.setPosition(clueResult.getPosition());
                        leads.setKeyword(clueResult.getKeyword());
                        if (clueResult.getPkResource() != null && sourceCampaignNameMap.containsKey(clueResult.getPkResource())) {
                            leads.setCampaignName(sourceCampaignNameMap.get(clueResult.getPkResource()).getCampaignName());
                            leads.setCampaignId(sourceCampaignNameMap.get(clueResult.getPkResource()).getCampaignId());
                        }
                        leads.setCustomerNeeds("\u6765\u6e90\uff1a\u8bc6\u5fae\u4e92\u52a8");
                        leads.setLeadsName(interfaceUrlProduct.getShortName());
                        leads.setProductName(interfaceUrlProduct.getShortName());
                        leads.setProductId(interfaceUrlProduct.getProductId().toString());
                        this.leadsService.addLeads(leads);
                        urlFindFlag = true;
                        break;
                    }
                }
                if (urlFindFlag) continue;
                Leads leads = new Leads();
                leads.setCompanyName(clueResult.getCompany());
                leads.setName(clueResult.getContactor());
                leads.setMobilePhone(clueResult.getPhone());
                leads.setPosition(clueResult.getPosition());
                if (clueResult.getPkResource() != null && sourceCampaignNameMap.containsKey(clueResult.getPkResource())) {
                    leads.setCampaignName(sourceCampaignNameMap.get(clueResult.getPkResource()).getCampaignName());
                    leads.setCampaignId(sourceCampaignNameMap.get(clueResult.getPkResource()).getCampaignId());
                }
                leads.setRemark(clueResult.getInterfaceForm());
                leads.setLeadsName("\u672a\u77e5");
                leads.setKeyword(clueResult.getKeyword());
                leads.setCustomerNeeds("\u6765\u6e90\uff1a\u8bc6\u5fae\u4e92\u52a8");
                this.leadsService.addLeads(leads);
            }
            this.saveOrUpdateBatch(clueResultSyncList);
            this.clueOpenDataApi.confirmClueResult(this.crmCommonProperties.getSwhudong().getUserName(), this.crmCommonProperties.getSwhudong().getPassword(), this.crmCommonProperties.getSwhudong().getRefresh().booleanValue(), clueResultIdList);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return new ProcessResult(true);
    }
}

