/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.fileinfo.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordAPIVo;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.crm.datasourcefolder.sysfileinfo1.service.SysFileInfo1Service;
import com.jxdinfo.crm.core.docbase.service.DocbaseService;
import com.jxdinfo.crm.core.fileinfo.dao.FileInfoMapper;
import com.jxdinfo.crm.core.fileinfo.dto.FileInfoDto;
import com.jxdinfo.crm.core.fileinfo.model.FileDownload;
import com.jxdinfo.crm.core.fileinfo.model.FileInfo;
import com.jxdinfo.crm.core.fileinfo.service.FileDownloadService;
import com.jxdinfo.crm.core.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.core.fileinfo.sync.SyncFileInfoCallable;
import com.jxdinfo.crm.core.product.dao.ProductMapper;
import com.jxdinfo.crm.core.product.model.Product;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.entity.ContentType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class FileInfoServiceImpl
extends ServiceImpl<FileInfoMapper, FileInfo>
implements FileInfoService {
    @Resource
    private FileInfoMapper fileInfoMapper;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Autowired
    SysFileInfo1Service sysFileInfo1Service;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private FileDownloadService fileDownloadService;
    @Resource
    private DocbaseService docbaseService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private ProductMapper productMapper;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private CrmCommonProperties crmCommonProperties;
    @Resource
    private IHussarBaseUserBoService iHussarBaseUserBoService;

    @Override
    public Page<FileInfo> selectFileInfoByBusinessId(FileInfoDto dto) {
        Page page = new Page(1L, -1L);
        long businessId = Long.valueOf(dto.getBusinessId());
        List trackRecordList = this.trackRecordAPIService.queryTrackRecordList(Long.valueOf(businessId));
        ArrayList<Long> lids = new ArrayList<Long>();
        List<Object> list = new ArrayList();
        lids.add(businessId);
        for (TrackRecordAPIVo trackRecord : trackRecordList) {
            if (!ToolUtil.isNotEmpty((Object)trackRecord)) continue;
            lids.add(trackRecord.getRecordId());
        }
        if (null != lids && lids.size() != 0) {
            list = this.fileInfoMapper.selectFileInfoByBusinessId(lids, page, "0");
        }
        page.setRecords(list);
        return page;
    }

    @Override
    public List<FileInfo> selectFileInfoFromTrackRecord(FileInfoDto dto) {
        long businessId = Long.valueOf(dto.getBusinessId());
        String enclosureType = dto.getEnclosureType();
        return this.fileInfoMapper.selectFileInfoFromTrackRecord(businessId, enclosureType, "0");
    }

    @Override
    @Transactional
    public Map<String, Object> upload(MultipartHttpServletRequest multipartRequest, String enclosureType, String attachmentType, String docbase, String businessType, String businessId) {
        Product product;
        SecurityUser user = BaseSecurityUtil.getUser();
        String uploadPerson = user.getUserName();
        LocalDateTime date = LocalDateTime.now();
        FileInfo fileInfo = new FileInfo();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (multipartRequest.getFileMap().isEmpty()) {
            throw new BaseException("\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u6587\u4ef6");
        }
        long id = Long.parseLong(CommonUtills.generateAssignId());
        AttachmentManagerModelVo attachment = null;
        try {
            ApiResponse response = this.attachmentManagerService.uploadFileWithDrag(multipartRequest, Long.valueOf(id));
            attachment = (AttachmentManagerModelVo)response.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException("\u4e0a\u4f20\u5931\u8d25");
        }
        if (this.crmProperties.getDocbase().isDocbaseEnable() && "1".equals(docbase)) {
            String docbaseFileId = "";
            Product product2 = (Product)this.productMapper.selectById((Serializable)((Object)businessId));
            MultipartFile file = multipartRequest.getFile("files");
            JSONObject tokenObject = this.docbaseService.getToken(user.getUserName(), user.getUserName());
            String accessToken = JSONObject.parseObject((String)tokenObject.get((Object)"result").toString()).get((Object)"accessToken").toString();
            JSONObject resultObject = this.docbaseService.uploadFile(user.getUserName(), user.getUserName(), accessToken, attachment.getId().toString(), file, product2.getFolderId());
            docbaseFileId = JSONObject.parseObject((String)resultObject.get((Object)"result").toString()).get((Object)"fileId").toString();
            if (ToolUtil.isEmpty((Object)docbaseFileId)) {
                throw new BaseException("\u4e0a\u4f20\u6587\u5e93\u5931\u8d25");
            }
            fileInfo.setDocbaseFileId(docbaseFileId);
        }
        String fileName = attachment.getAttachmentName();
        String fileType = attachment.getAttachmentType();
        double fileSize = Double.parseDouble(attachment.getBytes());
        fileInfo.setId(attachment.getId());
        fileInfo.setFileName(fileName);
        fileInfo.setFileType(fileType);
        fileInfo.setFilePath(attachment.getPath());
        fileInfo.setFileSize(fileSize / 1024.0);
        fileInfo.setEnclosureType(enclosureType);
        fileInfo.setUploadTime(LocalDateTime.now());
        fileInfo.setUploadPerson(uploadPerson);
        fileInfo.setDelFlag("0");
        fileInfo.setFileFrom("\u8bb0\u5f55\u4e0a\u4f20");
        if (attachmentType != null) {
            fileInfo.setAttachmentType(attachmentType);
        }
        this.fileInfoMapper.insertFileInfo(fileInfo);
        map.put("id", attachment.getId());
        if ("10".equals(businessType) && ToolUtil.isNotEmpty((Object)(product = (Product)this.productMapper.selectById((Serializable)((Object)businessId))))) {
            ArrayList<Long> pushRoleIds = new ArrayList<Long>();
            pushRoleIds.add(Long.valueOf(this.crmCommonProperties.getRoles().getSalesmanAnalysis()));
            pushRoleIds.add(Long.valueOf(this.crmCommonProperties.getRoles().getSalesGM()));
            List pushPerson = this.iHussarBaseUserBoService.getUserInfoByRoleId(pushRoleIds);
            ArrayList<String> pushPersonIds = new ArrayList();
            if (CollectionUtil.isNotEmpty((Collection)pushPerson)) {
                pushPersonIds = pushPerson.stream().map(UserVo::getId).map(String::valueOf).distinct().collect(Collectors.toList());
            }
            if (CollectionUtil.isNotEmpty(pushPersonIds)) {
                String title = "\u3010" + product.getShortName() + "\u3011\u4ea7\u54c1\u8d44\u6599\u66f4\u65b0";
                String content = "\u65b0\u589e\u3010" + fileName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                EimPushUtil.pushJqxArticleMessage(title, content, "/chanpinguanli/01pageFolder/chanpin/cpxq", businessId, pushPersonIds);
                AddSysMessageType addSysMessageType = new AddSysMessageType();
                String userIdToString = StringUtil.join(pushPersonIds, (String)",");
                String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/productDetails?row=" + "\"" + businessId + "\"";
                String contentUnify = "\u3010\u4ea7\u54c1\u8d44\u6599\u66f4\u65b0\u3011\u3010" + product.getShortName() + "\u3011\u4ea7\u54c1\u8d44\u6599\u66f4\u65b0\uff1a\u65b0\u589e\u3010" + fileName + "\u3011\uff0c\u8bf7\u77e5\u6089";
                UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, userIdToString, uploadPerson, unifyWebUrl, "");
                UnifyUtil.sendMessage(addSysMessageType);
            }
        }
        return map;
    }

    @Override
    @Transactional
    public String multiUpload(MultipartHttpServletRequest multipartRequest, FileInfoDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        String uploadPerson = user.getUserName();
        List<String> ids = dto.getIds();
        List<String> imageFormats = Arrays.asList("jpg", "jpeg", "png", "gif", "bmp", "webp");
        List attachments = new ArrayList();
        if (CollectionUtil.isNotEmpty(ids)) {
            this.deleteFileInfoByIds(dto);
        }
        try {
            long id = Long.parseLong(CommonUtills.generateAssignId());
            attachments = this.attachmentManagerService.uploadMultipleFile(multipartRequest, Long.valueOf(id));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException("\u4e0a\u4f20\u5931\u8d25");
        }
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        for (AttachmentManagerModelVo attachment : attachments) {
            FileInfo fileInfo = new FileInfo();
            fileInfo.setId(attachment.getId());
            fileInfo.setFileName(attachment.getAttachmentName());
            fileInfo.setFileType(attachment.getAttachmentType());
            fileInfo.setFilePath(attachment.getPath());
            fileInfo.setFileSize(Double.parseDouble(attachment.getBytes()) / 1024.0);
            if (imageFormats.contains(attachment.getAttachmentType().toLowerCase())) {
                fileInfo.setEnclosureType("2");
            } else {
                fileInfo.setEnclosureType("1");
            }
            fileInfo.setUploadTime(LocalDateTime.now());
            fileInfo.setUploadPerson(uploadPerson);
            fileInfo.setDelFlag("0");
            fileInfo.setFileFrom("\u9644\u4ef6\u4e0a\u4f20");
            if (dto.getAttachmentType() != null) {
                fileInfo.setAttachmentType(dto.getAttachmentType());
            }
            fileInfo.setBusinessId(Long.parseLong(dto.getBusinessId()));
            fileInfo.setBusinessType(dto.getBusinessType());
            fileInfoList.add(fileInfo);
        }
        this.saveOrUpdateBatch(fileInfoList);
        return "\u4fdd\u5b58\u6210\u529f";
    }

    @Override
    public int insertFileInfo(FileInfoDto fileInfoDto) {
        List<String> ids = fileInfoDto.getIds();
        String businessId = fileInfoDto.getBusinessId();
        if (ids == null || ids.size() == 0) {
            return -1;
        }
        ArrayList<String> idTemp = new ArrayList<String>();
        for (String id : ids) {
            if (!ToolUtil.isNotEmpty((Object)id)) continue;
            idTemp.add(id);
        }
        if (idTemp.size() == 0) {
            return -1;
        }
        List<Long> lids = idTemp.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        return this.fileInfoMapper.updateBusinessIdByIds(lids, Long.valueOf(businessId));
    }

    @Override
    public void insertFileInfoBatch(List<FileInfoDto> fileInfoDtoList) {
        if (CollectionUtil.isEmpty(fileInfoDtoList)) {
            return;
        }
        ArrayList<String> fileIdList = new ArrayList<String>();
        HashMap<String, String> tempMap = new HashMap<String, String>();
        for (FileInfoDto fileInfoDto : fileInfoDtoList) {
            fileIdList.addAll(fileInfoDto.getIds());
            for (String id : fileInfoDto.getIds()) {
                tempMap.put(id, fileInfoDto.getBusinessId());
            }
        }
        List fileInfoList = this.fileInfoMapper.selectBatchIds(fileIdList);
        for (FileInfo fileInfo : fileInfoList) {
            fileInfo.setBusinessId(Long.parseLong((String)tempMap.get(String.valueOf(fileInfo.getId()))));
        }
        this.updateBatchById(fileInfoList);
    }

    @Override
    @Transactional
    public String deleteFileInfoByIds(FileInfoDto fileInfoDto) {
        FileInfo fileInfo;
        Long businessId;
        Product product;
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        List<String> ids = fileInfoDto.getIds();
        List<Long> lids = ids.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        ArrayList<String> fileNames = new ArrayList<String>();
        Iterator iterator = lids.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            FileInfo fileInfo2 = this.fileInfoMapper.selectFileInfoById(id, "0");
            if (null == fileInfo2) {
                return "\u672a\u627e\u5230\u6587\u4ef6";
            }
            fileNames.add(fileInfo2.getFileName());
            this.attachmentManagerService.deleteFile(Long.valueOf(id));
        }
        if (CollectionUtil.isNotEmpty(fileNames) && ToolUtil.isNotEmpty((Object)(product = (Product)this.productMapper.selectById(businessId = Long.valueOf((fileInfo = (FileInfo)this.fileInfoMapper.selectById((Serializable)((Object)ids.get(0)))).getBusinessId())))) && CollectionUtil.isNotEmpty(fileNames)) {
            String fileName = String.join((CharSequence)"\u3001", fileNames);
            ArrayList<Long> pushRoleIds = new ArrayList<Long>();
            pushRoleIds.add(Long.valueOf(this.crmCommonProperties.getRoles().getSalesmanAnalysis()));
            pushRoleIds.add(Long.valueOf(this.crmCommonProperties.getRoles().getSalesGM()));
            List pushPerson = this.iHussarBaseUserBoService.getUserInfoByRoleId(pushRoleIds);
            ArrayList<String> pushPersonIds = new ArrayList();
            if (CollectionUtil.isNotEmpty((Collection)pushPerson)) {
                pushPersonIds = pushPerson.stream().map(UserVo::getId).map(String::valueOf).distinct().collect(Collectors.toList());
            }
            if (CollectionUtil.isNotEmpty(pushPersonIds)) {
                String title = "\u3010" + product.getShortName() + "\u3011\u4ea7\u54c1\u8d44\u6599\u66f4\u65b0";
                String content = "\u5220\u9664\u3010" + fileName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                EimPushUtil.pushJqxArticleMessage(title, content, "/chanpinguanli/01pageFolder/chanpin/cpxq", String.valueOf(businessId), pushPersonIds);
                AddSysMessageType addSysMessageType = new AddSysMessageType();
                String userIdToString = StringUtil.join(pushPersonIds, (String)",");
                String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/productDetails?row=" + "\"" + businessId + "\"";
                String contentUnify = "\u3010\u4ea7\u54c1\u8d44\u6599\u66f4\u65b0\u3011\u3010" + product.getShortName() + "\u3011\u4ea7\u54c1\u8d44\u6599\u66f4\u65b0\uff1a\u5220\u9664\u3010" + fileName + "\u3011\uff0c\u8bf7\u77e5\u6089";
                UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, userIdToString, user.getUserName(), unifyWebUrl, "");
                UnifyUtil.sendMessage(addSysMessageType);
            }
        }
        int i = this.fileInfoMapper.deleteFileInfoByIds(lids, null, "1");
        if (this.crmProperties.getDocbase().isDocbaseEnable() && fileInfoDto.getDocbase() != null && fileInfoDto.getDocbase().equals("1")) {
            String fids = ids.stream().collect(Collectors.joining(","));
            this.docbaseService.deleteFile(user.getUserName(), user.getUserName(), "", fids);
        }
        if (i > 0) {
            return "\u5220\u9664\u6210\u529f";
        }
        return "\u6570\u636e\u5220\u9664\u5931\u8d25";
    }

    @Override
    @Transactional
    public void fileDownload(HttpServletResponse response, String fileId, Long userId, String type) throws ServletException, IOException {
        SecurityUser user = this.fileDownloadService.getUserInfoByUserId(userId);
        if (user == null) {
            throw new BaseException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        String[] fileIdArr = fileId.split(",");
        LocalDateTime date = LocalDateTime.now();
        for (String fileIdStr : fileIdArr) {
            FileDownload download = new FileDownload();
            download.setDownloadId(Long.parseLong(CommonUtills.generateAssignId()));
            download.setCreateTime(date);
            download.setFileId(Long.valueOf(fileIdStr));
            download.setCreateDepartment(user.getDeptId());
            download.setCreateDepartmentName(user.getDeptName());
            download.setCreatePersion(user.getUserId());
            download.setCreatePersionName(user.getUserName());
            this.fileDownloadService.save(download);
        }
        if (fileIdArr.length == 1) {
            if (StringUtil.isNotBlank((CharSequence)type) && "web".equals(type)) {
                this.attachmentManagerService.batchDownload(fileId, response);
            } else {
                this.attachmentManagerService.fileDownload(response, Long.valueOf(fileIdArr[0]));
            }
        }
        if (fileIdArr.length > 1) {
            this.attachmentManagerService.batchDownload(fileId, response);
        }
    }

    @Override
    @Transactional
    public String previewFile(String id) {
        FileInfo fileInfo = (FileInfo)this.getById((Serializable)((Object)id));
        if (ToolUtil.isEmpty((Object)fileInfo.getDocbaseFileId())) {
            throw new BaseException("\u9644\u4ef6\u672a\u4e0a\u4f20\u6587\u5e93\u65e0\u6cd5\u9884\u89c8");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        String accessToken = "";
        JSONObject tokenObject = this.docbaseService.getToken(user.getUserName(), user.getUserName());
        if (tokenObject.get((Object)"code").equals("1")) {
            accessToken = JSONObject.parseObject((String)tokenObject.get((Object)"result").toString()).get((Object)"accessToken").toString();
        }
        JSONObject resultObject = this.docbaseService.previewFile(user.getUserName(), user.getUserName(), accessToken, fileInfo.getDocbaseFileId());
        String url = "";
        if (resultObject.get((Object)"code").equals("1")) {
            url = JSONObject.parseObject((String)resultObject.get((Object)"result").toString()).getString("filepath");
        }
        return url;
    }

    @Override
    @Transactional
    public boolean syncFile() {
        List products = this.productMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Product::getDelFlag, (Object)"0")).isNotNull(Product::getFolderId));
        if (CollectionUtil.isNotEmpty((Collection)products)) {
            try {
                for (Product product : products) {
                    if (!ToolUtil.isNotEmpty((Object)product.getFolderId())) continue;
                    List fileInfoList = this.fileInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FileInfo::getDelFlag, (Object)"0")).eq(FileInfo::getBusinessId, (Object)product.getProductId())).isNull(FileInfo::getDocbaseFileId));
                    for (FileInfo fileInfo : fileInfoList) {
                        if (!StringUtil.isEmpty((Object)fileInfo.getDocbaseFileId())) continue;
                        File file = new File(fileInfo.getFilePath());
                        if (!file.exists()) {
                            System.out.println("\u540c\u6b65\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + fileInfo.getFilePath());
                            continue;
                        }
                        MultipartFile file1 = this.getMultipartFile(file, fileInfo.getFileName());
                        SyncFileInfoCallable fileInfoCallable = new SyncFileInfoCallable();
                        fileInfoCallable.setUserName(product.getProductManagerName());
                        fileInfoCallable.setAccessToken("");
                        fileInfoCallable.setFile(file1);
                        fileInfoCallable.setId(String.valueOf(fileInfo.getId()));
                        fileInfoCallable.setFileName(fileInfo.getFileName());
                        fileInfoCallable.setFolderId(product.getFolderId());
                        fileInfoCallable.call();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public boolean mergeFileInfo(List<Long> oldBusinessIdList, Long newBusinessId) {
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(FileInfo::getBusinessId, oldBusinessIdList)).set(FileInfo::getBusinessId, (Object)newBusinessId));
        return true;
    }

    private MultipartFile getMultipartFile(File file, String fileName) {
        FileInputStream fileInputStream = null;
        MockMultipartFile multipartFile = null;
        try {
            fileInputStream = new FileInputStream(file);
            multipartFile = new MockMultipartFile(fileName, fileName, ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return multipartFile;
    }
}

