/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.dataright.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.model.CustomerIncludePool;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.customer.service.ICustomerIncludePoolService;
import com.jxdinfo.crm.core.dataright.dao.DataRightMapper;
import com.jxdinfo.crm.core.dataright.model.DataModule;
import com.jxdinfo.crm.core.dataright.model.DataRight;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.util.DefaultCacheUtil;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class DataPermission {
    public static ConcurrentHashMap<String, Object> moduleMap = new ConcurrentHashMap();

    public static void setRightCache() {
        DataRightMapper dataRightMapper = (DataRightMapper)SpringUtils.getBean(DataRightMapper.class);
        List<DataRight> rightList = dataRightMapper.selectDataRightList("0");
        DefaultCacheUtil.put((Object)"rightKey", rightList);
    }

    public static void setModuleCache() {
        DataRightMapper dataRightMapper = (DataRightMapper)SpringUtils.getBean(DataRightMapper.class);
        List<DataModule> moduleList = dataRightMapper.selectRightModule(null, "0");
        DefaultCacheUtil.put((Object)"moduleKey", moduleList);
        moduleMap.clear();
        if (moduleList != null && moduleList.size() > 0) {
            for (DataModule module : moduleList) {
                moduleMap.put(module.getModuleCode(), module.getModuleCode());
            }
        }
    }

    public static void setStruCache() {
        CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
        List<SysStru> struList = commonMapper.selectAllStruInfo("0", "100001");
        ArrayList list = new ArrayList();
        for (SysStru stru : struList) {
            HashMap<String, Long> child = new HashMap<String, Long>();
            child.put("struId", stru.getId());
            child.put("parentId", stru.getId());
            list.add(child);
            List<SysStru> children = commonMapper.selectAllStruInfo("0", stru.getId().toString());
            if (!CollectionUtil.isNotEmpty(children)) continue;
            for (SysStru stru2 : children) {
                HashMap<String, Long> child2 = new HashMap<String, Long>();
                child2.put("struId", stru2.getId());
                child2.put("parentId", stru.getId());
                list.add(child2);
            }
        }
        DefaultCacheUtil.put((Object)"struKey", list);
    }

    public static void setStruCacheCopy() {
        CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
        List<SysStru> struList = commonMapper.selectAllStruInfo("0", "100001");
        ArrayList list = new ArrayList();
        for (SysStru stru : struList) {
            HashMap<String, Long> child = new HashMap<String, Long>();
            child.put("struId", stru.getId());
            child.put("parentId", stru.getParentId());
            list.add(child);
            List<SysStru> children = commonMapper.selectAllStruInfo("0", stru.getId().toString());
            if (!CollectionUtil.isNotEmpty(children)) continue;
            for (SysStru stru2 : children) {
                HashMap<String, Long> child2 = new HashMap<String, Long>();
                child2.put("struId", stru2.getId());
                child2.put("parentId", stru.getId());
                list.add(child2);
            }
        }
        DefaultCacheUtil.put((Object)"struKeyCopy", list);
    }

    public static void setLeadershipRoles() {
        CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
        List<Long> list = commonMapper.getLeadershipRoles();
        DefaultCacheUtil.put((Object)"leadshipKey", list);
    }

    public static void setLeadershipBGList() {
        CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
        List<Map<String, String>> list = commonMapper.getBGListForUser();
        DefaultCacheUtil.put((Object)"userBGlist", list);
    }

    public static List<DataRight> getRightCache() {
        return (List)DefaultCacheUtil.get((Object)"rightKey");
    }

    public static List<DataModule> getModuleCache() {
        return (List)DefaultCacheUtil.get((Object)"moduleKey");
    }

    public static List<Map<String, Long>> getStruCache() {
        return (List)DefaultCacheUtil.get((Object)"struKey");
    }

    public static List<Long> getLeadershipRoles() {
        return (List)DefaultCacheUtil.get((Object)"leadshipKey");
    }

    public static List<Map<String, String>> getLeadershipBGList() {
        return (List)DefaultCacheUtil.get((Object)"userBGlist");
    }

    public static List<String> getLeadershipBGList(Long userId) {
        List userList;
        ArrayList<String> deptId = new ArrayList<String>();
        List<Map<String, String>> list = DataPermission.getLeadershipBGList();
        if (CollectionUtil.isNotEmpty(list) && (userList = list.stream().filter(s -> String.valueOf(s.get("userId")).equals(String.valueOf(userId))).collect(Collectors.toList())).size() > 0) {
            for (Map map : userList) {
                deptId.add(String.valueOf(map.get("struId")));
            }
        }
        return deptId;
    }

    public static Long getParentIdByDeptId(List<Map<String, Long>> struList, Long deptId) {
        if (CollectionUtil.isEmpty(struList)) {
            return deptId;
        }
        for (Map<String, Long> map : struList) {
            if (!map.get("struId").equals(deptId)) continue;
            return map.get("parentId");
        }
        return deptId;
    }

    public static boolean isLeadship(List<Long> userRoles, List<Long> leadershipRoles) {
        if (CollectionUtil.isEmpty(leadershipRoles)) {
            return false;
        }
        for (Long role : leadershipRoles) {
            if (!userRoles.contains(role)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getAllDeptIdByParentId(List<Map<String, Long>> struList, Long parentId) {
        ArrayList<String> deptList = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(struList)) {
            for (Map<String, Long> map : struList) {
                if (!map.get("parentId").equals(parentId) && !map.get("struId").equals(parentId)) continue;
                deptList.add(map.get("struId").toString());
            }
        }
        return deptList;
    }

    public static boolean customerNameExists(String name) {
        CustomerService customerService;
        long count;
        Long parentId;
        if (StringUtil.isEmpty((Object)name)) {
            return false;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List<Map<String, Long>> struList = DataPermission.getStruCache();
        List<String> deptIds = DataPermission.getAllDeptIdByParentId(struList, parentId = DataPermission.getParentIdByDeptId(struList, user.getDeptId()));
        if (CollectionUtil.isEmpty(deptIds)) {
            deptIds.add(user.getDeptId().toString());
        }
        return (count = (customerService = (CustomerService)SpringUtils.getBean(CustomerService.class)).count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerEntity::getCustomerName, (Object)name)).eq(CustomerEntity::getDelFlag, (Object)"0")).in(CustomerEntity::getOwnDepartment, deptIds))) > 0L;
    }

    public static List<CustomerIncludePool> customerNameCheck(String name) {
        if (StringUtil.isEmpty((Object)name)) {
            return null;
        }
        ICustomerIncludePoolService customerIncludePoolService = (ICustomerIncludePoolService)SpringUtils.getBean(ICustomerIncludePoolService.class);
        List list = customerIncludePoolService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(CustomerEntity::getCustomerName, (Object)name)).or()).like(CustomerEntity::getCustomerReferredName, (Object)name)).or()).like(CustomerEntity::getCustomerAlias, (Object)name);
        })).eq(CustomerEntity::getDelFlag, (Object)"0"));
        Collections.sort(list, (a, b) -> {
            if (name.equals(a.getCustomerName()) && !name.equals(b.getCustomerName())) {
                return -1;
            }
            if (!name.equals(a.getCustomerName()) && name.equals(b.getCustomerName())) {
                return 1;
            }
            return a.getCustomerName().compareTo(b.getCustomerName());
        });
        return list;
    }

    public static List<Long> getPermissionProduct(Long userId) {
        CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
        return commonMapper.getProductByUserId(userId);
    }
}

