/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.dataright.interceptor;

import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.core.dataright.interceptor.BoundSqlSource;
import com.jxdinfo.crm.core.dataright.model.DataModule;
import com.jxdinfo.crm.core.dataright.model.DataRight;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.cache.support.HussarCacheManager;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class DataScopeInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DataScopeInterceptor.class);
    private static final ReflectorFactory REFLECTORFACTORY = new DefaultReflectorFactory();

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        RowBounds rowBounds = (RowBounds)args[2];
        String sqlCommandType = ms.getSqlCommandType().toString();
        if (!sqlCommandType.equals(SqlCommandType.SELECT.toString())) {
            return invocation.proceed();
        }
        String id = ms.getId();
        String methodName = id.substring(id.lastIndexOf(".") + 1);
        if (StringUtils.startsWith((CharSequence)id, (CharSequence)"com.jxdinfo.hussar.example.bsp.")) {
            return invocation.proceed();
        }
        Optional<Object> bean = Optional.ofNullable(SpringContextUtil.getBean(HussarCacheManager.class));
        if (!bean.isPresent()) {
            return invocation.proceed();
        }
        List<DataModule> moduleList = DataPermission.getModuleCache();
        if (moduleList == null) {
            return invocation.proceed();
        }
        if (!DataPermission.moduleMap.containsKey(methodName)) {
            return invocation.proceed();
        }
        Object parameterObject = null;
        if (invocation.getArgs().length > 1) {
            parameterObject = invocation.getArgs()[1];
        }
        BoundSql boundSql = ms.getBoundSql(parameterObject);
        String origSql = boundSql.getSql();
        this.handleSql(origSql, invocation, moduleList, methodName);
        return invocation.proceed();
    }

    private void handleSql(String originSql, Invocation invocation, List<DataModule> moduleList, String methodName) {
        List<DataRight> rightList = DataPermission.getRightCache();
        List<Map<String, Long>> struList = DataPermission.getStruCache();
        Object[] args = invocation.getArgs();
        MappedStatement statement = (MappedStatement)args[0];
        Object parameterObject = args[1];
        BoundSql boundSql = statement.getBoundSql(parameterObject);
        MappedStatement newStatement = this.rebuildStatement(statement, new BoundSqlSource(boundSql));
        MetaObject metaObject = MetaObject.forObject((Object)newStatement, (ObjectFactory)SystemMetaObject.DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)SystemMetaObject.DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)REFLECTORFACTORY);
        String newSql = String.format("%s%s%s%s", "select * from (", originSql, ") DS where ", this.selectMaxRightByRoleList(rightList, moduleList, struList, methodName));
        metaObject.setValue("sqlSource.boundSql.sql", (Object)newSql);
        args[0] = newStatement;
        if (args.length >= 5) {
            args[5] = newStatement.getBoundSql(parameterObject);
        }
    }

    private MappedStatement rebuildStatement(MappedStatement statement, SqlSource sqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(statement.getConfiguration(), statement.getId(), sqlSource, statement.getSqlCommandType());
        builder.resource(statement.getResource());
        builder.fetchSize(statement.getFetchSize());
        builder.statementType(statement.getStatementType());
        builder.keyGenerator(statement.getKeyGenerator());
        if (statement.getKeyProperties() != null && statement.getKeyProperties().length > 0) {
            StringBuilder keyProperties = new StringBuilder();
            for (String keyProperty : statement.getKeyProperties()) {
                keyProperties.append(keyProperty).append(",");
            }
            keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
            builder.keyProperty(keyProperties.toString());
        }
        builder.timeout(statement.getTimeout());
        builder.parameterMap(statement.getParameterMap());
        builder.resultMaps(statement.getResultMaps());
        builder.resultSetType(statement.getResultSetType());
        builder.cache(statement.getCache());
        builder.flushCacheRequired(statement.isFlushCacheRequired());
        builder.useCache(statement.isUseCache());
        return builder.build();
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
        log.info("properties\u65b9\u6cd5\uff1a{}", (Object)properties.toString());
    }

    public String selectMaxRightByRoleList(List<DataRight> rightList, List<DataModule> moduleList, List<Map<String, Long>> struList, String moduleCode) {
        SecurityUser user = BaseSecurityUtil.getUser();
        DataModule module = new DataModule();
        for (DataModule mod : moduleList) {
            if (!moduleCode.equals(mod.getModuleCode())) continue;
            module = mod;
            break;
        }
        List userRoles = user.getRolesList();
        int maxRight = 0;
        List<Long> leadershipRoles = DataPermission.getLeadershipRoles();
        CrmCommonProperties crmProperties = (CrmCommonProperties)SpringUtils.getBean(CrmCommonProperties.class);
        maxRight = "selectCrmLeadsHighSeasList".equals(moduleCode) ? (userRoles.contains(Long.valueOf(crmProperties.getRoles().getCompanyLeader())) ? 8 : (DataPermission.isLeadship(userRoles, leadershipRoles) ? 7 : (userRoles.contains(Long.valueOf(crmProperties.getRoles().getBgLeader())) || userRoles.contains(Long.valueOf(crmProperties.getRoles().getSalesGM())) || userRoles.contains(Long.valueOf(crmProperties.getRoles().getSalesDirector())) || userRoles.contains(Long.valueOf(crmProperties.getRoles().getSalesman())) ? 6 : 1))) : (userRoles.contains(Long.valueOf(crmProperties.getRoles().getCompanyLeader())) ? 8 : (DataPermission.isLeadship(userRoles, leadershipRoles) ? 7 : (userRoles.contains(Long.valueOf(crmProperties.getRoles().getBgLeader())) ? 6 : (userRoles.contains(Long.valueOf(crmProperties.getRoles().getSalesGM())) || userRoles.contains(Long.valueOf(crmProperties.getRoles().getSalesDirector())) ? 4 : (userRoles.contains(Long.valueOf(crmProperties.getRoles().getSalesman())) ? 2 : 1)))));
        if ("selectCrmCampaignList".equals(moduleCode)) {
            String screening2 = "";
            switch (maxRight) {
                case 8: {
                    screening2 = "1=1";
                    break;
                }
                case 7: {
                    screening2 = this.getScreeningStringHeadship(struList, module, user);
                    break;
                }
                default: {
                    screening2 = this.getScreeningStringBG(struList, module, user);
                }
            }
            return screening2 + " OR find_in_set('" + user.getUserId() + "',PERSON_ID)";
        }
        String screening = this.getSqlScreening(struList, module, user, maxRight);
        if ("selectCrmLeadsHighSeasList".equals(moduleCode) && !"1=2".equals(screening)) {
            if (DataPermission.isLeadship(userRoles, leadershipRoles) || userRoles.contains(Long.valueOf(crmProperties.getRoles().getBgLeader())) || userRoles.contains(Long.valueOf(crmProperties.getRoles().getSalesGM())) || userRoles.contains(Long.valueOf(crmProperties.getRoles().getSalesDirector()))) {
                screening = screening + " OR HIGH_SEAS_ID = " + CommonConstant.ABANDONED_HIGH_SEAS;
            }
            if (userRoles.contains(Long.valueOf(crmProperties.getRoles().getMarketingPoolManager()))) {
                screening = screening + " OR HIGH_SEAS_ID = " + CommonConstant.DEFAULT_HIGN_SEAS;
            }
        } else {
            screening = user.getRolesList().contains(Long.valueOf(crmProperties.getRoles().getMarketingManager())) && "selectCrmLeadsList".equals(moduleCode) ? screening + " OR find_in_set('" + user.getUserId() + "',PERSON_ID) OR CREATE_DEPARTMENT =" + user.getDeptId() : screening + " OR find_in_set('" + user.getUserId() + "',PERSON_ID)";
        }
        return screening;
    }

    private String getSqlScreening(List<Map<String, Long>> struList, DataModule module, SecurityUser user, int maxRight) {
        String screening = "";
        switch (maxRight) {
            case 1: {
                screening = this.getScreeningStringOne(module, user);
                break;
            }
            case 2: {
                screening = this.getScreeningStringOneself(module, user);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                screening = this.getScreeningStringThree(module, user);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                screening = this.getScreeningStringBG(struList, module, user);
                break;
            }
            case 7: {
                screening = this.getScreeningStringHeadship(struList, module, user);
                break;
            }
            case 8: {
                screening = "1=1";
                break;
            }
            default: {
                screening = "1=2 ";
            }
        }
        return screening;
    }

    public String getScreeningStringOne(DataModule module, SecurityUser user) {
        String screeningString = "";
        String rightField = module.getRightFieldPerson();
        screeningString = rightField + " = " + user.getUserId().toString() + " ";
        return screeningString;
    }

    public String getScreeningStringOneself(DataModule module, SecurityUser user) {
        String screeningString = "";
        String self = module.getOneself();
        screeningString = self + " = " + user.getUserId().toString() + " ";
        return screeningString;
    }

    public String getScreeningStringThree(DataModule module, SecurityUser user) {
        String screeningString = "";
        String rightField = module.getRightFieldDept();
        screeningString = rightField + " = " + user.getDeptId().toString() + " ";
        return screeningString;
    }

    public String getScreeningStringBG(List<Map<String, Long>> struList, DataModule module, SecurityUser user) {
        String screeningString = "1 = 2";
        Long parentId = DataPermission.getParentIdByDeptId(struList, user.getDeptId());
        List<String> deptIds = DataPermission.getAllDeptIdByParentId(struList, parentId);
        if (CollectionUtil.isNotEmpty(deptIds)) {
            String rightField = module.getRightFieldDept();
            screeningString = rightField + " IN(" + String.join((CharSequence)",", deptIds) + ") ";
        }
        return screeningString;
    }

    public String getScreeningStringHeadship(List<Map<String, Long>> struList, DataModule module, SecurityUser user) {
        String self = module.getOneself();
        String screeningString = self + " = " + user.getUserId().toString();
        List<String> struIds = DataPermission.getLeadershipBGList(user.getUserId());
        ArrayList<String> deptIdList = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(struIds)) {
            for (String struId : struIds) {
                List<String> deptIds = DataPermission.getAllDeptIdByParentId(struList, Long.valueOf(struId));
                deptIdList.addAll(deptIds);
            }
        }
        if (CollectionUtil.isNotEmpty(deptIdList)) {
            String rightDeptField = module.getRightFieldDept();
            screeningString = screeningString + " OR " + rightDeptField + " IN(" + String.join((CharSequence)",", deptIdList) + ") ";
        }
        return screeningString;
    }
}

