/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.contact.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeKeyword;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAdapterService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordAPIVo;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.core.api.task.service.ITaskAPIService;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.common.dto.DeptChangeBatchDto;
import com.jxdinfo.crm.core.common.vo.PersonWithDepInfo;
import com.jxdinfo.crm.core.common.vo.TransferBatchResultVo;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.contact.constant.ContactEditConstant;
import com.jxdinfo.crm.core.contact.dao.ContactMapper;
import com.jxdinfo.crm.core.contact.dto.ContactAssociativeQueryDto;
import com.jxdinfo.crm.core.contact.dto.ContactDto;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.contact.service.ContactService;
import com.jxdinfo.crm.core.contact.service.IContactAssociativeQueryService;
import com.jxdinfo.crm.core.contact.vo.ContactEntityVo;
import com.jxdinfo.crm.core.contact.vo.ContactOrganTreeVo;
import com.jxdinfo.crm.core.contactcharacter.dao.ContactCharacterMapper;
import com.jxdinfo.crm.core.contactcharacter.model.ContactCharacterEntity;
import com.jxdinfo.crm.core.contactcharacter.service.ContactCharacterService;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.basearea1.model.BaseArea1;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.basearea1.service.BaseArea1Service;
import com.jxdinfo.crm.core.customer.dao.CustomerMapper;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.model.CustomerIncludePool;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.customer.service.ICustomerIncludePoolService;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.fileinfo.dao.FileInfoMapper;
import com.jxdinfo.crm.core.fileinfo.model.FileInfo;
import com.jxdinfo.crm.core.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.core.focus.model.FocusEntity;
import com.jxdinfo.crm.core.focus.service.FocusService;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.jxdIM.dto.CrmTeamAdminInfoDto;
import com.jxdinfo.crm.core.jxdIM.service.ImGroupMemberService;
import com.jxdinfo.crm.core.opportunity.constant.OpportunityEditConstant;
import com.jxdinfo.crm.core.provincerole.dao.ProvinceRoleMapper;
import com.jxdinfo.crm.core.scene.dao.CrmSceneMapper;
import com.jxdinfo.crm.core.scene.model.CrmScene;
import com.jxdinfo.crm.core.teammeber.dao.TeamMeberMapper;
import com.jxdinfo.crm.core.teammeber.dto.TeamMeberDto;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.crm.core.utills.ReadExcel;
import com.jxdinfo.crm.core.utills.WriteExcel;
import com.jxdinfo.crm.core.utills.entity.DateConvertVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ContactServiceImpl
extends ServiceImpl<ContactMapper, ContactEntity>
implements ContactService {
    @Resource
    private ContactMapper contactMapper;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private TeamMeberMapper teamMeberMapper;
    @Resource
    private ContactCharacterService contactCharacterService;
    @Resource
    private FileInfoService fileInfoService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private BaseArea1Service area1Service;
    @Resource
    private CustomerService customerService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private ContactService contactService;
    @Resource
    private ContactCharacterMapper contactCharacterMapper;
    @Resource
    private FileInfoMapper fileInfoMapper;
    @Resource
    private FocusService focusService;
    @Resource
    private CustomerMapper customerMapper;
    @Resource
    private ITaskAPIService taskAPIService;
    @Resource
    private ProvinceRoleMapper provinceRoleMapper;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private CrmSceneMapper crmSceneMapper;
    @Resource
    private ImGroupMemberService imGroupMemberService;
    @Resource
    private IAssociativeQueryAPIService associativeQueryService;
    @Resource
    private IContactAssociativeQueryService contactAssociativeQueryService;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private ICustomerIncludePoolService customerIncludePoolService;

    @Override
    public Page<ContactEntity> selectCrmContactList(ContactDto dto) {
        if (StringUtil.isEmpty((Object)dto.getContactView())) {
            dto.setContactView("1");
        }
        SalesStatisticsDto permissionDto = this.contactOperate(dto);
        List<ContactDto> dtoList = this.getContactDtoList(dto);
        Page page = dto.getPage();
        List<ContactEntity> list = this.contactMapper.selectContactList(dtoList, page, dto.getCurrentUserId(), dto.getTimeOrder(), permissionDto);
        page.setRecords(list);
        return page;
    }

    @Override
    public List<AssociativeQueryVo> associativeQuery(ContactAssociativeQueryDto dto) {
        String keyWord = dto.getKeyword();
        String queryScreening = null;
        if (dto.getDto() != null) {
            queryScreening = dto.getDto().getContactScreening();
        }
        IContactAssociativeQueryService adapterService = this.contactAssociativeQueryService;
        AssociativeKeyword associativeKeyword = new AssociativeKeyword();
        associativeKeyword.setLabelName("\u5173\u952e\u5b57");
        associativeKeyword.setDataName("input_5Data");
        associativeKeyword.setDictTypeName("");
        associativeKeyword.setMultiOption(Boolean.valueOf(false));
        return this.associativeQueryService.associativeQuery((AssociativeQueryDto)dto, keyWord, queryScreening, (IAssociativeQueryAdapterService)adapterService, associativeKeyword);
    }

    private ContactDto contactQueryCondition(ContactDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        String contactView = dto.getContactView();
        if (ToolUtil.isNotEmpty((Object)dto.getContactScreening())) {
            dto.setContactScreening(dto.getContactScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        ArrayList<String> userIds = new ArrayList<String>();
        List<String> chargerPersonIds = dto.getChargePersonIds();
        if (CollectionUtil.isNotEmpty(chargerPersonIds)) {
            for (String userId : chargerPersonIds) {
                userIds.add(CommonUtills.translateUserId(userId));
            }
            dto.setTransChargePersonIds(userIds);
        }
        List<String> departments = dto.getOwnDepartments();
        ArrayList<String> odpIds = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(departments)) {
            for (String odpId : departments) {
                ArrayList<String> Ids;
                String odpIsTemp = CommonUtills.translateDepId(odpId);
                List<String> idsTemp = CommonUtills.selectOpportunityTissueTreeUserId(odpIsTemp, Ids = new ArrayList<String>());
                if (!CollectionUtil.isNotEmpty(idsTemp)) continue;
                odpIds.addAll(idsTemp);
            }
            dto.setTransOwnDepartmentIds(odpIds);
        }
        if ("2".equals(contactView)) {
            dto.setChargePersonId(String.valueOf(user.getId()));
        }
        dto.setDelFlag("0");
        dto.setCurrentUserId(user.getUserId());
        return dto;
    }

    private SalesStatisticsDto contactOperate(ContactDto dto) {
        String contactView;
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        if (dto != null && StringUtil.isNotEmpty((Object)(contactView = dto.getContactView())) && !"2".equals(contactView) && !"3".equals(contactView) && !"0".equals(contactView)) {
            IndexUtil.currentUserRolePermissions(permissionDto, this.crmProperties);
        }
        return permissionDto;
    }

    private List<ContactDto> getContactDtoList(ContactDto dto) {
        ArrayList<ContactDto> queryDtoList = new ArrayList<ContactDto>();
        String view = dto.getContactView();
        if (StringUtil.isNotEmpty((Object)view) && !"preview".equals(view)) {
            CrmScene crmScene;
            long contactView = Long.parseLong(view);
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CrmScene::getSceneId, (Object)contactView);
            lambdaQueryWrapper.eq(CrmScene::getModule, (Object)"contact");
            List crmSceneList = this.crmSceneMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)crmSceneList) && "0".equals((crmScene = (CrmScene)((Object)crmSceneList.get(0))).getIsSystem())) {
                try {
                    String query = crmScene.getQuery();
                    if (StringUtil.isNotBlank((CharSequence)query)) {
                        String queryValue = JSONObject.parseObject((String)query).get((Object)"queryValue").toString();
                        ContactDto queryDto = (ContactDto)JSONObject.parseObject((String)queryValue, ContactDto.class);
                        queryDto.setContactView(String.valueOf(contactView));
                        queryDtoList.add(this.contactQueryCondition(queryDto));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        queryDtoList.add(this.contactQueryCondition(dto));
        return queryDtoList;
    }

    @Override
    @Transactional
    public Long saveCrmContact(ContactEntity contactEntity) {
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        if (StringUtils.isEmpty((CharSequence)contactEntity.getOwnUnit())) {
            contactEntity.setOwnUnit(null);
        }
        if (StringUtils.isEmpty((CharSequence)contactEntity.getOrderNumber())) {
            contactEntity.setOrderNumber(null);
        }
        Long contactId = contactEntity.getContactId();
        contactEntity.setOwnDepartment(user.getDeptId());
        contactEntity.setOwnDepartmentName(user.getDeptName());
        contactEntity.setCreateDepartment(user.getDeptId());
        contactEntity.setCreateDepartmentName(user.getDeptName());
        if (ToolUtil.isEmpty((Object)contactId)) {
            contactId = Long.valueOf(CommonUtills.generateAssignId());
            contactEntity.setContactId(contactId);
            contactEntity.setDelFlag("0");
            contactEntity.setMobilePhone(contactEntity.getMobilePhone().replace(" ", ""));
            contactEntity.setTelephone(contactEntity.getTelephone().replace(" ", ""));
            contactEntity.setCreatePerson(user.getUserId());
            contactEntity.setCreatePersonName(user.getUserName());
            contactEntity.setCreateTime(date);
            contactEntity.setChargePersonId(user.getUserId());
            contactEntity.setChargePersonName(user.getUserName());
            contactEntity.setOwnDepartment(user.getDeptId());
            contactEntity.setOwnDepartmentName(user.getDeptName());
        }
        contactEntity.setChangePerson(user.getUserId());
        contactEntity.setChangePersonName(user.getUserName());
        contactEntity.setChangeTime(date);
        this.saveOrUpdate(contactEntity);
        this.operateRecordAPIService.saveOperateLog(null, CrmBusinessTypeEnum.CONTACT, contactId, contactEntity.getContactName(), date, false, Arrays.asList(contactId, contactEntity.getCustomerId()));
        this.teamMeberService.insertTeamMember(contactEntity.getChargePersonName(), contactEntity.getChargePersonId(), contactId, "1", "1", date, "3");
        return contactId;
    }

    @Override
    @Transactional
    public boolean deleteCrmContactByContactIds(List<String> contactIds) {
        Long conCount = this.contactCharacterService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ContactCharacterEntity::getContactId, contactIds)).eq(ContactCharacterEntity::getDelFlag, (Object)"0"));
        Long recCount = this.trackRecordAPIService.countContact(contactIds, "0");
        if (conCount > 0L || recCount > 0L) {
            throw new BaseException("\u5df2\u4ea7\u751f\u4e1a\u52a1\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        Long changeCount = this.trackRecordAPIService.countConvertContact(contactIds, "0");
        if (changeCount > 0L) {
            throw new BaseException("\u8f6c\u6362\u751f\u6210\u7684\u8054\u7cfb\u4eba\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.contactMapper.deleteCrmContactByContactIds(contactIds, "1");
        this.teamMeberMapper.updateDelFlagByIds(null, "1", contactIds);
        List trackRecordList = this.trackRecordAPIService.list(contactIds, null, Collections.singletonList(RecordProductTypeEnum.PRODUCE_SYSTEM.getId()), "0");
        List<Object> recordIds = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)trackRecordList)) {
            recordIds = trackRecordList.stream().map(TrackRecordAPIVo::getRecordId).collect(Collectors.toList());
        }
        this.trackRecordAPIService.deleteBatchByIds(contactIds, CrmBusinessTypeEnum.CONTACT.getId(), "1");
        List<Long> lids = contactIds.stream().map(Long::parseLong).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(recordIds)) {
            lids.addAll(recordIds);
        }
        this.fileInfoMapper.deleteFileInfoByIds(null, lids, "1");
        return true;
    }

    @Override
    public String contactExport(HttpServletResponse response, ContactDto dto) {
        SalesStatisticsDto permissionDto = this.contactOperate(dto);
        Page page = dto.getPage();
        String contactView = dto.getContactView();
        DateConvertVo dateConvertVo = null;
        if ("1".equals(contactView)) {
            dateConvertVo = CommonUtills.getWeekDate();
        }
        if ("2".equals(contactView)) {
            dateConvertVo = CommonUtills.getMonthDay();
        }
        if ("4".equals(contactView)) {
            dateConvertVo = CommonUtills.getYearDay();
        }
        if (dateConvertVo != null) {
            dto.setStartDate(dateConvertVo.getStartDate());
            dto.setEndDate(dateConvertVo.getEndDate());
        }
        if ("2".equals(contactView)) {
            dto.setChargePersonId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        dto.setDelFlag("0");
        ArrayList<ContactDto> dtoList = new ArrayList<ContactDto>();
        dtoList.add(dto);
        List<ContactEntity> list = this.contactMapper.selectContactList(dtoList, null, dto.getCurrentUserId(), dto.getTimeOrder(), permissionDto);
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, list, "\u8054\u7cfb\u4eba", ContactEntity.class);
        return "\u5bfc\u51fa\u6210\u529f";
    }

    @Override
    public String contactExportTemplate(HttpServletResponse response) {
        ArrayList list = new ArrayList();
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, list, "\u8054\u7cfb\u4eba\u6a21\u677f", ContactEntity.class);
        return "\u5bfc\u51fa\u6a21\u677f\u6210\u529f";
    }

    @Override
    @Transactional
    public String contactImport(MultipartFile file) {
        int flag = 0;
        ReadExcel readExcel = new ReadExcel();
        LocalDateTime date = LocalDateTime.now();
        try {
            List<ContactEntity> list = ReadExcel.readExcel(file, ContactEntity.class);
            for (ContactEntity contact : list) {
                SecurityUser user = BaseSecurityUtil.getUser();
                contact.setContactId(Long.valueOf(CommonUtills.generateAssignId()));
                contact.setCreatePerson(user.getUserId());
                contact.setCreatePersonName(user.getUserName());
                contact.setCreateTime(date);
                contact.setChangePerson(user.getUserId());
                contact.setChangePersonName(user.getUserName());
                contact.setChangeTime(date);
                contact.setDelFlag("0");
                int i = this.contactMapper.insertCrmContact(contact);
                if (i <= 0) continue;
                ++flag;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "\u5bfc\u5165\u5931\u8d25";
        }
        return "\u5171\u5bfc\u5165" + flag + "\u6761\u6570\u636e";
    }

    @Override
    public List<ContactEntity> selectCrmContactCustomer(ContactDto dto) {
        dto.setDelFlag("0");
        List<ContactEntity> list = this.contactMapper.selectCrmContactCustomerPage(dto, null);
        if (CollectionUtil.isNotEmpty(list)) {
            for (ContactEntity contactEntity : list) {
                String telephone = contactEntity.getMobilePhone();
                if (!StringUtil.isNotEmpty((Object)telephone)) continue;
                contactEntity.setMobilePhone(StringUtils.overlay((String)telephone, (String)"****", (int)3, (int)7));
            }
        }
        return list;
    }

    @Override
    public List<ContactEntity> selectCrmContactCustomerExcludingOneself(ContactDto dto) {
        ArrayList<ContactEntity> resultList = new ArrayList<ContactEntity>();
        List list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactEntity::getCustomerId, (Object)dto.getCustomerId())).eq(ContactEntity::getDelFlag, (Object)"0")).ne(ContactEntity::getContactId, ToolUtil.isNotEmpty((Object)dto.getContactId()) ? dto.getContactId() : ""));
        if (ToolUtil.isNotEmpty((Object)dto.getContactId())) {
            ContactEntity contactEntity = (ContactEntity)this.contactService.getById(dto.getContactId());
            for (ContactEntity contact : list) {
                if ((ToolUtil.isNotEmpty((Object)contact.getDirectSuperior()) ? contact.getDirectSuperior() : "").equals(contactEntity.getContactId().toString())) continue;
                resultList.add(contact);
            }
        } else {
            resultList.addAll(list);
        }
        return resultList;
    }

    @Override
    public List<ContactEntity> selectCrmContactCustomerAll(ContactDto dto) {
        Long customerId = dto.getCustomerId();
        List<ContactEntity> list = this.contactMapper.selectCrmContactCustomer(customerId, "0");
        return list;
    }

    @Override
    public Page<ContactEntity> selectCrmContactCustomerPage(ContactDto dto) {
        Page page = dto.getPage();
        dto.setDelFlag("0");
        List<ContactEntity> list = this.contactMapper.selectCrmContactCustomerPage(dto, page);
        if (CollectionUtil.isNotEmpty(list)) {
            for (ContactEntity contactEntity : list) {
                String telephone = contactEntity.getMobilePhone();
                if (!StringUtil.isNotEmpty((Object)telephone)) continue;
                contactEntity.setMobilePhone(StringUtils.overlay((String)telephone, (String)"****", (int)3, (int)7));
            }
        }
        page.setRecords(list);
        return page;
    }

    @Override
    public Page<ContactEntity> selectCrmContactOpportunity(ContactDto dto) {
        Page page = dto.getPage();
        dto.setDelFlag("0");
        List<ContactEntity> list = this.contactMapper.selectCrmContactOpportunity(dto, page);
        page.setRecords(list);
        return page;
    }

    @Override
    public Integer selectRepeatNumber(ContactDto dto) {
        int i = this.contactMapper.selectRepeatNumber(dto);
        return i;
    }

    @Override
    public ContactEntityVo getContactDetailById(Long contactId) {
        List areaLabelList;
        if (CommonConstant.noPermission.equals(this.isOperate(contactId))) {
            return null;
        }
        ContactEntity entity = (ContactEntity)this.getById(contactId);
        if (entity == null || "1".equals(entity.getDelFlag())) {
            return null;
        }
        ContactEntityVo entityVo = (ContactEntityVo)BeanUtil.copy((Object)entity, ContactEntityVo.class);
        assert (entityVo != null);
        if (entityVo.getCustomerId() != null) {
            CustomerIncludePool customerEntity = (CustomerIncludePool)this.customerIncludePoolService.getById(entityVo.getCustomerId());
            entityVo.setCustomerName(customerEntity.getCustomerName());
            entityVo.setCustomerReferredName(customerEntity.getCustomerReferredName());
        }
        if (StringUtil.isNotBlank((CharSequence)entityVo.getSex())) {
            entityVo.setSex(this.sysDicRefService.getDictLabel("sex", entityVo.getSex()));
        }
        ArrayList<String> areaList = new ArrayList<String>();
        if (StringUtil.isNotBlank((CharSequence)entityVo.getProvince())) {
            areaList.add(entityVo.getProvince());
        }
        if (StringUtil.isNotBlank((CharSequence)entityVo.getCity())) {
            areaList.add(entityVo.getCity());
        }
        if (StringUtil.isNotBlank((CharSequence)entityVo.getCounty())) {
            areaList.add(entityVo.getCounty());
        }
        if (areaList.size() > 0 && (areaLabelList = this.area1Service.list((Wrapper)new LambdaQueryWrapper().in(BaseArea1::getBaseAreaid, areaList))) != null) {
            for (BaseArea1 area : areaLabelList) {
                if (StringUtil.isNotBlank((CharSequence)entityVo.getProvince()) && String.valueOf(area.getBaseAreaid()).equals(entityVo.getProvince())) {
                    entityVo.setProvince(area.getName());
                }
                if (StringUtil.isNotBlank((CharSequence)entityVo.getCity())) {
                    entityVo.setCity(area.getName());
                }
                if (!StringUtil.isNotBlank((CharSequence)entityVo.getCounty())) continue;
                entityVo.setCounty(area.getName());
            }
        }
        entityVo.setOpportunityCount(this.contactCharacterService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactCharacterEntity::getContactId, (Object)entityVo.getContactId())).ne(ContactCharacterEntity::getDelFlag, (Object)"1")));
        ArrayList<Long> businessIds = new ArrayList<Long>();
        businessIds.add(entityVo.getContactId());
        List fileRecordIds = this.trackRecordAPIService.selectRelationRecordIds(contactId);
        if (CollectionUtil.isNotEmpty((Collection)fileRecordIds)) {
            businessIds.addAll(fileRecordIds);
        }
        entityVo.setFileCount(this.fileInfoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(FileInfo::getBusinessId, businessIds)).ne(FileInfo::getDelFlag, (Object)"1")));
        entityVo.setMemberCount(this.teamMeberService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)entityVo.getContactId())).eq(TeamMeberEntity::getBusinessType, (Object)"3")).ne(TeamMeberEntity::getDelFlag, (Object)"1")));
        SecurityUser user = BaseSecurityUtil.getUser();
        long focusCount = this.focusService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FocusEntity::getBusinessId, (Object)entityVo.getContactId())).eq(FocusEntity::getBusinessType, (Object)Character.valueOf('3'))).eq(FocusEntity::getCreatePersion, (Object)user.getUserId()));
        entityVo.setFocus(focusCount > 0L);
        entityVo.setTaskAmount(this.taskAPIService.selectTaskCount("3", contactId));
        return entityVo;
    }

    @Override
    public Integer isOperate(Long contactId) {
        Object parentId;
        List<String> deptIds;
        List<Map<String, Long>> struList;
        if (contactId == null) {
            return CommonConstant.noPermission;
        }
        ContactEntity contactEntity = (ContactEntity)this.getById(contactId);
        if (contactEntity == null || "1".equals(contactEntity.getDelFlag())) {
            return CommonConstant.noPermission;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List userRoles = user.getRolesList();
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getCompanyLeader()))) {
            return CommonConstant.companyLeader;
        }
        List<Long> leadershipRoles = DataPermission.getLeadershipRoles();
        if (DataPermission.isLeadship(userRoles, leadershipRoles)) {
            struList = DataPermission.getStruCache();
            List<String> struIds = DataPermission.getLeadershipBGList(user.getUserId());
            ArrayList<String> deptIdList = new ArrayList<String>();
            if (CollectionUtil.isNotEmpty(struIds)) {
                for (String struId : struIds) {
                    List<String> deptIds2 = DataPermission.getAllDeptIdByParentId(struList, Long.valueOf(struId));
                    deptIdList.addAll(deptIds2);
                }
            }
            if (CollectionUtil.isNotEmpty(deptIdList) && deptIdList.contains(contactEntity.getOwnDepartment() == null ? "" : contactEntity.getOwnDepartment().toString())) {
                return CommonConstant.leadership;
            }
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getBgLeader())) && CollectionUtil.isNotEmpty(deptIds = DataPermission.getAllDeptIdByParentId(struList = DataPermission.getStruCache(), (Long)(parentId = DataPermission.getParentIdByDeptId(struList, user.getDeptId())))) && deptIds.contains(contactEntity.getOwnDepartment() == null ? "" : contactEntity.getOwnDepartment().toString())) {
            return CommonConstant.bgLeader;
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesGM())) && user.getDeptId().toString().equals(contactEntity.getOwnDepartment() == null ? "" : contactEntity.getOwnDepartment().toString())) {
            return CommonConstant.salesGM;
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesDirector())) && user.getDeptId().toString().equals(contactEntity.getOwnDepartment() == null ? "" : contactEntity.getOwnDepartment().toString())) {
            return CommonConstant.salesDirector;
        }
        if (user.getUserId().toString().equals(contactEntity.getChargePersonId() == null ? "" : contactEntity.getChargePersonId().toString())) {
            return CommonConstant.salesman;
        }
        List teamList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)contactEntity.getContactId())).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"3"));
        if (CollectionUtil.isNotEmpty((Collection)teamList)) {
            for (TeamMeberEntity teamMeberEntity : teamList) {
                if (!"1".equals(teamMeberEntity.getModifyPower())) continue;
                return CommonConstant.otherRole;
            }
            return CommonConstant.readOnly;
        }
        Integer count = this.customerMapper.getProductManagerByCustomerId(contactEntity.getCustomerId(), "0", user.getUserId());
        if (count > 0) {
            return CommonConstant.readOnly;
        }
        return CommonConstant.noPermission;
    }

    @Override
    public List<ContactEntity> selectContactRepeatList(ContactDto dto) {
        if (ToolUtil.isEmpty((Object)dto.getCustomerName()) || ToolUtil.isEmpty((Object)dto.getMobilePhone())) {
            return null;
        }
        List list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactEntity::getCustomerName, (Object)dto.getCustomerName())).eq(ContactEntity::getMobilePhone, (Object)dto.getMobilePhone())).eq(ContactEntity::getDelFlag, (Object)"0"));
        return list;
    }

    @Override
    public String contactCheckRepeat(ContactDto dto) {
        if (ToolUtil.isEmpty((Object)dto.getCustomerId()) || ToolUtil.isEmpty((Object)dto.getMobilePhone())) {
            return "0";
        }
        long companyCount = 0L;
        if (ToolUtil.isEmpty((Object)dto.getContactId())) {
            companyCount = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactEntity::getCustomerId, (Object)dto.getCustomerId())).eq(ContactEntity::getMobilePhone, (Object)dto.getMobilePhone())).eq(ContactEntity::getDelFlag, (Object)"0"));
        } else {
            ContactEntity contactEntity = (ContactEntity)this.getById(dto.getContactId());
            if (!dto.getMobilePhone().equals(contactEntity.getMobilePhone())) {
                companyCount = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactEntity::getCustomerId, (Object)dto.getCustomerId())).eq(ContactEntity::getMobilePhone, (Object)dto.getMobilePhone())).eq(ContactEntity::getDelFlag, (Object)"0")).ne(ContactEntity::getContactId, (Object)dto.getContactId()));
            }
        }
        if (companyCount > 0L) {
            return "1";
        }
        return "0";
    }

    @Override
    public List<ContactEntity> selectRepeatContactList(ContactDto contactDto) {
        if (ToolUtil.isEmpty((Object)contactDto.getCustomerId())) {
            throw new BaseException("\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5408\u5e76\u7684\u5ba2\u6237");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        SalesStatisticsDto dto = new SalesStatisticsDto();
        IndexUtil.currentUserRolePermissions(dto, this.crmProperties);
        contactDto.setDelFlag("0");
        List<ContactEntity> contactEntityList = this.contactMapper.selectRepeatContactList(contactDto);
        if (CollectionUtil.isEmpty(dto.getPermissionDeptIds())) {
            dto.setPermissionDeptIds(Collections.EMPTY_LIST);
        }
        if (CollectionUtil.isEmpty(contactEntityList)) {
            return null;
        }
        for (ContactEntity contact : contactEntityList) {
            Long parentId;
            List teamMemberList = this.teamMeberService.listObjs((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{TeamMeberEntity::getPersonId}).eq(TeamMeberEntity::getBusinessId, (Object)contact.getContactId())).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getBusinessType, (Object)"3"), s -> Long.parseLong(s.toString()));
            if (contact.getChargePersonId().equals(user.getUserId())) {
                contact.setRepeat("1");
                continue;
            }
            if (dto.getPermissionDeptIds().contains(contact.getOwnDepartment())) {
                contact.setRepeat("2");
                continue;
            }
            if (teamMemberList.size() > 0 && teamMemberList.contains(user.getUserId())) {
                contact.setRepeat("2");
                continue;
            }
            List<Map<String, Long>> struList = DataPermission.getStruCache();
            List<String> deptIds = DataPermission.getAllDeptIdByParentId(struList, parentId = DataPermission.getParentIdByDeptId(struList, user.getDeptId()));
            List deptLongIds = deptIds.stream().map(Long::valueOf).collect(Collectors.toList());
            if (deptLongIds.contains(contact.getOwnDepartment())) {
                contact.setRepeat("3");
                continue;
            }
            contact.setRepeat("4");
        }
        return contactEntityList;
    }

    @Override
    @Transactional
    public TransferBatchResultVo contactTransferBatch(List<ContactDto> dtos) {
        Object teamMeberEntity;
        ArrayList<TeamMeberEntity> teamMeberEntityList;
        ArrayList<String> msgList;
        TransferBatchResultVo resultVo = new TransferBatchResultVo();
        int dtoSize = dtos.size();
        int noPermissionNum = 0;
        int alreadyChargePersonNum = 0;
        ArrayList<CrmTeamAdminInfoDto> crmTeamAdminInfoDtoList = new ArrayList<CrmTeamAdminInfoDto>();
        String keepFlag = dtos.get(0).getKeepFlag();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = user.getId().toString();
        String userName = user.getUserName();
        String newChargePersonId = CommonUtills.translateUserId(dtos.get(0).getNewChargePersonId());
        PersonWithDepInfo mapDepartment = CommonUtills.selectDepIdName(newChargePersonId);
        String newOwnDepartment = mapDepartment.getDepartmentId().toString();
        String newOwnDepartmentName = mapDepartment.getDepartmentName();
        String newChargePersonName = dtos.get(0).getNewChargePersonName();
        List<Long> contactIdList = dtos.stream().map(ContactDto::getContactId).collect(Collectors.toList());
        List contactEntityList = this.listByIds(contactIdList);
        for (ContactDto dto : dtos) {
            for (ContactEntity contactEntity : contactEntityList) {
                if (!contactEntity.getContactId().equals(dto.getContactId())) continue;
                dto.setCustomerId(contactEntity.getCustomerId());
                dto.setCustomerName(contactEntity.getCustomerName());
                dto.setContactName(contactEntity.getContactName());
            }
        }
        ArrayList<Long> excludeContactIdList = new ArrayList<Long>();
        List<Integer> operateFlagList = this.contactService.isOperateBatch(contactIdList);
        for (int i = 0; i < operateFlagList.size(); ++i) {
            if (operateFlagList.get(i) >= 0) continue;
            excludeContactIdList.add(contactIdList.get(i));
            ++noPermissionNum;
        }
        for (Long excludeContactId : excludeContactIdList) {
            dtos = dtos.stream().filter(contact -> !contact.getContactId().equals(excludeContactId)).collect(Collectors.toList());
        }
        contactIdList = dtos.stream().map(ContactDto::getContactId).collect(Collectors.toList());
        contactEntityList = ToolUtil.isNotEmpty(contactIdList) ? this.listByIds(contactIdList) : new ArrayList();
        ArrayList<ContactDto> dtoList = new ArrayList<ContactDto>();
        ArrayList<TeamMeberDto> teamMeberDtoList = new ArrayList<TeamMeberDto>();
        for (ContactDto dto : dtos) {
            ContactEntity contactEntity = contactEntityList.stream().filter(object -> Objects.equals(object.getContactId(), dto.getContactId())).findFirst().get();
            String oldChargePersonName = dto.getOldChargePersonName();
            String string = dto.getOldChargePersonId();
            if (newChargePersonId.equals(string) && newChargePersonName.equals(oldChargePersonName)) {
                ++alreadyChargePersonNum;
                continue;
            }
            String string2 = contactEntity.getContactName();
            Long contactId = dto.getContactId();
            dto.setChangeTime(date);
            dto.setChangePerson(userId);
            dto.setChangePersonName(userName);
            dto.setNewChargePersonId(newChargePersonId);
            dto.setNewChargePersonName(newChargePersonName);
            dto.setOwnDepartment(newOwnDepartment);
            dto.setOwnDepartmentName(newOwnDepartmentName);
            dto.setContactId(contactId);
            dtoList.add(dto);
            TeamMeberDto teamMeberDto = new TeamMeberDto();
            teamMeberDto.setBusinessId(contactId);
            teamMeberDto.setPersonId(Long.parseLong(newChargePersonId));
            teamMeberDto.setDelFlag("0");
            teamMeberDtoList.add(teamMeberDto);
        }
        if (dtoList.size() + alreadyChargePersonNum == dtoSize) {
            resultVo.setTransferResult(true);
            msgList = new ArrayList<String>();
            msgList.add("\u8f6c\u79fb\u6210\u529f");
            resultVo.setMsgList(msgList);
        } else {
            resultVo.setTransferResult(false);
            msgList = new ArrayList();
            if (dtoSize == 1) {
                if (noPermissionNum != 0) {
                    msgList.add("\u8f6c\u79fb\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a\u65e0\u6743\u9650");
                }
                resultVo.setMsgList(msgList);
            } else {
                Object msg = String.format("\u8f6c\u79fb\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761\u3002\u5931\u8d25\u539f\u56e0\uff1a", dtoList.size() + alreadyChargePersonNum, dtoSize - dtoList.size() - alreadyChargePersonNum);
                if (noPermissionNum != 0) {
                    msg = msg + "\u65e0\u6743\u9650";
                }
                msgList.add((String)msg);
                resultVo.setMsgList(msgList);
            }
        }
        if (dtoList.isEmpty()) {
            return resultVo;
        }
        this.contactMapper.updateChargePersonBatch(dtoList);
        if ("0".equals(keepFlag)) {
            teamMeberEntityList = new ArrayList<TeamMeberEntity>();
            for (ContactDto dto : dtoList) {
                teamMeberEntity = new TeamMeberEntity();
                ((TeamMeberEntity)((Object)teamMeberEntity)).setBusinessId(dto.getContactId());
                ((TeamMeberEntity)((Object)teamMeberEntity)).setDelFlag("1");
                ((TeamMeberEntity)((Object)teamMeberEntity)).setPersonId(Long.valueOf(dto.getOldChargePersonId()));
                teamMeberEntityList.add((TeamMeberEntity)((Object)teamMeberEntity));
            }
            this.teamMeberMapper.deleteChargePersonBatch(teamMeberEntityList);
        } else if ("1".equals(keepFlag)) {
            teamMeberEntityList = new ArrayList();
            for (ContactDto dto : dtoList) {
                teamMeberEntity = new TeamMeberEntity();
                ((TeamMeberEntity)((Object)teamMeberEntity)).setBusinessId(dto.getContactId());
                ((TeamMeberEntity)((Object)teamMeberEntity)).setPersonId(Long.valueOf(dto.getOldChargePersonId()));
                ((TeamMeberEntity)((Object)teamMeberEntity)).setIsCharge("0");
                ((TeamMeberEntity)((Object)teamMeberEntity)).setMemberRole("6");
                ((TeamMeberEntity)((Object)teamMeberEntity)).setModifyPower(null);
                teamMeberEntityList.add((TeamMeberEntity)((Object)teamMeberEntity));
            }
            this.teamMeberMapper.updateIsChargeBatch(teamMeberEntityList);
        }
        List<Map<String, Object>> existTeamMemberList = this.teamMeberMapper.selectTeamMeberListBatch(teamMeberDtoList);
        ArrayList<ContactDto> insertMemberDtoList = new ArrayList<ContactDto>();
        ArrayList<ContactDto> updateChargeDtoList = new ArrayList<ContactDto>();
        for (ContactDto contactDto : dtoList) {
            boolean bl = true;
            for (Map map : existTeamMemberList) {
                if (!map.get("BUSINESS_ID").equals(contactDto.getContactId())) continue;
                updateChargeDtoList.add(contactDto);
                bl = false;
                break;
            }
            if (!bl) continue;
            insertMemberDtoList.add(contactDto);
        }
        if (ToolUtil.isNotEmpty(updateChargeDtoList)) {
            ArrayList<TeamMeberEntity> teamMeberEntityList2 = new ArrayList<TeamMeberEntity>();
            for (ContactDto contactDto : updateChargeDtoList) {
                TeamMeberEntity teamMeberEntity2 = new TeamMeberEntity();
                teamMeberEntity2.setBusinessId(contactDto.getContactId());
                teamMeberEntity2.setPersonId(Long.valueOf(newChargePersonId));
                teamMeberEntity2.setIsCharge("1");
                teamMeberEntity2.setMemberRole(null);
                teamMeberEntity2.setModifyPower("1");
                teamMeberEntityList2.add(teamMeberEntity2);
            }
            this.teamMeberMapper.updateIsChargeBatch(teamMeberEntityList2);
        }
        if (ToolUtil.isNotEmpty(insertMemberDtoList)) {
            this.teamMeberService.insertTeamMemberBatch(newChargePersonName, Long.parseLong(newChargePersonId), insertMemberDtoList.stream().map(ContactDto::getContactId).collect(Collectors.toList()), "1", "1", ((ContactDto)insertMemberDtoList.get(0)).getChangeTime(), "3");
        }
        ArrayList<Long> longOldChargePersonIdList = new ArrayList<Long>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ContactDto dto : dtoList) {
            longOldChargePersonIdList.add(Long.parseLong(dto.getOldChargePersonId()));
            arrayList.add(dto.getOldChargePersonName());
        }
        this.addTrackRecordBatch(dtoList, longOldChargePersonIdList, arrayList, newChargePersonId, newChargePersonName);
        for (ContactDto dto : dtoList) {
            String string = dto.getCustomerName();
            String contactName = dto.getContactName();
            Long contactId = dto.getContactId();
            String oldChargePersonId = dto.getOldChargePersonId();
            String title = user.getUserName() + "\u5c06\u8054\u7cfb\u4eba\u8d1f\u8d23\u4eba\u8f6c\u79fb\u7ed9\u60a8";
            String content = "\u8054\u7cfb\u4eba\u540d\u79f0\u3010" + contactName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
            EimPushUtil.pushJqxArticleMessage(title, content, "/crm/lxr/lxrxq", dto.getContactId().toString(), Arrays.asList(dto.getNewChargePersonId()));
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/contactDetails?row=" + "\"" + dto.getContactId() + "\"";
            String contentUnify = "\u3010\u8f6c\u79fb\u63d0\u9192\u3011" + userName + " \u5c06\u8054\u7cfb\u4eba\u8d1f\u8d23\u4eba\u8f6c\u79fb\u7ed9\u60a8\uff0c\u8054\u7cfb\u4eba\u540d\u79f0\u3010" + contactName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
            UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, dto.getNewChargePersonId(), user.getUserName(), unifyWebUrl, "");
            UnifyUtil.sendMessage(addSysMessageType);
            String oldTitle = userName + "\u8f6c\u79fb\u4e86\u60a8\u8d1f\u8d23\u7684\u8054\u7cfb\u4eba";
            String oldContent = "\u8054\u7cfb\u4eba\u540d\u79f0\u3010" + contactName + "\u3011\uff0c\u8f6c\u79fb\u7ed9" + newOwnDepartmentName + "-" + newChargePersonName + "\uff0c\u8bf7\u77e5\u6089\u3002";
            EimPushUtil.pushJqxArticleMessage(oldTitle, oldContent, "/crm/lxr/lxrxq", contactId.toString(), Arrays.asList(oldChargePersonId));
            AddSysMessageType oldAddSysMessageType = new AddSysMessageType();
            String oldContentUnify = "\u3010\u8f6c\u79fb\u63d0\u9192\u3011" + userName + "\u5c06\u60a8\u8d1f\u8d23\u7684\u8054\u7cfb\u4eba\u3010" + contactName + "\u3011\u8f6c\u79fb\u7ed9" + newOwnDepartmentName + "-" + newChargePersonName + "\uff0c\u8bf7\u77e5\u6089\u3002";
            UnifyUtil.defaultMessage(oldAddSysMessageType, oldContentUnify, date, user, oldChargePersonId, user.getUserName(), unifyWebUrl, "");
            UnifyUtil.sendMessage(oldAddSysMessageType);
            CrmTeamAdminInfoDto crmTeamAdminInfoDto = new CrmTeamAdminInfoDto();
            crmTeamAdminInfoDto.setBusinessType("3");
            crmTeamAdminInfoDto.setBusinessId(contactId);
            crmTeamAdminInfoDto.setNewChargePersonId(newChargePersonId);
            crmTeamAdminInfoDto.setOldChargePersonId(oldChargePersonId);
            crmTeamAdminInfoDto.setKeepFlag(dto.getKeepFlag());
            crmTeamAdminInfoDtoList.add(crmTeamAdminInfoDto);
        }
        this.imGroupMemberService.transferAdmin(crmTeamAdminInfoDtoList);
        return resultVo;
    }

    @Override
    public List<Integer> isOperateBatch(List<Long> contactIdList) {
        List<Map<String, Long>> struList;
        int i;
        ArrayList<Integer> permissionFlagList = new ArrayList<Integer>();
        List contactEntityList = this.listByIds(contactIdList);
        for (Long contactId : contactIdList) {
            boolean flag = false;
            for (ContactEntity contactEntity : contactEntityList) {
                if (!contactId.equals(contactEntity.getContactId())) continue;
                flag = true;
                break;
            }
            if (flag) {
                permissionFlagList.add(CommonConstant.unconfirmedPermission);
                continue;
            }
            permissionFlagList.add(CommonConstant.noPermission);
        }
        block2: for (ContactEntity contactEntity : contactEntityList) {
            if (!"1".equals(contactEntity.getDelFlag())) continue;
            for (i = 0; i < contactIdList.size(); ++i) {
                if (!contactEntity.getContactId().equals(contactIdList.get(i)) || !((Integer)permissionFlagList.get(i)).equals(CommonConstant.unconfirmedPermission)) continue;
                permissionFlagList.set(i, CommonConstant.noPermission);
                continue block2;
            }
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List userRoles = user.getRolesList();
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getCompanyLeader()))) {
            for (i = 0; i < permissionFlagList.size(); ++i) {
                if (!CommonConstant.unconfirmedPermission.equals(permissionFlagList.get(i))) continue;
                permissionFlagList.set(i, CommonConstant.companyLeader);
            }
        }
        List<Long> leadershipRoles = DataPermission.getLeadershipRoles();
        block5: for (ContactEntity contactEntity : contactEntityList) {
            if (!DataPermission.isLeadship(userRoles, leadershipRoles)) continue;
            struList = DataPermission.getStruCache();
            List<String> struIds = DataPermission.getLeadershipBGList(user.getUserId());
            ArrayList<String> deptIdList = new ArrayList<String>();
            if (CollectionUtil.isNotEmpty(struIds)) {
                for (String struId : struIds) {
                    List<String> deptIds = DataPermission.getAllDeptIdByParentId(struList, Long.valueOf(struId));
                    deptIdList.addAll(deptIds);
                }
            }
            if (!CollectionUtil.isNotEmpty(deptIdList) || !deptIdList.contains(contactEntity.getOwnDepartment() == null ? "" : contactEntity.getOwnDepartment().toString())) continue;
            for (int i2 = 0; i2 < contactIdList.size(); ++i2) {
                if (!contactEntity.getContactId().equals(contactIdList.get(i2)) || !((Integer)permissionFlagList.get(i2)).equals(CommonConstant.unconfirmedPermission)) continue;
                permissionFlagList.set(i2, CommonConstant.leadership);
                continue block5;
            }
        }
        block8: for (ContactEntity contactEntity : contactEntityList) {
            Long parentId;
            List<String> deptIds;
            if (!userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getBgLeader())) || !CollectionUtil.isNotEmpty(deptIds = DataPermission.getAllDeptIdByParentId(struList = DataPermission.getStruCache(), parentId = DataPermission.getParentIdByDeptId(struList, user.getDeptId()))) || !deptIds.contains(contactEntity.getOwnDepartment() == null ? "" : contactEntity.getOwnDepartment().toString())) continue;
            for (int i3 = 0; i3 < contactIdList.size(); ++i3) {
                if (!contactEntity.getContactId().equals(contactIdList.get(i3)) || !((Integer)permissionFlagList.get(i3)).equals(CommonConstant.unconfirmedPermission)) continue;
                permissionFlagList.set(i3, CommonConstant.bgLeader);
                continue block8;
            }
        }
        block10: for (ContactEntity contactEntity : contactEntityList) {
            if (!userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesGM())) || !user.getDeptId().toString().equals(contactEntity.getOwnDepartment() == null ? "" : contactEntity.getOwnDepartment().toString())) continue;
            for (int i4 = 0; i4 < contactIdList.size(); ++i4) {
                if (!contactEntity.getContactId().equals(contactIdList.get(i4)) || !((Integer)permissionFlagList.get(i4)).equals(CommonConstant.unconfirmedPermission)) continue;
                permissionFlagList.set(i4, CommonConstant.salesGM);
                continue block10;
            }
        }
        block12: for (ContactEntity contactEntity : contactEntityList) {
            if (!userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesDirector())) || !user.getDeptId().toString().equals(contactEntity.getOwnDepartment() == null ? "" : contactEntity.getOwnDepartment().toString())) continue;
            for (int i5 = 0; i5 < contactIdList.size(); ++i5) {
                if (!contactEntity.getContactId().equals(contactIdList.get(i5)) || !((Integer)permissionFlagList.get(i5)).equals(CommonConstant.unconfirmedPermission)) continue;
                permissionFlagList.set(i5, CommonConstant.salesDirector);
                continue block12;
            }
        }
        block14: for (ContactEntity contactEntity : contactEntityList) {
            if (!user.getUserId().toString().equals(contactEntity.getChargePersonId() == null ? "" : contactEntity.getChargePersonId().toString())) continue;
            for (int i6 = 0; i6 < contactIdList.size(); ++i6) {
                if (!contactEntity.getContactId().equals(contactIdList.get(i6)) || !((Integer)permissionFlagList.get(i6)).equals(CommonConstant.unconfirmedPermission)) continue;
                permissionFlagList.set(i6, CommonConstant.salesman);
                continue block14;
            }
        }
        block16: for (ContactEntity contactEntity : contactEntityList) {
            List teamList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)contactEntity.getContactId())).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"3"));
            if (!CollectionUtil.isNotEmpty((Collection)teamList)) continue;
            boolean flag = false;
            block17: for (TeamMeberEntity teamMeberEntity : teamList) {
                if (!"1".equals(teamMeberEntity.getModifyPower())) continue;
                for (int i7 = 0; i7 < contactIdList.size(); ++i7) {
                    if (!contactEntity.getContactId().equals(contactIdList.get(i7)) || !((Integer)permissionFlagList.get(i7)).equals(CommonConstant.unconfirmedPermission)) continue;
                    permissionFlagList.set(i7, CommonConstant.otherRole);
                    flag = true;
                    continue block17;
                }
            }
            if (flag) continue;
            for (int i8 = 0; i8 < contactIdList.size(); ++i8) {
                if (!contactEntity.getContactId().equals(contactIdList.get(i8)) || !((Integer)permissionFlagList.get(i8)).equals(CommonConstant.unconfirmedPermission)) continue;
                permissionFlagList.set(i8, CommonConstant.readOnly);
                continue block16;
            }
        }
        List<Long> customerIdList = contactEntityList.stream().map(ContactEntity::getCustomerId).collect(Collectors.toList());
        List<Map<String, Long>> isManagerList = this.customerMapper.getProductManagerByCustomerIdBatch(customerIdList, "0", user.getUserId());
        for (ContactEntity contactEntity : contactEntityList) {
            block21: for (Map<String, Long> stringLongMap : isManagerList) {
                if (!stringLongMap.get("CUSTOMER_ID").equals(contactEntity.getCustomerId()) || stringLongMap.get("IS_MANAGER") <= 0L) continue;
                for (int i9 = 0; i9 < contactIdList.size(); ++i9) {
                    if (!contactEntity.getContactId().equals(contactIdList.get(i9)) || !((Integer)permissionFlagList.get(i9)).equals(CommonConstant.unconfirmedPermission)) continue;
                    permissionFlagList.set(i9, CommonConstant.readOnly);
                    continue block21;
                }
            }
        }
        for (int i10 = 0; i10 < permissionFlagList.size(); ++i10) {
            if (!CommonConstant.unconfirmedPermission.equals(permissionFlagList.get(i10))) continue;
            permissionFlagList.set(i10, CommonConstant.noPermission);
        }
        return permissionFlagList;
    }

    @Override
    public void addTrackRecordBatch(List<ContactDto> dtoList, List<Long> oldContactPersonIdList, List<String> oldContactPersonNameList, String newChargePersonId, String newChargePersonName) {
        ArrayList<OperateRecordAPIVo> trackRecordList = new ArrayList<OperateRecordAPIVo>();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        for (int i = 0; i < dtoList.size(); ++i) {
            ContactDto dto = dtoList.get(i);
            OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
            operateRecordDO.setContactId(Long.valueOf(newChargePersonId));
            operateRecordDO.setContactName(newChargePersonName);
            operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_TRANSFER.getId());
            if (HussarUtils.isNotEmpty((Object)oldContactPersonIdList.get(i))) {
                operateRecordDO.setOldContactId(oldContactPersonIdList.get(i));
            }
            operateRecordDO.setOldContactName(oldContactPersonNameList.get(i));
            operateRecordDO.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
            operateRecordDO.setBusinessType(CrmBusinessTypeEnum.CONTACT.getId());
            operateRecordDO.setTypeId(dto.getContactId());
            operateRecordDO.setBusinessName(dto.getContactName());
            operateRecordDO.setCreatePerson(user.getUserId());
            operateRecordDO.setCreatePersonName(user.getUserName());
            operateRecordDO.setCreateTime(date);
            operateRecordDO.setChangePerson(user.getUserId());
            operateRecordDO.setChangeTime(date);
            operateRecordDO.setChangePersonName(user.getUserName());
            operateRecordDO.setDelflag("0");
            if (operateRecordDO.getProduceType() == null) {
                operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
            }
            trackRecordList.add(operateRecordDO);
        }
        this.operateRecordAPIService.saveOperateLogBatch(trackRecordList);
    }

    @Override
    public ApiResponse<String> contactChangeDeptBatch(DeptChangeBatchDto dto) {
        if (HussarUtils.isNotEmpty((Object)dto.getOwnDepartment()) && CollectionUtil.isNotEmpty(dto.getObjectIdList())) {
            LocalDateTime date = LocalDateTime.now();
            SecurityUser user = BaseSecurityUtil.getUser();
            List contactEntityList = this.list((Wrapper)new LambdaQueryWrapper().in(ContactEntity::getContactId, dto.getObjectIdList()));
            ArrayList<OperateRecordAPIVo> operateRecordDOList = new ArrayList<OperateRecordAPIVo>();
            String newOwnDeptName = dto.getOwnDepartmentName();
            Long newOwnDeptId = dto.getOwnDepartment();
            boolean changeFlag = false;
            for (ContactEntity contactEntity : contactEntityList) {
                HashMap<String, Object> before = new HashMap<String, Object>();
                HashMap<String, Object> after = new HashMap<String, Object>();
                ArrayList changeField = new ArrayList();
                if (dto.getOwnDepartmentName().equals(contactEntity.getOwnDepartmentName())) continue;
                String oldOwnDeptName = contactEntity.getOwnDepartmentName();
                Long oldOwnDeptId = contactEntity.getOwnDepartment();
                if ((ToolUtil.isEmpty((Object)oldOwnDeptName) && ToolUtil.isEmpty((Object)newOwnDeptName) || !ToolUtil.isEmpty((Object)oldOwnDeptName) && oldOwnDeptName.equals(newOwnDeptName)) && (ToolUtil.isEmpty((Object)oldOwnDeptId) && ToolUtil.isEmpty((Object)newOwnDeptId) || !ToolUtil.isEmpty((Object)oldOwnDeptId) && oldOwnDeptId.equals(newOwnDeptId))) continue;
                HashMap<String, String> field = new HashMap<String, String>();
                field.put("field", ContactEditConstant.OWN_DEPARTMENT_NAME.getField());
                field.put("fieldName", ContactEditConstant.OWN_DEPARTMENT_NAME.getName());
                changeField.add(field);
                before.put(ContactEditConstant.OWN_DEPARTMENT_NAME.getField(), oldOwnDeptName);
                after.put(ContactEditConstant.OWN_DEPARTMENT_NAME.getField(), newOwnDeptName);
                before.put(ContactEditConstant.OWN_DEPARTMENT_ID.getField(), oldOwnDeptId);
                after.put(ContactEditConstant.OWN_DEPARTMENT_ID.getField(), newOwnDeptId);
                String changeFieldStr = JSON.toJSONString(changeField);
                changeFlag = true;
                String oldJson = JSON.toJSONString(before);
                String newJson = JSON.toJSONString(after);
                String businessName = "";
                CrmBusinessTypeEnum typeEnum = null;
                businessName = contactEntity.getContactName();
                typeEnum = CrmBusinessTypeEnum.CONTACT;
                OperateRecordAPIVo trackRecord = new OperateRecordAPIVo();
                trackRecord.setProduceType(RecordProductTypeEnum.PRODUCE_OWN_DEPARTMENT.getId());
                trackRecord.setChangeBefore(oldJson);
                trackRecord.setChangeAfter(newJson);
                trackRecord.setChangeField(changeFieldStr);
                trackRecord.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
                trackRecord.setBusinessType(typeEnum.getId());
                trackRecord.setTypeId(contactEntity.getContactId());
                trackRecord.setBusinessName(businessName);
                trackRecord.setCreatePerson(user.getUserId());
                trackRecord.setCreatePersonName(user.getUserName());
                trackRecord.setCreateTime(date);
                trackRecord.setChangePerson(user.getUserId());
                trackRecord.setChangeTime(date);
                trackRecord.setChangePersonName(user.getUserName());
                trackRecord.setDelflag("0");
                trackRecord.setChangeBatch(1);
                operateRecordDOList.add(trackRecord);
            }
            this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(ContactEntity::getContactId, dto.getObjectIdList())).set(ContactEntity::getOwnDepartment, (Object)dto.getOwnDepartment())).set(ContactEntity::getOwnDepartmentName, (Object)dto.getOwnDepartmentName())).set(ContactEntity::getChangeTime, (Object)date)).set(ContactEntity::getChangePerson, (Object)user.getUserId())).set(ContactEntity::getChangePersonName, (Object)user.getUserName()));
            if (changeFlag) {
                this.operateRecordAPIService.saveOperateLogBatch(operateRecordDOList);
            }
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u53c2\u6570\u9519\u8bef");
    }

    @Override
    public ContactOrganTreeVo selectContactOrganTreeByCustomer(ContactDto dto) {
        List contactEntityList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactEntity::getCustomerId, (Object)dto.getCustomerId())).eq(ContactEntity::getDelFlag, (Object)"0"));
        ArrayList<ContactOrganTreeVo> list = new ArrayList<ContactOrganTreeVo>();
        ArrayList<ContactOrganTreeVo> result = new ArrayList<ContactOrganTreeVo>();
        List contactIdList = contactEntityList.stream().map(ContactEntity::getContactId).collect(Collectors.toList());
        List trackRecordViewAPIVoList = null;
        if (CollectionUtil.isNotEmpty(contactIdList)) {
            trackRecordViewAPIVoList = this.trackRecordAPIService.getTrackRecordDetailsBatch(contactIdList, null);
        }
        for (ContactEntity contactEntity : contactEntityList) {
            List treeNodeList;
            String superiorDepartment;
            List treeNodeList2;
            ContactEntityVo contactEntityVo = new ContactEntityVo();
            BeanUtil.copyProperties((Object)contactEntity, (Object)contactEntityVo);
            if (contactEntityVo.getContactId() != null && CollectionUtil.isNotEmpty((Collection)trackRecordViewAPIVoList)) {
                Long followupCount = trackRecordViewAPIVoList.stream().filter(trackRecordViewAPIVo -> StringUtil.isNotEmpty((Object)trackRecordViewAPIVo.getTypeId()) && trackRecordViewAPIVo.getRelationTypeId().equals(contactEntityVo.getContactId())).count();
                contactEntityVo.setFollowupCount(followupCount);
            }
            ContactOrganTreeVo contactTreeNode = this.initContactOrganTreeVo(contactEntity.getContactId().toString(), "", true, false, contactEntityVo);
            list.add(contactTreeNode);
            String department = contactEntity.getDepartment();
            if (ToolUtil.isNotEmpty((Object)department) && ToolUtil.isEmpty(treeNodeList2 = list.stream().filter(treeNode -> treeNode.getOrganName().equals(department)).collect(Collectors.toList()))) {
                ContactOrganTreeVo organTreeNode = this.initContactOrganTreeVo("", department, false, false, null);
                list.add(organTreeNode);
            }
            if (!ToolUtil.isNotEmpty((Object)(superiorDepartment = contactEntity.getSuperiorDepartment())) || !ToolUtil.isEmpty(treeNodeList = list.stream().filter(treeNode -> treeNode.getOrganName().equals(superiorDepartment)).collect(Collectors.toList()))) continue;
            ContactOrganTreeVo organTreeNode = this.initContactOrganTreeVo("", superiorDepartment, false, false, null);
            list.add(organTreeNode);
        }
        for (ContactOrganTreeVo treeNode2 : list) {
            ArrayList<ContactOrganTreeVo> treeNodeList;
            ContactOrganTreeVo node;
            if (!ToolUtil.isNotEmpty((Object)treeNode2.getUserFlag()) || !treeNode2.getUserFlag().booleanValue()) continue;
            if (ToolUtil.isNotEmpty((Object)treeNode2.getContact()) && ToolUtil.isNotEmpty((Object)treeNode2.getContact().getDirectSuperior())) {
                node = (ContactOrganTreeVo)((Object)list.stream().filter(node1 -> ((String)((Object)node1.getId())).equals(treeNode2.getContact().getDirectSuperior())).collect(Collectors.toList()).get(0));
                node.setHasChildren(true);
                if (ToolUtil.isEmpty((Object)node.getChildren())) {
                    treeNodeList = new ArrayList<ContactOrganTreeVo>();
                    treeNodeList.add(treeNode2);
                    node.setChildren(treeNodeList);
                } else {
                    node.getChildren().add(treeNode2);
                }
                treeNode2.setParentId(node.getId());
            } else if (ToolUtil.isNotEmpty((Object)treeNode2.getContact()) && ToolUtil.isNotEmpty((Object)treeNode2.getContact().getDepartment())) {
                node = (ContactOrganTreeVo)((Object)list.stream().filter(node1 -> node1.getOrganName().equals(treeNode2.getContact().getDepartment())).collect(Collectors.toList()).get(0));
                node.setHasChildren(true);
                if (ToolUtil.isEmpty((Object)node.getChildren())) {
                    treeNodeList = new ArrayList();
                    treeNodeList.add(treeNode2);
                    node.setChildren(treeNodeList);
                } else {
                    node.getChildren().add(treeNode2);
                }
                treeNode2.setParentId((Serializable)((Object)node.getOrganName()));
            }
            if (!ToolUtil.isNotEmpty((Object)treeNode2.getContact()) || !ToolUtil.isNotEmpty((Object)treeNode2.getContact().getDepartment()) || !ToolUtil.isNotEmpty((Object)treeNode2.getContact().getSuperiorDepartment())) continue;
            node = (ContactOrganTreeVo)((Object)list.stream().filter(node1 -> node1.getOrganName().equals(treeNode2.getContact().getDepartment())).collect(Collectors.toList()).get(0));
            ContactOrganTreeVo nodeSuper = (ContactOrganTreeVo)((Object)list.stream().filter(node1 -> node1.getOrganName().equals(treeNode2.getContact().getSuperiorDepartment())).collect(Collectors.toList()).get(0));
            if (!ToolUtil.isEmpty((Object)node.getParentId())) continue;
            nodeSuper.setHasChildren(true);
            if (ToolUtil.isEmpty((Object)nodeSuper.getChildren())) {
                ArrayList<ContactOrganTreeVo> treeNodeList3 = new ArrayList<ContactOrganTreeVo>();
                treeNodeList3.add(node);
                nodeSuper.setChildren(treeNodeList3);
            } else {
                nodeSuper.getChildren().add(node);
            }
            node.setParentId((Serializable)((Object)nodeSuper.getOrganName()));
        }
        for (ContactOrganTreeVo treeNode2 : list) {
            if (!ToolUtil.isEmpty((Object)treeNode2.getParentId())) continue;
            result.add(treeNode2);
        }
        String customerName = ((CustomerEntity)this.customerService.getById(dto.getCustomerId())).getCustomerName();
        ContactOrganTreeVo root = this.initContactOrganTreeVo("", customerName, false, true, null);
        for (ContactOrganTreeVo treeVo : result) {
            treeVo.setParentId((Serializable)((Object)root.getOrganName()));
        }
        root.setId((Serializable)((Object)((CustomerEntity)this.customerService.getById(dto.getCustomerId())).getCustomerId().toString()));
        root.setChildren(result);
        root.setHasChildren(true);
        return root;
    }

    public ContactOrganTreeVo initContactOrganTreeVo(String id, String organName, Boolean userFlag, Boolean hasChildren, ContactEntityVo contact) {
        ContactOrganTreeVo contactTreeNode = new ContactOrganTreeVo();
        if (userFlag.booleanValue()) {
            contactTreeNode.setUserFlag(true);
            contactTreeNode.setOrganName("");
            contactTreeNode.setHasChildren(false);
            contactTreeNode.setContact(contact);
            contactTreeNode.setId((Serializable)((Object)id));
        } else {
            contactTreeNode.setUserFlag(false);
            contactTreeNode.setHasChildren(false);
            contactTreeNode.setOrganName(organName);
            contactTreeNode.setId((Serializable)((Object)""));
        }
        return contactTreeNode;
    }

    @Override
    public ApiResponse<String> contactChangeDeptByChargePersonBatch(DeptChangeBatchDto dto) {
        if (CollectionUtil.isNotEmpty(dto.getObjectIdList())) {
            LocalDateTime date = LocalDateTime.now();
            SecurityUser user = BaseSecurityUtil.getUser();
            List contactEntityList = this.list((Wrapper)new LambdaQueryWrapper().in(ContactEntity::getContactId, dto.getObjectIdList()));
            for (ContactEntity contactEntity : contactEntityList) {
                if (!ToolUtil.isEmpty((Object)contactEntity.getChargePersonId())) continue;
                throw new HussarException("\u8054\u7cfb\u4eba\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728\uff01");
            }
            ArrayList<OperateRecordAPIVo> operateRecordDOList = new ArrayList<OperateRecordAPIVo>();
            List<Map<String, Object>> userInfoList = this.commonMapper.getDeptInfosByUserIdList(contactEntityList.stream().map(ContactEntity::getChargePersonId).collect(Collectors.toList()));
            boolean changeFlag = false;
            for (ContactEntity contactEntity : contactEntityList) {
                HashMap<String, Object> before = new HashMap<String, Object>();
                HashMap<String, Object> after = new HashMap<String, Object>();
                ArrayList changeField = new ArrayList();
                Map userMap = (Map)userInfoList.stream().filter(map -> map.get("USER_ID").equals(contactEntity.getChargePersonId())).collect(Collectors.toList()).get(0);
                Long newOwnDeptId = (Long)userMap.get("DEPARTMENT_ID");
                String newOwnDeptName = (String)userMap.get("ORGAN_ALIAS");
                if (newOwnDeptName.equals(contactEntity.getOwnDepartmentName())) continue;
                String oldOwnDeptName = contactEntity.getOwnDepartmentName();
                Long oldOwnDeptId = contactEntity.getOwnDepartment();
                if ((ToolUtil.isEmpty((Object)oldOwnDeptName) && ToolUtil.isEmpty((Object)newOwnDeptName) || !ToolUtil.isEmpty((Object)oldOwnDeptName) && oldOwnDeptName.equals(newOwnDeptName)) && (ToolUtil.isEmpty((Object)oldOwnDeptId) && ToolUtil.isEmpty((Object)newOwnDeptId) || !ToolUtil.isEmpty((Object)oldOwnDeptId) && oldOwnDeptId.equals(newOwnDeptId))) continue;
                HashMap<String, String> field = new HashMap<String, String>();
                field.put("field", OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField());
                field.put("fieldName", OpportunityEditConstant.OWN_DEPARTMENT_NAME.getName());
                changeField.add(field);
                before.put(OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField(), oldOwnDeptName);
                after.put(OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField(), newOwnDeptName);
                before.put(OpportunityEditConstant.OWN_DEPARTMENT_ID.getField(), oldOwnDeptId);
                after.put(OpportunityEditConstant.OWN_DEPARTMENT_ID.getField(), newOwnDeptId);
                String changeFieldStr = JSON.toJSONString(changeField);
                changeFlag = true;
                String oldJson = JSON.toJSONString(before);
                String newJson = JSON.toJSONString(after);
                String businessName = "";
                CrmBusinessTypeEnum typeEnum = null;
                businessName = contactEntity.getCustomerName();
                typeEnum = CrmBusinessTypeEnum.CONTACT;
                OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
                operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_OWN_DEPARTMENT.getId());
                operateRecordDO.setChangeBefore(oldJson);
                operateRecordDO.setChangeAfter(newJson);
                operateRecordDO.setChangeField(changeFieldStr);
                operateRecordDO.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
                operateRecordDO.setBusinessType(typeEnum.getId());
                operateRecordDO.setTypeId(contactEntity.getCustomerId());
                operateRecordDO.setBusinessName(businessName);
                operateRecordDO.setCreatePerson(user.getUserId());
                operateRecordDO.setCreatePersonName(user.getUserName());
                operateRecordDO.setCreateTime(date);
                operateRecordDO.setChangePerson(user.getUserId());
                operateRecordDO.setChangeTime(date);
                operateRecordDO.setChangePersonName(user.getUserName());
                operateRecordDO.setDelflag("0");
                operateRecordDO.setChangeBatch(1);
                operateRecordDOList.add(operateRecordDO);
                contactEntity.setOwnDepartment(newOwnDeptId);
                contactEntity.setOwnDepartmentName(newOwnDeptName);
                contactEntity.setChangeTime(date);
                contactEntity.setChangePerson(user.getUserId());
                contactEntity.setChangePersonName(user.getUserName());
            }
            this.updateBatchById(contactEntityList);
            if (changeFlag) {
                this.operateRecordAPIService.saveOperateLogBatch(operateRecordDOList);
            }
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u53c2\u6570\u9519\u8bef");
    }
}

