/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.competitoranalysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.core.competitoranalysis.dao.CompetitorAnalysisMapper;
import com.jxdinfo.crm.core.competitoranalysis.dto.CompetitorAnalysisBatchDto;
import com.jxdinfo.crm.core.competitoranalysis.dto.CompetitorAnalysisDto;
import com.jxdinfo.crm.core.competitoranalysis.model.CompetitorAnalysis;
import com.jxdinfo.crm.core.competitoranalysis.service.CompetitorAnalysisService;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CompetitorAnalysisServiceImpl
extends ServiceImpl<CompetitorAnalysisMapper, CompetitorAnalysis>
implements CompetitorAnalysisService {
    @Resource
    private CompetitorAnalysisMapper competitorAnalysisMapper;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private OpportunityService opportunityService;

    @Override
    public Page selectCrmCompetitorList(CompetitorAnalysisDto dto) {
        Page page = dto.getPage();
        dto.setDelFlag("0");
        List<CompetitorAnalysis> list = this.competitorAnalysisMapper.selectCompetitorAnalysisList(dto, page);
        page.setRecords(list);
        return page;
    }

    @Override
    public List<CompetitorAnalysis> selectCrmCompetitorListNoPage(CompetitorAnalysisDto dto) {
        dto.setDelFlag("0");
        List<CompetitorAnalysis> list = this.competitorAnalysisMapper.selectCompetitorAnalysisList(dto, null);
        return list;
    }

    @Override
    @Transactional
    public Boolean updateDelFlagByIds(CompetitorAnalysisDto dto) {
        List<String> ids = dto.getCompetitorAnalysisIds();
        if (ToolUtil.isEmpty(ids)) {
            throw new BaseException("\u7ade\u4e89\u5bf9\u624b\u5206\u6790id\u4e3a\u7a7a");
        }
        this.opportunityService.updateChangeTime(dto.getOpportunityId());
        this.competitorAnalysisMapper.updateDelFlagByIds("1", ids);
        return true;
    }

    @Override
    @Transactional
    public Long addCompetitorAnalysis(CompetitorAnalysis competitorAnalysis) {
        long repeatCount = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CompetitorAnalysis::getDelFlag, (Object)"0")).eq(CompetitorAnalysis::getOpportunityId, (Object)competitorAnalysis.getOpportunityId())).eq(CompetitorAnalysis::getCompetitorId, (Object)competitorAnalysis.getCompetitorId()));
        if (repeatCount > 0L) {
            throw new BaseException("\u6240\u9009\u5df2\u5b58\u5728");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        Long id = competitorAnalysis.getId();
        if (ToolUtil.isEmpty((Object)id)) {
            id = Long.valueOf(CommonUtills.generateAssignId());
            competitorAnalysis.setId(id);
            competitorAnalysis.setCreatePerson(user.getUserId());
            competitorAnalysis.setCreatePersonName(user.getUserName());
            competitorAnalysis.setCreateTime(date);
            competitorAnalysis.setChangePerson(user.getUserId());
            competitorAnalysis.setChangePersonName(user.getUserName());
            competitorAnalysis.setChangeTime(date);
            competitorAnalysis.setTrackTime(date);
            competitorAnalysis.setChargePersonId(user.getUserId());
            competitorAnalysis.setChargePersonName(user.getUserName());
            competitorAnalysis.setOwnDepartment(user.getDeptId());
            competitorAnalysis.setOwnDepartmentName(user.getDeptName());
            competitorAnalysis.setDelFlag("0");
        }
        this.opportunityService.updateChangeTime(String.valueOf(competitorAnalysis.getOpportunityId()));
        this.saveOrUpdate(competitorAnalysis);
        return id;
    }

    @Override
    @Transactional
    public String addBatchCompetitorAnalysis(CompetitorAnalysisBatchDto dto) {
        long repeatCount;
        List<CompetitorAnalysis> competitorAnalysisList = dto.getCompetitorAnalysisList();
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        List updateIdList = competitorAnalysisList.stream().map(CompetitorAnalysis::getId).filter(Objects::nonNull).collect(Collectors.toList());
        LambdaUpdateWrapper deleteWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(CompetitorAnalysis::getDelFlag, (Object)"0")).eq(CompetitorAnalysis::getOpportunityId, (Object)dto.getOpportunityId());
        if (ToolUtil.isNotEmpty(updateIdList)) {
            deleteWrapper.notIn(CompetitorAnalysis::getId, updateIdList);
        }
        deleteWrapper.set(CompetitorAnalysis::getDelFlag, (Object)"1");
        this.update((Wrapper)deleteWrapper);
        List newIdList = competitorAnalysisList.stream().filter(ca -> ToolUtil.isEmpty((Object)ca.getId())).map(CompetitorAnalysis::getCompetitorId).collect(Collectors.toList());
        if (ToolUtil.isNotEmpty(newIdList) && (repeatCount = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CompetitorAnalysis::getDelFlag, (Object)"0")).eq(CompetitorAnalysis::getOpportunityId, (Object)dto.getOpportunityId())).in(CompetitorAnalysis::getCompetitorId, newIdList))) > 0L) {
            throw new BaseException("\u6240\u9009\u5df2\u5b58\u5728");
        }
        for (int i = 0; i < competitorAnalysisList.size(); ++i) {
            CompetitorAnalysis analysis = competitorAnalysisList.get(i);
            Long id = analysis.getId();
            if (ToolUtil.isEmpty((Object)id)) {
                analysis.setCreatePerson(user.getUserId());
                analysis.setCreatePersonName(user.getUserName());
                analysis.setCreateTime(date);
                analysis.setOwnDepartment(user.getDeptId());
                analysis.setOwnDepartmentName(user.getDeptName());
                analysis.setOpportunityId(Long.valueOf(dto.getOpportunityId()));
                analysis.setChargePersonId(user.getUserId());
                analysis.setChargePersonName(user.getUserName());
                analysis.setDelFlag("0");
            }
            analysis.setChangePerson(user.getUserId());
            analysis.setChangePersonName(user.getUserName());
            analysis.setChangeTime(date);
            analysis.setTrackTime(date);
            if (!ToolUtil.isEmpty((Object)analysis.getOrderNumber())) continue;
            analysis.setOrderNumber(null);
        }
        this.opportunityService.updateChangeTime(String.valueOf(dto.getOpportunityId()));
        this.saveOrUpdateBatch(competitorAnalysisList);
        return "\u4fdd\u5b58\u6210\u529f";
    }

    @Override
    public Page<CompetitorAnalysis> selectAnalysisList(CompetitorAnalysisDto dto) {
        Page page = dto.getPage();
        dto.setDelFlag("0");
        List<CompetitorAnalysis> competitorAnalysisList = this.competitorAnalysisMapper.selectCrmCompetitorAnalysisById(dto, page);
        page.setRecords(competitorAnalysisList);
        return page;
    }

    @Override
    public Integer isOperate(Long Id) {
        Long parentId;
        List<String> deptIds;
        List<Map<String, Long>> struList;
        if (ToolUtil.isEmpty((Object)Id)) {
            return CommonConstant.noPermission;
        }
        CompetitorAnalysis competitorAnalysis = (CompetitorAnalysis)this.getById(Id);
        if (ToolUtil.isEmpty((Object)competitorAnalysis)) {
            return CommonConstant.noPermission;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List userRoles = user.getRolesList();
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getCompanyLeader()))) {
            return CommonConstant.companyLeader;
        }
        List<Long> leadershipRoles = DataPermission.getLeadershipRoles();
        if (DataPermission.isLeadship(userRoles, leadershipRoles)) {
            struList = DataPermission.getStruCache();
            List<String> struIds = DataPermission.getLeadershipBGList(user.getUserId());
            ArrayList<String> deptIdList = new ArrayList<String>();
            if (CollectionUtil.isNotEmpty(struIds)) {
                for (String struId : struIds) {
                    List<String> deptIds2 = DataPermission.getAllDeptIdByParentId(struList, Long.valueOf(struId));
                    deptIdList.addAll(deptIds2);
                }
            }
            if (CollectionUtil.isNotEmpty(deptIdList) && deptIdList.contains(competitorAnalysis.getOwnDepartment() == null ? "" : competitorAnalysis.getOwnDepartment().toString())) {
                return CommonConstant.leadership;
            }
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getBgLeader())) && CollectionUtil.isNotEmpty(deptIds = DataPermission.getAllDeptIdByParentId(struList = DataPermission.getStruCache(), parentId = DataPermission.getParentIdByDeptId(struList, user.getDeptId()))) && deptIds.contains(competitorAnalysis.getOwnDepartment() == null ? "" : competitorAnalysis.getOwnDepartment().toString())) {
            return CommonConstant.bgLeader;
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesGM())) && user.getDeptId().toString().equals(competitorAnalysis.getOwnDepartment() == null ? "" : competitorAnalysis.getOwnDepartment().toString())) {
            return CommonConstant.salesGM;
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesDirector())) && user.getDeptId().toString().equals(competitorAnalysis.getOwnDepartment() == null ? "" : competitorAnalysis.getOwnDepartment().toString())) {
            return CommonConstant.salesDirector;
        }
        if (user.getUserId().toString().equals(competitorAnalysis.getChargePersonId() == null ? "" : competitorAnalysis.getChargePersonId().toString())) {
            return CommonConstant.salesman;
        }
        return CommonConstant.noPermission;
    }
}

