/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.competitor.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeKeyword;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAdapterService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.core.api.task.service.ITaskAPIService;
import com.jxdinfo.crm.core.common.vo.PersonWithDepInfo;
import com.jxdinfo.crm.core.common.vo.TransferBatchResultVo;
import com.jxdinfo.crm.core.competitor.dao.CompetitorMapper;
import com.jxdinfo.crm.core.competitor.dto.CompetitorAssociativeQueryDto;
import com.jxdinfo.crm.core.competitor.dto.CompetitorDto;
import com.jxdinfo.crm.core.competitor.model.Competitor;
import com.jxdinfo.crm.core.competitor.service.CompetitorService;
import com.jxdinfo.crm.core.competitor.service.ICompetitorAssociativeQueryService;
import com.jxdinfo.crm.core.competitor.vo.CompetitorVo;
import com.jxdinfo.crm.core.competitoranalysis.dao.CompetitorAnalysisMapper;
import com.jxdinfo.crm.core.competitoranalysis.model.CompetitorAnalysis;
import com.jxdinfo.crm.core.competitoranalysis.service.CompetitorAnalysisService;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.basearea1.service.BaseArea1Service;
import com.jxdinfo.crm.core.crm.jzds.competitorcontact.crmcompetitorcontact.dto.CompetitorContactDto;
import com.jxdinfo.crm.core.crm.jzds.competitorcontact.crmcompetitorcontact.model.CrmCompetitorContact;
import com.jxdinfo.crm.core.crm.jzds.competitorcontact.crmcompetitorcontact.service.CrmCompetitorContactService;
import com.jxdinfo.crm.core.crm.jzds.competitorcontact.crmcompetitorcontact.service.ICompetitorContactService;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.fileinfo.model.FileInfo;
import com.jxdinfo.crm.core.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.core.focus.model.FocusEntity;
import com.jxdinfo.crm.core.focus.service.FocusService;
import com.jxdinfo.crm.core.jxdIM.dto.CrmTeamAdminInfoDto;
import com.jxdinfo.crm.core.jxdIM.service.ImGroupMemberService;
import com.jxdinfo.crm.core.teammeber.dao.TeamMeberMapper;
import com.jxdinfo.crm.core.teammeber.dto.TeamMeberDto;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.crm.core.utills.ReadExcel;
import com.jxdinfo.crm.core.utills.WriteExcel;
import com.jxdinfo.crm.core.utills.entity.DateConvertVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.region.model.SysRegion;
import com.jxdinfo.hussar.region.service.IHussarBaseRegionService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CompetitorServiceImpl
extends ServiceImpl<CompetitorMapper, Competitor>
implements CompetitorService {
    @Resource
    private CompetitorMapper competitorMapper;
    @Resource
    private CompetitorAnalysisMapper competitorAnalysisMapper;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private BaseArea1Service area1Service;
    @Resource
    private FileInfoService fileInfoService;
    @Resource
    private CompetitorAnalysisService competitorAnalysisService;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private ITaskAPIService taskAPIService;
    @Resource
    private CrmCommonProperties crmCommonProperties;
    @Resource
    private FocusService focusService;
    @Resource
    private IHussarBaseRegionService iHussarBaseRegionService;
    @Resource
    private IAssociativeQueryAPIService associativeQueryService;
    @Resource
    private ICompetitorAssociativeQueryService competitorAssociativeQueryService;
    @Resource
    private TeamMeberMapper teamMeberMapper;
    @Resource
    private CrmCompetitorContactService crmCompetitorContactService;
    @Resource
    private ICompetitorContactService competitorContactService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private ImGroupMemberService imGroupMemberService;

    @Override
    public Page<Competitor> selectCrmCompetitorList(CompetitorDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        Page page = dto.getPage();
        String competitorView = dto.getCompetitorView();
        if ("2".equals(competitorView)) {
            dto.setChargePersonId(userId.toString());
        }
        dto.setCurrentUserId(userId);
        dto.setDelFlag("0");
        List<Competitor> list = this.competitorMapper.selectCrmCompetitorList(dto, page);
        page.setRecords(list);
        return page;
    }

    @Override
    public List<AssociativeQueryVo> associativeQuery(CompetitorAssociativeQueryDto dto) {
        String keyWord = dto.getKeyword();
        String queryScreening = null;
        if (dto.getDto() != null) {
            queryScreening = dto.getDto().getCompetitorScreening();
        }
        ICompetitorAssociativeQueryService adapterService = this.competitorAssociativeQueryService;
        AssociativeKeyword associativeKeyword = new AssociativeKeyword();
        associativeKeyword.setLabelName("\u5173\u952e\u5b57");
        associativeKeyword.setDataName("input_5Data");
        associativeKeyword.setDictTypeName("");
        associativeKeyword.setMultiOption(Boolean.valueOf(false));
        return this.associativeQueryService.associativeQuery((AssociativeQueryDto)dto, keyWord, queryScreening, (IAssociativeQueryAdapterService)adapterService, associativeKeyword);
    }

    @Override
    @Transactional
    public Boolean updateDelFlagByIds(CompetitorDto dto) {
        if (ToolUtil.isEmpty(dto.getCompetitorIds())) {
            throw new BaseException("\u7ade\u4e89\u5bf9\u624bid\u4e3a\u7a7a");
        }
        Long analysCount = this.competitorAnalysisService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CompetitorAnalysis::getDelFlag, (Object)"0")).in(CompetitorAnalysis::getCompetitorId, dto.getCompetitorIds()));
        if (analysCount > 0L) {
            throw new BaseException("\u5df2\u5173\u8054\u7ade\u4e89\u5bf9\u624b\u5206\u6790\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.competitorMapper.updateDelFlagByIds("1", dto.getCompetitorIds());
        return true;
    }

    @Override
    public String competitorExport(HttpServletResponse response, CompetitorDto dto) {
        String competitorView = dto.getCompetitorView();
        DateConvertVo dateConvertVo = null;
        if ("1".equals(competitorView)) {
            dateConvertVo = CommonUtills.getWeekDate();
        }
        if ("2".equals(competitorView)) {
            dateConvertVo = CommonUtills.getMonthDay();
        }
        if ("4".equals(competitorView)) {
            dateConvertVo = CommonUtills.getYearDay();
        }
        if (dateConvertVo != null) {
            dto.setStartDate(dateConvertVo.getStartDate());
            dto.setEndDate(dateConvertVo.getEndDate());
        }
        dto.setDelFlag("0");
        List<Competitor> list = this.competitorMapper.selectCrmCompetitorListExport(dto, null);
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, list, "\u7ade\u4e89\u5bf9\u624b", Competitor.class);
        return "\u5bfc\u51fa\u6210\u529f";
    }

    @Override
    public String competitorExportTemplate(HttpServletResponse response) {
        ArrayList list = new ArrayList();
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, list, "\u7ade\u4e89\u5bf9\u624b\u6a21\u677f", Competitor.class);
        return "\u5bfc\u51fa\u6a21\u677f\u6210\u529f";
    }

    @Override
    public int competitorImport(MultipartFile file) {
        int flag = 0;
        ReadExcel readExcel = new ReadExcel();
        LocalDateTime date = LocalDateTime.now();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ");
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getId();
        String userName = user.getUserName();
        try {
            List<Competitor> list = ReadExcel.readExcel(file, Competitor.class);
            for (Competitor competitor : list) {
                competitor.setCompetitorId(Long.valueOf(CommonUtills.generateAssignId()));
                competitor.setCreatePerson(userId);
                competitor.setCreatePersonName(userName);
                competitor.setCreateTime(date);
                competitor.setChangePerson(userId);
                competitor.setChangePersonName(userName);
                competitor.setChangeTime(date);
                competitor.setDelFlag("0");
                int i = this.competitorMapper.insertCrmCompetitor(competitor);
                if (i <= 0) continue;
                ++flag;
            }
            return flag;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public CompetitorVo selectCompetitorDetails(Long competitorId) {
        if (CommonConstant.noPermission.equals(this.isOperate(competitorId))) {
            return null;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (ToolUtil.isEmpty((Object)competitorId)) {
            throw new BaseException("\u5ba2\u6237id\u4e3a\u7a7a");
        }
        Competitor competitor = (Competitor)this.getById(competitorId);
        if (competitor == null) {
            return null;
        }
        CompetitorVo competitorVo = (CompetitorVo)BeanUtil.copy((Object)competitor, CompetitorVo.class);
        assert (competitorVo != null);
        this.setCompetitorDic(competitorVo);
        competitorVo.setFileAmount(this.fileInfoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FileInfo::getBusinessId, (Object)competitorId)).eq(FileInfo::getDelFlag, (Object)"0")));
        competitorVo.setCompetitorAnalysisAmount(this.competitorAnalysisService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CompetitorAnalysis::getCompetitorId, (Object)competitorId)).eq(CompetitorAnalysis::getDelFlag, (Object)"0")));
        competitorVo.setTeamMemberAount(this.teamMeberService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getBusinessType, (Object)"12")).eq(TeamMeberEntity::getBusinessId, (Object)competitorId)));
        competitorVo.setTaskAmount(this.taskAPIService.selectTaskCount("12", competitorId));
        long focusCount = this.focusService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FocusEntity::getBusinessType, (Object)"12")).eq(FocusEntity::getBusinessId, (Object)competitorId)).eq(FocusEntity::getCreatePersion, (Object)user.getUserId()));
        competitorVo.setCompetitorContactAmount(this.crmCompetitorContactService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmCompetitorContact::getDelFlag, (Object)"0")).eq(CrmCompetitorContact::getCompetitorId, (Object)competitorId)));
        competitorVo.setFocus(focusCount > 0L);
        return competitorVo;
    }

    private void setCompetitorDic(CompetitorVo competitorVo) {
        if (StringUtil.isNotBlank((CharSequence)competitorVo.getStaffNumber())) {
            competitorVo.setStaffNumber(this.sysDicRefService.getDictLabel("staff_nums", competitorVo.getStaffNumber()));
        }
    }

    @Override
    @Transactional
    public Long saveCompetitor(Competitor competitor) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        Long competitorId = competitor.getCompetitorId();
        if (ToolUtil.isEmpty((Object)competitorId)) {
            competitorId = Long.valueOf(CommonUtills.generateAssignId());
            competitor.setCompetitorId(competitorId);
            competitor.setTelephone(competitor.getTelephone().replaceAll(" ", ""));
            competitor.setCreatePerson(user.getUserId());
            competitor.setCreatePersonName(user.getUserName());
            competitor.setCreateTime(date);
            competitor.setChargePersonId(user.getUserId());
            competitor.setChargePersonName(user.getUserName());
            competitor.setDelFlag("0");
            competitor.setOwnDepartment(user.getDeptId());
            competitor.setOwnDepartmentName(user.getDeptName());
            competitor.setCreateDepartment(user.getDeptId());
            competitor.setCreateDepartmentName(user.getDeptName());
        }
        competitor.setChangePerson(user.getUserId());
        competitor.setChangePersonName(user.getUserName());
        competitor.setChangeTime(date);
        competitor.setTrackTime(date);
        StringBuilder sb = new StringBuilder();
        if (ToolUtil.isEmpty((Object)competitor.getProvince())) {
            competitor.setProvince(null);
        } else {
            SysRegion province = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(competitor.getProvince()));
            if (ToolUtil.isNotEmpty((Object)province)) {
                sb.append(province.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)competitor.getCity())) {
            competitor.setCity(null);
        } else {
            SysRegion city = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(competitor.getCity()));
            if (ToolUtil.isNotEmpty((Object)city)) {
                sb.append("/").append(city.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)competitor.getCounty())) {
            competitor.setCounty(null);
        } else {
            SysRegion county = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(competitor.getCounty()));
            if (ToolUtil.isNotEmpty((Object)county)) {
                sb.append("/").append(county.getName());
            }
        }
        competitor.setRegionLabel(sb.toString());
        this.saveOrUpdate(competitor);
        this.teamMeberService.insertTeamMember(user.getUserName(), competitor.getChargePersonId(), competitorId, "1", "1", date, "12");
        return competitorId;
    }

    @Override
    public Integer isOperate(Long competitorId) {
        Object parentId;
        List<String> deptIds;
        List<Map<String, Long>> struList;
        if (ToolUtil.isEmpty((Object)competitorId)) {
            return CommonConstant.noPermission;
        }
        Competitor competitor = (Competitor)this.getById(competitorId);
        if (ToolUtil.isEmpty((Object)competitor)) {
            return CommonConstant.noPermission;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List userRoles = user.getRolesList();
        if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getCompanyLeader()))) {
            return CommonConstant.companyLeader;
        }
        List<Long> leadershipRoles = DataPermission.getLeadershipRoles();
        if (DataPermission.isLeadship(userRoles, leadershipRoles)) {
            struList = DataPermission.getStruCache();
            List<String> struIds = DataPermission.getLeadershipBGList(user.getUserId());
            ArrayList<String> deptIdList = new ArrayList<String>();
            if (CollectionUtil.isNotEmpty(struIds)) {
                for (String struId : struIds) {
                    List<String> deptIds2 = DataPermission.getAllDeptIdByParentId(struList, Long.valueOf(struId));
                    deptIdList.addAll(deptIds2);
                }
            }
            if (CollectionUtil.isNotEmpty(deptIdList) && deptIdList.contains(competitor.getOwnDepartment() == null ? "" : competitor.getOwnDepartment().toString())) {
                return CommonConstant.leadership;
            }
        }
        if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getBgLeader())) && CollectionUtil.isNotEmpty(deptIds = DataPermission.getAllDeptIdByParentId(struList = DataPermission.getStruCache(), (Long)(parentId = DataPermission.getParentIdByDeptId(struList, user.getDeptId())))) && deptIds.contains(competitor.getOwnDepartment() == null ? "" : competitor.getOwnDepartment().toString())) {
            return CommonConstant.bgLeader;
        }
        if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getSalesGM())) && user.getDeptId().toString().equals(competitor.getOwnDepartment() == null ? "" : competitor.getOwnDepartment().toString())) {
            return CommonConstant.salesGM;
        }
        if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getSalesDirector())) && user.getDeptId().toString().equals(competitor.getOwnDepartment() == null ? "" : competitor.getOwnDepartment().toString())) {
            return CommonConstant.salesDirector;
        }
        if (user.getUserId().toString().equals(competitor.getChargePersonId() == null ? "" : competitor.getChargePersonId().toString())) {
            return CommonConstant.salesman;
        }
        List teamList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)competitor.getCompetitorId())).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"12"));
        if (CollectionUtil.isNotEmpty((Collection)teamList)) {
            for (TeamMeberEntity teamMeberEntity : teamList) {
                if (!"1".equals(teamMeberEntity.getModifyPower())) continue;
                return CommonConstant.otherRole;
            }
            return CommonConstant.readOnly;
        }
        if (StringUtil.isNotBlank((CharSequence)competitor.getProductId())) {
            List<String> productIds = Arrays.asList(competitor.getProductId().split(","));
            List<Long> businessIds = productIds.stream().map(Long::valueOf).collect(Collectors.toList());
            List<Map<String, Object>> productManagers = this.teamMeberMapper.selectProductTeamMemberByBusinessId(businessIds, "0");
            for (Map<String, Object> productManager : productManagers) {
                if (!user.getUserId().equals(productManager.get("personId"))) continue;
                return CommonConstant.readOnly;
            }
        }
        if (DataPermission.isLeadship(userRoles, leadershipRoles) || userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getBgLeader())) || userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getSalesGM())) || userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getSalesDirector())) || userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getSalesman()))) {
            return CommonConstant.readOnly;
        }
        return CommonConstant.noPermission;
    }

    public List<Integer> competitorOperateBatch(List<Competitor> competitorEntityList) {
        List<String> deptIds;
        List<Map<String, Long>> struList;
        Competitor competitorEntity;
        int i;
        ArrayList<Integer> permissionFlagList = new ArrayList<Integer>();
        for (Competitor competitorEntity2 : competitorEntityList) {
            permissionFlagList.add(CommonConstant.unconfirmedPermission);
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List userRoles = user.getRolesList();
        if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getCompanyLeader()))) {
            for (int i2 = 0; i2 < permissionFlagList.size(); ++i2) {
                if (!CommonConstant.unconfirmedPermission.equals(permissionFlagList.get(i2))) continue;
                permissionFlagList.set(i2, CommonConstant.companyLeader);
            }
        }
        List<Long> leadershipRoles = DataPermission.getLeadershipRoles();
        for (i = 0; i < competitorEntityList.size(); ++i) {
            competitorEntity = competitorEntityList.get(i);
            if (!DataPermission.isLeadship(userRoles, leadershipRoles)) continue;
            struList = DataPermission.getStruCache();
            List<String> struIds = DataPermission.getLeadershipBGList(user.getUserId());
            ArrayList<String> deptIdList = new ArrayList<String>();
            if (CollectionUtil.isNotEmpty(struIds)) {
                for (String string : struIds) {
                    deptIds = DataPermission.getAllDeptIdByParentId(struList, Long.valueOf(string));
                    deptIdList.addAll(deptIds);
                }
            }
            if (!CollectionUtil.isNotEmpty(deptIdList) || !deptIdList.contains(competitorEntity.getOwnDepartment() == null ? "" : competitorEntity.getOwnDepartment().toString()) || !((Integer)permissionFlagList.get(i)).equals(CommonConstant.unconfirmedPermission)) continue;
            permissionFlagList.set(i, CommonConstant.leadership);
        }
        for (i = 0; i < competitorEntityList.size(); ++i) {
            Object parentId;
            List<String> deptIds2;
            competitorEntity = competitorEntityList.get(i);
            if (!userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getBgLeader())) || !CollectionUtil.isNotEmpty(deptIds2 = DataPermission.getAllDeptIdByParentId(struList = DataPermission.getStruCache(), (Long)(parentId = DataPermission.getParentIdByDeptId(struList, user.getDeptId())))) || !deptIds2.contains(competitorEntity.getOwnDepartment() == null ? "" : competitorEntity.getOwnDepartment().toString()) || !((Integer)permissionFlagList.get(i)).equals(CommonConstant.unconfirmedPermission)) continue;
            permissionFlagList.set(i, CommonConstant.bgLeader);
        }
        for (i = 0; i < competitorEntityList.size(); ++i) {
            competitorEntity = competitorEntityList.get(i);
            if (!userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getSalesGM())) || !user.getDeptId().toString().equals(competitorEntity.getOwnDepartment() == null ? "" : competitorEntity.getOwnDepartment().toString()) || !((Integer)permissionFlagList.get(i)).equals(CommonConstant.unconfirmedPermission)) continue;
            permissionFlagList.set(i, CommonConstant.salesGM);
        }
        for (i = 0; i < competitorEntityList.size(); ++i) {
            competitorEntity = competitorEntityList.get(i);
            if (!userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getSalesDirector())) || !user.getDeptId().toString().equals(competitorEntity.getOwnDepartment() == null ? "" : competitorEntity.getOwnDepartment().toString()) || !((Integer)permissionFlagList.get(i)).equals(CommonConstant.unconfirmedPermission)) continue;
            permissionFlagList.set(i, CommonConstant.salesDirector);
        }
        for (i = 0; i < competitorEntityList.size(); ++i) {
            competitorEntity = competitorEntityList.get(i);
            if (!user.getUserId().toString().equals(competitorEntity.getChargePersonId() == null ? "" : competitorEntity.getChargePersonId().toString()) || !((Integer)permissionFlagList.get(i)).equals(CommonConstant.unconfirmedPermission)) continue;
            permissionFlagList.set(i, CommonConstant.salesman);
        }
        for (i = 0; i < competitorEntityList.size(); ++i) {
            competitorEntity = competitorEntityList.get(i);
            List teamList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)competitorEntity.getCompetitorId())).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"12"));
            if (!CollectionUtil.isNotEmpty((Collection)teamList)) continue;
            for (TeamMeberEntity teamMeberEntity : teamList) {
                Long l;
                if (!"1".equals(teamMeberEntity.getModifyPower())) continue;
                List<Map<String, Long>> struList2 = DataPermission.getStruCache();
                deptIds = DataPermission.getAllDeptIdByParentId(struList2, l = DataPermission.getParentIdByDeptId(struList2, user.getDeptId()));
                if (CollectionUtil.isNotEmpty(deptIds) && deptIds.contains(competitorEntity.getOwnDepartment() == null ? "" : competitorEntity.getOwnDepartment().toString()) && ((Integer)permissionFlagList.get(i)).equals(CommonConstant.unconfirmedPermission)) {
                    permissionFlagList.set(i, CommonConstant.salesman);
                }
                if (!((Integer)permissionFlagList.get(i)).equals(CommonConstant.unconfirmedPermission)) continue;
                permissionFlagList.set(i, CommonConstant.otherRole);
            }
            if (!((Integer)permissionFlagList.get(i)).equals(CommonConstant.unconfirmedPermission)) continue;
            permissionFlagList.set(i, CommonConstant.readOnly);
        }
        for (i = 0; i < competitorEntityList.size(); ++i) {
            competitorEntity = competitorEntityList.get(i);
            if (!StringUtil.isNotBlank((CharSequence)competitorEntity.getProductId())) continue;
            List<String> productIds = Arrays.asList(competitorEntity.getProductId().split(","));
            List<Long> businessIds = productIds.stream().map(Long::valueOf).collect(Collectors.toList());
            List<Map<String, Object>> productManagers = this.teamMeberMapper.selectProductTeamMemberByBusinessId(businessIds, "0");
            for (Map map : productManagers) {
                if (!user.getUserId().equals(map.get("personId")) || !((Integer)permissionFlagList.get(i)).equals(CommonConstant.unconfirmedPermission)) continue;
                permissionFlagList.set(i, CommonConstant.readOnly);
            }
        }
        if (DataPermission.isLeadship(userRoles, leadershipRoles) || userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getBgLeader())) || userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getSalesGM())) || userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getSalesDirector())) || userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getSalesman()))) {
            for (i = 0; i < permissionFlagList.size(); ++i) {
                if (!CommonConstant.unconfirmedPermission.equals(permissionFlagList.get(i))) continue;
                permissionFlagList.set(i, CommonConstant.readOnly);
            }
        }
        for (i = 0; i < permissionFlagList.size(); ++i) {
            if (!CommonConstant.unconfirmedPermission.equals(permissionFlagList.get(i))) continue;
            permissionFlagList.set(i, CommonConstant.noPermission);
        }
        return permissionFlagList;
    }

    @Override
    public Competitor selectRepeatCompetitor(CompetitorDto dto) {
        if (ToolUtil.isEmpty((Object)dto.getCompetitorName())) {
            return null;
        }
        Competitor competitor = ToolUtil.isEmpty((Object)dto.getCompetitorId()) ? (Competitor)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Competitor::getCompetitorName, (Object)dto.getCompetitorName())).eq(Competitor::getDelFlag, (Object)"0")) : (Competitor)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Competitor::getCompetitorName, (Object)dto.getCompetitorName())).eq(Competitor::getDelFlag, (Object)"0")).ne(Competitor::getCompetitorId, (Object)dto.getCompetitorId()));
        return competitor;
    }

    @Override
    public TransferBatchResultVo competitorTransferBatch(List<CompetitorDto> dtos) {
        Object teamMeberEntity;
        ArrayList<TeamMeberEntity> teamMeberEntityList;
        List competitorContactEntityList;
        ArrayList<String> msgList;
        TransferBatchResultVo resultVo = new TransferBatchResultVo();
        int dtoSize = dtos.size();
        int noPermissionNum = 0;
        int alreadyChargePersonNum = 0;
        ArrayList<CrmTeamAdminInfoDto> crmTeamAdminInfoDtoList = new ArrayList<CrmTeamAdminInfoDto>();
        String keepFlag = dtos.get(0).getKeepFlag();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getId();
        String userName = user.getUserName();
        String newChargePersonId = CommonUtills.translateUserId(dtos.get(0).getNewChargePersonId());
        PersonWithDepInfo mapDepartment = CommonUtills.selectDepIdName(newChargePersonId);
        Long newOwnDepartment = mapDepartment.getDepartmentId();
        String newOwnDepartmentName = mapDepartment.getDepartmentName();
        String newChargePersonName = dtos.get(0).getNewChargePersonName();
        List competitorIdList = dtos.stream().map(CompetitorDto::getCompetitorId).collect(Collectors.toList());
        List competitorEntityList = this.listByIds(competitorIdList);
        ArrayList<Long> excludeCompetitorIdList = new ArrayList<Long>();
        List<Integer> operateFlagList = this.competitorOperateBatch(competitorEntityList);
        for (int i = 0; i < operateFlagList.size(); ++i) {
            if (operateFlagList.get(i) >= 0) continue;
            excludeCompetitorIdList.add(((Competitor)competitorEntityList.get(i)).getCompetitorId());
            ++noPermissionNum;
        }
        for (Long excludeCompetitorId : excludeCompetitorIdList) {
            dtos = dtos.stream().filter(competitor -> !competitor.getCompetitorId().equals(excludeCompetitorId)).collect(Collectors.toList());
        }
        competitorIdList = dtos.stream().map(CompetitorDto::getCompetitorId).collect(Collectors.toList());
        competitorEntityList = ToolUtil.isNotEmpty(competitorIdList) ? this.listByIds(competitorIdList) : new ArrayList();
        ArrayList<CompetitorDto> dtoList = new ArrayList<CompetitorDto>();
        ArrayList<TeamMeberDto> teamMeberDtoList = new ArrayList<TeamMeberDto>();
        for (CompetitorDto dto : dtos) {
            Competitor competitorEntity = competitorEntityList.stream().filter(object -> Objects.equals(object.getCompetitorId(), dto.getCompetitorId())).findFirst().get();
            String oldChargePersonName = dto.getOldChargePersonName();
            String oldChargePersonId = dto.getOldChargePersonId();
            if (newChargePersonId.equals(oldChargePersonId) && newChargePersonName.equals(oldChargePersonName)) {
                ++alreadyChargePersonNum;
                continue;
            }
            dto.setChangeTime(date);
            dto.setChangePerson(userId);
            dto.setChangePersonName(userName);
            dto.setNewChargePersonId(newChargePersonId);
            dto.setNewChargePersonName(newChargePersonName);
            dto.setOwnDepartment(newOwnDepartment);
            dto.setOwnDepartmentName(newOwnDepartmentName);
            dto.setCompetitorName(competitorEntity.getCompetitorName());
            dtoList.add(dto);
            TeamMeberDto teamMeberDto = new TeamMeberDto();
            teamMeberDto.setBusinessId(dto.getCompetitorId());
            teamMeberDto.setPersonId(Long.parseLong(newChargePersonId));
            teamMeberDto.setDelFlag("0");
            teamMeberDtoList.add(teamMeberDto);
        }
        if (dtoList.size() + alreadyChargePersonNum == dtoSize) {
            resultVo.setTransferResult(true);
            msgList = new ArrayList<String>();
            msgList.add("\u8f6c\u79fb\u6210\u529f");
            resultVo.setMsgList(msgList);
        } else {
            resultVo.setTransferResult(false);
            msgList = new ArrayList();
            if (dtoSize == 1) {
                if (noPermissionNum != 0) {
                    msgList.add("\u8f6c\u79fb\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a\u65e0\u6743\u9650");
                }
                resultVo.setMsgList(msgList);
            } else {
                String msg2 = String.format("\u8f6c\u79fb\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761\u3002\u5931\u8d25\u539f\u56e0\uff1a", dtoList.size() + alreadyChargePersonNum, dtoSize - dtoList.size() - alreadyChargePersonNum);
                if (noPermissionNum != 0) {
                    msg2 = msg2 + "\u65e0\u6743\u9650";
                }
                msgList.add(msg2);
                resultVo.setMsgList(msgList);
            }
        }
        if (dtoList.isEmpty()) {
            return resultVo;
        }
        String contactFlag = ((CompetitorDto)dtoList.get(0)).getContactFlag();
        String keepContactFlag = ((CompetitorDto)dtoList.get(0)).getKeepContactFlag();
        competitorIdList = dtoList.stream().map(CompetitorDto::getCompetitorId).collect(Collectors.toList());
        if ("1".equals(contactFlag) && CollectionUtil.isNotEmpty((Collection)(competitorContactEntityList = this.crmCompetitorContactService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CrmCompetitorContact::getCompetitorId, competitorIdList)).eq(CrmCompetitorContact::getDelFlag, (Object)"0"))))) {
            ArrayList transferCompetitorContactList = new ArrayList();
            for (CrmCompetitorContact competitorContactEntity : competitorContactEntityList) {
                Long l = competitorContactEntity.getCompetitorContactId();
                CompetitorContactDto competitorContactDto = new CompetitorContactDto();
                competitorContactDto.setCompetitorContactId(l);
                competitorContactDto.setCompetitorContactName(competitorContactEntity.getCompetitorContactName());
                competitorContactDto.setOldChargePersonId(competitorContactEntity.getChargePersonId() == null ? null : competitorContactEntity.getChargePersonId().toString());
                competitorContactDto.setOldChargePersonName(competitorContactEntity.getChargePersonName());
                competitorContactDto.setNewChargePersonId(newChargePersonId);
                competitorContactDto.setNewChargePersonName(newChargePersonName);
                competitorContactDto.setKeepFlag(keepContactFlag);
                transferCompetitorContactList.add(competitorContactDto);
            }
            if (CollectionUtil.isNotEmpty((Collection)transferCompetitorContactList)) {
                TransferBatchResultVo competitorContactResultVo = this.competitorContactService.competitorContactTransferBatch(transferCompetitorContactList);
                if (ToolUtil.isNotEmpty((Object)competitorContactResultVo) && !competitorContactResultVo.getTransferResult().booleanValue()) {
                    resultVo.setTransferResult(false);
                    if (CollectionUtil.isNotEmpty(resultVo.getMsgList())) {
                        resultVo.setMsgList(resultVo.getMsgList().stream().map(msg -> "\u7ade\u4e89\u5bf9\u624b\uff1a" + msg).collect(Collectors.toList()));
                    }
                    if (CollectionUtil.isNotEmpty(competitorContactResultVo.getMsgList())) {
                        resultVo.getMsgList().addAll(competitorContactResultVo.getMsgList().stream().map(msg -> "\u7ade\u4e89\u5bf9\u624b\u8054\u7cfb\u4eba\uff1a" + msg).collect(Collectors.toList()));
                    }
                } else {
                    String msg3 = "\u7ade\u4e89\u5bf9\u624b\u8054\u7cfb\u4eba\uff1a\u8f6c\u79fb\u6210\u529f";
                    resultVo.getMsgList().add(msg3);
                }
            }
        }
        this.competitorMapper.updateChargePersonBatch(dtoList);
        if ("0".equals(keepFlag)) {
            teamMeberEntityList = new ArrayList<TeamMeberEntity>();
            for (CompetitorDto dto : dtoList) {
                teamMeberEntity = new TeamMeberEntity();
                ((TeamMeberEntity)((Object)teamMeberEntity)).setBusinessId(dto.getCompetitorId());
                ((TeamMeberEntity)((Object)teamMeberEntity)).setDelFlag("1");
                ((TeamMeberEntity)((Object)teamMeberEntity)).setPersonId(Long.valueOf(dto.getOldChargePersonId()));
                teamMeberEntityList.add((TeamMeberEntity)((Object)teamMeberEntity));
            }
            this.teamMeberMapper.deleteChargePersonBatch(teamMeberEntityList);
        } else if ("1".equals(keepFlag)) {
            teamMeberEntityList = new ArrayList();
            for (CompetitorDto dto : dtoList) {
                teamMeberEntity = new TeamMeberEntity();
                ((TeamMeberEntity)((Object)teamMeberEntity)).setBusinessId(dto.getCompetitorId());
                ((TeamMeberEntity)((Object)teamMeberEntity)).setPersonId(Long.valueOf(dto.getOldChargePersonId()));
                ((TeamMeberEntity)((Object)teamMeberEntity)).setIsCharge("0");
                ((TeamMeberEntity)((Object)teamMeberEntity)).setMemberRole("6");
                ((TeamMeberEntity)((Object)teamMeberEntity)).setModifyPower(null);
                teamMeberEntityList.add((TeamMeberEntity)((Object)teamMeberEntity));
            }
            this.teamMeberMapper.updateIsChargeBatch(teamMeberEntityList);
        }
        List<Map<String, Object>> existTeamMemberList = this.teamMeberMapper.selectTeamMeberListBatch(teamMeberDtoList);
        ArrayList<CompetitorDto> insertMemberDtoList = new ArrayList<CompetitorDto>();
        ArrayList<CompetitorDto> updateChargeDtoList = new ArrayList<CompetitorDto>();
        for (CompetitorDto competitorDto : dtoList) {
            boolean bl = true;
            for (Map<String, Object> map : existTeamMemberList) {
                if (!map.get("BUSINESS_ID").equals(competitorDto.getCompetitorId())) continue;
                updateChargeDtoList.add(competitorDto);
                bl = false;
                break;
            }
            if (!bl) continue;
            insertMemberDtoList.add(competitorDto);
        }
        if (ToolUtil.isNotEmpty(updateChargeDtoList)) {
            ArrayList<TeamMeberEntity> teamMeberEntityList2 = new ArrayList<TeamMeberEntity>();
            for (CompetitorDto competitorDto : updateChargeDtoList) {
                TeamMeberEntity teamMeberEntity2 = new TeamMeberEntity();
                teamMeberEntity2.setBusinessId(competitorDto.getCompetitorId());
                teamMeberEntity2.setPersonId(Long.valueOf(newChargePersonId));
                teamMeberEntity2.setIsCharge("1");
                teamMeberEntity2.setMemberRole(null);
                teamMeberEntity2.setModifyPower("1");
                teamMeberEntityList2.add(teamMeberEntity2);
            }
            this.teamMeberMapper.updateIsChargeBatch(teamMeberEntityList2);
        }
        if (ToolUtil.isNotEmpty(insertMemberDtoList)) {
            this.teamMeberService.insertTeamMemberBatch(newChargePersonName, Long.parseLong(newChargePersonId), insertMemberDtoList.stream().map(CompetitorDto::getCompetitorId).collect(Collectors.toList()), "1", "1", ((CompetitorDto)insertMemberDtoList.get(0)).getChangeTime(), "12");
        }
        ArrayList<Long> longOldChargePersonIdList = new ArrayList<Long>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CompetitorDto dto : dtoList) {
            longOldChargePersonIdList.add(Long.parseLong(dto.getOldChargePersonId()));
            arrayList.add(dto.getOldChargePersonName());
        }
        this.addTrackRecordBatch(dtoList, longOldChargePersonIdList, arrayList, newChargePersonId, newChargePersonName);
        for (CompetitorDto dto : dtoList) {
            String competitorName = dto.getCompetitorName();
            Long competitorId = dto.getCompetitorId();
            String oldChargePersonId = dto.getOldChargePersonId();
            String title = user.getUserName() + "\u5c06\u7ade\u4e89\u5bf9\u624b\u8d1f\u8d23\u4eba\u8f6c\u79fb\u7ed9\u4f60";
            String content = "\u7ade\u4e89\u5bf9\u624b\u3010" + competitorName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb";
            EimPushUtil.pushJqxArticleMessage(title, content, "/crm/jzds/jzdsxq", null, Arrays.asList(dto.getNewChargePersonId()));
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/opponentDetails?row=" + "\"" + dto.getCompetitorId() + "\"";
            String contentUnify = "\u3010\u8f6c\u79fb\u63d0\u9192\u3011" + userName + " \u5c06\u7ade\u4e89\u5bf9\u624b\u8d1f\u8d23\u4eba\u8f6c\u79fb\u7ed9\u4f60\uff0c\u7ade\u4e89\u5bf9\u624b\u3010" + competitorName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
            UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, dto.getNewChargePersonId(), user.getUserName(), unifyWebUrl, "");
            UnifyUtil.sendMessage(addSysMessageType);
            String oldTitle = userName + "\u8f6c\u79fb\u4e86\u60a8\u8d1f\u8d23\u7684\u7ade\u4e89\u5bf9\u624b";
            String oldContent = "\u7ade\u4e89\u5bf9\u624b\u540d\u79f0\u3010" + competitorName + "\u3011\u8f6c\u79fb\u7ed9" + newOwnDepartmentName + "-" + newChargePersonName + "\uff0c\u8bf7\u77e5\u6089\u3002";
            EimPushUtil.pushJqxArticleMessage(oldTitle, oldContent, "/crm/jzds/jzdsxq", null, Arrays.asList(oldChargePersonId));
            AddSysMessageType oldAddSysMessageType = new AddSysMessageType();
            String oldContentUnify = "\u3010\u8f6c\u79fb\u63d0\u9192\u3011" + userName + "\u5c06\u60a8\u8d1f\u8d23\u7684\u7ade\u4e89\u5bf9\u624b\u3010" + competitorName + "\u3011\u8f6c\u79fb\u7ed9" + newOwnDepartmentName + "-" + newChargePersonName + "\uff0c\u8bf7\u77e5\u6089\u3002";
            UnifyUtil.defaultMessage(oldAddSysMessageType, oldContentUnify, date, user, oldChargePersonId, user.getUserName(), unifyWebUrl, "");
            UnifyUtil.sendMessage(oldAddSysMessageType);
            CrmTeamAdminInfoDto crmTeamAdminInfoDto = new CrmTeamAdminInfoDto();
            crmTeamAdminInfoDto.setBusinessType("17");
            crmTeamAdminInfoDto.setBusinessId(competitorId);
            crmTeamAdminInfoDto.setNewChargePersonId(newChargePersonId);
            crmTeamAdminInfoDto.setOldChargePersonId(oldChargePersonId);
            crmTeamAdminInfoDto.setKeepFlag(dto.getKeepFlag());
            crmTeamAdminInfoDtoList.add(crmTeamAdminInfoDto);
        }
        this.imGroupMemberService.transferAdmin(crmTeamAdminInfoDtoList);
        return resultVo;
    }

    public void addTrackRecordBatch(List<CompetitorDto> dtoList, List<Long> oldChargePersonIdList, List<String> oldChargePersonNameList, String newChargePersonId, String newChargePersonName) {
        ArrayList<OperateRecordAPIVo> trackRecordList = new ArrayList<OperateRecordAPIVo>();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        for (int i = 0; i < dtoList.size(); ++i) {
            CompetitorDto dto = dtoList.get(i);
            OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
            operateRecordDO.setContactId(Long.valueOf(newChargePersonId));
            operateRecordDO.setContactName(newChargePersonName);
            operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_TRANSFER.getId());
            if (HussarUtils.isNotEmpty((Object)oldChargePersonIdList.get(i))) {
                operateRecordDO.setOldContactId(oldChargePersonIdList.get(i));
            }
            operateRecordDO.setOldContactName(oldChargePersonNameList.get(i));
            operateRecordDO.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
            operateRecordDO.setBusinessType(CrmBusinessTypeEnum.COMPETITOR.getId());
            operateRecordDO.setTypeId(dto.getCompetitorId());
            operateRecordDO.setBusinessName(dto.getCompetitorName());
            operateRecordDO.setCreatePerson(user.getUserId());
            operateRecordDO.setCreatePersonName(user.getUserName());
            operateRecordDO.setCreateTime(date);
            operateRecordDO.setChangePerson(user.getUserId());
            operateRecordDO.setChangeTime(date);
            operateRecordDO.setChangePersonName(user.getUserName());
            operateRecordDO.setDelflag("0");
            if (operateRecordDO.getProduceType() == null) {
                operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
            }
            trackRecordList.add(operateRecordDO);
        }
        this.operateRecordAPIService.saveOperateLogBatch(trackRecordList);
    }
}

