/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.utills;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.utills.HttpUnifyStatisticUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import com.jxdinfo.mp.im.model.ArticleBean;
import com.jxdinfo.mp.im.model.ArticleMsgBean;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.TextMsgBean;
import com.jxdinfo.mp.push.service.PushService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EimPushUtil {
    private static Logger log = LogManager.getLogger(EimPushUtil.class);
    private static final PushService pushService = new PushService();

    public static void pushJqxArticleMessage(String title, String content, String url, String bid, List<String> users) {
        CompletableFuture.runAsync(() -> {
            CrmCommonProperties properties = (CrmCommonProperties)SpringUtils.getBean(CrmCommonProperties.class);
            if (properties.isEimpush()) {
                if (StringUtil.isEmpty((Object)title) || StringUtil.isEmpty((Object)content) || StringUtil.isEmpty((Object)url)) {
                    log.error("\u6d88\u606f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
                    return;
                }
                if (users == null || users.size() == 0) {
                    log.error("\u672a\u8bbe\u7f6e\u63a8\u9001\u8303\u56f4");
                } else {
                    List<String> sendUsers = EimPushUtil.converUsers(users);
                    if (sendUsers.size() == 0) {
                        log.error("\u8bbe\u7f6e\u7684\u63a8\u9001\u8303\u56f4\u65e0\u6548");
                        return;
                    }
                    try {
                        String objid = UUID.randomUUID().toString().toUpperCase();
                        ArrayList<ArticleBean> articleBeanList = new ArrayList<ArticleBean>();
                        ArticleBean articleBean = new ArticleBean();
                        articleBean.setArticleMsgId(objid);
                        articleBean.setBid(bid);
                        articleBean.setLinkType(ArticleBean.LinkType.HYBRID);
                        articleBean.setUrl(url);
                        articleBean.setSubTitle(content);
                        articleBean.setTitle(title);
                        articleBean.setObjID(UUID.randomUUID().toString().toUpperCase());
                        articleBeanList.add(articleBean);
                        ArticleMsgBean msgBean = pushService.buildArticleMsgBean(articleBeanList);
                        msgBean.setBody(title);
                        pushService.postMessage((BaseMsgBean)msgBean, sendUsers);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                    }
                }
            }
        });
    }

    public static void pushJqxTextMessage(String content, List<String> users) {
        CrmCommonProperties properties = (CrmCommonProperties)SpringUtils.getBean(CrmCommonProperties.class);
        if (properties.isEimpush()) {
            if (StringUtil.isEmpty((Object)content)) {
                log.error("\u6d88\u606f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
                return;
            }
            if (users == null || users.size() == 0) {
                log.error("\u672a\u8bbe\u7f6e\u63a8\u9001\u8303\u56f4");
            } else {
                List<String> sendUsers = EimPushUtil.converUsers(users);
                if (sendUsers.size() == 0) {
                    log.error("\u8bbe\u7f6e\u7684\u63a8\u9001\u8303\u56f4\u65e0\u6548");
                    return;
                }
                try {
                    TextMsgBean msgBean = pushService.buildTextMsgBean(content);
                    pushService.postMessage((BaseMsgBean)msgBean, sendUsers);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
        }
    }

    private static List<String> converUsers(List<String> users) {
        ISysUsersService usersService = (ISysUsersService)SpringUtils.getBean(ISysUsersService.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.in((Object)"USER_ID", users)).or()).in((Object)"CHAR_1", users);
        List userList = usersService.list((Wrapper)queryWrapper);
        ArrayList<String> sendUsers = new ArrayList<String>();
        for (SysUsers user : userList) {
            sendUsers.add(user.getChar1());
        }
        return sendUsers;
    }

    public static ApiResponse post(String uri, Map<String, Object> param) {
        ApiResponse response = null;
        try {
            String clientToken = HttpUnifyStatisticUtil.getUnifyToken(false);
            if (ToolUtil.isEmpty((Object)clientToken)) {
                log.error("\u53d1\u9001\u83b7\u53d6token\u8bf7\u6c42\u5931\u8d25!");
            } else {
                response = HttpUnifyStatisticUtil.request(uri, param, clientToken, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25uri:{},param:{}", (Object)uri, param);
        }
        return response;
    }
}

