/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.partner.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.core.customer.dao.CustomerMapper;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.message.config.WxMpProperty;
import com.jxdinfo.crm.core.message.dao.ShortMessageRecordMapper;
import com.jxdinfo.crm.core.message.dto.SMSGDTO;
import com.jxdinfo.crm.core.message.model.ShortMessageRecord;
import com.jxdinfo.crm.core.message.service.ShortMessageRecordService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunity.vo.OpportunityVo;
import com.jxdinfo.crm.core.partner.service.PartnerService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.mysql.cj.util.StringUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PartnerServiceImpl
extends ServiceImpl<ShortMessageRecordMapper, ShortMessageRecord>
implements PartnerService {
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private ShortMessageRecordService shortMessageRecordService;
    @Autowired
    private OpportunityService opportunityService;
    @Autowired
    private WxMpProperty wxMpProperty;
    @Autowired
    private CustomerService customerService;

    @Override
    public ApiResponse<Boolean> binding(SMSGDTO smsgdto) {
        String phoneNumber = smsgdto.getMobilePhone();
        String code = smsgdto.getCode();
        String openId = smsgdto.getOpenId();
        ApiResponse<Boolean> apiResponse = this.shortMessageRecordService.checkVerificationCode(phoneNumber, code);
        if (!"OK".equals(apiResponse.getMsg())) {
            return apiResponse;
        }
        LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper1.eq(CustomerEntity::getTelephone, (Object)phoneNumber)).eq(CustomerEntity::getDelFlag, (Object)"0")).like(CustomerEntity::getCustomerType, (Object)2);
        List list1 = this.customerService.list((Wrapper)queryWrapper1);
        if (HussarUtils.isEmpty((Object)list1)) {
            return ApiResponse.fail((String)"\u672a\u627e\u5230\u5408\u4f5c\u4f19\u4f34");
        }
        for (CustomerEntity customer : list1) {
            if (HussarUtils.isNotEmpty((Object)customer.getOpenId())) {
                return ApiResponse.fail((String)"\u8be5\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a\u5176\u4ed6\u5fae\u4fe1");
            }
            customer.setOpenId(openId);
        }
        this.customerService.updateBatchById(list1);
        return ApiResponse.success((String)"OK");
    }

    @Override
    public ApiResponse<List<OpportunityVo>> getOpportunityList(String openId, String opportunityName) {
        if (HussarUtils.isEmpty((Object)openId)) {
            return ApiResponse.fail((String)"openid\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(CustomerEntity::getOpenId, (Object)openId)).eq(CustomerEntity::getDelFlag, (Object)"0");
        List customerEntityList = this.customerMapper.selectList((Wrapper)queryWrapper);
        ArrayList<OpportunityVo> list = new ArrayList<OpportunityVo>();
        for (CustomerEntity customerEntity : customerEntityList) {
            list.addAll(this.opportunityService.selectOpportunityByPartnerId(customerEntity.getCustomerId(), opportunityName));
        }
        return ApiResponse.success(list);
    }

    @Override
    public ApiResponse<Map<String, String>> checkWeChatCode(String code) {
        HashMap<String, String> map = new HashMap<String, String>();
        String appid = "wxe7e2a867bbe4dcd2";
        String secret = "37b4bb2a06b96ab3c3c864c33edde6f8";
        String openId = "";
        try {
            String resultJson;
            URL url = new URL("https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + appid + "&secret=" + secret + "&code=" + code + "&grant_type=authorization_code");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                return ApiResponse.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((resultJson = br.readLine()) != null) {
                JSONObject paramsJSONObject = JSONObject.parseObject((String)resultJson);
                openId = paramsJSONObject.getString("openid");
            }
            conn.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtils.isNullOrEmpty((String)openId)) {
            return ApiResponse.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        map.put("openId", openId);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(CustomerEntity::getOpenId, (Object)openId)).eq(CustomerEntity::getDelFlag, (Object)"0");
        List list = this.customerMapper.selectList((Wrapper)queryWrapper);
        if (list.size() > 0) {
            map.put("isBinding", "true");
        } else {
            map.put("isBinding", "false");
        }
        return ApiResponse.success(map);
    }
}

