/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.partner.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.message.dto.SMSGDTO;
import com.jxdinfo.crm.core.message.service.ShortMessageRecordService;
import com.jxdinfo.crm.core.opportunity.vo.OpportunityVo;
import com.jxdinfo.crm.core.partner.service.PartnerService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/partner"})
@Api(tags={"\u5408\u4f5c\u4f19\u4f34\u76f8\u5173\u64cd\u4f5c"})
public class PartnerController {
    private static final Logger log = LoggerFactory.getLogger(PartnerController.class);
    private static Logger logger = LoggerFactory.getLogger(PartnerController.class);
    @Resource
    private PartnerService partnerService;
    @Resource
    private CustomerService customerService;
    @Resource
    private ShortMessageRecordService shortMessageRecordService;

    @ApiOperation(value="\u53d1\u9001\u9a8c\u8bc1\u7801")
    @PostMapping(value={"/sendCode"})
    public ApiResponse<Boolean> sendShortMessageCode(@RequestBody SMSGDTO smsgdto) {
        return this.shortMessageRecordService.sendShortMsg(smsgdto.getMobilePhone());
    }

    @ApiOperation(value="\u7ed1\u5b9a")
    @PostMapping(value={"binding/mobilePhone"})
    public ApiResponse<Boolean> checkShortMessage(@RequestBody SMSGDTO smsgdto) {
        return this.partnerService.binding(smsgdto);
    }

    @ApiOperation(value="\u83b7\u53d6\u5546\u673a\u5217\u8868")
    @PostMapping(value={"opportunityList"})
    public ApiResponse<List<OpportunityVo>> getOpportunityList(@RequestBody String params) {
        JSONObject paramsJSONObject = JSONObject.parseObject((String)params);
        String openId = paramsJSONObject.getString("openId");
        String opportunityName = paramsJSONObject.getString("opportunityName");
        return this.partnerService.getOpportunityList(openId, opportunityName);
    }

    @ApiOperation(value="\u6839\u636e\u5fae\u4fe1code\u5224\u65ad\u7528\u6237\u662f\u5426\u7ed1\u5b9a\u5408\u4f5c\u4f19\u4f34")
    @PostMapping(value={"checkWeChatCode"})
    public ApiResponse<Map<String, String>> checkWeChatCode(@RequestBody String codeJson) {
        JSONObject paramsJSONObject = JSONObject.parseObject((String)codeJson);
        String code = paramsJSONObject.getString("code");
        if (code == null) {
            throw new RuntimeException("\u53c2\u6570code\u4e3anull");
        }
        return this.partnerService.checkWeChatCode(code);
    }
}

