/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.leads.service.impl;

import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.leads.dao.LeadsPermissionMapper;
import com.jxdinfo.crm.core.leads.service.ILeadsPermissionService;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class LeadsPermissionServiceImpl
implements ILeadsPermissionService {
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private LeadsPermissionMapper leadsPermissionMapper;

    @Override
    public List<Long> getLeadsIdListByPermission(Long userId) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        if (userId == null) {
            IndexUtil.currentUserRolePermissions(permissionDto, this.crmProperties);
        } else {
            CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
            IndexUtil.getUserRolePermissionsByUserId(permissionDto, this.crmProperties, userId);
        }
        if (permissionDto.getPermissionDeptIds() == null && permissionDto.getPermissionUserId() == null) {
            return null;
        }
        List<Long> leadsIdList = this.leadsPermissionMapper.getLeadsIdList(permissionDto);
        if (CollectionUtil.isEmpty(leadsIdList)) {
            leadsIdList.add(-1L);
        }
        return leadsIdList;
    }
}

