/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.index.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.organUser.IUserBoService;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.index.dao.CrmIndexMapper;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.ListUtil;
import com.jxdinfo.crm.core.provincerole.dao.ProvinceRoleMapper;
import com.jxdinfo.crm.core.provincerole.model.ProvinceRole;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.entity.DateConvertVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class IndexUtil {
    public static void currentUserRolePermissions(SalesStatisticsDto dto, CrmCommonProperties crmProperties) {
        SecurityUser user = BaseSecurityUtil.getUser();
        IndexUtil.currentUserRolePermissionsNew(dto, crmProperties, "", user.getUserId(), user.getDeptId(), user.getRolesList());
    }

    public static void getUserRolePermissionsByUserId(SalesStatisticsDto dto, CrmCommonProperties crmProperties, Long userId) {
        IUserBoService iUserBoService = (IUserBoService)SpringUtils.getBean(IUserBoService.class);
        SecurityUser user = iUserBoService.selectSecurityByUserId(userId);
        IndexUtil.currentUserRolePermissionsNew(dto, crmProperties, "", user.getUserId(), user.getDeptId(), user.getRolesList());
    }

    public static void currentUserRolePermissionsNew(SalesStatisticsDto dto, CrmCommonProperties crmProperties, String moduleCode, Long userId, Long deptId, List<Long> userRoles) {
        dto.setCurrentUserId(userId);
        if (userRoles.contains(Long.valueOf(crmProperties.getRoles().getMarketingManager()))) {
            dto.setCurrentDeptId(deptId);
        }
        dto.setPermissionProductIds(DataPermission.getPermissionProduct(userId));
        List<Map<String, Long>> struList = DataPermission.getStruCache();
        List<Long> leadershipRoles = DataPermission.getLeadershipRoles();
        if (userRoles.contains(Long.valueOf(crmProperties.getRoles().getCompanyLeader()))) {
            dto.setPermissionDeptIds(null);
        } else if (DataPermission.isLeadship(userRoles, leadershipRoles)) {
            List<String> struIds = DataPermission.getLeadershipBGList(userId);
            ArrayList<String> deptIdList = new ArrayList<String>();
            if (CollectionUtil.isNotEmpty(struIds)) {
                for (String struId : struIds) {
                    List<String> deptIds = DataPermission.getAllDeptIdByParentId(struList, Long.valueOf(struId));
                    deptIdList.addAll(deptIds);
                }
            }
            List<Long> deptLongIds = deptIdList.stream().map(Long::valueOf).collect(Collectors.toList());
            ProvinceRoleMapper provinceRoleMapper = (ProvinceRoleMapper)SpringUtils.getBean(ProvinceRoleMapper.class);
            List provinceRoles = provinceRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().in(ProvinceRole::getRoleId, userRoles));
            if (CollectionUtil.isNotEmpty((Collection)provinceRoles)) {
                dto.setPermissionProvinceIds(provinceRoles.stream().map(ProvinceRole::getProvinceId).collect(Collectors.toList()));
            }
            dto.setPermissionDeptIds(deptLongIds);
        } else if (userRoles.contains(Long.valueOf(crmProperties.getRoles().getBgLeader())) || moduleCode.equals("selectCrmCampaignList")) {
            Long parentId = DataPermission.getParentIdByDeptId(struList, deptId);
            List<String> deptIds = DataPermission.getAllDeptIdByParentId(struList, parentId);
            List<Long> deptLongIds = deptIds.stream().map(Long::valueOf).collect(Collectors.toList());
            dto.setPermissionDeptIds(deptLongIds);
        } else if (userRoles.contains(Long.valueOf(crmProperties.getRoles().getSalesGM())) || userRoles.contains(Long.valueOf(crmProperties.getRoles().getSalesDirector()))) {
            dto.setPermissionDeptIds(Collections.singletonList(deptId));
        } else {
            dto.setPermissionDeptIds(null);
            dto.setPermissionUserId(userId);
        }
    }

    public static void getCurrentTimeRange(SalesStatisticsDto dto) {
        DateConvertVo dateConvertVo;
        if (StringUtil.isEmpty((Object)dto.getTimeRange())) {
            dto.setTimeRange("3");
        }
        if ((dateConvertVo = IndexUtil.getCurrentTime(dto.getTimeRange())) != null) {
            dto.setStartTime(dateConvertVo.getStartDate());
            dto.setEndTime(dateConvertVo.getEndDate());
        }
        dto.setDate(DateUtil.today());
    }

    @Deprecated
    public static DateConvertVo getCurrentTime(String timeRange) {
        DateConvertVo dateConvertVo = null;
        if ("1".equals(timeRange)) {
            dateConvertVo = CommonUtills.getWeekDate();
        } else if ("11".equals(timeRange)) {
            dateConvertVo = CommonUtills.getLastWeekDate();
        } else if ("8".equals(timeRange)) {
            dateConvertVo = CommonUtills.getNextWeekDate();
        } else if ("12".equals(timeRange)) {
            dateConvertVo = CommonUtills.getLastMonthDay();
        } else if ("2".equals(timeRange)) {
            dateConvertVo = CommonUtills.getMonthDay();
        } else if ("9".equals(timeRange)) {
            dateConvertVo = CommonUtills.getNextMonthDay();
        } else if ("4".equals(timeRange)) {
            dateConvertVo = CommonUtills.getYearDay();
        } else if ("7".equals(timeRange)) {
            dateConvertVo = CommonUtills.getLastYearDay();
        } else if ("5".equals(timeRange)) {
            dateConvertVo = CommonUtills.getNextYearDay();
        } else if ("13".equals(timeRange)) {
            dateConvertVo = CommonUtills.getYesterday();
        } else if ("0".equals(timeRange)) {
            dateConvertVo = CommonUtills.getToday();
        }
        return dateConvertVo;
    }

    @Deprecated
    public static void getLastTimeRange(SalesStatisticsDto dto) {
        DateConvertVo dateConvertVo = null;
        if ("1".equals(dto.getTimeRange())) {
            dateConvertVo = CommonUtills.getLastWeekDate();
        } else if ("11".equals(dto.getTimeRange())) {
            dateConvertVo = CommonUtills.getLastWeekDate();
            dateConvertVo.setStartDate(DateUtil.format((Date)DateUtil.minusWeeks((Date)DateUtil.parse((String)dateConvertVo.getStartDate(), (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
            dateConvertVo.setEndDate(DateUtil.format((Date)DateUtil.minusWeeks((Date)DateUtil.parse((String)dateConvertVo.getEndDate(), (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
        } else if ("2".equals(dto.getTimeRange())) {
            dateConvertVo = CommonUtills.getLastMonthDay();
        } else if ("12".equals(dto.getTimeRange())) {
            dateConvertVo = CommonUtills.getLastMonthDay();
            dateConvertVo.setStartDate(DateUtil.format((Date)DateUtil.minusMonths((Date)DateUtil.parse((String)dateConvertVo.getStartDate(), (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
            dateConvertVo.setEndDate(DateUtil.format((Date)DateUtil.minusMonths((Date)DateUtil.parse((String)dateConvertVo.getEndDate(), (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
        } else if ("4".equals(dto.getTimeRange())) {
            dateConvertVo = CommonUtills.getLastYearDay();
        } else if ("7".equals(dto.getTimeRange())) {
            dateConvertVo = CommonUtills.getLastYearDay();
            dateConvertVo.setStartDate(DateUtil.format((Date)DateUtil.plusYears((Date)DateUtil.parse((String)dateConvertVo.getStartDate(), (String)"yyyy-MM-dd"), (int)-1), (String)"yyyy-MM-dd"));
            dateConvertVo.setEndDate(DateUtil.format((Date)DateUtil.plusYears((Date)DateUtil.parse((String)dateConvertVo.getEndDate(), (String)"yyyy-MM-dd"), (int)-1), (String)"yyyy-MM-dd"));
        }
        if (dateConvertVo != null) {
            dto.setStartTime(dateConvertVo.getStartDate());
            dto.setEndTime(dateConvertVo.getEndDate());
        }
        dto.setDate(DateUtil.format((Date)DateUtil.plusYears((Date)new Date(), (int)-1), (String)"yyyy-MM-dd"));
    }

    public static List<String> getSubDeptId(List<String> deptIdList) {
        CrmIndexMapper indexMapper = (CrmIndexMapper)SpringUtils.getBean(CrmIndexMapper.class);
        List<String> newDeptIdList = indexMapper.getSubDeptIdAndCurDeptId(ListUtil.listToString(deptIdList, ","));
        if (newDeptIdList.size() > deptIdList.size()) {
            return IndexUtil.getSubDeptId(newDeptIdList);
        }
        return newDeptIdList;
    }
}

