/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.datarightmanage.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.core.datarightmanage.dao.DataRightManageMapper;
import com.jxdinfo.crm.core.datarightmanage.dto.DataRightManageDto;
import com.jxdinfo.crm.core.datarightmanage.model.DataRightManageEntity;
import com.jxdinfo.crm.core.datarightmanage.service.DataRightManageService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class DataRightManageServiceImpl
extends ServiceImpl<DataRightManageMapper, DataRightManageEntity>
implements DataRightManageService {
    @Resource
    private DataRightManageMapper dataRightManageMapper;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;

    @Override
    public Page<DataRightManageEntity> selectDataRightManageList(DataRightManageDto dto) {
        Page page = dto.getPage();
        dto.setDelFlag("0");
        List<DataRightManageEntity> list = this.dataRightManageMapper.selectDataRightManageList(page, dto);
        page.setRecords(list);
        return page;
    }

    @Override
    public Integer updateDelFlagByIds(List<Long> ids) {
        int num = this.dataRightManageMapper.updateDelFlagByIds(ids, "1");
        return num;
    }

    @Override
    public Boolean addCrmDataRightManage(Map<String, Object> map) {
        String businessId = map.get("businessId").toString();
        String personIds = map.get("personIds").toString();
        String dataRightManageNames = map.get("dataRightManageNames").toString();
        String modifyPower = map.get("modifyPower").toString();
        String isCharge = map.get("isCharge").toString();
        String[] personIdArr = personIds.split(",");
        String[] dataRightManageNameArr = dataRightManageNames.split(",");
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        ArrayList<DataRightManageEntity> list = new ArrayList<DataRightManageEntity>();
        for (int i = 0; i < personIdArr.length; ++i) {
            String dataRightManageId = CommonUtills.generateAssignId();
            DataRightManageEntity dataRightManageEntity = new DataRightManageEntity();
            dataRightManageEntity.setDataRightManageId(Long.valueOf(dataRightManageId));
            dataRightManageEntity.setDataRightManageName(dataRightManageNameArr[i]);
            dataRightManageEntity.setPersonId(Long.valueOf(personIdArr[i]));
            dataRightManageEntity.setBusinessId(Long.valueOf(businessId));
            dataRightManageEntity.setModifyPower(modifyPower);
            dataRightManageEntity.setIsCharge(isCharge);
            dataRightManageEntity.setDataRightManageId(Long.valueOf(dataRightManageId));
            dataRightManageEntity.setCreatePerson(user.getId());
            dataRightManageEntity.setCreatePersonName(user.getName());
            dataRightManageEntity.setCreateTime(date);
            list.add(dataRightManageEntity);
        }
        if (!this.saveBatch(list)) {
            return false;
        }
        ArrayList<OperateRecordAPIVo> operateRecordDOList = new ArrayList<OperateRecordAPIVo>();
        for (DataRightManageEntity dataRightManageEntity : list) {
            OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
            String recordId = CommonUtills.generateAssignId();
            operateRecordDO.setRecordId(Long.valueOf(recordId));
            operateRecordDO.setBusinessType(CrmBusinessTypeEnum.TEAM_MEMBER.getId());
            operateRecordDO.setTypeId(Long.valueOf(dataRightManageEntity.getDataRightManageId()));
            operateRecordDO.setBusinessName(dataRightManageEntity.getDataRightManageName());
            operateRecordDO.setContactId(null);
            operateRecordDO.setContactName(null);
            operateRecordDO.setRecordType(null);
            operateRecordDO.setRecordContent(null);
            operateRecordDO.setCreatePerson(user.getId());
            operateRecordDO.setCreatePersonName(user.getName());
            operateRecordDO.setCreateTime(date);
            operateRecordDO.setDelflag("0");
            operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
            operateRecordDOList.add(operateRecordDO);
        }
        if (this.operateRecordAPIService.saveOperateLogBatch(operateRecordDOList).booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    @Transactional
    public Boolean saveCrmDataRightManage(DataRightManageEntity dataRightManageEntity) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        if (StringUtils.isEmpty((Object)dataRightManageEntity.getDataRightManageId())) {
            String dataRightManageId = CommonUtills.generateAssignId();
            dataRightManageEntity.setDataRightManageId(Long.valueOf(dataRightManageId));
            dataRightManageEntity.setCreatePerson(user.getId());
            dataRightManageEntity.setCreatePersonName(user.getName());
            dataRightManageEntity.setCreateTime(date);
        } else {
            dataRightManageEntity.setUpdatePerson(user.getId());
            dataRightManageEntity.setUpdatePersonName(user.getName());
            dataRightManageEntity.setUpdateTime(date);
        }
        this.saveOrUpdate((Object)dataRightManageEntity);
        this.operateRecordAPIService.saveOperateLog(null, CrmBusinessTypeEnum.TEAM_MEMBER, dataRightManageEntity.getDataRightManageId(), dataRightManageEntity.getDataRightManageName(), date, false, Arrays.asList(dataRightManageEntity.getDataRightManageId(), dataRightManageEntity.getBusinessId()));
        return true;
    }
}

