/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunity.external.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordViewAPIVo;
import com.jxdinfo.crm.core.api.opportunity.dto.OpportunityQueryDto;
import com.jxdinfo.crm.core.api.opportunity.dto.OpportunityQueryNoPageDto;
import com.jxdinfo.crm.core.api.opportunity.dto.OpportunityStatisticsDto;
import com.jxdinfo.crm.core.api.opportunity.dto.SalesKPIRuleDto;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityAPIService;
import com.jxdinfo.crm.core.api.opportunity.vo.NewAdditionCountVo;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityAPIVo;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityCreatorVo;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityStageVo;
import com.jxdinfo.crm.core.api.opportunity.vo.SOBCFollowerVo;
import com.jxdinfo.crm.core.api.opportunity.vo.SOBCProductVo;
import com.jxdinfo.crm.core.api.opportunity.vo.SalesKPIScopeVo;
import com.jxdinfo.crm.core.api.opportunity.vo.SelectOppoInfoByContractIdVo;
import com.jxdinfo.crm.core.api.product.vo.ProductSellPriceApiVo;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageTypeDto;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.common.vo.UserInfoVo;
import com.jxdinfo.crm.core.competitoranalysis.model.CompetitorAnalysis;
import com.jxdinfo.crm.core.competitoranalysis.service.CompetitorAnalysisService;
import com.jxdinfo.crm.core.contactcharacter.model.ContactCharacterEntity;
import com.jxdinfo.crm.core.contactcharacter.service.ContactCharacterService;
import com.jxdinfo.crm.core.contract.model.CrmContractProduct;
import com.jxdinfo.crm.core.contract.service.CrmContractService;
import com.jxdinfo.crm.core.contract.vo.CrmContractVo;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.model.CrmOpportunity2;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.service.CrmOpportunity2Service;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypooloppo.model.OpportunityPoolOppo;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypooloppo.service.OpportunityPoolOppoService;
import com.jxdinfo.crm.core.fileinfo.model.FileInfo;
import com.jxdinfo.crm.core.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityStageMapper;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityDto;
import com.jxdinfo.crm.core.opportunity.external.dao.OpportunityApiMapper;
import com.jxdinfo.crm.core.opportunity.external.dao.OpportunitySalesKPIMapper;
import com.jxdinfo.crm.core.opportunity.external.dto.OpptyAPIDto;
import com.jxdinfo.crm.core.opportunity.external.util.SalesKPIEnum;
import com.jxdinfo.crm.core.opportunity.external.vo.SalesKPIVo;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.service.GlobalOpportunityService;
import com.jxdinfo.crm.core.opportunity.service.IOpportunityPermissionService;
import com.jxdinfo.crm.core.opportunity.service.IOpportunitySelectService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.mongodb.lang.Nullable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OpportunityAPIServiceImpl
implements IOpportunityAPIService {
    @Resource
    private OpportunityStageMapper opportunityStageMapper;
    @Resource
    private OpportunitySalesKPIMapper opportunitySalesKPIMapper;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private ISysOrganService organService;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private CommonService commonService;
    @Resource
    private ISysStruService struService;
    @Resource
    private IOrganUserBoService organUserBoService;
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private ISysUsersService usersService;
    @Resource
    private ISysUserRoleService userRoleService;
    @Resource
    private OpportunityPoolOppoService opportunityPoolOppoService;
    @Resource
    private ContactCharacterService contactCharacterService;
    @Resource
    private FileInfoService fileInfoService;
    @Resource
    private CompetitorAnalysisService competitorAnalysisService;
    @Resource
    private OpportunityApiMapper opportunityApiMapper;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private IOpportunityPermissionService opportunityPermissionService;
    @Resource
    private IOpportunitySelectService opportunitySelectService;
    @Resource
    private GlobalOpportunityService globalOpportunityService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private IStageProcessApiService stageProcessApiService;
    @Resource
    private CrmOpportunity2Service crmOpportunity2Service;
    @Resource
    private CrmContractService contractService;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;

    public ApiResponse<List<OpportunityStageVo>> getOpportunityStage() {
        List<OpportunityStageVo> list = this.opportunityStageMapper.selectStandardOpportunityStage();
        return ApiResponse.success(list);
    }

    public ApiResponse<List<SalesKPIScopeVo>> getKPI(SalesKPIRuleDto dto) {
        SysStru stru;
        dto.setEndDate(dto.getAnalyseDate().plusMonths(11L).with(TemporalAdjusters.lastDayOfMonth()));
        LocalDate startTime = dto.getAnalyseDate();
        ArrayList<SalesKPIScopeVo> kpiScopeVoList = new ArrayList<SalesKPIScopeVo>();
        ArrayList<SalesKPIVo> list = new ArrayList();
        ArrayList<SalesKPIVo> winList = new ArrayList<SalesKPIVo>();
        if (CollectionUtil.isEmpty((Collection)dto.getCheckObjectList())) {
            return null;
        }
        List<Object> departments = new ArrayList();
        ArrayList<List<Long>> deptCidsList = new ArrayList<List<Long>>();
        List<SysStru> struList = new ArrayList();
        if ("1".equals(dto.getCheckObjectType())) {
            struList = this.struService.list((Wrapper)new LambdaQueryWrapper().in(SysStru::getId, (Collection)dto.getCheckObjectList()));
            List struIdList = struList.stream().map(SysStru::getId).collect(Collectors.toList());
            departments = dto.getCheckObjectList().stream().map(Long::parseLong).collect(Collectors.toList());
            for (int i = 0; i < departments.size(); ++i) {
                if (struIdList.contains(departments.get(i))) continue;
                departments.remove(i);
                --i;
            }
            dto.setCheckObjectList(departments.stream().map(Object::toString).collect(Collectors.toList()));
            if (ToolUtil.isNotEmpty(departments)) {
                for (Long l : departments) {
                    List organByParentIdContainsParent = this.organUserBoService.getOrganByParentIdContainsParent(Collections.singletonList(l));
                    deptCidsList.add(organByParentIdContainsParent);
                }
            }
        }
        if (SalesKPIEnum.CUSTOMER_FOLLOWUP.getId().equals(dto.getCheckIndex()) || SalesKPIEnum.BUSINESS_OPPORTUNITY_FOLLOWUP.getId().equals(dto.getCheckIndex()) || SalesKPIEnum.NEW_LEADS_RECORD.getId().equals(dto.getCheckIndex())) {
            if ("1".equals(dto.getCheckObjectType())) {
                for (int i = 0; i < deptCidsList.size(); ++i) {
                    Long l = (Long)departments.get(i);
                    List<SalesKPIVo> listTemp = this.opportunitySalesKPIMapper.selectCustomerFollowupKPI(dto, (List)deptCidsList.get(i));
                    stru = (SysStru)struList.stream().filter(sysStru -> deptId2.equals(sysStru.getId())).collect(Collectors.toList()).get(0);
                    listTemp.forEach(t -> {
                        t.setObjectID(stru.getId());
                        t.setObjectName(stru.getOrganAlias());
                    });
                    list.addAll(listTemp);
                }
            } else {
                list = this.opportunitySalesKPIMapper.selectCustomerFollowupKPI(dto, null);
            }
            this.getScore(list, startTime, dto, kpiScopeVoList, struList);
        } else if (SalesKPIEnum.NEW_BUSINESS_OPPORTUNITIES.getId().equals(dto.getCheckIndex())) {
            if ("1".equals(dto.getCheckObjectType())) {
                for (int i = 0; i < deptCidsList.size(); ++i) {
                    List<SalesKPIVo> listTemp = this.opportunitySalesKPIMapper.selectNewOpportunitiesNumber(dto, (List)deptCidsList.get(i));
                    Long l = (Long)departments.get(i);
                    stru = (SysStru)struList.stream().filter(sysStru -> deptId2.equals(sysStru.getId())).collect(Collectors.toList()).get(0);
                    listTemp.forEach(t -> {
                        t.setObjectID(stru.getId());
                        t.setObjectName(stru.getOrganAlias());
                    });
                    list.addAll(listTemp);
                }
            } else {
                list = this.opportunitySalesKPIMapper.selectNewOpportunitiesNumber(dto, null);
            }
            this.getScore(list, startTime, dto, kpiScopeVoList, struList);
        } else if (SalesKPIEnum.BUSINESS_OPPORTUNITY_AMOUNT.getId().equals(dto.getCheckIndex())) {
            this.successDataProcessor(dto, deptCidsList, departments, struList, startTime, list, winList, kpiScopeVoList, dto.getCheckIndex());
        } else if (SalesKPIEnum.PRODUCT_SALES_VOLUME.getId().equals(dto.getCheckIndex())) {
            this.successDataProcessor(dto, deptCidsList, departments, struList, startTime, list, winList, kpiScopeVoList, dto.getCheckIndex());
        } else if (SalesKPIEnum.PRODUCT_SALES_REVENUE.getId().equals(dto.getCheckIndex())) {
            this.successDataProcessor(dto, deptCidsList, departments, struList, startTime, list, winList, kpiScopeVoList, dto.getCheckIndex());
        } else if (!SalesKPIEnum.CONTRACT_AMOUNT.getId().equals(dto.getCheckIndex()) && !SalesKPIEnum.RECEIVED_PAYMENTS.getId().equals(dto.getCheckIndex())) {
            if (SalesKPIEnum.COMPLETED_OPPORTUNITY_AMOUNT.getId().equals(dto.getCheckIndex())) {
                this.successDataProcessor(dto, deptCidsList, departments, struList, startTime, list, winList, kpiScopeVoList, dto.getCheckIndex());
            } else if (SalesKPIEnum.NEW_CUSTOMER.getId().equals(dto.getCheckIndex())) {
                if ("1".equals(dto.getCheckObjectType())) {
                    for (int i = 0; i < deptCidsList.size(); ++i) {
                        List<SalesKPIVo> listTemp = this.opportunitySalesKPIMapper.selectNewCustomerNumber(dto, (List)deptCidsList.get(i));
                        Long l = (Long)departments.get(i);
                        stru = (SysStru)struList.stream().filter(sysStru -> deptId2.equals(sysStru.getId())).collect(Collectors.toList()).get(0);
                        listTemp.forEach(t -> {
                            t.setObjectID(stru.getId());
                            t.setObjectName(stru.getOrganAlias());
                        });
                        list.addAll(listTemp);
                    }
                } else {
                    list = this.opportunitySalesKPIMapper.selectNewCustomerNumber(dto, null);
                }
                this.getScore(list, startTime, dto, kpiScopeVoList, struList);
            } else if (SalesKPIEnum.NEW_LEADS.getId().equals(dto.getCheckIndex())) {
                if ("1".equals(dto.getCheckObjectType())) {
                    for (int i = 0; i < deptCidsList.size(); ++i) {
                        List<SalesKPIVo> listTemp = this.opportunitySalesKPIMapper.selectNewLeadsNumber(dto, (List)deptCidsList.get(i));
                        Long l = (Long)departments.get(i);
                        stru = (SysStru)struList.stream().filter(sysStru -> deptId2.equals(sysStru.getId())).collect(Collectors.toList()).get(0);
                        listTemp.forEach(t -> {
                            t.setObjectID(stru.getId());
                            t.setObjectName(stru.getOrganAlias());
                        });
                        list.addAll(listTemp);
                    }
                } else {
                    list = this.opportunitySalesKPIMapper.selectNewLeadsNumber(dto, null);
                }
                this.getScore(list, startTime, dto, kpiScopeVoList, struList);
            }
        }
        return ApiResponse.success(kpiScopeVoList);
    }

    /*
     * WARNING - void declaration
     */
    private void successDataProcessor(SalesKPIRuleDto dto, List<List<Long>> deptCidsList, List<Long> departments, List<SysStru> struList, LocalDate startTime, List<SalesKPIVo> list, List<SalesKPIVo> winList, List<SalesKPIScopeVo> kpiScopeVoList, String checkIndex) {
        SalesKPIRuleDto winDto = new SalesKPIRuleDto();
        BeanUtil.copyProperties((Object)dto, (Object)winDto);
        ArrayList<String> stageIds = dto.getStageIds();
        boolean winFlag = false;
        List allWinStageList = this.opportunityStageMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityStage::getStageType, (Object)"20")).eq(OpportunityStage::getDelFlag, (Object)"0")).stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        ArrayList<String> winStageIdList = new ArrayList<String>();
        block0: for (String string : stageIds) {
            for (Long winStageId : allWinStageList) {
                if (!winStageId.toString().equals(string)) continue;
                winStageIdList.add(string);
                continue block0;
            }
        }
        ArrayList<String> tempStage = new ArrayList<String>();
        for (String stageId : stageIds) {
            if (winStageIdList.contains(stageId)) continue;
            tempStage.add(stageId);
        }
        stageIds = tempStage;
        if (CollectionUtil.isNotEmpty(winStageIdList)) {
            winDto.setStageIds(winStageIdList);
            winDto.setAnalyseDateType("2");
            winFlag = true;
            dto.setStageIds(stageIds);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<SalesKPIScopeVo> kpiScopeVoListWin = new ArrayList<SalesKPIScopeVo>();
        if ("1".equals(dto.getCheckObjectType())) {
            ArrayList<SalesKPIScopeVo> kpiScopeVoListWinTemp = new ArrayList<SalesKPIScopeVo>();
            for (int i2 = 0; i2 < deptCidsList.size(); ++i2) {
                Long deptId = departments.get(i2);
                SysStru stru = (SysStru)struList.stream().filter(sysStru -> deptId.equals(sysStru.getId())).collect(Collectors.toList()).get(0);
                if (winFlag) {
                    void var16_19;
                    if (SalesKPIEnum.BUSINESS_OPPORTUNITY_AMOUNT.getId().equals(checkIndex)) {
                        List<SalesKPIVo> list2 = this.opportunitySalesKPIMapper.selectAmount(winDto, deptCidsList.get(i2), "1");
                    } else if (SalesKPIEnum.PRODUCT_SALES_VOLUME.getId().equals(checkIndex)) {
                        List<SalesKPIVo> list3 = this.opportunitySalesKPIMapper.selectVolume(winDto, deptCidsList.get(i2), "1");
                    } else if (SalesKPIEnum.PRODUCT_SALES_REVENUE.getId().equals(checkIndex)) {
                        List<SalesKPIVo> list4 = this.opportunitySalesKPIMapper.selectProductSalesRevenue(winDto, deptCidsList.get(i2), "1");
                    } else if (SalesKPIEnum.COMPLETED_OPPORTUNITY_AMOUNT.getId().equals(checkIndex)) {
                        List<SalesKPIVo> list5 = this.opportunitySalesKPIMapper.selectCompletedOpportunitiesNumber(winDto, deptCidsList.get(i2), "1");
                    }
                    var16_19.forEach(t -> {
                        t.setObjectID(stru.getId());
                        t.setObjectName(stru.getOrganAlias());
                    });
                    winList.addAll((Collection<SalesKPIVo>)var16_19);
                }
                List<Object> listTemp = new ArrayList();
                if (CollectionUtil.isNotEmpty((Collection)dto.getStageIds())) {
                    if (SalesKPIEnum.BUSINESS_OPPORTUNITY_AMOUNT.getId().equals(checkIndex)) {
                        listTemp = this.opportunitySalesKPIMapper.selectAmount(dto, deptCidsList.get(i2), "0");
                    } else if (SalesKPIEnum.PRODUCT_SALES_VOLUME.getId().equals(checkIndex)) {
                        listTemp = this.opportunitySalesKPIMapper.selectVolume(dto, deptCidsList.get(i2), "0");
                    } else if (SalesKPIEnum.PRODUCT_SALES_REVENUE.getId().equals(checkIndex)) {
                        listTemp = this.opportunitySalesKPIMapper.selectProductSalesRevenue(dto, deptCidsList.get(i2), "0");
                    } else if (SalesKPIEnum.COMPLETED_OPPORTUNITY_AMOUNT.getId().equals(checkIndex)) {
                        listTemp = this.opportunitySalesKPIMapper.selectCompletedOpportunitiesNumber(dto, deptCidsList.get(i2), "0");
                    }
                }
                listTemp.forEach(t -> {
                    t.setObjectID(stru.getId());
                    t.setObjectName(stru.getOrganAlias());
                });
                list.addAll(listTemp);
            }
            this.getScore(winList, startTime, dto, kpiScopeVoListWinTemp, struList);
            kpiScopeVoListWin.addAll(kpiScopeVoListWinTemp);
        } else {
            if (winFlag) {
                if (SalesKPIEnum.BUSINESS_OPPORTUNITY_AMOUNT.getId().equals(checkIndex)) {
                    winList = this.opportunitySalesKPIMapper.selectAmount(winDto, null, "1");
                } else if (SalesKPIEnum.PRODUCT_SALES_VOLUME.getId().equals(checkIndex)) {
                    winList = this.opportunitySalesKPIMapper.selectVolume(winDto, null, "1");
                } else if (SalesKPIEnum.PRODUCT_SALES_REVENUE.getId().equals(checkIndex)) {
                    winList = this.opportunitySalesKPIMapper.selectProductSalesRevenue(winDto, null, "1");
                } else if (SalesKPIEnum.COMPLETED_OPPORTUNITY_AMOUNT.getId().equals(checkIndex)) {
                    winList = this.opportunitySalesKPIMapper.selectCompletedOpportunitiesNumber(winDto, null, "1");
                }
                this.getScore(winList, startTime, dto, kpiScopeVoListWin, struList);
            }
            if (CollectionUtil.isNotEmpty((Collection)dto.getStageIds())) {
                if (SalesKPIEnum.BUSINESS_OPPORTUNITY_AMOUNT.getId().equals(checkIndex)) {
                    list = this.opportunitySalesKPIMapper.selectAmount(dto, null, "0");
                } else if (SalesKPIEnum.PRODUCT_SALES_VOLUME.getId().equals(checkIndex)) {
                    list = this.opportunitySalesKPIMapper.selectVolume(dto, null, "0");
                } else if (SalesKPIEnum.PRODUCT_SALES_REVENUE.getId().equals(checkIndex)) {
                    list = this.opportunitySalesKPIMapper.selectProductSalesRevenue(dto, null, "0");
                } else if (SalesKPIEnum.COMPLETED_OPPORTUNITY_AMOUNT.getId().equals(checkIndex)) {
                    list = this.opportunitySalesKPIMapper.selectCompletedOpportunitiesNumber(dto, null, "0");
                }
            }
        }
        this.getScore(list, startTime, dto, kpiScopeVoList, struList);
        if (CollectionUtil.isNotEmpty(kpiScopeVoListWin)) {
            block4: for (SalesKPIScopeVo vo : kpiScopeVoList) {
                for (SalesKPIScopeVo vo1 : kpiScopeVoListWin) {
                    if (!vo.getObjectId().equals(vo1.getObjectId())) continue;
                    vo.setKPIScore(IntStream.range(0, vo.getKPIScore().size()).mapToObj(i -> {
                        BigDecimal sum = (BigDecimal)vo.getKPIScore().get(i);
                        sum = sum.add((BigDecimal)vo1.getKPIScore().get(i));
                        return sum;
                    }).collect(Collectors.toList()));
                    continue block4;
                }
            }
        }
    }

    private void countFull(Map<Long, List<SalesKPIVo>> map, LocalDate time, SalesKPIRuleDto dto, List<SalesKPIScopeVo> kpiScopeVoList) {
        for (Map.Entry<Long, List<SalesKPIVo>> entry : map.entrySet()) {
            LocalDate startTime = time;
            List<SalesKPIVo> tempList = entry.getValue();
            ArrayList<BigDecimal> scoreList = new ArrayList<BigDecimal>();
            for (int i = 0; i < tempList.size(); ++i) {
                LocalDate tempDate = YearMonth.parse(tempList.get(i).getDateGroup(), DateTimeFormatter.ofPattern("yyyy-MM")).atDay(1);
                while (tempDate.getYear() > startTime.getYear() || tempDate.getYear() == startTime.getYear() && tempDate.getMonth().compareTo(startTime.getMonth()) > 0) {
                    scoreList.add(BigDecimal.valueOf(0.0));
                    startTime = startTime.plusMonths(1L);
                }
                scoreList.add(new BigDecimal(tempList.get(i).getCount()));
                startTime = startTime.plusMonths(1L);
                if (i != tempList.size() - 1) continue;
                while (startTime.isBefore(dto.getEndDate())) {
                    scoreList.add(BigDecimal.valueOf(0L));
                    startTime = startTime.plusMonths(1L);
                }
            }
            SalesKPIScopeVo scopeVo = new SalesKPIScopeVo();
            scopeVo.setKPIScore(scoreList);
            scopeVo.setObjectId(tempList.get(0).getObjectID());
            scopeVo.setObjectName(tempList.get(0).getObjectName());
            kpiScopeVoList.add(scopeVo);
        }
    }

    private void countGroupByDateType(String checkCycle, List<SalesKPIScopeVo> kpiScopeVoList) {
        block10: {
            block11: {
                block9: {
                    if (!"1".equals(checkCycle)) break block9;
                    for (SalesKPIScopeVo vo : kpiScopeVoList) {
                        vo.setKPIScore(Collections.singletonList(vo.getKPIScore().stream().reduce(BigDecimal.ZERO, BigDecimal::add)));
                    }
                    break block10;
                }
                if (!"2".equals(checkCycle)) break block11;
                for (SalesKPIScopeVo vo : kpiScopeVoList) {
                    List scoreList = vo.getKPIScore();
                    ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
                    for (int i = 0; i < scoreList.size(); i += 6) {
                        BigDecimal score = new BigDecimal(0.0);
                        if (i < 7) {
                            for (int j = i; j < i + 6 && j < scoreList.size(); ++j) {
                                score = score.add((BigDecimal)scoreList.get(j));
                            }
                        }
                        list.add(score);
                    }
                    vo.setKPIScore(list);
                }
                break block10;
            }
            if (!"3".equals(checkCycle)) break block10;
            for (SalesKPIScopeVo vo : kpiScopeVoList) {
                List scoreList = vo.getKPIScore();
                ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
                for (int i = 0; i < scoreList.size(); i += 3) {
                    BigDecimal score = new BigDecimal(0.0);
                    if (i < 10) {
                        for (int j = i; j < i + 3 && j < scoreList.size(); ++j) {
                            score = score.add((BigDecimal)scoreList.get(j));
                        }
                    }
                    list.add(score);
                }
                vo.setKPIScore(list);
            }
        }
    }

    private void getScore(List<SalesKPIVo> list, LocalDate startTime, final SalesKPIRuleDto dto, List<SalesKPIScopeVo> kpiScopeVoList, List<SysStru> struList) {
        if (HussarUtils.isNotEmpty(list)) {
            Map<Long, List<SalesKPIVo>> map = list.stream().collect(Collectors.groupingBy(SalesKPIVo::getObjectID));
            this.countFull(map, startTime, dto, kpiScopeVoList);
            if (!"4".equals(dto.getCheckCycle())) {
                this.countGroupByDateType(dto.getCheckCycle(), kpiScopeVoList);
            }
        }
        Map userMap = new HashMap();
        if ("2".equals(dto.getCheckObjectType())) {
            userMap = this.hussarBaseUserBoService.getUserInfo(dto.getCheckObjectList().stream().map(Long::parseLong).collect(Collectors.toList()));
        }
        for (final String id : dto.getCheckObjectList()) {
            SysUsers user;
            if (list.stream().map(SalesKPIVo::getObjectID).collect(Collectors.toList()).contains(Long.parseLong(id))) continue;
            String name = null;
            if ("1".equals(dto.getCheckObjectType())) {
                name = ((SysStru)struList.stream().filter(sysStru -> id.equals(sysStru.getId().toString())).collect(Collectors.toList()).get(0)).getOrganAlias();
            } else if (userMap != null && (user = (SysUsers)userMap.get(Long.parseLong(id))) != null) {
                name = user.getUserName();
            }
            final String finalName = name != null ? name : "";
            kpiScopeVoList.add(new SalesKPIScopeVo(){
                {
                    int length;
                    this.setObjectId(Long.parseLong(id));
                    this.setObjectName(finalName);
                    switch (dto.getCheckCycle()) {
                        case "1": {
                            length = 1;
                            break;
                        }
                        case "2": {
                            length = 2;
                            break;
                        }
                        case "3": {
                            length = 4;
                            break;
                        }
                        default: {
                            length = 12;
                        }
                    }
                    this.setKPIScore(Collections.nCopies(length, new BigDecimal(0)));
                }
            });
        }
    }

    public ApiResponse<Object> selectOpportunityListByPermission(Map<String, Object> body) {
        Long userId = null;
        if (!HussarUtils.isNotEmpty((Object)body.get("userId"))) {
            return null;
        }
        userId = HussarUtils.toLong((Object)body.get("userId"));
        List roleList = this.userRoleService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId));
        SysUsers users = this.usersService.getUser(userId);
        if (users == null) {
            return null;
        }
        long current = HussarUtils.toLong((Object)body.get("current"));
        long size = HussarUtils.toLong((Object)body.get("size"));
        SalesStatisticsDto permissionDto = this.opportunityOperate(roleList, users);
        Page page = new Page();
        page.setCurrent(current);
        page.setSize(size);
        String name = HussarUtils.toStr((Object)body.get("name"));
        name = name.replaceAll("%", "/%").replaceAll("_", "/_");
        Page<OpportunityAPIVo> opportunityAPIVoList = this.opportunityMapper.selectIdAndNameByPermission((Page<OpportunityAPIVo>)page, permissionDto, name);
        return ApiResponse.success(opportunityAPIVoList);
    }

    public OpportunityAPIVo selectOneOverride(Long id) {
        OpportunityEntity opportunity = (OpportunityEntity)this.opportunityMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityEntity::getOpportunityId, (Object)id)).eq(OpportunityEntity::getDelFlag, (Object)"0"));
        if (opportunity == null) {
            opportunity = (OpportunityEntity)BeanUtil.copy((Object)this.opportunityPoolOppoService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityPoolOppo::getOpportunityId, (Object)id)).eq(OpportunityPoolOppo::getDelFlag, (Object)"0")), OpportunityEntity.class);
        }
        return (OpportunityAPIVo)BeanUtil.copy((Object)opportunity, OpportunityAPIVo.class);
    }

    public List<OpportunityAPIVo> selectListIfNullAll(List<Long> ids, OpportunityStatisticsDto dto) {
        List<OpportunityEntity> opportunityEntityList = this.opportunitySelectService.selectListIfNullAll(ids, dto);
        return BeanUtil.copy(opportunityEntityList, OpportunityAPIVo.class);
    }

    public Page<OpportunityAPIVo> selectListIfNullAll(List<Long> ids, OpportunityStatisticsDto dto, Page<OpportunityAPIVo> page) {
        Page opportunityEntityPage = new Page();
        opportunityEntityPage.setSize(page.getSize());
        opportunityEntityPage.setCurrent(page.getCurrent());
        Page<OpportunityEntity> opportunityPage = this.opportunitySelectService.selectListIfNullAll(ids, dto, (Page<OpportunityEntity>)opportunityEntityPage);
        if (opportunityPage != null) {
            page.setRecords(BeanUtil.copy((Collection)opportunityPage.getRecords(), OpportunityAPIVo.class));
            page.setTotal(opportunityPage.getTotal());
        }
        return page;
    }

    public List<OpportunityAPIVo> selectList(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return null;
        }
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(OpportunityEntity::getOpportunityId, ids)).eq(OpportunityEntity::getDelFlag, (Object)"0");
        List opportunityEntityList = this.opportunityMapper.selectList((Wrapper)lambdaQueryWrapper);
        return BeanUtil.copy((Collection)opportunityEntityList, OpportunityAPIVo.class);
    }

    public Page<OpportunityAPIVo> selectList(OpportunityQueryDto opportunityQueryDto) {
        return this.opportunityService.selectList(opportunityQueryDto);
    }

    public void update(Long typeId, String endTime, String opportunityAmount, String opportunityWinRate) {
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(OpportunityEntity::getOpportunityId, (Object)typeId)).eq(OpportunityEntity::getDelFlag, (Object)"0");
        if (HussarUtils.isNotEmpty((Object)endTime)) {
            wrapper.set(OpportunityEntity::getEndTime, (Object)endTime);
        }
        if (HussarUtils.isNotEmpty((Object)opportunityAmount)) {
            wrapper.set(OpportunityEntity::getOpportunityAmount, (Object)opportunityAmount);
        }
        if (HussarUtils.isNotEmpty((Object)opportunityWinRate)) {
            wrapper.set(OpportunityEntity::getOpportunityWinRate, (Object)opportunityWinRate);
        }
        this.opportunityService.update((Wrapper)wrapper);
    }

    public OpportunityAPIVo getById(Long id) {
        return (OpportunityAPIVo)BeanUtil.copy((Object)this.opportunityService.getById(id), OpportunityAPIVo.class);
    }

    public void updateById(OpportunityAPIVo opportunityEntity) {
        this.opportunityService.updateById(BeanUtil.copy((Object)opportunityEntity, OpportunityEntity.class));
    }

    public List<String> opportunityProductManagerList(Long opportunityId, String delFlagNo, Long productId) {
        return this.opportunityMapper.opportunityProductManagerList(opportunityId, delFlagNo, productId);
    }

    public List<OpportunityAPIVo> selectByCustomerIdAndStageAndTime(List<Long> customerIdList, List<Long> productId, String stageId, LocalDateTime startTime, LocalDateTime endTime) {
        if (CollectionUtil.isEmpty(customerIdList)) {
            return null;
        }
        List<OpportunityEntity> opportunityEntityList = this.opportunityMapper.selectByCustomerIdAndStageAndTime(customerIdList, productId, stageId, startTime, endTime);
        return BeanUtil.copy(opportunityEntityList, OpportunityAPIVo.class);
    }

    public List<OpportunityAPIVo> selectWinByCustomerIdAndTime(List<Long> customerIdList, List<Long> productId, LocalDateTime startTime, LocalDateTime endTime) {
        if (CollectionUtil.isEmpty(customerIdList)) {
            return null;
        }
        List<Long> winStages = this.opportunityStageMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityStage::getStageType, (Object)"20")).eq(OpportunityStage::getDelFlag, (Object)"0")).stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        return this.opportunityMapper.selectWinByCustomerIdAndTime(customerIdList, productId, winStages, startTime, endTime);
    }

    public Map<Long, Integer> selectOpportunityAmountByCustomerId(List<Long> customerIdList) {
        if (CollectionUtil.isEmpty(customerIdList)) {
            return null;
        }
        HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        List<Map<String, Object>> mapList = this.opportunityMapper.selectCountByCustomerId(customerIdList);
        if (CollectionUtil.isNotEmpty(mapList)) {
            for (Map<String, Object> map : mapList) {
                result.put((Long)map.get("CUSTOMER_ID"), ((Long)map.get("COUNT")).intValue());
            }
        }
        return result;
    }

    public List<OpportunityAPIVo> selectByChargePersonIdList(List<Long> userIdList) {
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageAbandon(true);
        List stageAbandon = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageAbandon();
        List list = this.opportunityService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(OpportunityEntity::getChargePersonId, userIdList)).eq(OpportunityEntity::getDelFlag, (Object)"0")).notIn(OpportunityEntity::getCustomerStageId, (Collection)stageAbandon));
        if (CollectionUtil.isEmpty((Collection)list)) {
            return null;
        }
        List voList = BeanUtil.copy((Collection)list, OpportunityAPIVo.class);
        List oppoIdList = list.stream().map(OpportunityEntity::getOpportunityId).collect(Collectors.toList());
        List fileOppoIdList = this.fileInfoService.list((Wrapper)new LambdaQueryWrapper().in(FileInfo::getBusinessId, oppoIdList)).stream().map(FileInfo::getBusinessId).collect(Collectors.toList());
        List contactCharacterOppoIdList = this.contactCharacterService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ContactCharacterEntity::getOpportunityId, oppoIdList)).eq(ContactCharacterEntity::getDelFlag, (Object)"0")).stream().map(contactCharacterEntity -> Long.parseLong(contactCharacterEntity.getOpportunityId())).collect(Collectors.toList());
        List competitorOppoId = this.competitorAnalysisService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CompetitorAnalysis::getOpportunityId, oppoIdList)).eq(CompetitorAnalysis::getDelFlag, (Object)"0")).stream().map(CompetitorAnalysis::getOpportunityId).collect(Collectors.toList());
        for (OpportunityAPIVo vo : voList) {
            vo.setAnnexExist(Boolean.valueOf(fileOppoIdList.contains(vo.getOpportunityId())));
            vo.setContactCharacterExist(Boolean.valueOf(contactCharacterOppoIdList.contains(vo.getOpportunityId())));
            vo.setCompetitorExist(Boolean.valueOf(competitorOppoId.contains(vo.getOpportunityId())));
        }
        return voList;
    }

    private SalesStatisticsDto opportunityOperate(List<SysUserRole> roleList, SysUsers users) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        IndexUtil.currentUserRolePermissionsNew(permissionDto, this.crmProperties, "", users.getId(), users.getDepartmentId(), roleList.stream().map(SysUserRole::getGrantedRole).collect(Collectors.toList()));
        if (roleList.stream().map(SysUserRole::getGrantedRole).collect(Collectors.toList()).contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
            permissionDto.setPermissionDeptIds(null);
            permissionDto.setPermissionUserId(null);
        }
        return permissionDto;
    }

    public List<OpportunityAPIVo> selectOpportunityListForNoCode(Page<OpportunityAPIVo> page) {
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        List stageWin = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin();
        CrmBaseConfigVo tqkg = this.crmBaseConfigBoService.getCrmBaseConfigByKey("stage_config");
        List<Long> tqkgList = Arrays.stream(tqkg.getConfigValue().split(",")).map(Long::parseLong).collect(Collectors.toList());
        List deptList = this.organUserBoService.getOrganByParentIdContainsParent(Arrays.asList(100058L));
        List<OpportunityAPIVo> opportunityAPIVoList = this.opportunityApiMapper.selectOpportunityListForNoCode(page, deptList, stageWin, tqkgList);
        List dicList = this.sysDicRefService.getDicListByType("leads_state");
        for (OpportunityAPIVo opportunityAPIVo : opportunityAPIVoList) {
            String stateLabel = ToolUtil.isNotEmpty(dicList.stream().filter(dic -> dic.getValue().equals(opportunityAPIVo.getState())).collect(Collectors.toList())) ? ((DicVo)dicList.stream().filter(dic -> dic.getValue().equals(opportunityAPIVo.getState())).collect(Collectors.toList()).get(0)).getLabel() : "";
            opportunityAPIVo.setStateLabel(stateLabel);
        }
        return opportunityAPIVoList;
    }

    public Page<ProductSellPriceApiVo> selectProductSellPriceListNoCode(Page<ProductSellPriceApiVo> page) {
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        List stageWin = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin();
        CrmBaseConfigVo tqkg = this.crmBaseConfigBoService.getCrmBaseConfigByKey("stage_config");
        List<Long> tqkgList = Arrays.stream(tqkg.getConfigValue().split(",")).map(Long::parseLong).collect(Collectors.toList());
        List deptList = this.organUserBoService.getOrganByParentIdContainsParent(Arrays.asList(100058L));
        List<ProductSellPriceApiVo> list = this.opportunityApiMapper.selectProductSellPriceListNoCode(page, deptList, stageWin, tqkgList);
        page.setRecords(list);
        return page;
    }

    public Page<ProductSellPriceApiVo> selectProductSellPriceListQuarterNoCode(Page<ProductSellPriceApiVo> page) {
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        List stageWin = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin();
        List deptList = this.organUserBoService.getOrganByParentIdContainsParent(Arrays.asList(100058L));
        List<ProductSellPriceApiVo> list = this.opportunityApiMapper.selectProductSellPriceListQuarterNoCode(page, deptList, stageWin);
        page.setRecords(list);
        return page;
    }

    public NewAdditionCountVo getSaleCountToday(Long userId, String startTime, String endTime) {
        return this.opportunityApiMapper.getSaleCountToday(userId, startTime, endTime);
    }

    public List<Long> getOpportunityIdList(@Nullable Long userId) {
        return this.opportunityPermissionService.getOpportunityIdListByPermission(userId);
    }

    public List<Long> getOpportunityIdList() {
        return this.opportunityPermissionService.getOpportunityIdListByPermission(null);
    }

    public Object selectCrmOpportunityListNoPermission(Map<String, Object> map, Page<OpportunityAPIVo> page) {
        Page entityPage = new Page();
        if (ToolUtil.isNotEmpty(page)) {
            entityPage.setSize(page.getSize());
            entityPage.setCurrent(page.getCurrent());
        } else {
            entityPage = null;
        }
        ArrayList<OpportunityDto> dtoList = new ArrayList<OpportunityDto>();
        OpportunityDto dto = (OpportunityDto)BeanUtil.copy(map, OpportunityDto.class);
        dto.setDelFlag("0");
        if (ToolUtil.isEmpty((Object)dto.getOpportunityView())) {
            dto.setOpportunityView("excludeProcessing");
        }
        dtoList.add(dto);
        String timeOrder = (String)map.get("timeOrder");
        List<OpportunityEntity> list = this.opportunityMapper.selectCrmOpportunityList(entityPage, null, dtoList, null, timeOrder, null, null);
        List voList = BeanUtil.copy(list, OpportunityAPIVo.class);
        if (ToolUtil.isNotEmpty(page)) {
            page = (Page)BeanUtil.copy((Object)entityPage, Page.class);
            page.setRecords(voList);
            return page;
        }
        return voList;
    }

    public List<OpportunityAPIVo> selectOpportunityByCustomer(Long customerId) {
        OpportunityDto opportunityDto = new OpportunityDto();
        opportunityDto.setCustomerId(customerId.toString());
        List<OpportunityEntity> opportunityEntityList = this.globalOpportunityService.selectCrmOpportunityListNoPage(opportunityDto, false);
        if (CollectionUtil.isNotEmpty(opportunityEntityList)) {
            return BeanUtil.copyProperties(opportunityEntityList, OpportunityAPIVo.class);
        }
        return null;
    }

    public List<OpportunityAPIVo> selectOpportunityByCustomerIdList(List<Long> customerIdList) {
        List opportunityEntityList = this.opportunityService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(OpportunityEntity::getCustomerId, customerIdList)).eq(OpportunityEntity::getDelFlag, (Object)"0"));
        return BeanUtil.copy((Collection)opportunityEntityList, OpportunityAPIVo.class);
    }

    public List<OpportunityAPIVo> selectOpptyPortraitUsedList(Map<String, Object> map) {
        OpptyAPIDto dto = (OpptyAPIDto)BeanUtil.copy(map, OpptyAPIDto.class);
        assert (dto != null);
        dto.setDelFlag("0");
        List<OpportunityEntity> list = this.opportunityMapper.selectOpptyPortraitUsedList(dto);
        List voList = BeanUtil.copy(list, OpportunityAPIVo.class);
        if (HussarUtils.isNotEmpty((Object)voList)) {
            return voList;
        }
        return new ArrayList<OpportunityAPIVo>();
    }

    public void saveOrUpdateBatch(List<OpportunityAPIVo> opptyList) {
        this.opportunityService.updateBatchById(BeanUtil.copy(opptyList, OpportunityEntity.class));
    }

    public List<OpportunityStageVo> getOpportunityStageForSalesKpi() {
        CrmBaseConfigVo config = this.crmBaseConfigBoService.getCrmBaseConfigByKey("sales_kpi_stage");
        List<Long> stageList = Arrays.stream(config.getConfigValue().split(",")).map(Long::parseLong).collect(Collectors.toList());
        return this.opportunityStageMapper.getOpportunityStageForSalesKpi(stageList);
    }

    public void editOpportunity(Map<String, Object> paramMap, Long opportunityId) {
        CrmOpportunity2 opportunity = (CrmOpportunity2)this.crmOpportunity2Service.getById(opportunityId);
        this.opportunityService.mapToEntity(paramMap, opportunity);
        this.crmOpportunity2Service.insertOrUpdate(opportunity);
    }

    public List<OpportunityAPIVo> selectOpportunityForWallChart(Page<OpportunityAPIVo> page, OpportunityQueryNoPageDto queryDto) {
        return this.opportunityService.selectOpportunityForWallChart(page, queryDto);
    }

    public Integer selectOpportunityCountForWallChart(OpportunityQueryNoPageDto queryDto) {
        return this.opportunityService.selectOpportunityCountForWallChart(queryDto);
    }

    public SelectOppoInfoByContractIdVo selectOpportunityInfoByContractId(String yyzcContractId) {
        CrmContractVo contractVo = this.contractService.selectContractProductListByYyzcContractId(yyzcContractId);
        List recordList = this.trackRecordAPIService.getTrackRecordDetailsBatch(Collections.singletonList(contractVo.getOpportunityId()), "2");
        OpportunityEntity opportunity = (OpportunityEntity)this.opportunityService.getById(contractVo.getOpportunityId());
        UserInfoVo userInfo = this.commonService.getUserInfo(opportunity.getCreatePerson());
        SelectOppoInfoByContractIdVo vo = new SelectOppoInfoByContractIdVo();
        vo.setOpportunityId(opportunity.getOpportunityId());
        vo.setOpportunityName(opportunity.getOpportunityName());
        ArrayList<SOBCProductVo> productVoList = new ArrayList<SOBCProductVo>();
        ArrayList<OpportunityCreatorVo> creatorVoList = new ArrayList<OpportunityCreatorVo>();
        for (CrmContractProduct product : contractVo.getContractProductList()) {
            SOBCProductVo productVo = new SOBCProductVo();
            productVo.setProductName(product.getProductName());
            productVo.setProductEffeValue(product.getThisSignAmount());
            productVo.setProductDepartment(product.getOwnDepartmentName());
            productVoList.add(productVo);
            OpportunityCreatorVo creator = new OpportunityCreatorVo();
            creator.setFinderName(opportunity.getCreatePersonName());
            creator.setFinderDepartment(userInfo.getStruName());
            creator.setFinderId(opportunity.getCreatePerson());
            creator.setFinderDepartmentId(userInfo.getStruId());
            creator.setProductName(product.getProductName());
            creator.setProductEffeValue(product.getThisSignAmount());
            creatorVoList.add(creator);
        }
        vo.setProductList(productVoList);
        vo.setCreatorList(creatorVoList);
        ArrayList<SOBCFollowerVo> followerVoList = new ArrayList<SOBCFollowerVo>();
        HashSet<String> createPersonNameSet = new HashSet<String>();
        for (TrackRecordViewAPIVo record : recordList) {
            if (createPersonNameSet.contains(record.getCreatePersonName())) continue;
            for (SOBCProductVo productVo : productVoList) {
                SOBCFollowerVo followerVo = new SOBCFollowerVo();
                followerVo.setProductName(productVo.getProductName());
                followerVo.setProductEffeValue(productVo.getProductEffeValue());
                followerVo.setFollowerName(record.getCreatePersonName());
                followerVo.setFollowerId(record.getCreatePerson());
                followerVo.setFollowerDepartment(record.getDepartmentName());
                followerVo.setFollowerDepartmentId(record.getDepartmentId());
                followerVoList.add(followerVo);
                createPersonNameSet.add(record.getCreatePersonName());
            }
        }
        vo.setFollowerList(followerVoList);
        return vo;
    }
}

