/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.leads.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.label.common.LabelModuleEnum;
import com.jxdinfo.crm.common.api.label.service.ILabelService;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.core.associativeQuery.dto.AssociativeKeyword;
import com.jxdinfo.crm.core.associativeQuery.service.AssociativeQueryService;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.common.vo.AssociativeQueryVo;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.focus.dao.FocusMapper;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.leads.dao.LeadsMapper;
import com.jxdinfo.crm.core.leads.dao.LeadsOriginMapper;
import com.jxdinfo.crm.core.leads.dto.LeadsOriginAssociativeQueryDto;
import com.jxdinfo.crm.core.leads.dto.LeadsOriginDto;
import com.jxdinfo.crm.core.leads.model.Leads;
import com.jxdinfo.crm.core.leads.model.LeadsOrigin;
import com.jxdinfo.crm.core.leads.model.LeadsOriginClaim;
import com.jxdinfo.crm.core.leads.service.LeadsOriginAssociativeQueryService;
import com.jxdinfo.crm.core.leads.service.LeadsOriginClaimService;
import com.jxdinfo.crm.core.leads.service.LeadsOriginService;
import com.jxdinfo.crm.core.leads.service.LeadsService;
import com.jxdinfo.crm.core.leadshighseas.dao.LeadsHighSeasRelationMapper;
import com.jxdinfo.crm.core.leadshighseas.model.LeadsHighSeasRelation;
import com.jxdinfo.crm.core.leadshighseas.service.LeadsHighSeasRelationService;
import com.jxdinfo.crm.core.product.model.Product;
import com.jxdinfo.crm.core.product.service.ProductService;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.CrmLabelUtil;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.crm.core.utills.entity.DateConvertVo;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.region.model.SysRegion;
import com.jxdinfo.hussar.region.service.IHussarBaseRegionService;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LeadsOriginServiceImpl
extends ServiceImpl<LeadsOriginMapper, LeadsOrigin>
implements LeadsOriginService {
    @Resource
    private LeadsOriginMapper leadsOriginMapper;
    @Resource
    private LeadsService leadsService;
    @Resource
    private LeadsHighSeasRelationService leadsHighSeasRelationService;
    @Resource
    private FocusMapper focusMapper;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private LeadsMapper leadsMapper;
    @Resource
    private IHussarBaseRegionService iHussarBaseRegionService;
    @Resource
    private LeadsOriginClaimService leadsOriginClaimService;
    @Resource
    private CommonService commonService;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private ProductService productService;
    @Resource
    private LeadsHighSeasRelationMapper leadsHighSeasRelationMapper;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private LeadsOriginAssociativeQueryService leadsOriginAssociativeQueryService;
    @Resource
    private AssociativeQueryService associativeQueryService;
    @Resource
    private ILabelService labelService;

    @Override
    public Page<LeadsOrigin> selectCrmLeadsOriginList(LeadsOriginDto dto) {
        Page page = dto.getPage();
        SecurityUser user = BaseSecurityUtil.getUser();
        SalesStatisticsDto salesStatisticsDto = new SalesStatisticsDto();
        dto = this.leadsOriginQueryCondition(dto);
        dto.setDelFlag("0");
        salesStatisticsDto.setCurrentUserId(user.getUserId());
        List<LeadsOrigin> list = this.leadsOriginMapper.selectCrmLeadsOriginList(page, dto, salesStatisticsDto);
        page.setRecords(list);
        return page;
    }

    @Override
    public List<AssociativeQueryVo> associativeQuery(LeadsOriginAssociativeQueryDto dto) {
        String keyWord = dto.getKeyword();
        String queryScreening = null;
        if (dto.getDto() != null) {
            queryScreening = dto.getDto().getLeadsScreening();
        }
        LeadsOriginAssociativeQueryService adapterService = this.leadsOriginAssociativeQueryService;
        AssociativeKeyword associativeKeyword = new AssociativeKeyword();
        associativeKeyword.setLabelName("\u5173\u952e\u5b57");
        associativeKeyword.setDataName("hussar_79Data");
        associativeKeyword.setDictTypeName("");
        associativeKeyword.setMultiOption(false);
        return this.associativeQueryService.associativeQuery(dto, keyWord, queryScreening, adapterService, associativeKeyword);
    }

    @Override
    @Transactional
    public boolean abandonedLeadsOrigin(LeadsOriginDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        LeadsOrigin leadsOrigin = (LeadsOrigin)this.getById(dto.getLeadsId());
        if (leadsOrigin == null) {
            throw new BaseException("\u7ebf\u7d22\u4e0d\u5b58\u5728");
        }
        if ("6".equals(leadsOrigin.getState())) {
            throw new BaseException("\u8be5\u516c\u6d77\u7ebf\u7d22\u5df2\u5e9f\u5f03\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c");
        }
        List<Leads> leadsList = this.leadsOriginMapper.getLeadsListByLeadsOriginId(dto);
        List leadsStateList = leadsList.stream().filter(leads -> leads.getState() != null && !leads.getState().isEmpty()).map(Leads::getState).collect(Collectors.toList());
        if (leadsStateList.contains("4")) {
            throw new BaseException("\u8be5\u516c\u6d77\u7ebf\u7d22\u5df2\u8f6c\u6362\uff0c\u4e0d\u80fd\u5e9f\u5f03");
        }
        List leadsNotAbandonedList = leadsList.stream().filter(leads -> leads.getState() != null && !leads.getState().isEmpty() && !"6".equals(leads.getState())).collect(Collectors.toList());
        leadsOrigin.setState("6");
        leadsOrigin.setChangePerson(user.getUserId());
        leadsOrigin.setChangePersonName(user.getUserName());
        leadsOrigin.setChangeTime(date);
        leadsOrigin.setAbandonedPeason(dto.getAbandonedPeason());
        leadsOrigin.setAbandonedDescribe(dto.getAbandonedDescribe());
        this.updateById(leadsOrigin);
        LeadsHighSeasRelation relation = new LeadsHighSeasRelation();
        relation.setLeadId(dto.getLeadsId());
        relation.setHighSeasId(CommonConstant.ABANDONED_HIGH_SEAS);
        this.leadsHighSeasRelationService.save(relation);
        ArrayList<String> senderIdSum = new ArrayList<String>();
        this.createAbandonedRecords(senderIdSum, leadsOrigin.getLeadsId(), leadsOrigin.getLeadsName(), dto.getAbandonedPeason(), dto.getAbandonedDescribe(), CrmBusinessTypeEnum.LEADS_ORIGIN.getId());
        if (ToolUtil.isNotEmpty(leadsNotAbandonedList)) {
            for (Leads leads2 : leadsNotAbandonedList) {
                leads2.setState("6");
                leads2.setChangePerson(user.getUserId());
                leads2.setChangePersonName(user.getUserName());
                leads2.setChangeTime(date);
                leads2.setAbandonedPeason(dto.getAbandonedPeason());
                leads2.setAbandonedDescribe(dto.getAbandonedDescribe());
            }
            this.leadsService.updateBatchById(leadsList);
            for (Leads leads2 : leadsNotAbandonedList) {
                relation.setLeadId(leads2.getLeadsId());
                relation.setHighSeasId(CommonConstant.ABANDONED_HIGH_SEAS);
                this.leadsHighSeasRelationService.save(relation);
                ArrayList<String> senderId = new ArrayList<String>();
                senderId.add(String.valueOf(leads2.getChargePersonId()));
                this.createAbandonedRecords(senderId, leads2.getLeadsId(), leads2.getLeadsName(), dto.getAbandonedPeason(), dto.getAbandonedDescribe(), CrmBusinessTypeEnum.LEADS.getId());
            }
        }
        return true;
    }

    @Override
    @Transactional
    public boolean activatedLeadsOrigin(LeadsOriginDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        LeadsOrigin leadsOrigin = (LeadsOrigin)this.getById(dto.getLeadsId());
        if (leadsOrigin == null) {
            throw new BaseException("\u516c\u6d77\u7ebf\u7d22\u4e0d\u5b58\u5728");
        }
        if (!"6".equals(leadsOrigin.getState())) {
            throw new BaseException("\u53ea\u6709\u5e9f\u5f03\u7684\u7ebf\u7d22\u624d\u80fd\u88ab\u6fc0\u6d3b");
        }
        leadsOrigin.setState("10");
        leadsOrigin.setChangePerson(user.getUserId());
        leadsOrigin.setChangePersonName(user.getUserName());
        leadsOrigin.setChangeTime(date);
        this.updateById(leadsOrigin);
        ArrayList<String> senderId = new ArrayList<String>();
        this.createActivatedRecords(senderId, leadsOrigin.getLeadsId(), leadsOrigin.getLeadsName());
        return true;
    }

    private void createAbandonedRecords(List<String> senderId, Long id, String name, String abandonedReason, String abandonedDescribe, String flag) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        String title4 = user.getUserName() + "\u5c06\u7ebf\u7d22\u5e9f\u5f03";
        String content4 = "\u7ebf\u7d22\u3010" + name + "\u3011\u5df2\u5e9f\u5f03\uff0c\u5e9f\u5f03\u539f\u56e0\uff1a" + abandonedDescribe;
        EimPushUtil.pushJqxArticleMessage(title4, content4, "/crm/schd/xsxq", String.valueOf(id), senderId);
        AddSysMessageType addSysMessageType4 = new AddSysMessageType();
        if (ToolUtil.isNotEmpty(senderId)) {
            String userIdToString = StringUtil.join(senderId, (String)",");
            String unifyWebUrl4 = this.unifyProperties.getCrmUrl() + "/crm/clueDetails?row=" + "\"" + id + "\"";
            UnifyUtil.defaultMessage(addSysMessageType4, content4, date, user, userIdToString, user.getUserName(), unifyWebUrl4, "");
            UnifyUtil.sendMessage(addSysMessageType4);
        }
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setContactId(Long.valueOf(abandonedReason));
        if (ToolUtil.isNotEmpty((Object)abandonedReason)) {
            operateRecordDO.setContactName(this.leadsMapper.selectAbandonedReason(abandonedReason));
        }
        operateRecordDO.setRecordContent(abandonedDescribe);
        if (CrmBusinessTypeEnum.LEADS.getId().equals(flag)) {
            operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_LEADS_ABANDONED.getId());
            this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.LEADS, id, name, date, true, Collections.singletonList(id));
        } else {
            operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_LEADS_ABANDONED.getId());
            this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.LEADS_ORIGIN, id, name, date, true, Collections.singletonList(id));
        }
    }

    private void createActivatedRecords(List<String> senderId, Long id, String name) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        String title4 = user.getUserName() + "\u5c06\u7ebf\u7d22\u5e9f\u5f03";
        String content4 = user.getUserName() + "\u5c06\u7ebf\u7d22\u3010" + name + "\u3011\u6fc0\u6d3b";
        EimPushUtil.pushJqxArticleMessage(title4, content4, "/crm/schd/xsxq", String.valueOf(id), senderId);
        AddSysMessageType addSysMessageType4 = new AddSysMessageType();
        if (ToolUtil.isNotEmpty(senderId)) {
            String userIdToString = StringUtil.join(senderId, (String)",");
            String unifyWebUrl4 = this.unifyProperties.getCrmUrl() + "/crm/clueDetails?row=" + "\"" + id + "\"";
            UnifyUtil.defaultMessage(addSysMessageType4, content4, date, user, userIdToString, user.getUserName(), unifyWebUrl4, "");
            UnifyUtil.sendMessage(addSysMessageType4);
        }
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_LEADS_ACTIVATE.getId());
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.LEADS_ORIGIN, id, name, date, true, Collections.singletonList(id));
    }

    @Override
    @Transactional
    public Long addLeadsOrigin(LeadsOriginDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        Long leadId = dto.getLeadsId();
        SysStru unit = this.commonService.getLoginUserUnit(user.getDeptId());
        if (dto.getLeadsId() == null) {
            leadId = Long.valueOf(CommonUtills.generateAssignId());
            dto.setLeadsId(leadId);
            dto.setMobilePhone(dto.getMobilePhone().replace(" ", ""));
            dto.setTelephone(dto.getTelephone().replace(" ", ""));
            dto.setDelFlag("0");
            dto.setCreatePerson(user.getUserId());
            dto.setCreatePersonName(user.getUserName());
            dto.setCreateTime(date);
            dto.setCreateDepartment(user.getDeptId());
            dto.setCreateDepartmentName(user.getDeptName());
            if (unit != null) {
                dto.setCreateUnit(unit.getId());
                dto.setCreateUnitName(unit.getOrganAlias());
            }
            dto.setState("11");
            dto.setChargePersonId(null);
            dto.setChargePersonName(null);
            dto.setOwnDepartment(null);
            dto.setOwnDepartmentName(null);
            dto.setClaimNum(1);
            dto.setClaimRange("1");
        }
        dto.setChangePerson(user.getUserId());
        dto.setChangePersonName(user.getUserName());
        dto.setChangeTime(date);
        StringBuilder sb = new StringBuilder();
        if (ToolUtil.isEmpty((Object)dto.getProvince())) {
            dto.setProvince(null);
        } else {
            SysRegion province = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(dto.getProvince()));
            if (ToolUtil.isNotEmpty((Object)province)) {
                sb.append(province.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)dto.getCity())) {
            dto.setCity(null);
        } else {
            SysRegion city = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(dto.getCity()));
            if (ToolUtil.isNotEmpty((Object)city)) {
                sb.append("/").append(city.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)dto.getCounty())) {
            dto.setCounty(null);
        } else {
            SysRegion county = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(dto.getCounty()));
            if (ToolUtil.isNotEmpty((Object)county)) {
                sb.append("/").append(county.getName());
            }
        }
        dto.setRegionLabel(sb.toString());
        LeadsOrigin leadsOrigin = (LeadsOrigin)BeanUtil.copy((Object)dto, LeadsOrigin.class);
        this.save(leadsOrigin);
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setDelflag("0");
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.LEADS_ORIGIN, leadId, dto.getLeadsName(), date, false, Arrays.asList(leadId));
        return leadId;
    }

    @Override
    public LeadsOrigin selectCrmLeadsOriginListDetails(LeadsOriginDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        dto.setDelFlag("0");
        dto.setCurrentUserId(user.getUserId());
        LeadsOrigin leadsOrigin = this.leadsOriginMapper.selectCrmLeadsOriginDetailsTemp(dto);
        if (leadsOrigin == null) {
            throw new BaseException("\u5f53\u524d\u7ebf\u7d22\u4e0d\u5b58\u5728");
        }
        if ("12".equals(leadsOrigin.getState())) {
            throw new BaseException("\u5f53\u524d\u7ebf\u7d22\u5df2\u5206\u914d");
        }
        if ("13".equals(leadsOrigin.getState())) {
            throw new BaseException("\u5f53\u524d\u7ebf\u7d22\u5df2\u8ba4\u9886");
        }
        if (leadsOrigin != null && StringUtil.isNotBlank((CharSequence)leadsOrigin.getProductId())) {
            String[] products = leadsOrigin.getProductId().split(",");
            List productList = this.productService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Product::getProductId, Product::getProductName}).in(Product::getProductId, Arrays.stream(products).toArray())).orderByAsc(Product::getCreateTime));
            String productName = "";
            for (Product product : productList) {
                productName = productName + "," + product.getProductName();
            }
            if (ToolUtil.isNotEmpty((Object)productName)) {
                productName = productName.substring(1);
            }
            leadsOrigin.setProductName(productName);
            leadsOrigin.setProductList(productList);
        }
        assert (leadsOrigin != null);
        List labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.LEAD.getModuleId());
        leadsOrigin.setLabelName(CrmLabelUtil.getLabelName(labelList, leadsOrigin.getLabelId()));
        if ("1".equals(leadsOrigin.getClaimRange())) {
            leadsOrigin.setClaimRange("\u5168\u90e8");
        } else {
            leadsOrigin.setClaimRange(this.getClaimRangeByLeadsId(leadsOrigin.getLeadsId()));
        }
        return leadsOrigin;
    }

    @Override
    @Transactional
    public String distribute(LeadsOriginDto dto) {
        List<Long> newChargePersonIds = dto.getNewChargePersonIds();
        if (ToolUtil.isEmpty(newChargePersonIds)) {
            throw new BaseException("\u8bf7\u9009\u62e9\u88ab\u5206\u914d\u4eba");
        }
        LeadsOrigin leadsOrigin = (LeadsOrigin)this.getById(dto.getLeadsId());
        if (!"11".equals(leadsOrigin.getState())) {
            throw new BaseException("\u5f53\u524d\u7ebf\u7d22\u65e0\u6cd5\u5206\u914d");
        }
        SysUsers sysUsers = this.sysUsersService.getById(dto.getNewChargePersonIds().get(0));
        Long departmentId = sysUsers.getDepartmentId();
        SysStru department = (SysStru)this.sysStruService.getById((Serializable)departmentId);
        String departmentName = department.getOrganAlias();
        SysStru sysStru = this.commonService.getLoginUserUnit(departmentId);
        String newChargePersonName = sysUsers.getUserName();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = user.getId().toString();
        String userName = user.getUserName();
        leadsOrigin.setChangeTime(date);
        leadsOrigin.setChangePerson(Long.valueOf(userId));
        leadsOrigin.setChangePersonName(userName);
        leadsOrigin.setState("12");
        this.updateById(leadsOrigin);
        leadsOrigin = (LeadsOrigin)this.getById(dto.getLeadsId());
        Leads leads = (Leads)BeanUtil.copy((Object)leadsOrigin, Leads.class);
        Long leadsId = Long.valueOf(CommonUtills.generateAssignId());
        leads.setLeadsId(leadsId);
        leads.setOwnDepartment(departmentId);
        leads.setOwnDepartmentName(departmentName);
        leads.setChargePersonId(sysUsers.getId());
        leads.setChargePersonName(newChargePersonName);
        if (sysStru != null) {
            leads.setOwnUnit(sysStru.getId());
            leads.setOwnUnitName(sysStru.getOrganAlias());
        }
        leads.setState("1");
        leads.setHighSeasId(null);
        leads.setHighSeasName(null);
        leads.setOriginLeads(dto.getLeadsId());
        leads.setClaimType("1");
        leads.setClaimPerson(leads.getChargePersonId());
        leads.setClaimPersonName(leads.getChargePersonName());
        leads.setClaimTime(date);
        this.leadsService.save(leads);
        this.teamMeberService.insertTeamMember(leads.getChargePersonName(), leads.getChargePersonId(), leadsId, "1", "1", date, "4");
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_DISTRIBUTE.getId());
        operateRecordDO.setDelflag("0");
        operateRecordDO.setContactId(leads.getChargePersonId());
        operateRecordDO.setContactName(leads.getChargePersonName());
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.LEADS_ORIGIN, leadsOrigin.getLeadsId(), leadsOrigin.getLeadsName(), date, false, Arrays.asList(leadsOrigin.getLeadsId()));
        OperateRecordAPIVo operateRecordDO1 = new OperateRecordAPIVo();
        operateRecordDO1.setProduceType(RecordProductTypeEnum.PRODUCE_DISTRIBUTE.getId());
        operateRecordDO1.setDelflag("0");
        operateRecordDO1.setContactId(leads.getChargePersonId());
        operateRecordDO1.setContactName(leads.getChargePersonName());
        this.operateRecordAPIService.saveOperateLog(operateRecordDO1, CrmBusinessTypeEnum.LEADS, leadsId, dto.getLeadsName(), date, false, Arrays.asList(leadsId));
        String title = user.getUserName() + "\u5c06\u7ebf\u7d22\u5206\u914d\u7ed9\u4f60";
        String content = leads.getLeadsName() + "\u3010" + leads.getCompanyName() + "\u3011,\u8bf7\u53ca\u65f6\u8ddf\u8fdb";
        AddSysMessageType addSysMessageType = new AddSysMessageType();
        String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/clueDetails?row=" + "\"" + leadsId + "\"";
        UnifyUtil.defaultMessage(addSysMessageType, content, date, user, String.valueOf(leads.getChargePersonId()), user.getUserName(), unifyWebUrl, "");
        UnifyUtil.sendMessage(addSysMessageType);
        return "";
    }

    private LeadsOriginDto leadsOriginQueryCondition(LeadsOriginDto dto) {
        DateConvertVo dateConvertVo;
        if (ToolUtil.isNotEmpty((Object)dto.getLeadsScreening())) {
            dto.setLeadsScreening(dto.getLeadsScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        ArrayList<String> userIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(dto.getCreatePersonIds()) && dto.getCreatePersonIds().size() > 0) {
            for (String userId : dto.getCreatePersonIds()) {
                userIds.add(CommonUtills.translateUserId(userId));
            }
            dto.setCreatePersonIds(userIds);
        }
        List<String> createDepartmentIds = dto.getCreateDepartmentIds();
        ArrayList<String> cdpIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(createDepartmentIds) && createDepartmentIds.size() > 0) {
            for (String cdpId : createDepartmentIds) {
                ArrayList<String> Ids;
                String cdpIdsTemp = CommonUtills.translateDepId(cdpId);
                List<String> idsTemp = CommonUtills.selectOpportunityTissueTreeUserId(cdpIdsTemp, Ids = new ArrayList<String>());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    cdpIds.add(idsTemp.get(i));
                }
            }
            dto.setCreateDepartmentIds(cdpIds);
        }
        if (!"".equals(dto.getCreateTimeFlag()) && !"6".equals(dto.getCreateTimeFlag()) && ToolUtil.isNotEmpty((Object)(dateConvertVo = IndexUtil.getCurrentTime(dto.getCreateTimeFlag())))) {
            dto.setStartTime(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setFinalTime(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        dto.setState("11");
        return dto;
    }

    private String getClaimRangeByLeadsId(Long leadsId) {
        List unitIdsList = this.leadsOriginClaimService.listObjs((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{LeadsOriginClaim::getUnitId}).in(LeadsOriginClaim::getLeadsId, new Object[]{leadsId}), s -> Long.parseLong(s.toString()));
        List unitNameList = this.sysStruService.listObjs((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{SysStru::getOrganAlias}).in(SysStru::getId, (Collection)unitIdsList), s -> s.toString());
        String claimRange = "";
        if (ToolUtil.isNotEmpty((Object)unitNameList)) {
            claimRange = unitNameList.stream().collect(Collectors.joining("\uff0c"));
        }
        return claimRange;
    }

    @Override
    @Transactional
    public String claim(LeadsOriginDto dto) {
        if (ToolUtil.isEmpty((Object)dto.getLeadsId())) {
            throw new BaseException("\u8bf7\u9009\u62e9\u8ba4\u9886\u7684\u7ebf\u7d22");
        }
        LeadsOrigin oldLeadsOrigin = (LeadsOrigin)this.getById(dto.getLeadsId());
        if (!"11".equals(oldLeadsOrigin.getState())) {
            throw new BaseException("\u5f53\u524d\u7ebf\u7d22\u65e0\u6cd5\u8ba4\u9886");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        Long departmentId = user.getDeptId();
        String departmentName = user.getDeptName();
        SysStru sysStru = this.commonService.getLoginUserUnit(departmentId);
        Long userId = user.getUserId();
        String userName = user.getUserName();
        oldLeadsOrigin.setChangeTime(date);
        oldLeadsOrigin.setChangePerson(userId);
        oldLeadsOrigin.setChangePersonName(userName);
        oldLeadsOrigin.setState("13");
        this.updateById(oldLeadsOrigin);
        Leads leads = (Leads)BeanUtil.copy((Object)oldLeadsOrigin, Leads.class);
        Long leadsId = Long.valueOf(CommonUtills.generateAssignId());
        leads.setLeadsId(leadsId);
        leads.setOwnDepartment(departmentId);
        leads.setOwnDepartmentName(departmentName);
        leads.setChargePersonId(userId);
        leads.setChargePersonName(userName);
        if (sysStru != null) {
            leads.setOwnUnit(sysStru.getId());
            leads.setOwnUnitName(sysStru.getOrganAlias());
        }
        leads.setState("1");
        leads.setHighSeasId(null);
        leads.setHighSeasName(null);
        leads.setOriginLeads(dto.getLeadsId());
        leads.setClaimType("2");
        leads.setClaimPerson(userId);
        leads.setClaimPersonName(userName);
        leads.setClaimTime(date);
        this.leadsService.save(leads);
        this.teamMeberService.insertTeamMember(userName, userId, leadsId, "1", "1", date, "4");
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_LEADS_CLAIM.getId());
        operateRecordDO.setDelflag("0");
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.LEADS_ORIGIN, oldLeadsOrigin.getLeadsId(), oldLeadsOrigin.getLeadsName(), date, false, Arrays.asList(oldLeadsOrigin.getLeadsId()));
        OperateRecordAPIVo operateRecordDO1 = new OperateRecordAPIVo();
        operateRecordDO1.setProduceType(RecordProductTypeEnum.PRODUCE_LEADS_CLAIM.getId());
        operateRecordDO1.setDelflag("0");
        this.operateRecordAPIService.saveOperateLog(operateRecordDO1, CrmBusinessTypeEnum.LEADS, leadsId, leads.getLeadsName(), date, false, Arrays.asList(leadsId));
        return "";
    }
}

