/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.dataright.service.impl;

import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.dataright.dao.DataRightMapper;
import com.jxdinfo.crm.core.dataright.model.DataModule;
import com.jxdinfo.crm.core.dataright.service.DataRightService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DataRightServiceImpl
implements DataRightService {
    @Resource
    private DataRightMapper dataRightMapper;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private CommonService commonService;

    @Override
    public String selectMaxRightByRoleList(String moduleCode) {
        SecurityUser user = BaseSecurityUtil.getUser();
        DataModule module = this.dataRightMapper.selectRightModule(moduleCode, "0").get(0);
        ArrayList rightMapList = new ArrayList();
        int maxRight = this.dataRightMapper.selectMaxRightByRoleList(module.getModuleCode(), user.getRolesList());
        String screening = "";
        switch (maxRight) {
            case 1: {
                screening = this.getScreeningStringOne(module, user);
                break;
            }
            case 3: {
                screening = this.getScreeningStringTwo(module, user);
                break;
            }
            case 4: {
                screening = this.getScreeningStringThree(module, user);
                break;
            }
            case 5: {
                screening = this.getScreeningStringFour(module, user);
                break;
            }
            case 6: {
                screening = this.getScreeningStringFive(module);
                break;
            }
            case 7: {
                screening = this.getScreeningStringSix(module);
                break;
            }
            case 8: {
                screening = "";
                break;
            }
            default: {
                screening = "1=2 ";
            }
        }
        return screening;
    }

    public String getScreeningStringOne(DataModule module, SecurityUser user) {
        String screeningString = "";
        String rightField = module.getRightFieldPerson();
        screeningString = rightField + " = " + user.getId().toString() + " ";
        return screeningString;
    }

    public String getScreeningStringTwo(DataModule module, SecurityUser user) {
        String screeningString = "";
        String sonsIds = "";
        String userId = user.getId().toString();
        String rightField = module.getRightFieldPerson();
        String sonsId = this.commonMapper.selectAllOrganId(userId, "9");
        if (!sonsId.isEmpty()) {
            sonsIds = sonsId.substring(1);
        }
        screeningString = rightField + " IN (" + sonsIds + ") ";
        return screeningString;
    }

    public String getScreeningStringThree(DataModule module, SecurityUser user) {
        String screeningString = "";
        String rightField = module.getRightFieldDept();
        screeningString = rightField + " = " + user.getDeptId().toString() + " ";
        return screeningString;
    }

    public String getScreeningStringFour(DataModule module, SecurityUser user) {
        String screeningString = "";
        String sonsIds = "";
        String rightField = module.getRightFieldDept();
        String sonsId = this.commonMapper.selectAllStruId(user.getDeptId().toString(), "2");
        if (!sonsId.isEmpty()) {
            sonsIds = sonsId.substring(1);
        }
        screeningString = rightField + " IN(" + sonsIds + ") ";
        return screeningString;
    }

    public String getScreeningStringFive(DataModule module) {
        String screeningString = "";
        String rightField = module.getRightFieldCompany();
        screeningString = rightField + " = " + this.commonService.selectUserUnit() + " ";
        return screeningString;
    }

    public String getScreeningStringSix(DataModule module) {
        String screeningString = "";
        String sonsIds = "";
        String rightField = module.getRightFieldCompany();
        String unitId = this.commonService.selectUserUnit();
        String sonsId = this.commonMapper.selectAllStruId(unitId, "1");
        if (!sonsId.isEmpty()) {
            sonsIds = sonsId.substring(1);
        }
        screeningString = rightField + " IN(" + sonsIds + ") ";
        return screeningString;
    }
}

