/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.customer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.common.api.label.service.ILabelService;
import com.jxdinfo.crm.common.api.label.vo.LabelVo;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.customer.dao.CustomerMergeMapper;
import com.jxdinfo.crm.core.customer.dto.CheckedPropertyInfo;
import com.jxdinfo.crm.core.customer.dto.CustomerMergeDto;
import com.jxdinfo.crm.core.customer.dto.PrimaryDto;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.model.CustomerMergeInfo;
import com.jxdinfo.crm.core.customer.model.CustomerMergeRecord;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.customer.service.ICustomerMergeInfoService;
import com.jxdinfo.crm.core.customer.service.ICustomerMergeRecordService;
import com.jxdinfo.crm.core.customer.service.ICustomerMergeService;
import com.jxdinfo.crm.core.customer.vo.CustomerMergeVo;
import com.jxdinfo.crm.core.customer.vo.CustomerRelationInfoVo;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.crm.core.utills.PushMessageEnum;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.exception.HussarCoreException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerMergeServiceImpl
implements ICustomerMergeService {
    @Resource
    private CustomerService customerService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private ILabelService labelService;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private ICustomerMergeRecordService customerMergeRecordService;
    @Resource
    private ICustomerMergeInfoService customerMergeInfoService;
    @Resource
    private CustomerMergeMapper customerMergeMapper;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private UnifyProperties unifyProperties;

    @Override
    public List<CustomerMergeVo> getList(String customerName, String customerIds) throws Exception {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        if (StringUtil.isNotEmpty((Object)customerIds)) {
            String[] customerIdStr = customerIds.split(",");
            List customerIdList = Arrays.stream(customerIdStr).map(Long::parseLong).collect(Collectors.toList());
            lambdaQueryWrapper.in(CustomerEntity::getCustomerId, customerIdList);
        }
        if (StringUtil.isNotEmpty((Object)customerName)) {
            lambdaQueryWrapper.eq(CustomerEntity::getCustomerName, (Object)customerName);
        }
        lambdaQueryWrapper.ne(CustomerEntity::getDelFlag, (Object)"1");
        List customerEntityList = this.customerService.list((Wrapper)lambdaQueryWrapper);
        if (CollectionUtil.isEmpty((Collection)customerEntityList)) {
            throw new HussarCoreException("\u6ca1\u6709\u5bf9\u5e94\u7684\u5ba2\u6237\u4fe1\u606f");
        }
        return this.toMergeVo(customerEntityList);
    }

    private List<CustomerMergeVo> toMergeVo(List<CustomerEntity> customerEntityList) {
        List labelVoList;
        LinkedHashMap customerTypeDictMap = this.sysDicRefService.getDictMapByType("customerType");
        LinkedHashMap customerLevelDictMap = this.sysDicRefService.getDictMapByType("customer_level");
        LinkedHashMap tradeDictMap = this.sysDicRefService.getDictMapByType("industry");
        LinkedHashMap customerOriginDictMap = this.sysDicRefService.getDictMapByType("customer_source");
        LinkedHashMap customerAttributeDictMap = this.sysDicRefService.getDictMapByType("customer_type");
        LinkedHashMap staffNumberDictMap = this.sysDicRefService.getDictMapByType("staff_nums");
        LinkedHashMap lastRevenueDictMap = this.sysDicRefService.getDictMapByType("last_revenue");
        ArrayList labelIdList = new ArrayList();
        ArrayList<Long> customerIdList = new ArrayList<Long>();
        for (CustomerEntity customerEntity : customerEntityList) {
            String labels = customerEntity.getLabelId();
            if (StringUtil.isNotEmpty((Object)labels)) {
                String[] labelArray = labels.split(",");
                labelIdList.addAll(Arrays.stream(labelArray).map(Long::parseLong).collect(Collectors.toList()));
            }
            customerIdList.add(customerEntity.getCustomerId());
        }
        Map<Object, Object> labelInfoMap = new HashMap();
        if (CollectionUtil.isNotEmpty(labelIdList) && CollectionUtil.isNotEmpty((Collection)(labelVoList = this.labelService.listByIds(labelIdList)))) {
            labelInfoMap = labelVoList.stream().collect(Collectors.toMap(LabelVo::getLabelId, LabelVo::getLabelName));
        }
        List teamMeberEntityList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TeamMeberEntity::getBusinessId, customerIdList)).ne(TeamMeberEntity::getDelFlag, (Object)"1"));
        ArrayList<CustomerMergeVo> customerMergeVoList = new ArrayList<CustomerMergeVo>();
        for (CustomerEntity customerEntity : customerEntityList) {
            Object lastRevenue;
            Object staffNumber;
            Object customerAttribute;
            Object v;
            Object trade;
            Object customerLevel;
            CustomerMergeVo customerMergeVo = new CustomerMergeVo();
            BeanUtil.copyProperties((Object)customerEntity, (Object)customerMergeVo);
            String labels = customerEntity.getLabelId();
            ArrayList<Map<String, Object>> labelList = new ArrayList<Map<String, Object>>();
            if (StringUtil.isNotEmpty((Object)labels)) {
                String[] labelArray = labels.split(",");
                for (String string : labelArray) {
                    Long labelId = Long.parseLong(string);
                    Object label = labelInfoMap.get(labelId);
                    if (!ToolUtil.isNotEmpty((Object)label)) continue;
                    HashMap<String, Object> labelMap = new HashMap<String, Object>();
                    labelMap.put("label", label);
                    labelMap.put("value", string);
                    labelList.add(labelMap);
                }
            }
            customerMergeVo.setLabelList(labelList);
            ArrayList<Map<String, Object>> teamMemberList = new ArrayList<Map<String, Object>>();
            for (TeamMeberEntity teamMeberEntity : teamMeberEntityList) {
                if (!teamMeberEntity.getBusinessId().equals(customerEntity.getCustomerId())) continue;
                HashMap<String, Object> teamMemberMap = new HashMap<String, Object>();
                teamMemberMap.put("value", teamMeberEntity.getTeamMeberId());
                teamMemberMap.put("label", teamMeberEntity.getTeamMeberName());
                teamMemberMap.put("departmentId", teamMeberEntity.getOwnDepartment());
                teamMemberMap.put("departmentName", teamMeberEntity.getOwnDepartmentName());
                teamMemberMap.put("modifyPower", teamMeberEntity.getModifyPower());
                teamMemberMap.put("isCharge", teamMeberEntity.getIsCharge());
                teamMemberMap.put("personId", teamMeberEntity.getPersonId());
                teamMemberList.add(teamMemberMap);
            }
            customerMergeVo.setTeamNumberList(teamMemberList);
            String customerTypes = customerEntity.getCustomerType();
            if (StringUtil.isNotEmpty((Object)customerTypes)) {
                String[] customerTypeArray = customerTypes.split(",");
                String customerLabel = null;
                for (String customerType : customerTypeArray) {
                    customerLabel = CollectionUtil.isNotEmpty(customerLabel) ? customerLabel + "," + customerTypeDictMap.get(customerType) : customerTypeDictMap.get(customerType).toString();
                }
                customerMergeVo.setCustomerTypeLabel(customerLabel);
            }
            if ((customerLevel = customerLevelDictMap.get(customerEntity.getCustLevel())) != null) {
                customerMergeVo.setCustLevelLabel(customerLevel.toString());
            }
            if ((trade = tradeDictMap.get(customerEntity.getTrade())) != null) {
                customerMergeVo.setTradeLabel(trade.toString());
            }
            if ((v = customerOriginDictMap.get(customerEntity.getCustomerOrigin())) != null) {
                customerMergeVo.setCustomerOriginLabel(v.toString());
            }
            if ((customerAttribute = customerAttributeDictMap.get(customerEntity.getCustomerAttribute())) != null) {
                customerMergeVo.setCustomerAttributeLabel(customerAttribute.toString());
            }
            if ((staffNumber = staffNumberDictMap.get(customerEntity.getStaffNumber())) != null) {
                customerMergeVo.setStaffNumberLabel(staffNumber.toString());
            }
            if ((lastRevenue = lastRevenueDictMap.get(customerEntity.getLastRevenue())) != null) {
                customerMergeVo.setLastRevenueLabel(lastRevenue.toString());
            }
            if (StringUtil.isNotBlank((CharSequence)customerEntity.getProvince())) {
                StringBuilder sb = new StringBuilder();
                sb.append(customerEntity.getProvince());
                if (StringUtil.isNotBlank((CharSequence)customerEntity.getCity())) {
                    sb.append("/").append(customerEntity.getCity());
                    if (StringUtil.isNotBlank((CharSequence)customerEntity.getCounty())) {
                        sb.append("/").append(customerEntity.getCounty());
                    }
                }
                customerMergeVo.setRegion(sb.toString());
            }
            customerMergeVoList.add(customerMergeVo);
        }
        return customerMergeVoList;
    }

    @Override
    @Transactional
    public int merge(CustomerMergeDto dto) {
        if (dto.getPrimaryCustomer() == null) {
            throw new HussarCoreException("\u7f3a\u5c11\u9009\u4e2d\u53c2\u6570");
        }
        if (dto.getCustomerList().size() <= 1) {
            return 1;
        }
        PrimaryDto primaryDto = dto.getPrimaryCustomer();
        long primaryCustomerId = primaryDto.getPrimaryCustomerId();
        String primaryCustomerName = primaryDto.getPrimaryCustomerName();
        CustomerMergeRecord customerMergeRecord = new CustomerMergeRecord();
        customerMergeRecord.setCustomerName(primaryCustomerName);
        customerMergeRecord.setCustomerId(primaryCustomerId);
        this.customerMergeRecordService.save((Object)customerMergeRecord);
        List<CustomerMergeVo> customerMergeVoList = dto.getCustomerList();
        HashMap<String, Object> customerEntityMap = new HashMap<String, Object>();
        List<CheckedPropertyInfo> checkedPropertyInfoList = primaryDto.getCheckedPropertyInfoList();
        Map<String, Map<String, String>> checkPropertyMap = this.checkedPropertyToMap(checkedPropertyInfoList, customerEntityMap);
        List<Long> mergeCustomerIdList = customerMergeVoList.stream().map(CustomerMergeVo::getCustomerId).collect(Collectors.toList());
        HashMap<String, List<CustomerRelationInfoVo>> relationRecordMap = new HashMap();
        HashMap<String, List<CustomerRelationInfoVo>> relationContactMap = new HashMap();
        HashMap<String, List<CustomerRelationInfoVo>> relationOpportunityMap = new HashMap();
        HashMap<String, List<CustomerRelationInfoVo>> relationVehicleMap = new HashMap();
        HashMap<String, List<CustomerRelationInfoVo>> relationFileMap = new HashMap();
        HashMap<String, List<CustomerRelationInfoVo>> relationOperationMap = new HashMap();
        HashMap<String, List<CustomerRelationInfoVo>> relationTasMap = new HashMap();
        if (CollectionUtil.isNotEmpty(mergeCustomerIdList)) {
            List<CustomerRelationInfoVo> relationRecordList = this.customerMergeMapper.selectRelationRecord(mergeCustomerIdList);
            relationRecordMap = relationRecordList.stream().collect(Collectors.groupingBy(CustomerRelationInfoVo::getCustomerId));
            List<CustomerRelationInfoVo> relationContactList = this.customerMergeMapper.selectRelationContact(mergeCustomerIdList);
            relationContactMap = relationContactList.stream().collect(Collectors.groupingBy(CustomerRelationInfoVo::getCustomerId));
            List<CustomerRelationInfoVo> relationOpportunityList = this.customerMergeMapper.selectOpportunity(mergeCustomerIdList);
            relationOpportunityMap = relationOpportunityList.stream().collect(Collectors.groupingBy(CustomerRelationInfoVo::getCustomerId));
            List<CustomerRelationInfoVo> relationVehicleList = this.customerMergeMapper.selectRelationVehicle(mergeCustomerIdList);
            relationVehicleMap = relationVehicleList.stream().collect(Collectors.groupingBy(CustomerRelationInfoVo::getCustomerId));
            List<CustomerRelationInfoVo> relationFileList = this.customerMergeMapper.selectRelationFile(mergeCustomerIdList);
            relationFileMap = relationFileList.stream().collect(Collectors.groupingBy(CustomerRelationInfoVo::getCustomerId));
            List<CustomerRelationInfoVo> relationOperationList = this.customerMergeMapper.selectRelationOperation(mergeCustomerIdList);
            relationOperationMap = relationOperationList.stream().collect(Collectors.groupingBy(CustomerRelationInfoVo::getCustomerId));
            List<CustomerRelationInfoVo> relationTaskList = this.customerMergeMapper.selectRelationTask(mergeCustomerIdList);
            relationTasMap = relationTaskList.stream().collect(Collectors.groupingBy(CustomerRelationInfoVo::getCustomerId));
        }
        ArrayList<Long> deleteCustomerIdList = new ArrayList<Long>();
        ArrayList<CustomerMergeInfo> customerMergeInfoList = new ArrayList<CustomerMergeInfo>();
        ArrayList<Map<String, Object>> checkedTeamMember = new ArrayList<Map<String, Object>>();
        HashSet<String> users = new HashSet<String>();
        for (CustomerMergeVo customerMergeVo : customerMergeVoList) {
            long customerId = customerMergeVo.getCustomerId();
            if (customerId != primaryCustomerId) {
                deleteCustomerIdList.add(customerId);
            }
            users.add(customerMergeVo.getChargePersonId().toString());
            users.addAll(customerMergeVo.getTeamNumberList().stream().map(teamNumber -> teamNumber.get("personId").toString()).collect(Collectors.toList()));
            CustomerMergeInfo customerMergeInfo = new CustomerMergeInfo();
            customerMergeInfo.setCustomerId(customerId);
            customerMergeInfo.setOldRecordIds(this.getRelationIds(relationRecordMap, customerId));
            customerMergeInfo.setOldContactIds(this.getRelationIds(relationContactMap, customerId));
            customerMergeInfo.setOldOpportunityIds(this.getRelationIds(relationOpportunityMap, customerId));
            customerMergeInfo.setOldVehicleApplicationIds(this.getRelationIds(relationVehicleMap, customerId));
            customerMergeInfo.setOldFileInfoIds(this.getRelationIds(relationFileMap, customerId));
            customerMergeInfo.setOldOperationIds(this.getRelationIds(relationOperationMap, customerId));
            customerMergeInfo.setOldTaskIds(this.getRelationIds(relationTasMap, customerId));
            Map<String, String> checkedProperyByCustomerMap = checkPropertyMap.get(String.valueOf(customerId));
            if (CollectionUtil.isEmpty(checkedProperyByCustomerMap)) continue;
            try {
                Long customerMergeRecordId = customerMergeRecord.getMergeRecordId();
                this.makeCustomerMergeInfo(customerMergeVo, checkedProperyByCustomerMap, customerMergeInfo, checkedTeamMember);
                customerMergeInfo.setMergeRecordId(customerMergeRecordId);
                customerMergeInfoList.add(customerMergeInfo);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        this.customerMergeInfoService.saveBatch(customerMergeInfoList);
        CustomerEntity customerEntity = (CustomerEntity)JSONObject.parseObject((String)JSONObject.toJSONString(customerEntityMap), CustomerEntity.class);
        customerEntity.setCustomerId(primaryCustomerId);
        this.customerService.updateById(customerEntity);
        String primaryChargePersonId = customerEntity.getChargePersonId().toString();
        String primaryChargePerson = customerEntity.getOwnDepartmentName() + "-" + customerEntity.getChargePersonName();
        this.updateTeamMemberInfo(checkedTeamMember, primaryCustomerId, primaryChargePersonId, deleteCustomerIdList);
        this.customerMergeMapper.deleteCustomer(deleteCustomerIdList);
        this.customerMergeMapper.updateRecordRelationId(deleteCustomerIdList, primaryCustomerId);
        this.customerMergeMapper.updateRecordBusinessRelationId(deleteCustomerIdList, primaryCustomerId);
        this.customerMergeMapper.updateContactRelationId(deleteCustomerIdList, primaryCustomerId);
        this.customerMergeMapper.updateOpportunityRelationId(deleteCustomerIdList, primaryCustomerId);
        this.customerMergeMapper.updateVehicleRelationId(deleteCustomerIdList, primaryCustomerId);
        this.customerMergeMapper.updateFileRelationId(deleteCustomerIdList, primaryCustomerId);
        this.customerMergeMapper.updateOperationRelationId(deleteCustomerIdList, primaryCustomerId);
        this.customerMergeMapper.updateTaskRelationId(deleteCustomerIdList, primaryCustomerId);
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setBusinessType("1");
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_MERGE.getId());
        operateRecordDO.setRecordContent(null);
        ArrayList<Long> businessIds = new ArrayList<Long>();
        businessIds.add(primaryCustomerId);
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.CUSTOMER, Long.valueOf(primaryCustomerId), "\u5408\u5e76\u5ba2\u6237", LocalDateTime.now(), false, businessIds);
        if (CollectionUtil.isEmpty(users)) {
            return 1;
        }
        String teamMemberInfo = null;
        Map<String, List<Map>> checkedTeamMemberMap = checkedTeamMember.stream().collect(Collectors.groupingBy(teamMember -> teamMember.get("departmentName").toString()));
        if (CollectionUtil.isNotEmpty(checkedTeamMember)) {
            for (String departmentName : checkedTeamMemberMap.keySet()) {
                HashSet<String> teamMemberNameSet = new HashSet<String>();
                String teamMemberInfoByDepartment = null;
                List<Map> checkedTeamMemberList = checkedTeamMemberMap.get(departmentName);
                for (Map checkedTeamMemberInfo : checkedTeamMemberList) {
                    String teamMemberName = checkedTeamMemberInfo.get("label").toString();
                    if (!StringUtil.isNotEmpty((Object)teamMemberName) || !teamMemberNameSet.add(teamMemberName)) continue;
                    if (StringUtil.isNotEmpty((Object)teamMemberInfoByDepartment)) {
                        teamMemberInfoByDepartment = teamMemberInfoByDepartment + "\u3001" + checkedTeamMemberInfo.get("label");
                        continue;
                    }
                    teamMemberInfoByDepartment = departmentName + "-" + checkedTeamMemberInfo.get("label");
                }
                if (StringUtil.isNotEmpty(teamMemberInfo)) {
                    teamMemberInfo = teamMemberInfo + ";" + teamMemberInfoByDepartment;
                    continue;
                }
                teamMemberInfo = teamMemberInfoByDepartment;
            }
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        String title = "\u3010CRM\u3011\u5ba2\u6237\u5408\u5e76\u63d0\u9192";
        String content = user.getDeptName() + "-" + user.getUserName() + "\u5bf9\u3010" + primaryCustomerName + "\u3011\u8fdb\u884c\u4e86\u5408\u5e76\u5904\u7406\uff0c\u5408\u5e76\u540e\u5ba2\u6237\u8d1f\u8d23\u4eba\u4e3a\uff1a" + primaryChargePerson + "\uff0c\u56e2\u961f\u6210\u5458\u5305\u542b\uff1a" + teamMemberInfo;
        String userIds = null;
        ArrayList<String> userList = new ArrayList<String>(users);
        for (String userId : userList) {
            if (StringUtil.isNotEmpty(userIds)) {
                userIds = userIds + "," + userId;
                continue;
            }
            userIds = userId;
        }
        String businessId = String.valueOf(primaryCustomerId);
        EimPushUtil.pushJqxArticleMessage(title, content, PushMessageEnum.CUSTOMER.getMobile(), businessId, userList);
        String contentUnify = "\u3010\u5ba2\u6237\u5408\u5e76\u3011 " + content;
        AddSysMessageType addSysMessageType = new AddSysMessageType();
        String unifyWebUrl = this.unifyProperties.getCrmUrl() + PushMessageEnum.CUSTOMER.getUnify() + "\"" + businessId + "\"";
        addSysMessageType.setBusinessAddress(unifyWebUrl);
        LocalDateTime date = LocalDateTime.now();
        UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, userIds, user.getUserName(), unifyWebUrl, "");
        UnifyUtil.sendMessage(addSysMessageType);
        return 1;
    }

    private String getRelationIds(Map<String, List<CustomerRelationInfoVo>> relationMap, long customerId) {
        List<CustomerRelationInfoVo> relationList = relationMap.get(customerId + "");
        if (CollectionUtil.isNotEmpty(relationList)) {
            List relationIdList = relationList.stream().map(CustomerRelationInfoVo::getRelationId).collect(Collectors.toList());
            return JSONObject.toJSONString(relationIdList);
        }
        return null;
    }

    private void updateTeamMemberInfo(List<Map<String, Object>> checkedTeamMember, long primaryCustomerId, String primaryChargePersonId, List<Long> deleteCustomerIdList) {
        Map<String, List<Map>> checkedTeamMemberMap = checkedTeamMember.stream().collect(Collectors.groupingBy(teamMember -> teamMember.get("personId").toString()));
        ArrayList<Long> teamMemberIdList = new ArrayList<Long>();
        ArrayList<TeamMeberEntity> teamMemberEntityList = new ArrayList<TeamMeberEntity>();
        for (String personId : checkedTeamMemberMap.keySet()) {
            String modifyPower;
            TeamMeberEntity teamMeberEntity;
            List<Map> checkedTeamMemberList = checkedTeamMemberMap.get(personId);
            if (personId.equals(primaryChargePersonId)) {
                teamMeberEntity = new TeamMeberEntity();
                if (CollectionUtil.isEmpty(checkedTeamMemberList)) {
                    throw new HussarCoreException("\u56e2\u961f\u6210\u5458\u4e2d\u5e94\u8be5\u5305\u542b\u8d1f\u8d23\u4eba\u4fe1\u606f");
                }
                Map chargePersonTeamMember = checkedTeamMemberList.get(0);
                if (checkedTeamMemberList.size() > 1) {
                    for (Map teamMemberMap : checkedTeamMemberList) {
                        if (!"1".equals(teamMemberMap.get("isCharge").toString())) continue;
                        chargePersonTeamMember = teamMemberMap;
                        break;
                    }
                }
                Long teamMemberId = Long.parseLong(chargePersonTeamMember.get("value").toString());
                teamMeberEntity.setTeamMeberId(teamMemberId);
                teamMeberEntity.setBusinessId(primaryCustomerId);
                teamMemberEntityList.add(teamMeberEntity);
                teamMemberIdList.add(teamMemberId);
                continue;
            }
            teamMeberEntity = new TeamMeberEntity();
            Map teamMember2 = checkedTeamMemberList.get(0);
            try {
                modifyPower = teamMember2.get("modifyPower").toString();
            }
            catch (Exception e) {
                modifyPower = "0";
            }
            if (CollectionUtil.isNotEmpty(checkedTeamMemberList)) {
                for (Map teamMemberMap : checkedTeamMemberList) {
                    String thisModifyPower;
                    if ("1".equals(teamMemberMap.get("isCharge").toString())) {
                        teamMember2 = teamMemberMap;
                        teamMeberEntity.setModifyPower("1");
                        teamMeberEntity.setIsCharge("0");
                        teamMeberEntity.setMemberRole("5");
                        break;
                    }
                    try {
                        thisModifyPower = teamMemberMap.get("modifyPower").toString();
                    }
                    catch (Exception e) {
                        thisModifyPower = "0";
                    }
                    if (thisModifyPower.equals(modifyPower) || !"1".equals(thisModifyPower)) continue;
                    teamMember2 = teamMemberMap;
                }
            }
            Long teamMemberId = Long.parseLong(teamMember2.get("value").toString());
            teamMeberEntity.setTeamMeberId(teamMemberId);
            teamMeberEntity.setBusinessId(primaryCustomerId);
            teamMemberEntityList.add(teamMeberEntity);
            teamMemberIdList.add(teamMemberId);
        }
        this.customerMergeMapper.updateTeamMemberRelationId(deleteCustomerIdList, primaryCustomerId);
        this.teamMeberService.updateBatchById(teamMemberEntityList);
        if (CollectionUtil.isNotEmpty(teamMemberIdList)) {
            this.customerMergeMapper.deleteNoCheckedTeamMember(teamMemberIdList, primaryCustomerId);
        }
    }

    private void makeCustomerMergeInfo(CustomerMergeVo customerMergeVo, Map<String, String> checkedProperyByCustomerMap, CustomerMergeInfo customerMergeInfo, List<Map<String, Object>> checkedTeamMember) throws IllegalAccessException {
        Field[] fields;
        Long superiorCustomerId;
        Long ownDepartment;
        Long campaignId;
        BeanUtil.copyProperties((Object)customerMergeVo, (Object)customerMergeInfo);
        Long chargePersonId = customerMergeVo.getChargePersonId();
        if (chargePersonId != null && chargePersonId > 0L) {
            customerMergeInfo.setChargePersonId(String.valueOf(chargePersonId));
        }
        if ((campaignId = customerMergeVo.getCampaignId()) != null && campaignId > 0L) {
            customerMergeInfo.setCampaignId(String.valueOf(campaignId));
        }
        if ((ownDepartment = customerMergeVo.getOwnDepartment()) != null && ownDepartment > 0L) {
            customerMergeInfo.setOwnDepartment(String.valueOf(ownDepartment));
        }
        if ((superiorCustomerId = customerMergeVo.getSuperiorCustomerId()) != null && superiorCustomerId > 0L) {
            customerMergeInfo.setSuperiorCustomerId(String.valueOf(superiorCustomerId));
        }
        Class<?> clazz = customerMergeInfo.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = field.getName();
            String value = checkedProperyByCustomerMap.get(fieldName);
            if ("mergeInfoId".equals(fieldName) || "mergeRecordId".equals(fieldName) || "customerId".equals(fieldName)) continue;
            if ("labelId".equals(fieldName)) {
                List<Map<String, Object>> labelList = customerMergeVo.getLabelList();
                String labelValue = this.getMultipleChoiceValue(labelList, value, null);
                field.set(customerMergeInfo, labelValue);
                continue;
            }
            if ("teamMember".equals(fieldName)) {
                List<Map<String, Object>> teamNumberList = customerMergeVo.getTeamNumberList();
                String teamNumberValue = this.getMultipleChoiceValue(teamNumberList, value, checkedTeamMember);
                field.set(customerMergeInfo, teamNumberValue);
                continue;
            }
            HashMap<String, String> properyMap = new HashMap<String, String>();
            switch (fieldName) {
                case "customerType": {
                    properyMap.put("label", customerMergeVo.getCustomerTypeLabel());
                    break;
                }
                case "custLevel": {
                    properyMap.put("label", customerMergeVo.getCustLevelLabel());
                    break;
                }
                case "trade": {
                    properyMap.put("label", customerMergeVo.getTradeLabel());
                    break;
                }
                case "customerOrigin": {
                    properyMap.put("label", customerMergeVo.getCustomerOriginLabel());
                    break;
                }
                case "customerAttribute": {
                    properyMap.put("label", customerMergeVo.getCustomerAttributeLabel());
                    break;
                }
                case "staffNumber": {
                    properyMap.put("label", customerMergeVo.getStaffNumberLabel());
                    break;
                }
                case "lastRevenue": {
                    properyMap.put("label", customerMergeVo.getLastRevenueLabel());
                }
            }
            if (checkedProperyByCustomerMap.containsKey(fieldName)) {
                properyMap.put("value", value);
                properyMap.put("checked", "1");
            } else {
                if (fieldName.startsWith("old")) continue;
                properyMap.put("checked", "0");
                properyMap.put("value", field.get(customerMergeInfo) == null ? null : field.get(customerMergeInfo).toString());
            }
            properyMap.put("isRadio", "1");
            String propertyValue = JSONObject.toJSONString(properyMap);
            field.set(customerMergeInfo, propertyValue);
        }
    }

    private String getMultipleChoiceValue(List<Map<String, Object>> multipleChoiceList, String value, List<Map<String, Object>> checkedTeamMember) {
        List checkedList = null;
        if (StringUtil.isNotEmpty((Object)value)) {
            checkedList = Arrays.stream(value.split(",")).collect(Collectors.toList());
        }
        if (CollectionUtil.isNotEmpty(multipleChoiceList)) {
            for (Map<String, Object> labelMap : multipleChoiceList) {
                String multipleChoiceValue = labelMap.get("value").toString();
                if (checkedList != null && CollectionUtil.isNotEmpty(checkedList) && checkedList.contains(multipleChoiceValue)) {
                    if (checkedTeamMember != null) {
                        checkedTeamMember.add(labelMap);
                    }
                    labelMap.put("checked", "1");
                } else {
                    labelMap.put("checked", "0");
                }
                labelMap.put("isRadio", "0");
            }
        }
        return JSONObject.toJSONString(multipleChoiceList);
    }

    private Map<String, Map<String, String>> checkedPropertyToMap(List<CheckedPropertyInfo> checkedPropertyInfoList, Map<String, Object> customerEntityMap) {
        HashMap<String, Map<String, String>> checkedPropertyMap = new HashMap<String, Map<String, String>>();
        for (CheckedPropertyInfo checkedPropertyInfo : checkedPropertyInfoList) {
            String value = checkedPropertyInfo.getValue();
            if ("labelList".equals(value) || "teamNumberList".equals(value)) {
                List<Map<String, Object>> resultList = checkedPropertyInfo.getResult();
                for (Map<String, Object> result : resultList) {
                    String customerId = result.get("customerId").toString();
                    String valueList = result.get("value").toString();
                    HashMap<String, String> checkedPropertyByCustomerMap = (HashMap<String, String>)checkedPropertyMap.get(customerId);
                    if (CollectionUtil.isEmpty((Map)checkedPropertyByCustomerMap)) {
                        checkedPropertyByCustomerMap = new HashMap<String, String>();
                    }
                    checkedPropertyByCustomerMap.put(value, valueList);
                    if ("labelList".equals(value)) {
                        Object labelIdValue = customerEntityMap.get("labelId");
                        if (ToolUtil.isNotEmpty((Object)labelIdValue)) {
                            valueList = labelIdValue + "," + valueList;
                        }
                        customerEntityMap.put("labelId", valueList);
                        checkedPropertyByCustomerMap.put("labelId", valueList);
                    }
                    if ("teamNumberList".equals(value)) {
                        checkedPropertyByCustomerMap.put("teamMember", valueList);
                    }
                    checkedPropertyMap.put(customerId, checkedPropertyByCustomerMap);
                }
                continue;
            }
            String customerId = checkedPropertyInfo.getCustomerId().toString();
            HashMap<String, String> checkedPropertyByCustomerMap = (HashMap<String, String>)checkedPropertyMap.get(customerId);
            if (CollectionUtil.isEmpty((Map)checkedPropertyByCustomerMap)) {
                checkedPropertyByCustomerMap = new HashMap<String, String>();
            }
            String label = checkedPropertyInfo.getLabel();
            String resultValue = checkedPropertyInfo.getResultValue();
            String resultLabel = checkedPropertyInfo.getResultLabel();
            if (StringUtil.isNotEmpty((Object)value)) {
                checkedPropertyByCustomerMap.put(value, resultValue);
                if ("chargePersonId".equals(value) && StringUtil.isNotEmpty((Object)resultValue)) {
                    customerEntityMap.put(value, Long.parseLong(resultValue));
                } else if ("campaignId".equals(value) && StringUtil.isNotEmpty((Object)resultValue)) {
                    customerEntityMap.put(value, Long.parseLong(resultValue));
                } else if ("ownDepartment".equals(value) && StringUtil.isNotEmpty((Object)resultValue)) {
                    customerEntityMap.put(value, Long.parseLong(resultValue));
                } else if ("region".equals(value) && StringUtil.isNotBlank((CharSequence)resultValue)) {
                    String[] region = resultValue.split("/");
                    if (region.length > 0) {
                        customerEntityMap.put("province", region[0]);
                        if (region.length > 1) {
                            customerEntityMap.put("city", region[1]);
                            if (region.length > 2) {
                                customerEntityMap.put("county", region[2]);
                            }
                        }
                    }
                } else {
                    customerEntityMap.put(value, resultValue);
                }
            }
            if (StringUtil.isNotEmpty((Object)label)) {
                checkedPropertyByCustomerMap.put(label, resultLabel);
                customerEntityMap.put(label, resultLabel);
            }
            checkedPropertyMap.put(customerId, checkedPropertyByCustomerMap);
        }
        Object labelIds = customerEntityMap.get("labelId");
        if (ToolUtil.isNotEmpty((Object)labelIds)) {
            List labelIdList = Arrays.stream(String.valueOf(labelIds).split(",")).distinct().collect(Collectors.toList());
            String labelIdToString = StringUtil.join(labelIdList, (String)",");
            customerEntityMap.put("labelId", labelIdToString);
        }
        return checkedPropertyMap;
    }
}

