/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.contact.service.impl;

import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.contact.dao.ContactPermissionMapper;
import com.jxdinfo.crm.core.contact.service.IContactPermissionService;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ContactPermissionServiceImpl
implements IContactPermissionService {
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private ContactPermissionMapper contactPermissionMapper;

    @Override
    public List<Long> getContactIdListByPermission(Long userId) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        if (userId == null) {
            IndexUtil.currentUserRolePermissions(permissionDto, this.crmProperties);
        } else {
            IndexUtil.getUserRolePermissionsByUserId(permissionDto, this.crmProperties, userId);
        }
        if (permissionDto.getPermissionDeptIds() == null && permissionDto.getPermissionUserId() == null) {
            return null;
        }
        List<Long> contactIdList = this.contactPermissionMapper.getContactIdList(permissionDto);
        if (CollectionUtil.isEmpty(contactIdList)) {
            contactIdList.add(-1L);
        }
        return contactIdList;
    }
}

