/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.contact.external.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.api.contact.dto.ContactAPIDto;
import com.jxdinfo.crm.core.api.contact.service.IContactAPIService;
import com.jxdinfo.crm.core.api.contact.vo.ContactAPIVo;
import com.jxdinfo.crm.core.contact.dao.ContactMapper;
import com.jxdinfo.crm.core.contact.dto.ContactDto;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.contact.service.ContactService;
import com.jxdinfo.crm.core.contact.service.IContactPermissionService;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ContactApiServiceImpl
implements IContactAPIService {
    @Resource
    private ContactMapper contactMapper;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private ISysUserRoleService userRoleService;
    @Resource
    private ISysUsersService usersService;
    @Resource
    private ContactService contactService;
    @Resource
    private IContactPermissionService contactPermissionService;

    public ApiResponse<Object> selectContactListByPermission(Map<String, Object> body) {
        Long userId = null;
        if (!HussarUtils.isNotEmpty((Object)body.get("userId"))) {
            return null;
        }
        userId = HussarUtils.toLong((Object)body.get("userId"));
        List roleList = this.userRoleService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId));
        SysUsers users = this.usersService.getUser(userId);
        if (users == null) {
            return null;
        }
        long current = HussarUtils.toLong((Object)body.get("current"));
        long size = HussarUtils.toLong((Object)body.get("size"));
        SalesStatisticsDto permissionDto = this.contactOperate(roleList, users);
        Page page = new Page();
        page.setCurrent(current);
        page.setSize(size);
        String name = HussarUtils.toStr((Object)body.get("name"));
        name = name.replaceAll("%", "/%").replaceAll("_", "/_");
        Page<ContactAPIVo> contactAPIVoList = this.contactMapper.selectIdAndNameByPermission((Page<ContactAPIVo>)page, permissionDto, name);
        return ApiResponse.success(contactAPIVoList);
    }

    public ContactAPIVo selectOne(Long id) {
        ContactEntity contact = (ContactEntity)this.contactMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactEntity::getContactId, (Object)id)).eq(ContactEntity::getDelFlag, (Object)"0"));
        return (ContactAPIVo)BeanUtil.copy((Object)contact, ContactAPIVo.class);
    }

    public List<ContactAPIVo> selectList(List<Long> ids) {
        List contactList = this.contactMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ContactEntity::getContactId, ids)).eq(ContactEntity::getDelFlag, (Object)"0"));
        return BeanUtil.copy((Collection)contactList, ContactAPIVo.class);
    }

    public ContactAPIVo getById(Long typeId) {
        return (ContactAPIVo)BeanUtil.copy((Object)this.contactService.getById(typeId), ContactAPIVo.class);
    }

    public void updateById(ContactAPIVo contactEntity) {
        this.contactService.updateById(BeanUtil.copy((Object)contactEntity, ContactEntity.class));
    }

    private SalesStatisticsDto contactOperate(List<SysUserRole> roleList, SysUsers users) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        IndexUtil.currentUserRolePermissionsNew(permissionDto, this.crmProperties, "", users.getId(), users.getDepartmentId(), roleList.stream().map(SysUserRole::getGrantedRole).collect(Collectors.toList()));
        if (roleList.stream().map(SysUserRole::getGrantedRole).collect(Collectors.toList()).contains(Long.valueOf(this.crmProperties.getRoles().getAllContact()))) {
            permissionDto.setPermissionDeptIds(null);
            permissionDto.setPermissionUserId(null);
        }
        return permissionDto;
    }

    public List<ContactAPIVo> selectFirstContactByCustomer(List<Long> customerIdList, LocalDateTime createTimeStart, LocalDateTime createTimeEnd) {
        if (CollectionUtil.isEmpty(customerIdList)) {
            return null;
        }
        List<ContactEntity> list = this.contactMapper.selectContactByCustomer(customerIdList, createTimeStart, createTimeEnd);
        HashMap<Long, ContactEntity> map = new HashMap<Long, ContactEntity>();
        for (ContactEntity entity : list) {
            map.putIfAbsent(entity.getCustomerId(), entity);
        }
        return BeanUtil.copy((Collection)CollectionUtil.toList(map.values()), ContactAPIVo.class);
    }

    public List<Long> getContactIdList(Long userId) {
        return this.contactPermissionService.getContactIdListByPermission(userId);
    }

    public List<Long> getContactIdList() {
        return this.contactPermissionService.getContactIdListByPermission(null);
    }

    public List<ContactAPIVo> selectCrmContactCustomer(ContactAPIDto dto) {
        ContactDto contactDto = new ContactDto();
        BeanUtil.copyProperties((Object)dto, (Object)contactDto);
        List<ContactEntity> contactEntityList = this.contactService.selectCrmContactCustomer(contactDto);
        if (CollectionUtil.isEmpty(contactEntityList)) {
            return null;
        }
        return BeanUtil.copyProperties(contactEntityList, ContactAPIVo.class);
    }
}

