/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.utills;

import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypooloppo.model.OpportunityPoolOppo;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

public class ReadLeadsExcelUtil {
    private static int totalRows = 0;
    private static int totalCells = 0;
    private static String errorMsg;

    public static List<OpportunityEntity> getExcelInfo(MultipartFile mFile) {
        String fileName = mFile.getOriginalFilename();
        try {
            if (!ReadLeadsExcelUtil.validateExcel(fileName)) {
                return null;
            }
            boolean isExcel2003 = true;
            if (ReadLeadsExcelUtil.isExcel2007(fileName)) {
                isExcel2003 = false;
            }
            List<OpportunityEntity> userList = ReadLeadsExcelUtil.createExcel(mFile.getInputStream(), isExcel2003);
            return userList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<OpportunityPoolOppo> getExcelInfoOppo(MultipartFile mFile) {
        String fileName = mFile.getOriginalFilename();
        try {
            if (!ReadLeadsExcelUtil.validateExcel(fileName)) {
                return null;
            }
            boolean isExcel2003 = true;
            if (ReadLeadsExcelUtil.isExcel2007(fileName)) {
                isExcel2003 = false;
            }
            List<OpportunityPoolOppo> userList = ReadLeadsExcelUtil.createExcelOppo(mFile.getInputStream(), isExcel2003);
            return userList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<OpportunityEntity> createExcel(InputStream is, boolean isExcel2003) {
        try {
            Object wb = isExcel2003 ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            List<OpportunityEntity> opportunityEntityList = ReadLeadsExcelUtil.readExcelValue((Workbook)wb);
            return opportunityEntityList;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<OpportunityPoolOppo> createExcelOppo(InputStream is, boolean isExcel2003) {
        try {
            Object wb = isExcel2003 ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            List<OpportunityPoolOppo> opportunityEntityList = ReadLeadsExcelUtil.readExcelValueOppo((Workbook)wb);
            return opportunityEntityList;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static List<OpportunityEntity> readExcelValue(Workbook wb) {
        Sheet sheet = wb.getSheetAt(0);
        totalRows = sheet.getPhysicalNumberOfRows();
        if (totalRows > 1 && sheet.getRow(0) != null) {
            totalCells = sheet.getRow(0).getPhysicalNumberOfCells();
        }
        ArrayList<OpportunityEntity> opportunityEntityList = new ArrayList<OpportunityEntity>();
        for (int r = 1; r < totalRows; ++r) {
            Row row = sheet.getRow(r);
            if (row == null) continue;
            Cell cell0 = row.getCell(0);
            if (row == null || cell0 == null || CellType.STRING.equals((Object)cell0.getCellType()) && "".equals(cell0.getStringCellValue())) continue;
            OpportunityEntity opportunity = new OpportunityEntity();
            block23: for (int c = 0; c < totalCells; ++c) {
                Cell cell = row.getCell(c);
                if (!ToolUtil.isNotEmpty((Object)cell)) continue;
                switch (c) {
                    case 0: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setOpportunityName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 1: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setProcessName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 2: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setCustomerName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 3: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 4: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setContactDepartment(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                    }
                    case 5: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setSex(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 6: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setMobilePhone(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 7: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setTelephone(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 8: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setPosition(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 9: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setEmail(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 10: {
                        Object find;
                        if (cell.getCellTypeEnum() == CellType.STRING) {
                            find = cell.getStringCellValue().replace(".", "-").replace("/", "-");
                            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                            LocalDate findTime = LocalDate.parse((CharSequence)find, df);
                            opportunity.setFindTime(findTime.atStartOfDay());
                            continue block23;
                        }
                        if (cell.getCellTypeEnum() != CellType.NUMERIC) continue block23;
                        cell.setCellType(CellType.STRING);
                        find = HSSFDateUtil.getJavaDate((double)Double.valueOf(cell.getStringCellValue()));
                        opportunity.setFindTime(((Date)find).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
                        continue block23;
                    }
                    case 11: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setOpopportunityFrom(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 12: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setCampaignName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 13: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setTrade(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 14: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        if ("".equals(cell.getStringCellValue())) continue block23;
                        opportunity.setProvince(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 15: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setCity(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 16: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setCustomerDemand(cell.getStringCellValue());
                        continue block23;
                    }
                    case 17: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setProductName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 18: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setOpportunityWinRate(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 19: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setRemark(cell.getStringCellValue());
                        continue block23;
                    }
                }
            }
            opportunityEntityList.add(opportunity);
        }
        return opportunityEntityList;
    }

    private static List<OpportunityPoolOppo> readExcelValueOppo(Workbook wb) {
        Sheet sheet = wb.getSheetAt(0);
        totalRows = sheet.getPhysicalNumberOfRows();
        if (totalRows > 1 && sheet.getRow(0) != null) {
            totalCells = sheet.getRow(0).getPhysicalNumberOfCells();
        }
        ArrayList<OpportunityPoolOppo> opportunityEntityList = new ArrayList<OpportunityPoolOppo>();
        for (int r = 1; r < totalRows; ++r) {
            Row row = sheet.getRow(r);
            if (row == null) continue;
            Cell cell0 = row.getCell(0);
            if (cell0.getCellTypeEnum() == CellType.NUMERIC) {
                cell0.setCellType(CellType.STRING);
                if (row == null || cell0 == null || CellType.STRING.equals((Object)cell0.getCellType()) && "".equals(cell0.getStringCellValue())) continue;
            }
            OpportunityPoolOppo opportunity = new OpportunityPoolOppo();
            block23: for (int c = 0; c < totalCells; ++c) {
                Cell cell = row.getCell(c);
                if (!ToolUtil.isNotEmpty((Object)cell)) continue;
                switch (c) {
                    case 0: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setOpportunityName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 1: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setProcessName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 2: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setCustomerName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 3: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 4: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setContactDepartment(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                    }
                    case 5: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setSex(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 6: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setMobilePhone(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 7: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setTelephone(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 8: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setPosition(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 9: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setEmail(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 10: {
                        Object find;
                        if (cell.getCellTypeEnum() == CellType.STRING) {
                            find = cell.getStringCellValue().replace(".", "-").replace("/", "-");
                            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                            LocalDate findTime = LocalDate.parse((CharSequence)find, df);
                            opportunity.setFindTime(findTime.atStartOfDay());
                            continue block23;
                        }
                        if (cell.getCellTypeEnum() != CellType.NUMERIC) continue block23;
                        cell.setCellType(CellType.STRING);
                        find = HSSFDateUtil.getJavaDate((double)Double.valueOf(cell.getStringCellValue()));
                        opportunity.setFindTime(((Date)find).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
                        continue block23;
                    }
                    case 11: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setOpopportunityFrom(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 12: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setCampaignName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 13: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setTrade(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 14: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        if ("".equals(cell.getStringCellValue())) continue block23;
                        opportunity.setProvinceString(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 15: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setCityString(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 16: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setCustomerDemand(cell.getStringCellValue());
                        continue block23;
                    }
                    case 17: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setProductName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 18: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setOpportunityWinRate(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block23;
                    }
                    case 19: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        opportunity.setRemark(cell.getStringCellValue());
                        continue block23;
                    }
                }
            }
            opportunityEntityList.add(opportunity);
        }
        return opportunityEntityList;
    }

    public static boolean validateExcel(String filePath) {
        if (filePath == null || !ReadLeadsExcelUtil.isExcel2003(filePath) && !ReadLeadsExcelUtil.isExcel2007(filePath)) {
            errorMsg = "\u6587\u4ef6\u540d\u4e0d\u662fexcel\u683c\u5f0f";
            return false;
        }
        return true;
    }

    public static boolean isExcel2003(String filePath) {
        return filePath.matches("^.+\\.(?i)(xls)$");
    }

    public static boolean isExcel2007(String filePath) {
        return filePath.matches("^.+\\.(?i)(xlsx)$");
    }
}

