/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunitystage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityStageVo;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageMergeListDto;
import com.jxdinfo.crm.core.api.stageprocess.vo.StageMergeListVo;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.competitoranalysis.model.CompetitorAnalysis;
import com.jxdinfo.crm.core.competitoranalysis.service.CompetitorAnalysisService;
import com.jxdinfo.crm.core.contactcharacter.model.ContactCharacterEntity;
import com.jxdinfo.crm.core.contactcharacter.service.ContactCharacterService;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypooloppo.model.OpportunityPoolOppo;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypooloppo.service.OpportunityPoolOppoService;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.fileinfo.model.FileInfo;
import com.jxdinfo.crm.core.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityStageMapper;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.opportunityproduct.model.OpportunityProduct;
import com.jxdinfo.crm.core.opportunityproduct.service.OpportunityProductService;
import com.jxdinfo.crm.core.opportunitystage.dao.StageProcessMapper;
import com.jxdinfo.crm.core.opportunitystage.dto.StageDto;
import com.jxdinfo.crm.core.opportunitystage.dto.StageKeyTaskDto;
import com.jxdinfo.crm.core.opportunitystage.dto.StageProcessDto;
import com.jxdinfo.crm.core.opportunitystage.model.ProcessUserDefaultEntity;
import com.jxdinfo.crm.core.opportunitystage.model.StageCrossingEntity;
import com.jxdinfo.crm.core.opportunitystage.model.StageKeyTaskEntity;
import com.jxdinfo.crm.core.opportunitystage.model.StageProcessEntity;
import com.jxdinfo.crm.core.opportunitystage.model.StageProcessPermissionEntity;
import com.jxdinfo.crm.core.opportunitystage.model.StageTaskDetailEntity;
import com.jxdinfo.crm.core.opportunitystage.model.StageTaskOpptyRelationEntity;
import com.jxdinfo.crm.core.opportunitystage.service.IProcessUserDefaultService;
import com.jxdinfo.crm.core.opportunitystage.service.IStageCrossingService;
import com.jxdinfo.crm.core.opportunitystage.service.IStageKeyTaskService;
import com.jxdinfo.crm.core.opportunitystage.service.IStageProcessPermissionService;
import com.jxdinfo.crm.core.opportunitystage.service.IStageProcessService;
import com.jxdinfo.crm.core.opportunitystage.service.IStageTaskDetailService;
import com.jxdinfo.crm.core.opportunitystage.service.IStageTaskOpptyRelationService;
import com.jxdinfo.crm.core.opportunitystage.vo.ProcessSelectionVo;
import com.jxdinfo.crm.core.opportunitystage.vo.StageKeyTaskVo;
import com.jxdinfo.crm.core.opportunitystage.vo.StageProcessPermissionVo;
import com.jxdinfo.crm.core.opportunitystage.vo.StageProcessVo;
import com.jxdinfo.crm.core.opportunitystage.vo.StageTaskDetailVo;
import com.jxdinfo.crm.core.opportunitystage.vo.StageVo;
import com.jxdinfo.crm.core.opportunitystage.vo.TaskFiledVo;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.product.vo.OpptyTargetProfileVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StageProcessServiceImpl
extends ServiceImpl<StageProcessMapper, StageProcessEntity>
implements IStageProcessService {
    @Resource
    private StageProcessMapper stageProcessMapper;
    @Resource
    private IStageProcessPermissionService stageProcessPermissionService;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private IStageCrossingService stageCrossingService;
    @Resource
    private IStageKeyTaskService stageKeyTaskService;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private IStageTaskDetailService stageTaskDetailService;
    @Resource
    private IProcessUserDefaultService processUserDefaultService;
    @Resource
    private IStageTaskOpptyRelationService stageTaskOpptyRelationService;
    @Resource
    private ContactCharacterService contactCharacterService;
    @Resource
    private OpportunityProductService opportunityProductService;
    @Resource
    private CompetitorAnalysisService competitorAnalysisService;
    @Resource
    private FileInfoService fileInfoService;
    @Resource
    private CommonService commonService;
    @Resource
    private OpportunityPoolOppoService opportunityPoolOppoService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private OpportunityStageMapper opportunityStageMapper;

    public ApiResponse selectStageProcessList(StageProcessDto dto) {
        dto.setProcessName(dto.getProcessName().replaceAll("%", "/%").replaceAll("_", "/_"));
        dto.setCreatorName(dto.getCreatorName().replaceAll("%", "/%").replaceAll("_", "/_"));
        dto.setLastEditorName(dto.getCreatorName());
        Page page = dto.getPage();
        List<StageProcessVo> voList = this.stageProcessMapper.selectStageProcessList(page, dto);
        for (StageProcessVo vo : voList) {
            if ("0".equals(vo.getPermissionScope())) {
                vo.setPermissionScope("\u5168\u5458\u53ef\u89c1");
                continue;
            }
            if (!"1".equals(vo.getPermissionScope())) continue;
            if (CollectionUtil.isEmpty(vo.getPermissionList())) {
                vo.setPermissionScope("\u65e0");
                continue;
            }
            vo.setPermissionScope(vo.getPermissionList().stream().map(StageProcessPermissionVo::getBusinessName).collect(Collectors.joining("\u3001")));
        }
        page.setRecords(voList);
        return ApiResponse.success(page);
    }

    @Override
    public StageProcessVo selectStageProcessDetail(Long id) {
        StageProcessVo stageProcessVo;
        long countProcessUse = this.stageProcessUseCount((stageProcessVo = this.stageProcessMapper.selectStageProcessDetail(id)).getModuleId(), id);
        stageProcessVo.setUsed(countProcessUse > 0L);
        List<StageVo> stageVoList = stageProcessVo.getStageList();
        List<Long> usedId = this.stageUseCheck(id, stageProcessVo.getModuleId(), stageVoList.stream().map(StageVo::getCustomerStageId).collect(Collectors.toList()));
        for (StageVo stage : stageVoList) {
            stage.setUsed(usedId.contains(stage.getCustomerStageId()));
        }
        return stageProcessVo;
    }

    @Override
    public StageProcessVo selectProcessDetailByOpportunityId(Long opportunityId) {
        OpportunityEntity opportunity = (OpportunityEntity)this.opportunityService.getById(opportunityId);
        Long processId = opportunity == null ? ((OpportunityPoolOppo)this.opportunityPoolOppoService.getById(opportunityId)).getStageProcessId() : opportunity.getStageProcessId();
        if (processId == null) {
            return null;
        }
        StageProcessVo stageProcessVo = this.stageProcessMapper.selectStageProcessDetail(processId);
        List relationList = this.stageTaskOpptyRelationService.list((Wrapper)new LambdaQueryWrapper().eq(StageTaskOpptyRelationEntity::getOpportunityId, (Object)opportunityId));
        Map<Long, List<StageTaskOpptyRelationEntity>> detailCompletedMap = relationList.stream().collect(Collectors.groupingBy(StageTaskOpptyRelationEntity::getTaskDetailId));
        for (StageVo stage : stageProcessVo.getStageList()) {
            if (stage.getTaskList() == null) continue;
            for (StageKeyTaskVo stageKeyTaskVo : stage.getTaskList()) {
                if (stageKeyTaskVo.getTaskDetailList() == null) continue;
                for (StageTaskDetailVo detailVo : stageKeyTaskVo.getTaskDetailList()) {
                    List<StageTaskOpptyRelationEntity> relationEntityList = detailCompletedMap.get(detailVo.getTaskDetailId());
                    if (CollectionUtil.isEmpty(relationEntityList)) continue;
                    detailVo.setIsCompleted(relationEntityList.get(0).getIsCompleted());
                }
            }
        }
        List<TaskFiledVo> fieldList = this.stageProcessMapper.getTaskField(CrmBusinessTypeEnum.OPPORTUNITY.getId());
        HashMap<Long, TaskFiledVo> taskFiledVoMap = new HashMap<Long, TaskFiledVo>();
        for (TaskFiledVo taskFiledVo : fieldList) {
            taskFiledVoMap.put(taskFiledVo.getFieldId(), taskFiledVo);
        }
        HashSet<String> dicTypeName = new HashSet<String>();
        for (StageVo stageVo : stageProcessVo.getStageList()) {
            for (StageKeyTaskVo taskVo : stageVo.getTaskList()) {
                for (StageTaskDetailVo detailVo : taskVo.getTaskDetailList()) {
                    TaskFiledVo taskFiledVo = (TaskFiledVo)taskFiledVoMap.get(detailVo.getFieldId());
                    if (detailVo.getFieldId() == null || taskFiledVo == null) continue;
                    if (taskFiledVo.getDicTypeName() != null) {
                        dicTypeName.add(taskFiledVo.getDicTypeName());
                    }
                    detailVo.setValueType(taskFiledVo.getValueType());
                    detailVo.setEntityFieldName(taskFiledVo.getFieldName());
                }
            }
        }
        if (CollectionUtil.isNotEmpty(dicTypeName)) {
            List<DicSingle> list = this.commonService.selectDicByTypeNames(new ArrayList<String>(dicTypeName));
            Map<String, List<DicSingle>> map = list.stream().collect(Collectors.groupingBy(DicSingle::getTypeName));
            for (StageVo stageVo : stageProcessVo.getStageList()) {
                for (StageKeyTaskVo taskVo : stageVo.getTaskList()) {
                    for (StageTaskDetailVo detailVo : taskVo.getTaskDetailList()) {
                        if (detailVo.getFieldId() == null || taskFiledVoMap.get(detailVo.getFieldId()) == null || ((TaskFiledVo)taskFiledVoMap.get(detailVo.getFieldId())).getDicTypeName() == null) continue;
                        detailVo.setDicList(map.get(((TaskFiledVo)taskFiledVoMap.get(detailVo.getFieldId())).getDicTypeName()));
                    }
                }
            }
        }
        return stageProcessVo;
    }

    @Override
    @Transactional
    public ApiResponse<String> saveStageProcess(StageProcessDto dto) {
        Long stageProcessId;
        long count;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(StageProcessEntity::getProcessName, (Object)dto.getProcessName())).eq(StageProcessEntity::getDelFlag, (Object)"0");
        if (dto.getStageProcessId() != null) {
            wrapper.ne(StageProcessEntity::getStageProcessId, (Object)dto.getStageProcessId());
        }
        if ((count = this.count((Wrapper)wrapper)) > 0L) {
            return ApiResponse.fail((String)"\u6d41\u7a0b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        LocalDateTime dateTime = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        if (dto.getStageProcessId() == null) {
            stageProcessId = Long.valueOf(CommonUtills.generateAssignId());
            dto.setStageProcessId(stageProcessId);
            dto.setCreateTime(dateTime);
            dto.setCreator(user.getUserId());
            dto.setCreatorName(user.getUserName());
            dto.setDelFlag("0");
        } else {
            stageProcessId = dto.getStageProcessId();
            if (CollectionUtil.isNotEmpty(dto.getDelStageId())) {
                if (!this.stageUseCheck(stageProcessId, dto.getModuleId(), dto.getDelStageId()).isEmpty()) {
                    return ApiResponse.fail((int)10001, (String)"\u9636\u6bb5\u5df2\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
                }
                this.opportunityStageService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(OpportunityStage::getCustomerStageId, dto.getDelStageId())).set(OpportunityStage::getDelFlag, (Object)"1"));
            }
            this.stageCrossingService.remove((Wrapper)new LambdaQueryWrapper().eq(StageCrossingEntity::getProcessId, (Object)stageProcessId));
            this.stageTaskDetailService.remove((Wrapper)new LambdaQueryWrapper().eq(StageTaskDetailEntity::getProcessId, (Object)stageProcessId));
            this.stageKeyTaskService.remove((Wrapper)new LambdaQueryWrapper().eq(StageKeyTaskEntity::getProcessId, (Object)stageProcessId));
            this.stageProcessPermissionService.remove((Wrapper)new LambdaQueryWrapper().eq(StageProcessPermissionEntity::getProcessId, (Object)stageProcessId));
        }
        dto.setLastEditor(user.getUserId());
        dto.setLastEditorName(user.getUserName());
        dto.setLastTime(dateTime);
        this.saveOrUpdate(BeanUtil.copy((Object)dto, StageProcessEntity.class));
        List<StageDto> stageDtoList = dto.getStageList();
        ArrayList<StageCrossingEntity> stageCrossingEntities = new ArrayList<StageCrossingEntity>();
        ArrayList<StageKeyTaskDto> stageKeyTaskList = new ArrayList<StageKeyTaskDto>();
        ArrayList<StageTaskDetailEntity> stageTaskDetailEntities = new ArrayList<StageTaskDetailEntity>();
        if (CollectionUtil.isNotEmpty(stageDtoList)) {
            for (StageDto stageDto : stageDtoList) {
                if (stageDto.getCustomerStageId() == null) {
                    stageDto.setCustomerStageId(Long.valueOf(CommonUtills.generateAssignId()));
                }
                if (stageDto.getStageProcessId() == null) {
                    stageDto.setStageProcessId(stageProcessId);
                }
                if (StringUtil.isEmpty((Object)stageDto.getDelFlag())) {
                    stageDto.setDelFlag("0");
                }
                Long stageId = stageDto.getCustomerStageId();
                if (CollectionUtil.isNotEmpty(stageDto.getCrossingList())) {
                    for (StageCrossingEntity stageCrossing : stageDto.getCrossingList()) {
                        if (stageCrossing.getStageId() != null) continue;
                        stageCrossing.setStageId(stageId);
                        stageCrossing.setProcessId(stageProcessId);
                    }
                    stageCrossingEntities.addAll(stageDto.getCrossingList());
                }
                if (!CollectionUtil.isNotEmpty(stageDto.getTaskList())) continue;
                for (StageKeyTaskDto stageKeyTask : stageDto.getTaskList()) {
                    if (stageKeyTask.getStageId() == null) {
                        stageKeyTask.setStageId(stageId);
                        stageKeyTask.setProcessId(stageProcessId);
                    }
                    if (stageKeyTask.getStageTaskId() == null) {
                        stageKeyTask.setStageTaskId(Long.valueOf(CommonUtills.generateAssignId()));
                        stageKeyTask.setProcessId(stageProcessId);
                    }
                    if (CollectionUtil.isNotEmpty(stageKeyTask.getTaskDetailList())) {
                        for (StageTaskDetailEntity detail : stageKeyTask.getTaskDetailList()) {
                            detail.setStageTaskId(stageKeyTask.getStageTaskId());
                            detail.setProcessId(stageProcessId);
                            detail.setStageId(stageId);
                        }
                    }
                    stageTaskDetailEntities.addAll(stageKeyTask.getTaskDetailList());
                }
                stageKeyTaskList.addAll(stageDto.getTaskList());
            }
            this.opportunityStageService.saveOrUpdateBatch(BeanUtil.copy(stageDtoList, OpportunityStage.class));
            this.stageCrossingService.saveOrUpdateBatch(stageCrossingEntities);
            this.stageKeyTaskService.saveOrUpdateBatch(BeanUtil.copy(stageKeyTaskList, StageKeyTaskEntity.class));
            this.stageTaskDetailService.saveOrUpdateBatch(stageTaskDetailEntities);
        }
        if ("1".equals(dto.getPermissionScope()) && CollectionUtil.isNotEmpty(dto.getPermissionList())) {
            List<StageProcessPermissionEntity> stageProcessPermissionDtoList = dto.getPermissionList();
            for (StageProcessPermissionEntity spp : stageProcessPermissionDtoList) {
                if (spp.getProcessId() != null) continue;
                spp.setProcessId(stageProcessId);
            }
            this.stageProcessPermissionService.saveOrUpdateBatch(stageProcessPermissionDtoList);
        }
        return ApiResponse.success();
    }

    @Override
    public String checkStageUse(Long processId, Long stageId, String moduleId) {
        List<Long> usedId = this.stageUseCheck(processId, moduleId, Collections.singletonList(stageId));
        if (CollectionUtil.isNotEmpty(usedId)) {
            return "1";
        }
        return "0";
    }

    @Override
    @Transactional
    public ApiResponse<String> delProcess(Long processId, String moduleId) {
        long countUse = this.stageProcessUseCount(moduleId, processId);
        if (countUse > 0L) {
            return ApiResponse.fail((int)10001, (String)"\u9636\u6bb5\u6d41\u7a0b\u5df2\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.stageCrossingService.remove((Wrapper)new LambdaQueryWrapper().eq(StageCrossingEntity::getProcessId, (Object)processId));
        this.stageTaskOpptyRelationService.remove((Wrapper)new LambdaQueryWrapper().eq(StageTaskOpptyRelationEntity::getProcessId, (Object)processId));
        this.stageTaskDetailService.remove((Wrapper)new LambdaQueryWrapper().eq(StageTaskDetailEntity::getProcessId, (Object)processId));
        this.stageKeyTaskService.remove((Wrapper)new LambdaQueryWrapper().eq(StageKeyTaskEntity::getProcessId, (Object)processId));
        this.opportunityStageService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(OpportunityStage::getStageProcessId, (Object)processId)).set(OpportunityStage::getDelFlag, (Object)"1"));
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(StageProcessEntity::getStageProcessId, (Object)processId)).set(StageProcessEntity::getDelFlag, (Object)"1"));
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    private Set<Long> getAllParentDeptId(Set<Long> parentIds, List<Map<String, Long>> struList, Long deptId) {
        Long parentId = DataPermission.getParentIdByDeptId(struList, deptId);
        if (Objects.equals(parentId, deptId)) {
            return parentIds;
        }
        parentIds.add(parentId);
        return this.getAllParentDeptId(parentIds, struList, parentId);
    }

    @Override
    public ApiResponse<List<StageProcessVo>> processListForSelection(String moduleId) {
        SecurityUser user = BaseSecurityUtil.getUser();
        List<Map<String, Long>> struList = DataPermission.getStruCache();
        HashSet<Long> parentIds = new HashSet<Long>();
        this.getAllParentDeptId(parentIds, struList, user.getDeptId());
        parentIds.add(user.getDeptId());
        List<StageProcessVo> list = this.stageProcessMapper.selectProcessListForSelection(moduleId, user, parentIds);
        if (CollectionUtil.isEmpty(list)) {
            return ApiResponse.success(list);
        }
        ProcessUserDefaultEntity processUserDefault = (ProcessUserDefaultEntity)this.processUserDefaultService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProcessUserDefaultEntity::getUserId, (Object)user.getUserId())).eq(ProcessUserDefaultEntity::getModuleId, (Object)moduleId));
        if (processUserDefault != null) {
            for (StageProcessVo vo : list) {
                if (!vo.getStageProcessId().equals(processUserDefault.getProcessId())) continue;
                vo.setIsDefault("1");
            }
        } else {
            list.get(0).setIsDefault("1");
        }
        return ApiResponse.success(list);
    }

    private List<Long> stageUseCheck(Long processId, String moduleId, List<Long> idList) {
        Set<Object> usedIdSet;
        List stageList = this.opportunityStageService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityStage::getStageProcessId, (Object)processId)).orderByAsc(OpportunityStage::getOrderNumber));
        if (CrmBusinessTypeEnum.OPPORTUNITY.getId().equals(moduleId)) {
            List list = this.opportunityService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityEntity::getStageProcessId, (Object)processId)).eq(OpportunityEntity::getDelFlag, (Object)"0"));
            if (CollectionUtil.isEmpty((Collection)list)) {
                return new ArrayList<Long>();
            }
            usedIdSet = list.stream().map(o -> {
                if (HussarUtils.isNotEmpty((Object)o.getCustomerStageId())) {
                    return Long.parseLong(o.getCustomerStageId());
                }
                return null;
            }).collect(Collectors.toSet());
        } else {
            usedIdSet = new HashSet();
        }
        List usedStage = stageList.stream().filter(opportunityStage -> usedIdSet.contains(opportunityStage.getCustomerStageId())).collect(Collectors.toList());
        List checkStage = stageList.stream().filter(opportunityStage -> idList.contains(opportunityStage.getCustomerStageId())).collect(Collectors.toList());
        ArrayList<Long> resultUsedId = new ArrayList<Long>();
        block0: for (OpportunityStage check : checkStage) {
            if (check.getStageType().charAt(0) != '2') {
                for (OpportunityStage used : usedStage) {
                    if (Integer.parseInt(used.getOrderNumber()) < Integer.parseInt(check.getOrderNumber())) continue;
                    resultUsedId.add(check.getCustomerStageId());
                    continue block0;
                }
                continue;
            }
            for (OpportunityStage used : usedStage) {
                if (!used.getCustomerStageId().equals(check.getCustomerStageId())) continue;
                resultUsedId.add(check.getCustomerStageId());
                continue block0;
            }
        }
        return resultUsedId;
    }

    private long stageProcessUseCount(String moduleId, Long processId) {
        long count = 0L;
        if (CrmBusinessTypeEnum.OPPORTUNITY.getId().equals(moduleId)) {
            count = this.opportunityService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityEntity::getStageProcessId, (Object)processId)).eq(OpportunityEntity::getDelFlag, (Object)"0"));
        }
        return count;
    }

    @Override
    public ApiResponse<Map<String, List<TaskFiledVo>>> getTaskField(String moduleId) {
        List<TaskFiledVo> list = this.stageProcessMapper.getTaskField(moduleId);
        Map<String, List<TaskFiledVo>> map = list.stream().collect(Collectors.groupingBy(TaskFiledVo::getFileInfoGroup));
        return ApiResponse.success(map);
    }

    @Override
    public ApiResponse<String> changePublishStatus(String status, Long processId) {
        if (!"1".equals(status) && !"2".equals(status)) {
            return ApiResponse.fail((String)"\u65e0\u6cd5\u5207\u6362\u72b6\u6001");
        }
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(StageProcessEntity::getStageProcessId, (Object)processId)).set(StageProcessEntity::getPublishStatus, (Object)status));
        return ApiResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    public String checkField(String moduleId, Object checkObject, List<Long> fieldIds) {
        if (CollectionUtil.isEmpty(fieldIds)) {
            return "0";
        }
        List<TaskFiledVo> list = this.stageProcessMapper.selectFieldByIds(fieldIds);
        ArrayList<String> unfilledList = new ArrayList<String>();
        try {
            for (TaskFiledVo vo : list) {
                Field field = checkObject.getClass().getDeclaredField(vo.getFieldName());
                field.setAccessible(true);
                if (!HussarUtils.isEmpty((Object)field.get(checkObject))) continue;
                unfilledList.add("\u201c" + vo.getFieldDescribe() + "\u201d");
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        if (CollectionUtil.isNotEmpty(unfilledList)) {
            return "\u5b57\u6bb5\uff1a" + String.join((CharSequence)"\u3001", unfilledList) + "\u672a\u5b8c\u6210\u586b\u5199";
        }
        return "0";
    }

    @Override
    public String checkOpportunityData(OpportunityEntity opportunity, List<String> checkDataList) {
        List fileInfos;
        List competitorAnalysisList;
        List opportunityProductList;
        List contactCharacterList;
        if (CollectionUtil.isEmpty(checkDataList)) {
            return "0";
        }
        ArrayList<String> unfilledList = new ArrayList<String>();
        if (checkDataList.contains("1") && opportunity.getCustomerId() == null) {
            unfilledList.add("\u201c\u5173\u8054\u5ba2\u6237\u201d");
        }
        if (checkDataList.contains("3") && CollectionUtil.isEmpty((Collection)(contactCharacterList = this.contactCharacterService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactCharacterEntity::getOpportunityId, (Object)opportunity.getOpportunityId())).eq(ContactCharacterEntity::getDelFlag, (Object)"0"))))) {
            unfilledList.add("\u201c\u5546\u673a\u5e72\u7cfb\u4eba\u201d");
        }
        if (checkDataList.contains("4") && CollectionUtil.isEmpty((Collection)(opportunityProductList = this.opportunityProductService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityProduct::getOpportunityId, (Object)opportunity.getOpportunityId())).eq(OpportunityProduct::getDelFlag, (Object)"0"))))) {
            unfilledList.add("\u201c\u5546\u673a\u4ea7\u54c1\u201d");
        }
        if (checkDataList.contains("5") && CollectionUtil.isEmpty((Collection)(competitorAnalysisList = this.competitorAnalysisService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CompetitorAnalysis::getOpportunityId, (Object)opportunity.getOpportunityId())).eq(CompetitorAnalysis::getDelFlag, (Object)"0"))))) {
            unfilledList.add("\u201c\u7ade\u5bf9\u5206\u6790\u201d");
        }
        if (checkDataList.contains("6") && CollectionUtil.isEmpty((Collection)(fileInfos = this.fileInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FileInfo::getBusinessId, (Object)opportunity.getOpportunityId())).eq(FileInfo::getDelFlag, (Object)"0"))))) {
            unfilledList.add("\u201c\u9644\u4ef6\u4fe1\u606f\u201d");
        }
        if (checkDataList.contains("7")) {
            boolean notFillFlag = false;
            List<Map<String, Object>> mapList = this.opportunityProductService.getOpportunityProductList(opportunity.getOpportunityId());
            if (CollectionUtil.isNotEmpty(mapList)) {
                block0: for (Map<String, Object> map : mapList) {
                    List profileVoList = (List)map.get("oppTargetProfile");
                    if (!CollectionUtil.isNotEmpty((Collection)profileVoList)) continue;
                    for (OpptyTargetProfileVo vo : profileVoList) {
                        if (!HussarUtils.isEmpty((Object)vo.getIsMatched())) continue;
                        notFillFlag = true;
                        break block0;
                    }
                }
                if (notFillFlag) {
                    unfilledList.add("\u201c\u5ba2\u6237\u753b\u50cf\u5339\u914d\u5ea6\u201d");
                }
            }
        }
        if (CollectionUtil.isNotEmpty(unfilledList)) {
            return "\u6570\u636e\uff1a" + String.join((CharSequence)"\u3001", unfilledList) + "\u201d\u672a\u5b8c\u6210\u586b\u5199";
        }
        return "0";
    }

    @Override
    public String checkOpportunityOtherTask(Long opportunityId, List<Long> otherTaskId) {
        if (CollectionUtil.isEmpty(otherTaskId)) {
            return "0";
        }
        List list = this.stageTaskOpptyRelationService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(StageTaskOpptyRelationEntity::getTaskDetailId, otherTaskId)).eq(StageTaskOpptyRelationEntity::getOpportunityId, (Object)opportunityId));
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (StageTaskOpptyRelationEntity entity : list) {
                if ("1".equals(entity.getIsCompleted())) continue;
                return "\u5176\u4ed6\u4efb\u52a1\u672a\u5b8c\u6210\u586b\u5199";
            }
        }
        return "0";
    }

    @Override
    public List<StageMergeListVo> getStageMergeListByModule(StageMergeListDto dto) {
        List<StageMergeListVo> resultList = this.stageProcessMapper.getStageMergeListByModule(dto);
        List dicVoList = this.sysDicRefService.getDicListByType("salesProcess_StageList");
        if (dto.getMerge().booleanValue()) {
            ArrayList<StageMergeListVo> list = new ArrayList<StageMergeListVo>();
            Map<String, List<StageMergeListVo>> map = resultList.stream().collect(Collectors.groupingBy(StageMergeListVo::getStageName));
            for (int i = 0; i < dicVoList.size(); ++i) {
                if (map.get(((DicVo)dicVoList.get(i)).getLabel()) == null) continue;
                String stageId = map.get(((DicVo)dicVoList.get(i)).getLabel()).stream().map(StageMergeListVo::getStageId).collect(Collectors.joining(","));
                String stageType = map.get(((DicVo)dicVoList.get(i)).getLabel()).stream().map(StageMergeListVo::getStageType).collect(Collectors.joining(","));
                StageMergeListVo stageMergeListVo = new StageMergeListVo();
                stageMergeListVo.setStageId(stageId);
                stageMergeListVo.setStageType(stageType);
                stageMergeListVo.setStageName(((DicVo)dicVoList.get(i)).getLabel());
                stageMergeListVo.setStageNameValue(((DicVo)dicVoList.get(i)).getValue());
                stageMergeListVo.setOrderNumber(Integer.valueOf(i));
                list.add(stageMergeListVo);
            }
            return list;
        }
        return resultList;
    }

    @Override
    public List<ProcessSelectionVo> opportunityProcessUsed() {
        return this.stageProcessMapper.selectOpportunityProcessUsed();
    }

    @Override
    public List<OpportunityStageVo> completedStage() {
        CrmBaseConfigVo configVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("stage_config");
        List<Long> tqkgStageIdList = Arrays.stream(configVo.getConfigValue().split(",")).map(Long::parseLong).collect(Collectors.toList());
        List<OpportunityStageVo> opportunityStageVoList = this.opportunityStageMapper.selectCompletedStage(tqkgStageIdList);
        Map<String, List<OpportunityStageVo>> map = opportunityStageVoList.stream().collect(Collectors.groupingBy(OpportunityStageVo::getStageName));
        ArrayList<OpportunityStageVo> resultList = new ArrayList<OpportunityStageVo>();
        for (Map.Entry<String, List<OpportunityStageVo>> entry : map.entrySet()) {
            OpportunityStageVo opportunityStageVo = new OpportunityStageVo();
            opportunityStageVo.setStageName(entry.getValue().get(0).getStageName());
            String stageId = entry.getValue().stream().map(OpportunityStageVo::getStageId).collect(Collectors.joining(","));
            HashSet<String> stageType = new HashSet<String>();
            for (OpportunityStageVo vo : entry.getValue()) {
                stageType.add(vo.getStageType());
            }
            opportunityStageVo.setStageType(String.join((CharSequence)",", stageType));
            opportunityStageVo.setStageId(stageId);
            resultList.add(opportunityStageVo);
        }
        return resultList;
    }
}

