/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunity.service.impl;

import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.organUser.IUserBoService;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityPermissionMapper;
import com.jxdinfo.crm.core.opportunity.service.IOpportunityPermissionService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.mongodb.lang.Nullable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OpportunityPermissionServiceImpl
implements IOpportunityPermissionService {
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private OpportunityPermissionMapper opportunityPermissionMapper;
    @Resource
    private IUserBoService userBoService;

    @Override
    public List<Long> getOpportunityIdListByPermission(@Nullable Long userId) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        SecurityUser user = new SecurityUser();
        if (userId == null) {
            user = BaseSecurityUtil.getUser();
            IndexUtil.currentUserRolePermissions(permissionDto, this.crmProperties);
        } else {
            user = this.userBoService.selectSecurityByUserId(userId);
            IndexUtil.getUserRolePermissionsByUserId(permissionDto, this.crmProperties, userId);
        }
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
            permissionDto.setPermissionDeptIds(null);
            permissionDto.setPermissionUserId(null);
        }
        if (permissionDto.getPermissionDeptIds() == null && permissionDto.getPermissionUserId() == null) {
            return null;
        }
        List<Long> opportunityIdList = this.opportunityPermissionMapper.getOpportunityIdList(permissionDto);
        if (CollectionUtil.isEmpty(opportunityIdList)) {
            opportunityIdList.add(-1L);
        }
        return opportunityIdList;
    }

    @Override
    public List<Long> getOpportunityIdListByPermission(@Nullable Long userId, @Nullable List<Long> productIds, @Nullable List<Long> stageIds) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        SecurityUser user = new SecurityUser();
        if (userId == null) {
            user = BaseSecurityUtil.getUser();
            IndexUtil.currentUserRolePermissions(permissionDto, this.crmProperties);
        } else {
            user = this.userBoService.selectSecurityByUserId(userId);
            IndexUtil.getUserRolePermissionsByUserId(permissionDto, this.crmProperties, userId);
        }
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
            permissionDto.setPermissionDeptIds(null);
            permissionDto.setPermissionUserId(null);
        }
        if (permissionDto.getPermissionDeptIds() == null && permissionDto.getPermissionUserId() == null) {
            return null;
        }
        List<Long> opportunityIdList = this.opportunityPermissionMapper.getOpportunityIdListByProductAndStage(permissionDto, productIds, stageIds);
        if (CollectionUtil.isEmpty(opportunityIdList)) {
            opportunityIdList.add(-1L);
        }
        return opportunityIdList;
    }
}

