/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.leads.service.impl;

import com.jxdinfo.crm.core.associativeQuery.dto.AssociativeLabelVo;
import com.jxdinfo.crm.core.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.core.associativeQuery.service.AssociativeFiledQueryService;
import com.jxdinfo.crm.core.common.vo.AssociativeQueryVo;
import com.jxdinfo.crm.core.leads.dto.LeadsOriginAssociativeQueryDto;
import com.jxdinfo.crm.core.leads.dto.LeadsOriginDto;
import com.jxdinfo.crm.core.leads.service.LeadsOriginAssociativeQueryService;
import com.jxdinfo.crm.core.leads.vo.LeadsAssociativeQueryEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class LeadsOriginAssociativeQueryServiceImpl
implements LeadsOriginAssociativeQueryService {
    @Resource
    private AssociativeFiledQueryService associativeFiledQueryService;

    @Override
    public List<AssociativeQueryVo> getAssociativeQueryVo(String keyword, AssociativeQueryDto associativeQueryDto, Map<String, List<String>> excludeInfoMap) {
        ArrayList<AssociativeQueryVo> associativeQueryVoList = new ArrayList<AssociativeQueryVo>();
        LeadsOriginAssociativeQueryDto leadsAssociativeQueryDto = null;
        if (associativeQueryDto instanceof LeadsOriginAssociativeQueryDto) {
            leadsAssociativeQueryDto = (LeadsOriginAssociativeQueryDto)associativeQueryDto;
        }
        assert (leadsAssociativeQueryDto != null);
        LeadsOriginDto leadsDto = leadsAssociativeQueryDto.getDto();
        List<String> fromList = null;
        List<String> productIds = null;
        List<Long> campaignIds = null;
        List<String> tradeList = null;
        String createTimeTage = null;
        List<String> createDepIds = null;
        List<String> createPersonList = null;
        if (leadsDto != null) {
            fromList = leadsDto.getLeadsOrigins();
            productIds = leadsDto.getProductIds();
            campaignIds = leadsDto.getCampaignIds();
            tradeList = leadsDto.getTrades();
            createTimeTage = leadsDto.getCreateTimeFlag();
            createDepIds = leadsDto.getCreateDepartmentIds();
            createPersonList = leadsDto.getCreatePersonIds();
        }
        List<String> selectedProducts = excludeInfoMap.get("selectedProducts");
        selectedProducts = this.associativeFiledQueryService.getProductAssociativeQuery(associativeQueryVoList, keyword, selectedProducts, productIds, this.getAssociateLabelVoByEnum(LeadsAssociativeQueryEnum.LEAD_ORIGIN_PRODUCT_TYPES));
        excludeInfoMap.put("selectedProducts", selectedProducts);
        List<String> selectedFroms = excludeInfoMap.get("selectedFroms");
        selectedFroms = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedFroms, fromList, this.getAssociateLabelVoByEnum(LeadsAssociativeQueryEnum.LEAD_ORIGIN_FROM));
        excludeInfoMap.put("selectedFroms", selectedFroms);
        List<String> selectedCampaignIds = excludeInfoMap.get("selectedCampaignIds");
        selectedCampaignIds = this.associativeFiledQueryService.getCampaignIdAssociativeQuery(associativeQueryVoList, keyword, selectedCampaignIds, campaignIds, this.getAssociateLabelVoByEnum(LeadsAssociativeQueryEnum.LEAD_ORIGIN_CAMPAIGN));
        excludeInfoMap.put("selectedCampaignIds", selectedCampaignIds);
        List<String> selectedTrades = excludeInfoMap.get("selectedTrades");
        selectedTrades = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedTrades, tradeList, this.getAssociateLabelVoByEnum(LeadsAssociativeQueryEnum.LEAD_INDUSTRY));
        excludeInfoMap.put("selectedTrades", selectedTrades);
        List<String> selectedCreatePersonIds = excludeInfoMap.get("selectedCreatePersonIds");
        selectedCreatePersonIds = this.associativeFiledQueryService.getCreatePersonIdAssociativeQuery(associativeQueryVoList, keyword, selectedCreatePersonIds, createPersonList, this.getAssociateLabelVoByEnum(LeadsAssociativeQueryEnum.LEAD_ORIGIN_CREATE_USER));
        excludeInfoMap.put("selectedCreatePersonIds", selectedCreatePersonIds);
        List<String> selectedCreateDepartments = excludeInfoMap.get("selectedCreateDepartments");
        selectedCreateDepartments = this.associativeFiledQueryService.getCreateDepartmentAssociativeQuery(associativeQueryVoList, keyword, selectedCreateDepartments, createDepIds, this.getAssociateLabelVoByEnum(LeadsAssociativeQueryEnum.LEAD_ORIGIN_CREATE_DEPT));
        excludeInfoMap.put("selectedCreateDepartments", selectedCreateDepartments);
        List<String> selectedCreateTimes = excludeInfoMap.get("selectedCreateTimes");
        selectedCreateTimes = this.associativeFiledQueryService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedCreateTimes, createTimeTage, this.getAssociateLabelVoByEnum(LeadsAssociativeQueryEnum.LEAD_ORIGIN_CREATE_TIME));
        excludeInfoMap.put("selectedCreateTimes", selectedCreateTimes);
        return associativeQueryVoList;
    }

    private AssociativeLabelVo getAssociateLabelVoByEnum(LeadsAssociativeQueryEnum queryEnum) {
        return new AssociativeLabelVo(queryEnum.getLabelName(), queryEnum.getDataName(), queryEnum.getDictTypeName(), queryEnum.getMultiOption());
    }
}

