/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.fileinfo.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.core.fileinfo.dto.FileInfoDto;
import com.jxdinfo.crm.core.fileinfo.model.FileInfo;
import com.jxdinfo.crm.core.fileinfo.service.FileInfoService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(tags={"\u9644\u4ef6\u7ba1\u7406"})
@RestController
@RequestMapping(value={"fileInfo"})
public class FileInfoController {
    @Resource
    private FileInfoService fileInfoService;

    @PostMapping(value={"/selectById"})
    @ApiOperation(value="\u901a\u8fc7\u4e1a\u52a1id\u67e5\u8be2\u9644\u4ef6\u5217\u8868", notes="\u901a\u8fc7\u4e1a\u52a1id\u67e5\u8be2\u9644\u4ef6\u5217\u8868")
    @AuditLog(moduleName="\u9644\u4ef6\u7ba1\u7406", eventDesc="\u9644\u4ef6\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<FileInfo>> selectById(@RequestBody @ApiParam(value="\u9644\u4ef6dto") FileInfoDto fileInfoDto) {
        return ApiResponse.success(this.fileInfoService.selectFileInfoByBusinessId(fileInfoDto));
    }

    @PostMapping(value={"/fileUpload"})
    @ApiOperation(value="\u8ddf\u8fdb\u8bb0\u5f55\u6587\u4ef6\u4e0a\u4f20", notes="\u8ddf\u8fdb\u8bb0\u5f55\u6587\u4ef6\u4e0a\u4f20")
    @AuditLog(moduleName="\u9644\u4ef6\u7ba1\u7406", eventDesc="\u9644\u4ef6\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Map<String, Object>> upload(@ApiParam(value="\u4e0a\u4f20\u6587\u4ef6") MultipartHttpServletRequest multipartRequest, @RequestParam(value="enclosureType", required=false, defaultValue="1") @ApiParam(value="\u9644\u4ef6\u7c7b\u578b") String enclosureType, @RequestParam(value="attachmentType", required=false) @ApiParam(value="\u9644\u4ef6\u7c7b\u578b\u8bf4\u660e") String attachmentType, @RequestParam(value="docbase", required=false) @ApiParam(value="\u4e0a\u4f20\u9644\u4ef6\u6807\u5fd7\u4f4d") String docbase, @RequestParam(value="businessType", required=false) @ApiParam(value="\u4e1a\u52a1\u7c7b\u578b") String businessType, @RequestParam(value="businessId", required=false) @ApiParam(value="\u4e1a\u52a1id") String businessId) {
        return ApiResponse.success(this.fileInfoService.upload(multipartRequest, enclosureType, attachmentType, docbase, businessType, businessId));
    }

    @PostMapping(value={"/opportunityMultiFileUpload"})
    @ApiOperation(value="\u5546\u673a\u9644\u4ef6\u6279\u91cf\u4e0a\u4f20", notes="\u5546\u673a\u9644\u4ef6\u6279\u91cf\u4e0a\u4f20")
    @AuditLog(moduleName="\u9644\u4ef6\u7ba1\u7406", eventDesc="\u5546\u673a\u9644\u4ef6\u6279\u91cf\u4e0a\u4f20", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse multiUpload(@ApiParam(value="\u4e0a\u4f20\u6587\u4ef6") MultipartHttpServletRequest multipartRequest, @ApiParam(value="\u9644\u4ef6dto") FileInfoDto fileInfoDto) {
        return ApiResponse.success((String)this.fileInfoService.multiUpload(multipartRequest, fileInfoDto));
    }

    @PostMapping(value={"/upload"})
    @ApiOperation(value="\u66f4\u65b0\u9644\u4ef6\u6570\u636e", notes="\u66f4\u65b0\u9644\u4ef6\u6570\u636e")
    @AuditLog(moduleName="\u9644\u4ef6\u7ba1\u7406", eventDesc="\u9644\u4ef6\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse insert(@RequestBody @ApiParam(value="\u9644\u4ef6dto") FileInfoDto fileInfoDto) {
        int i = this.fileInfoService.insertFileInfo(fileInfoDto);
        if (i <= 0) {
            return ApiResponse.fail((String)"\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u4e0a\u4f20\u6210\u529f");
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u9644\u4ef6\u5220\u9664", notes="\u9644\u4ef6\u5220\u9664")
    @AuditLog(moduleName="\u9644\u4ef6\u7ba1\u7406", eventDesc="\u9644\u4ef6\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> delete(@RequestBody @ApiParam(value="\u9644\u4ef6dto") FileInfoDto fileInfoDto) {
        String msg = this.fileInfoService.deleteFileInfoByIds(fileInfoDto);
        return ApiResponse.success((String)msg);
    }

    @GetMapping(value={"/fileDownload"})
    @ApiOperation(value="\u6587\u4ef6\u4e0b\u8f7d\uff0c\u8bb0\u5f55\u4e0b\u8f7d\u6b21\u6570", notes="\u6587\u4ef6\u4e0b\u8f7d\uff0c\u8bb0\u5f55\u4e0b\u8f7d\u6b21\u6570")
    @AuditLog(moduleName="\u9644\u4ef6\u7ba1\u7406", eventDesc="\u9644\u4ef6\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.NULL_EVENT_TYPE)
    public void fileDownload(@ApiParam(value="\u8fd4\u56de\u5bf9\u8c61") HttpServletResponse response, @RequestParam(value="fileId") @ApiParam(value="\u6587\u4ef6id") String fileId, @RequestParam(value="userId") @ApiParam(value="\u4e0b\u8f7d\u4ebaid") Long userId, @RequestParam(value="type", required=false) @ApiParam(value="\u4e0b\u8f7d\u7c7b\u578b") String type) throws ServletException, IOException {
        this.fileInfoService.fileDownload(response, fileId, userId, type);
    }

    @GetMapping(value={"/preview/{id}"})
    @ApiOperation(value="\u6587\u4ef6\u9884\u89c8", notes="\u6587\u4ef6\u9884\u89c8")
    @AuditLog(moduleName="\u9644\u4ef6\u7ba1\u7406", eventDesc="\u9644\u4ef6\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<String> previewFile(@PathVariable(value="id") @ApiParam(value="\u9644\u4ef6id") String id) {
        return ApiResponse.success((String)this.fileInfoService.previewFile(id));
    }

    @GetMapping(value={"/syncFile"})
    @ApiOperation(value="\u540c\u6b65\u9644\u4ef6", notes="\u540c\u6b65\u9644\u4ef6")
    @AuditLog(moduleName="\u9644\u4ef6\u7ba1\u7406", eventDesc="\u9644\u4ef6\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.NULL_EVENT_TYPE)
    public ApiResponse<Boolean> syncFile() {
        return ApiResponse.success((Object)this.fileInfoService.syncFile());
    }
}

