/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.jxdinfo.crm.common.api.config.OsApiProperties;
import com.jxdinfo.crm.core.contract.dao.CrmContractMapper;
import com.jxdinfo.crm.core.contract.model.CrmContract;
import com.jxdinfo.crm.core.contract.model.CrmContractProduct;
import com.jxdinfo.crm.core.contract.service.CrmContractProductService;
import com.jxdinfo.crm.core.contract.service.CrmContractService;
import com.jxdinfo.crm.core.contract.vo.CrmContractVo;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.crm.core.yyzc.client.OsApiClient;
import com.jxdinfo.crm.core.yyzc.client.conf.OsApiConf;
import com.jxdinfo.crm.core.yyzc.client.request.OsApiRequest;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrmContractServiceImpl
extends ServiceImpl<CrmContractMapper, CrmContract>
implements CrmContractService {
    @Autowired
    private OsApiClient osApiClient;
    @Autowired
    private OsApiConf osApiConf;
    @Resource
    private OsApiProperties osApiProperties;
    @Resource
    private CrmContractMapper crmContractMapper;
    @Resource
    private CrmContractProductService crmContractProductService;

    @Override
    @Transactional
    public void saveYyzcContracts() {
        OsApiRequest request = new OsApiRequest();
        LocalDateTime lastUpdateTime = this.crmContractMapper.selectLastContract();
        if (lastUpdateTime == null) {
            lastUpdateTime = LocalDateTime.parse("2000-01-01 00:00:00", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        if (!this.osApiProperties.isOsEnable()) {
            return;
        }
        HashMap<String, LocalDateTime> body = new HashMap<String, LocalDateTime>();
        body.put("updateTime", lastUpdateTime);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("body", body);
        ApiResponse contractJSON = EimPushUtil.post(this.osApiProperties.getAssociationContractList(), param);
        List list = (List)contractJSON.getData();
        ArrayList<CrmContract> saveCrmContracts = new ArrayList<CrmContract>();
        List<Object> oldContractList = new ArrayList();
        ArrayList<CrmContractProduct> saveContractProductList = new ArrayList<CrmContractProduct>();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            LocalDateTime now = LocalDateTime.now();
            oldContractList = list.stream().map(map -> (String)map.get("ID")).filter(HussarUtils::isNotEmpty).collect(Collectors.toList());
            for (Map map2 : list) {
                List cpxx;
                String contractId = String.valueOf(map2.get("ID"));
                String contractNo = String.valueOf(map2.get("HTBH"));
                String contractName = String.valueOf(map2.get("HTMC"));
                String contractType = String.valueOf(map2.get("HTFL"));
                String paper = String.valueOf(map2.get("ZZHT"));
                String ownCompany = String.valueOf(map2.get("GSGS"));
                String contractAmount = String.valueOf(map2.get("HTJE"));
                String outsourcedAmount = String.valueOf(map2.get("WGJE"));
                String netContractAmount = String.valueOf(map2.get("JHTE"));
                String paymentRatio = String.valueOf(map2.get("HKBL"));
                String approvalStatus = String.valueOf(map2.get("FLOWNODENAME"));
                String customizedAmount = String.valueOf(map2.get("XMDZHHTJE"));
                String registeredProductAmount = String.valueOf(map2.get("CPJE"));
                String manpowerContractAmount = String.valueOf(map2.get("RLHTJE"));
                String customerName = String.valueOf(map2.get("QYKHMC"));
                String projectContractName = String.valueOf(map2.get("QHXMMC"));
                String effectiveContractAmount = String.valueOf(map2.get("HTJE"));
                String signTime = String.valueOf(map2.get("QDRQ"));
                String updateTime = String.valueOf(map2.get("UPDATE_TIME"));
                String finishTime = String.valueOf(map2.get("FINISH_TIME"));
                String dataStatus = String.valueOf(map2.get("DATASTATUSID"));
                if (signTime.length() > 10) {
                    signTime = signTime.substring(0, 10);
                }
                String signDepartment = String.valueOf(map2.get("QDBM"));
                String contractChargePersonName = String.valueOf(map2.get("HTFZR"));
                String opportunityId = "";
                if (map2.get("CRMSJ_ID") != null) {
                    opportunityId = String.valueOf(map2.get("CRMSJ_ID"));
                }
                String opportunityName = String.valueOf(map2.get("CRMSJ_NAME"));
                CrmContract contract = new CrmContract();
                contract.setYyzcContractId(contractId);
                contract.setContractNumber(contractNo);
                contract.setContractName(contractName);
                contract.setCustomerName(customerName);
                if (!StringUtils.isEmpty((CharSequence)opportunityId)) {
                    contract.setOpportunityId(Long.valueOf(opportunityId));
                }
                contract.setOpportunityName(opportunityName);
                contract.setChargePersonName(contractChargePersonName);
                contract.setContractType(contractType);
                contract.setStartDate(ToolUtil.isNotEmpty((Object)signTime) ? LocalDate.parse(signTime).atStartOfDay() : null);
                try {
                    if (StringUtils.isNotBlank((CharSequence)contractAmount)) {
                        contract.setContractAmount(Double.valueOf(contractAmount));
                    }
                }
                catch (Exception e) {
                    contract.setContractAmount(0.0);
                }
                contract.setChangeTime(now);
                contract.setOwnDepartmentName(signDepartment);
                contract.setOwnUnitName(ownCompany);
                contract.setState(approvalStatus);
                contract.setFinishTime(ToolUtil.isNotEmpty((Object)finishTime) ? LocalDateTime.parse(finishTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) : null);
                contract.setContractUpdateTime(ToolUtil.isNotEmpty((Object)updateTime) ? LocalDateTime.parse(updateTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) : null);
                contract.setDelFlag("zf".equals(String.valueOf(map2.get("DATASTATUSID"))) || "sc".equals(String.valueOf(map2.get("DATASTATUSID"))) ? "1" : "0");
                contract.setContractPaper(paper);
                try {
                    if (StringUtils.isNotBlank((CharSequence)outsourcedAmount)) {
                        contract.setOutSourcedAmount(Double.valueOf(outsourcedAmount));
                    }
                }
                catch (Exception e) {
                    contract.setOutSourcedAmount(0.0);
                }
                try {
                    if (StringUtils.isNotBlank((CharSequence)netContractAmount)) {
                        contract.setNetContractAmount(Double.valueOf(netContractAmount));
                    }
                }
                catch (Exception e) {
                    contract.setNetContractAmount(0.0);
                }
                contract.setPaybackRatio(paymentRatio);
                contract.setSignTime(ToolUtil.isNotEmpty((Object)signTime) ? LocalDate.parse(signTime).atStartOfDay() : null);
                saveCrmContracts.add(contract);
                Gson gson = new Gson();
                String cpxxJson = String.valueOf(map2.get("CPXX"));
                if (!HussarUtils.isNotBlank((CharSequence)cpxxJson) || !HussarUtils.isNotEmpty((Object)(cpxx = (List)gson.fromJson(cpxxJson, new TypeToken<List<Map<String, String>>>(){}.getType())))) continue;
                for (Map productMap : cpxx) {
                    String yyzcContractProductId = String.valueOf(productMap.get("ID"));
                    String yyzcContractId = String.valueOf(productMap.get("HTID"));
                    String productId = String.valueOf(productMap.get("CPID"));
                    String productName = String.valueOf(productMap.get("CPMC"));
                    String productSellAmount = String.valueOf(productMap.get("GLHTJE"));
                    String thisSignAmount = String.valueOf(productMap.get("CPJE"));
                    String developChargePersonId = String.valueOf(productMap.get("CPYFFZR"));
                    String developChargePersonName = String.valueOf(productMap.get("CPYFFZRMC"));
                    String productOwnDepartmentId = String.valueOf(productMap.get("CPSSBM"));
                    String productOwnDepartmentName = String.valueOf(productMap.get("CPSSBMMC"));
                    String relationOpportunityId = String.valueOf(productMap.get("SJID"));
                    String productChargePersonId = String.valueOf(productMap.get("CPFZR"));
                    CrmContractProduct crmContractProduct = new CrmContractProduct();
                    crmContractProduct.setYyzcContractProductId(yyzcContractProductId);
                    crmContractProduct.setYyzcContractId(yyzcContractId);
                    crmContractProduct.setProductId(productId);
                    crmContractProduct.setProductName(productName);
                    try {
                        if (StringUtils.isNotBlank((CharSequence)productSellAmount)) {
                            crmContractProduct.setProductSellAmount(Double.valueOf(productSellAmount));
                        }
                    }
                    catch (Exception e) {
                        crmContractProduct.setProductSellAmount(0.0);
                    }
                    try {
                        if (StringUtils.isNotBlank((CharSequence)thisSignAmount)) {
                            crmContractProduct.setThisSignAmount(Double.valueOf(thisSignAmount));
                        }
                    }
                    catch (Exception e) {
                        crmContractProduct.setThisSignAmount(0.0);
                    }
                    crmContractProduct.setDevelopChargePersonId(developChargePersonId);
                    crmContractProduct.setDevelopChargePersonName(developChargePersonName);
                    crmContractProduct.setProductOwnDepartmentId(productOwnDepartmentId);
                    crmContractProduct.setProductOwnDepartmentName(productOwnDepartmentName);
                    if (StringUtils.isNotBlank((CharSequence)relationOpportunityId)) {
                        crmContractProduct.setOpportunityId(Long.valueOf(relationOpportunityId));
                    }
                    crmContractProduct.setProductChargePersonId(productChargePersonId);
                    saveContractProductList.add(crmContractProduct);
                }
            }
            if (CollectionUtil.isNotEmpty(oldContractList)) {
                this.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CrmContract::getYyzcContractId, oldContractList)).or()).isNull(CrmContract::getYyzcContractId));
                this.crmContractProductService.remove((Wrapper)new LambdaQueryWrapper().in(CrmContractProduct::getYyzcContractId, oldContractList));
            }
            this.saveBatch(saveCrmContracts);
            this.crmContractProductService.saveBatch(saveContractProductList);
        }
    }

    @Override
    public List<CrmContractVo> selectContractProductList(LocalDateTime date, List<Long> opportunityIds) {
        return this.crmContractMapper.selectContractProductList(date, opportunityIds);
    }

    @Override
    public List<Long> selectOpportunityIdSigned(LocalDateTime dateNow, List<Long> productIdList) {
        return this.crmContractMapper.selectOpportunityIdSigned(dateNow, productIdList);
    }

    @Override
    public CrmContractVo selectContractProductListByYyzcContractId(String yid) {
        return this.crmContractMapper.selectContractProductListByYyzcContractId(yid);
    }
}

