/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.associativeQuery.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.label.service.ILabelService;
import com.jxdinfo.crm.common.api.label.vo.LabelVo;
import com.jxdinfo.crm.core.associativeQuery.dto.AssociativeLabelVo;
import com.jxdinfo.crm.core.associativeQuery.service.AssociativeFiledQueryService;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.common.vo.AssociativeQueryVo;
import com.jxdinfo.crm.core.common.vo.ProvinceVo;
import com.jxdinfo.crm.core.customer.dto.CustomerDto;
import com.jxdinfo.crm.core.leads.dto.LeadsDto;
import com.jxdinfo.crm.core.marketingactivity.model.MarketingActivityEntity;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityDto;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunitystage.model.StageProcessEntity;
import com.jxdinfo.crm.core.product.model.Product;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AssociativeFiledQueryServiceImpl
implements AssociativeFiledQueryService {
    @Resource
    private CommonService commonService;
    @Resource
    private ISysStruService struService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private ILabelService labelService;

    @Override
    public List<String> getLabelAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedLabels, List<String> labelList, String moduleId) {
        List labelVoList;
        if (CollectionUtil.isEmpty(selectedLabels)) {
            selectedLabels = new ArrayList<String>();
        }
        ArrayList<String> labelIds = new ArrayList<String>(selectedLabels);
        if (CollectionUtil.isNotEmpty(labelList)) {
            labelIds.addAll(labelList);
        }
        if (ToolUtil.isNotEmpty((Object)(labelVoList = this.labelService.listByModuleIdForSelect(moduleId, keyword, labelIds)))) {
            for (LabelVo labelVo : labelVoList) {
                AssociativeQueryVo LabelAssociative = new AssociativeQueryVo();
                LabelAssociative.setLabelName("\u6807\u7b7e\uff1a");
                LabelAssociative.setDataName("labelSelect");
                LabelAssociative.setMultiOption(true);
                LabelAssociative.setTips("\u6807\u7b7e\uff1a " + labelVo.getLabelName());
                LabelAssociative.setOptionName(labelVo.getLabelName());
                LabelAssociative.setOptionValue(String.valueOf(labelVo.getLabelId()));
                associativeQueryVoList.add(LabelAssociative);
                selectedLabels.add(String.valueOf(labelVo.getLabelId()));
            }
        }
        return selectedLabels;
    }

    @Override
    public List<String> getOwnDepartmentAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedOwnDepartments, List<String> ownDepartmentList, AssociativeLabelVo associativeLabelVo) {
        List detpId = this.struService.listObjs((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{SysStru::getId}).eq(SysStru::getOrganAlias, (Object)"\u79bb\u804c\u4eba\u5458"), s -> Long.parseLong(s.toString()));
        ArrayList<String> ownDepartments = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty((Collection)detpId)) {
            ownDepartments.add(((Long)detpId.get(0)).toString());
        }
        if (CollectionUtil.isNotEmpty(ownDepartmentList)) {
            ownDepartments.addAll(ownDepartmentList);
        }
        if (CollectionUtil.isEmpty(selectedOwnDepartments)) {
            selectedOwnDepartments = new ArrayList<String>();
        }
        ownDepartments.addAll(selectedOwnDepartments);
        List<SysStru> ownDepartmentsList = this.commonService.getDeptList(keyword, ownDepartments);
        if (ToolUtil.isNotEmpty(ownDepartmentsList)) {
            for (SysStru sysStru : ownDepartmentsList) {
                AssociativeQueryVo ownDepartmentsAssociative = this.getAssociativeQueryVo(associativeLabelVo, sysStru.getOrganAlias(), String.valueOf(sysStru.getId()));
                associativeQueryVoList.add(ownDepartmentsAssociative);
                selectedOwnDepartments.add(String.valueOf(sysStru.getId()));
            }
        }
        return selectedOwnDepartments;
    }

    @Override
    public List<String> getChargePersonAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedChargePersonIds, List<String> chargePersonIdList, AssociativeLabelVo associativeLabelVo) {
        ArrayList<String> chargePersonIds = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(chargePersonIdList)) {
            chargePersonIds.addAll(chargePersonIdList);
        }
        if (CollectionUtil.isEmpty(selectedChargePersonIds)) {
            selectedChargePersonIds = new ArrayList<String>();
        }
        chargePersonIds.addAll(selectedChargePersonIds);
        List<SysUsers> chargePersonList = this.commonService.getUserList(keyword, chargePersonIds);
        if (ToolUtil.isNotEmpty(chargePersonList)) {
            for (SysUsers sysUsers : chargePersonList) {
                AssociativeQueryVo chargePersonIdAssociative = this.getAssociativeQueryVo(associativeLabelVo, sysUsers.getUserName(), String.valueOf(sysUsers.getId()));
                associativeQueryVoList.add(chargePersonIdAssociative);
                selectedChargePersonIds.add(String.valueOf(sysUsers.getId()));
            }
        }
        return selectedChargePersonIds;
    }

    @Override
    public List<String> getTeamMemberIdAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedTeamMemberIds, List<String> teamMemberIdList) {
        ArrayList<String> teamMemberIds = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(teamMemberIdList)) {
            teamMemberIds.addAll(teamMemberIdList);
        }
        if (CollectionUtil.isEmpty(selectedTeamMemberIds)) {
            selectedTeamMemberIds = new ArrayList<String>();
        }
        teamMemberIds.addAll(selectedTeamMemberIds);
        List<SysUsers> teamMemberList = this.commonService.getUserList(keyword, teamMemberIds);
        if (ToolUtil.isNotEmpty(teamMemberList)) {
            for (SysUsers sysUsers : teamMemberList) {
                AssociativeQueryVo teamMemberIdAssociative = new AssociativeQueryVo();
                teamMemberIdAssociative.setLabelName("\u56e2\u961f\u6210\u5458\uff1a");
                teamMemberIdAssociative.setDataName("teamMemberMulti");
                teamMemberIdAssociative.setMultiOption(true);
                teamMemberIdAssociative.setTips("\u56e2\u961f\u6210\u5458\uff1a " + sysUsers.getUserName());
                teamMemberIdAssociative.setOptionName(sysUsers.getUserName());
                teamMemberIdAssociative.setOptionValue(String.valueOf(sysUsers.getId()));
                associativeQueryVoList.add(teamMemberIdAssociative);
                selectedTeamMemberIds.add(String.valueOf(sysUsers.getId()));
            }
        }
        return selectedTeamMemberIds;
    }

    @Override
    public List<String> getTimeTageAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedCreateTimes, String timeTage, AssociativeLabelVo associativeLabelVo) {
        List<DicVo> dicVoList;
        ArrayList<String> createTimes = new ArrayList<String>();
        createTimes.add("6");
        if (CollectionUtil.isEmpty(selectedCreateTimes)) {
            selectedCreateTimes = new ArrayList<String>();
        }
        createTimes.addAll(selectedCreateTimes);
        if (StringUtil.isEmpty((Object)timeTage) && ToolUtil.isNotEmpty(dicVoList = this.commonService.getDicValue(associativeLabelVo.getDictTypeName(), keyword, createTimes))) {
            for (DicVo dicVo : dicVoList) {
                AssociativeQueryVo createTimeAssociative = this.getAssociativeQueryVo(associativeLabelVo, dicVo.getLabel(), dicVo.getValue());
                String labelName = associativeLabelVo.getLabelName() + "\uff1a";
                createTimeAssociative.setLabelName(labelName);
                createTimeAssociative.setDataName(associativeLabelVo.getDataName());
                createTimeAssociative.setMultiOption(associativeLabelVo.getMultiOption());
                createTimeAssociative.setTips(labelName + dicVo.getLabel());
                createTimeAssociative.setOptionName(dicVo.getLabel());
                createTimeAssociative.setOptionValue(dicVo.getValue());
                associativeQueryVoList.add(createTimeAssociative);
                selectedCreateTimes.add(dicVo.getValue());
            }
        }
        return selectedCreateTimes;
    }

    @Override
    public List<String> getStateAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedStates, OpportunityDto dto) {
        ArrayList<String> states = new ArrayList<String>(Arrays.asList("6", "7", "8", "9"));
        if (ToolUtil.isNotEmpty((Object)dto) && ToolUtil.isNotEmpty(dto.getStates())) {
            states.addAll(dto.getStates());
        }
        if (CollectionUtil.isEmpty(selectedStates)) {
            selectedStates = new ArrayList<String>();
        }
        states.addAll(selectedStates);
        List<DicVo> stateDicVoList = this.commonService.getDicValue("leads_state", keyword, states);
        if (ToolUtil.isNotEmpty(stateDicVoList)) {
            for (DicVo dicVo : stateDicVoList) {
                AssociativeQueryVo stateAssociative = new AssociativeQueryVo();
                stateAssociative.setLabelName("\u5546\u673a\u72b6\u6001\uff1a");
                stateAssociative.setDataName("hussar_72SelectShowData");
                stateAssociative.setMultiOption(true);
                stateAssociative.setTips("\u5546\u673a\u72b6\u6001\uff1a " + dicVo.getLabel());
                stateAssociative.setOptionName(dicVo.getLabel());
                stateAssociative.setOptionValue(dicVo.getValue());
                associativeQueryVoList.add(stateAssociative);
                selectedStates.add(dicVo.getValue());
            }
        }
        return selectedStates;
    }

    @Override
    public List<String> getLeadsStateAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedStates, LeadsDto dto) {
        ArrayList<String> states = new ArrayList<String>(Arrays.asList("6", "7", "8", "9"));
        if (ToolUtil.isNotEmpty((Object)dto) && ToolUtil.isNotEmpty(dto.getStates())) {
            states.addAll(dto.getStates());
        }
        if (CollectionUtil.isEmpty(selectedStates)) {
            selectedStates = new ArrayList<String>();
        }
        states.addAll(selectedStates);
        List<DicVo> stateDicVoList = this.commonService.getDicValue("leads_state", keyword, states);
        if (ToolUtil.isNotEmpty(stateDicVoList)) {
            for (DicVo dicVo : stateDicVoList) {
                AssociativeQueryVo stateAssociative = new AssociativeQueryVo();
                stateAssociative.setLabelName("\u7ebf\u7d22\u72b6\u6001\uff1a");
                stateAssociative.setDataName("hussar_72Data");
                stateAssociative.setMultiOption(true);
                stateAssociative.setTips("\u7ebf\u7d22\u72b6\u6001\uff1a " + dicVo.getLabel());
                stateAssociative.setOptionName(dicVo.getLabel());
                stateAssociative.setOptionValue(dicVo.getValue());
                associativeQueryVoList.add(stateAssociative);
                selectedStates.add(dicVo.getValue());
            }
        }
        return selectedStates;
    }

    @Override
    public List<String> getCustomerStageIdAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedStageId, OpportunityDto dto) {
        ArrayList<String> customerStageIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)dto) && ToolUtil.isNotEmpty(dto.getCustomerStageIds())) {
            for (String s : dto.getCustomerStageIds()) {
                List<String> stageTempList = Arrays.asList(s.split(","));
                customerStageIds.addAll(stageTempList);
            }
        }
        if (CollectionUtil.isEmpty(selectedStageId)) {
            selectedStageId = new ArrayList<String>();
        }
        customerStageIds.addAll(selectedStageId);
        List<Object> stageList = new ArrayList();
        stageList = ToolUtil.isNotEmpty(dto.getStageProcessIds()) ? this.commonService.getOpportunityStageList(keyword, customerStageIds, dto.getStageProcessIds()) : this.commonService.getOpportunityStageList(keyword, customerStageIds, null);
        Map<String, List<OpportunityStage>> stageListMap = stageList.stream().collect(Collectors.groupingBy(OpportunityStage::getCustomerStageName));
        ArrayList<String> stageNameList = new ArrayList<String>(stageListMap.keySet());
        if (ToolUtil.isNotEmpty(stageNameList)) {
            for (String stageName : stageNameList) {
                AssociativeQueryVo stageAssociative = new AssociativeQueryVo();
                stageAssociative.setLabelName("\u5546\u673a\u9636\u6bb5\uff1a");
                stageAssociative.setDataName("hussar_45SelectShowData");
                stageAssociative.setMultiOption(true);
                stageAssociative.setTips("\u5546\u673a\u9636\u6bb5\uff1a " + stageName);
                stageAssociative.setOptionName(stageName);
                List stageIds = stageListMap.get(stageName).stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
                String idsString = StringUtil.join(stageIds, (String)",");
                stageAssociative.setOptionValue(idsString);
                associativeQueryVoList.add(stageAssociative);
                selectedStageId.add(idsString);
            }
        }
        return selectedStageId;
    }

    @Override
    public List<String> getOpptyStageProcessAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedOpptyStageProcesses, List<String> stageProcessIds, AssociativeLabelVo associativeLabelVo) {
        if (ToolUtil.isEmpty(stageProcessIds)) {
            stageProcessIds = new ArrayList<String>();
        }
        if (ToolUtil.isNotEmpty(selectedOpptyStageProcesses)) {
            stageProcessIds.addAll(selectedOpptyStageProcesses);
        } else {
            selectedOpptyStageProcesses = new ArrayList<String>();
        }
        List<StageProcessEntity> stageProcessList = this.commonService.getStageProcessAssociateQuery(keyword, stageProcessIds);
        if (ToolUtil.isNotEmpty(stageProcessList)) {
            for (StageProcessEntity stageProcess : stageProcessList) {
                AssociativeQueryVo processAssociative = this.getAssociativeQueryVo(associativeLabelVo, stageProcess.getProcessName(), String.valueOf(stageProcess.getStageProcessId()));
                associativeQueryVoList.add(processAssociative);
                selectedOpptyStageProcesses.add(String.valueOf(stageProcess.getStageProcessId()));
            }
        }
        return selectedOpptyStageProcesses;
    }

    @Override
    public List<String> getCustomerStageIdAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedStageId, List<String> customerStageIds, List<String> stageProcessIds) {
        ArrayList<String> customerStageIdsFinal = new ArrayList<String>();
        if (CollectionUtil.isEmpty(selectedStageId)) {
            selectedStageId = new ArrayList<String>();
        }
        if (CollectionUtil.isNotEmpty(customerStageIds)) {
            for (String s : customerStageIds) {
                List<String> stageTempList = Arrays.asList(s.split(","));
                customerStageIdsFinal.addAll(stageTempList);
            }
        }
        customerStageIdsFinal.addAll(selectedStageId);
        List<Object> stageList = new ArrayList();
        stageList = ToolUtil.isNotEmpty(stageProcessIds) ? this.commonService.getOpportunityStageList(keyword, customerStageIdsFinal, stageProcessIds) : this.commonService.getOpportunityStageList(keyword, customerStageIdsFinal, null);
        Map<String, List<OpportunityStage>> stageListMap = stageList.stream().collect(Collectors.groupingBy(OpportunityStage::getCustomerStageName));
        ArrayList<String> stageNameList = new ArrayList<String>(stageListMap.keySet());
        if (ToolUtil.isNotEmpty(stageNameList)) {
            for (String stageName : stageNameList) {
                AssociativeQueryVo stageAssociative = new AssociativeQueryVo();
                stageAssociative.setLabelName("\u5546\u673a\u9636\u6bb5\uff1a");
                stageAssociative.setDataName("hussar_45SelectShowData");
                stageAssociative.setMultiOption(true);
                stageAssociative.setTips("\u5546\u673a\u9636\u6bb5\uff1a " + stageName);
                stageAssociative.setOptionName(stageName);
                List stageIds = stageListMap.get(stageName).stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
                String idsString = StringUtil.join(stageIds, (String)",");
                stageAssociative.setOptionValue(idsString);
                associativeQueryVoList.add(stageAssociative);
                selectedStageId.add(idsString);
            }
        }
        return selectedStageId;
    }

    @Override
    public List<String> getCustomerStageIdAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedStageId, CustomerDto dto) {
        ArrayList<String> customerStageIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)dto) && ToolUtil.isNotEmpty(dto.getCustomerStageIds())) {
            for (String s : dto.getCustomerStageIds()) {
                List<String> stageTempList = Arrays.asList(s.split(","));
                customerStageIds.addAll(stageTempList);
            }
        }
        if (CollectionUtil.isEmpty(selectedStageId)) {
            selectedStageId = new ArrayList<String>();
        }
        customerStageIds.addAll(selectedStageId);
        List<OpportunityStage> stageList = ToolUtil.isNotEmpty(dto.getStageProcessIds()) ? this.commonService.getOpportunityStageList(keyword, customerStageIds, dto.getStageProcessIds()) : this.commonService.getOpportunityStageList(keyword, customerStageIds, null);
        Map<String, List<OpportunityStage>> stageListMap = stageList.stream().collect(Collectors.groupingBy(OpportunityStage::getCustomerStageName));
        ArrayList<String> stageNameList = new ArrayList<String>(stageListMap.keySet());
        if (ToolUtil.isNotEmpty(stageNameList)) {
            for (String stageName : stageNameList) {
                AssociativeQueryVo stageAssociative = new AssociativeQueryVo();
                stageAssociative.setLabelName("\u5546\u673a\u9636\u6bb5\uff1a");
                stageAssociative.setDataName("customerStageId");
                stageAssociative.setMultiOption(true);
                stageAssociative.setTips("\u5546\u673a\u9636\u6bb5\uff1a " + stageName);
                stageAssociative.setOptionName(stageName);
                List stageIds = stageListMap.get(stageName).stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
                String idsString = StringUtil.join(stageIds, (String)",");
                stageAssociative.setOptionValue(idsString);
                associativeQueryVoList.add(stageAssociative);
                selectedStageId.add(idsString);
            }
        }
        return selectedStageId;
    }

    @Override
    public List<String> getRelationProductAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedRelationProduct, CustomerDto dto, AssociativeLabelVo associativeLabelVo) {
        List<Product> productList;
        ArrayList<String> products = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty((Object)dto) && CollectionUtil.isNotEmpty(dto.getProducts())) {
            products.addAll(dto.getProducts().stream().map(Object::toString).collect(Collectors.toList()));
        }
        if (CollectionUtil.isEmpty(selectedRelationProduct)) {
            selectedRelationProduct = new ArrayList<String>();
        }
        products.addAll(selectedRelationProduct);
        if (ToolUtil.isEmpty((Object)dto.getRelationProduct()) && ToolUtil.isNotEmpty(productList = this.commonService.getProductList(keyword, products))) {
            for (Product product : productList) {
                AssociativeQueryVo productAssociative = this.getAssociativeQueryVo(associativeLabelVo, product.getProductName(), String.valueOf(product.getProductId()));
                associativeQueryVoList.add(productAssociative);
                selectedRelationProduct.add(String.valueOf(product.getProductId()));
            }
        }
        return selectedRelationProduct;
    }

    @Override
    public List<String> getCampaignIdAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedCampaignIds, List<Long> campaignIds, AssociativeLabelVo associativeLabelVo) {
        if (ToolUtil.isNotEmpty(campaignIds)) {
            campaignIds.addAll(campaignIds);
        }
        if (CollectionUtil.isEmpty(selectedCampaignIds)) {
            selectedCampaignIds = new ArrayList<String>();
        } else {
            List selectedCampaignIdList = selectedCampaignIds.stream().map(Long::parseLong).collect(Collectors.toList());
            campaignIds.addAll(selectedCampaignIdList);
        }
        List<MarketingActivityEntity> activityList = this.commonService.getMarketingActivityList(keyword, campaignIds);
        if (ToolUtil.isNotEmpty(activityList)) {
            for (MarketingActivityEntity marketingActivityEntity : activityList) {
                AssociativeQueryVo activityAssociative = this.getAssociativeQueryVo(associativeLabelVo, marketingActivityEntity.getCampaignName(), String.valueOf(marketingActivityEntity.getCampaignId()));
                associativeQueryVoList.add(activityAssociative);
                selectedCampaignIds.add(String.valueOf(marketingActivityEntity.getCampaignId()));
            }
        }
        return selectedCampaignIds;
    }

    @Override
    public List<String> getProductAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedProducts, List<String> productIds, AssociativeLabelVo associativeLabelVo) {
        ArrayList<String> products = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(productIds)) {
            products.addAll(productIds);
        }
        if (CollectionUtil.isEmpty(selectedProducts)) {
            selectedProducts = new ArrayList<String>();
        }
        products.addAll(selectedProducts);
        List<Product> productList = this.commonService.getProductList(keyword, products);
        if (ToolUtil.isNotEmpty(productList)) {
            for (Product product : productList) {
                AssociativeQueryVo productAssociative = this.getAssociativeQueryVo(associativeLabelVo, product.getProductName(), String.valueOf(product.getProductId()));
                associativeQueryVoList.add(productAssociative);
                selectedProducts.add(String.valueOf(product.getProductId()));
            }
        }
        return selectedProducts;
    }

    @Override
    public List<String> getProvinceAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedProvinces, List<Long> provinceIdList) {
        ArrayList<Long> provinces = new ArrayList<Long>();
        if (CollectionUtil.isNotEmpty(provinceIdList)) {
            provinces.addAll(provinceIdList);
        }
        if (CollectionUtil.isNotEmpty(selectedProvinces)) {
            List selectedProvinceList = selectedProvinces.stream().map(Long::parseLong).collect(Collectors.toList());
            provinces.addAll(selectedProvinceList);
        } else {
            selectedProvinces = new ArrayList<String>();
        }
        List<ProvinceVo> provinceList = this.commonService.getProvinceList(keyword, provinces);
        if (ToolUtil.isNotEmpty(provinceList)) {
            for (ProvinceVo provinceVo : provinceList) {
                AssociativeQueryVo provinceAssociative = new AssociativeQueryVo();
                provinceAssociative.setLabelName("\u6240\u5728\u7701\u4efd\uff1a");
                provinceAssociative.setDataName("provinceData");
                provinceAssociative.setMultiOption(true);
                provinceAssociative.setTips("\u6240\u5728\u7701\u4efd\uff1a " + provinceVo.getProvinceName());
                provinceAssociative.setOptionName(provinceVo.getProvinceName());
                provinceAssociative.setOptionValue(String.valueOf(provinceVo.getProvinceId()));
                associativeQueryVoList.add(provinceAssociative);
                selectedProvinces.add(String.valueOf(provinceVo.getProvinceId()));
            }
        }
        return selectedProvinces;
    }

    @Override
    public List<String> getCreateDepartmentAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedCreateDepartments, List<String> createDepIds, AssociativeLabelVo associativeLabelVo) {
        List detpId = this.struService.listObjs((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{SysStru::getId}).eq(SysStru::getOrganAlias, (Object)"\u79bb\u804c\u4eba\u5458"), s -> Long.parseLong(s.toString()));
        ArrayList<String> createDepartments = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)detpId)) {
            createDepartments.add(String.valueOf(detpId.get(0)));
        }
        if (ToolUtil.isNotEmpty(createDepIds)) {
            createDepartments.addAll(createDepIds);
        }
        if (CollectionUtil.isEmpty(selectedCreateDepartments)) {
            selectedCreateDepartments = new ArrayList<String>();
        }
        createDepartments.addAll(selectedCreateDepartments);
        List<SysStru> createDepartmentList = this.commonService.getDeptList(keyword, createDepartments);
        if (ToolUtil.isNotEmpty(createDepartmentList)) {
            for (SysStru sysStru : createDepartmentList) {
                AssociativeQueryVo createDepartmentAssociative = this.getAssociativeQueryVo(associativeLabelVo, sysStru.getOrganAlias(), String.valueOf(sysStru.getId()));
                associativeQueryVoList.add(createDepartmentAssociative);
                selectedCreateDepartments.add(String.valueOf(sysStru.getId()));
            }
        }
        return selectedCreateDepartments;
    }

    @Override
    public List<String> getCreatePersonIdAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedCreatePersonIds, List<String> createPersonList, AssociativeLabelVo associativeLabelVo) {
        ArrayList<String> createPersonIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(createPersonList)) {
            createPersonIds.addAll(createPersonList);
        }
        if (CollectionUtil.isEmpty(selectedCreatePersonIds)) {
            selectedCreatePersonIds = new ArrayList<String>();
        }
        createPersonIds.addAll(selectedCreatePersonIds);
        List<SysUsers> createPersonIdList = this.commonService.getUserList(keyword, createPersonIds);
        if (ToolUtil.isNotEmpty(createPersonIdList)) {
            for (SysUsers sysUsers : createPersonIdList) {
                AssociativeQueryVo createPersonIdAssociative = this.getAssociativeQueryVo(associativeLabelVo, sysUsers.getUserName(), String.valueOf(sysUsers.getId()));
                associativeQueryVoList.add(createPersonIdAssociative);
                selectedCreatePersonIds.add(String.valueOf(sysUsers.getId()));
            }
        }
        return selectedCreatePersonIds;
    }

    @Override
    public List<String> getPersonByNameAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedCreatePersonIds, String personName, AssociativeLabelVo associativeLabelVo) {
        ArrayList<String> createPersonIds = new ArrayList<String>();
        if (CollectionUtil.isEmpty(selectedCreatePersonIds)) {
            selectedCreatePersonIds = new ArrayList<String>();
        }
        createPersonIds.addAll(selectedCreatePersonIds);
        if (ToolUtil.isEmpty((Object)personName)) {
            if ("\u7cfb\u7edf".equals(keyword)) {
                AssociativeQueryVo createPersonIdAssociative = this.getAssociativeQueryVo(associativeLabelVo, keyword, null);
                associativeQueryVoList.add(createPersonIdAssociative);
                selectedCreatePersonIds.add(personName);
            } else {
                List<SysUsers> createPersonIdList = this.commonService.getUserExcuteNameList(keyword, createPersonIds);
                if (CollectionUtil.isNotEmpty(createPersonIdList)) {
                    for (SysUsers sysUsers : createPersonIdList) {
                        AssociativeQueryVo createPersonIdAssociative = this.getAssociativeQueryVo(associativeLabelVo, sysUsers.getUserName(), String.valueOf(sysUsers.getId()));
                        associativeQueryVoList.add(createPersonIdAssociative);
                        selectedCreatePersonIds.add(String.valueOf(sysUsers.getId()));
                    }
                }
            }
        }
        return selectedCreatePersonIds;
    }

    @Override
    public List<String> getWinPossibility(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedWinPossibility, List<String> winPossibilityList, AssociativeLabelVo associativeLabelVo) {
        if (selectedWinPossibility == null) {
            selectedWinPossibility = new ArrayList<String>();
        }
        List list = this.crmBaseConfigBoService.getOpptyScoreLevel();
        for (Map map : list) {
            String value = (String)map.get("value");
            if (winPossibilityList.contains(value) || !keyword.equals(map.get("value"))) continue;
            selectedWinPossibility.add(value);
            AssociativeQueryVo associative = new AssociativeQueryVo();
            associative.setLabelName(associativeLabelVo.getLabelName() + "\uff1a");
            associative.setDataName(associativeLabelVo.getDataName());
            associative.setMultiOption(true);
            associative.setTips(associativeLabelVo.getLabelName() + "\u5305\u542b\uff1a " + keyword);
            associative.setOptionName(keyword);
            associative.setOptionValue(keyword);
            associativeQueryVoList.add(associative);
        }
        return selectedWinPossibility;
    }

    @Override
    public List<String> getOverdueAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedOverdues, String overdueFollow) {
        List<DicVo> dicVoList;
        if (CollectionUtil.isEmpty(selectedOverdues)) {
            selectedOverdues = new ArrayList<String>();
        }
        ArrayList<String> overdues = new ArrayList<String>(selectedOverdues);
        if (StringUtil.isEmpty((Object)overdueFollow) && ToolUtil.isNotEmpty(dicVoList = this.commonService.getDicValue("overdue_follow", keyword, overdues))) {
            for (DicVo dicVo : dicVoList) {
                AssociativeQueryVo overdueAssociative = new AssociativeQueryVo();
                overdueAssociative.setLabelName("\u903e\u671f\u672a\u8ddf\u8fdb\uff1a");
                overdueAssociative.setDataName("overdueFollow");
                overdueAssociative.setMultiOption(false);
                overdueAssociative.setTips("\u903e\u671f\u672a\u8ddf\u8fdb\uff1a " + dicVo.getLabel());
                overdueAssociative.setOptionName(dicVo.getLabel());
                overdueAssociative.setOptionValue(dicVo.getValue());
                associativeQueryVoList.add(overdueAssociative);
                selectedOverdues.add(dicVo.getValue());
            }
        }
        return selectedOverdues;
    }

    @Override
    public List<String> getDictAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedValueList, List<String> dtoValueList, AssociativeLabelVo associativeLabelVo) {
        List<DicVo> dicVoList;
        if (CollectionUtil.isEmpty(selectedValueList)) {
            selectedValueList = new ArrayList<String>();
        }
        ArrayList<String> excludeValueList = new ArrayList<String>(selectedValueList);
        if (CollectionUtil.isNotEmpty(dtoValueList)) {
            excludeValueList.addAll(dtoValueList);
        }
        if (ToolUtil.isNotEmpty(dicVoList = this.commonService.getDicValue(associativeLabelVo.getDictTypeName(), keyword, excludeValueList))) {
            for (DicVo dicVo : dicVoList) {
                AssociativeQueryVo opportunityTypeAssociative = this.getAssociativeQueryVo(associativeLabelVo, dicVo.getLabel(), dicVo.getValue());
                associativeQueryVoList.add(opportunityTypeAssociative);
                selectedValueList.add(dicVo.getValue());
            }
        }
        return selectedValueList;
    }

    @Override
    public List<String> getDealStateAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectDealStates, List<String> dealStates) {
        ArrayList<String> states = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(dealStates)) {
            states.addAll(dealStates);
        }
        if (CollectionUtil.isEmpty(selectDealStates)) {
            selectDealStates = new ArrayList<String>();
        }
        states.addAll(selectDealStates);
        List<DicVo> opportunityTypeDicVoList = this.commonService.getDicValue("deal_state", keyword, states);
        if (ToolUtil.isNotEmpty(opportunityTypeDicVoList)) {
            for (DicVo dicVo : opportunityTypeDicVoList) {
                AssociativeQueryVo customerTypeAssociative = new AssociativeQueryVo();
                customerTypeAssociative.setLabelName("\u6210\u4ea4\u72b6\u6001\uff1a");
                customerTypeAssociative.setDataName("dealStates");
                customerTypeAssociative.setMultiOption(true);
                customerTypeAssociative.setTips("\u6210\u4ea4\u72b6\u6001\uff1a " + dicVo.getLabel());
                customerTypeAssociative.setOptionName(dicVo.getLabel());
                customerTypeAssociative.setOptionValue(dicVo.getValue());
                associativeQueryVoList.add(customerTypeAssociative);
                selectDealStates.add(dicVo.getValue());
            }
        }
        return selectDealStates;
    }

    @Override
    public List<String> getOpportunityWinRatesAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedOpportunityWinRates, List<String> opportunityWinRates, AssociativeLabelVo associativeLabelVo) {
        ArrayList<String> rates = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(opportunityWinRates)) {
            rates.addAll(opportunityWinRates);
        }
        if (CollectionUtil.isEmpty(selectedOpportunityWinRates)) {
            selectedOpportunityWinRates = new ArrayList<String>();
        }
        rates.addAll(selectedOpportunityWinRates);
        List<DicVo> rateDicVoList = this.commonService.getDicValue("opportunity_win_rate", keyword, rates);
        if (ToolUtil.isNotEmpty(rateDicVoList)) {
            for (DicVo dicVo : rateDicVoList) {
                AssociativeQueryVo stateAssociative = new AssociativeQueryVo();
                stateAssociative.setLabelName("\u5546\u673a\u8d62\u7387\uff1a");
                stateAssociative.setDataName("hussar_75SelectShowData");
                stateAssociative.setMultiOption(true);
                stateAssociative.setTips("\u5546\u673a\u8d62\u7387\uff1a " + dicVo.getLabel());
                stateAssociative.setOptionName(dicVo.getLabel());
                stateAssociative.setOptionValue(dicVo.getValue());
                associativeQueryVoList.add(stateAssociative);
                selectedOpportunityWinRates.add(dicVo.getValue());
            }
        }
        return selectedOpportunityWinRates;
    }

    private AssociativeQueryVo getAssociativeQueryVo(AssociativeLabelVo associativeLabelVo, String name, String value) {
        AssociativeQueryVo associativeQueryVo = new AssociativeQueryVo();
        String labelName = associativeLabelVo.getLabelName() + "\uff1a";
        associativeQueryVo.setLabelName(labelName);
        associativeQueryVo.setDataName(associativeLabelVo.getDataName());
        associativeQueryVo.setMultiOption(associativeLabelVo.getMultiOption());
        associativeQueryVo.setTips(labelName + name);
        associativeQueryVo.setOptionName(name);
        associativeQueryVo.setOptionValue(value);
        return associativeQueryVo;
    }
}

