/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.leads.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.core.associativeQuery.service.AssociativeQueryService;
import com.jxdinfo.crm.core.common.dto.DeptChangeBatchDto;
import com.jxdinfo.crm.core.common.vo.AssociativeQueryVo;
import com.jxdinfo.crm.core.common.vo.TransferBatchResultVo;
import com.jxdinfo.crm.core.leads.dto.LeadConvertDto;
import com.jxdinfo.crm.core.leads.dto.LeadsAssociativeQueryDto;
import com.jxdinfo.crm.core.leads.dto.LeadsDto;
import com.jxdinfo.crm.core.leads.dto.LeadsOriginDto;
import com.jxdinfo.crm.core.leads.model.Leads;
import com.jxdinfo.crm.core.leads.service.LeadsService;
import com.jxdinfo.crm.core.leads.vo.LeadsAnalysisSumVo;
import com.jxdinfo.crm.core.leads.vo.LeadsRepeatDetailVo;
import com.jxdinfo.crm.core.leads.vo.LeadsRepeatVo;
import com.jxdinfo.crm.core.opportunity.dto.ImproveOpportunityDto;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityDto;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityEntityDto;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunityproduct.vo.OpportunityProductVo;
import com.jxdinfo.crm.core.product.model.Product;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7ebf\u7d22\u7ba1\u7406"})
@RestController
@RequestMapping(value={"leads"})
public class LeadsController {
    @Resource
    private LeadsService leadsService;
    @Resource
    private AssociativeQueryService associativeQueryService;

    @PostMapping(value={"/selectCrmLeadsList"})
    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u5217\u8868", notes="\u67e5\u8be2\u6570\u636e\u5217\u8868")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u67e5\u8be2\u6570\u636e\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<Leads>> selectCrmLeadsList(@RequestBody @ApiParam(value="\u7ebf\u7d22dto") LeadsDto dto) {
        return ApiResponse.success(this.leadsService.selectCrmLeadsList(dto));
    }

    @PostMapping(value={"/selectLeadsAnalysisList"})
    @ApiOperation(value="\u67e5\u8be2\u7ebf\u7d22\u7edf\u8ba1\u5206\u6790\u5217\u8868", notes="\u67e5\u8be2\u7ebf\u7d22\u7edf\u8ba1\u5206\u6790\u5217\u8868")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u67e5\u8be2\u7ebf\u7d22\u7edf\u8ba1\u5206\u6790\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<OpportunityEntity>> selectLeadsAnalysisList(@RequestBody @ApiParam(value="\u5546\u673adto") OpportunityDto dto) {
        return ApiResponse.success(this.leadsService.selectLeadsAnalysisList(dto));
    }

    @PostMapping(value={"/selectLeadsAnalysisSum"})
    @ApiOperation(value="\u7ebf\u7d22\u6570\u636e\u7edf\u8ba1", notes="\u7ebf\u7d22\u6570\u636e\u7edf\u8ba1")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u7ebf\u7d22\u6570\u636e\u7edf\u8ba1", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<LeadsAnalysisSumVo>> selectLeadsAnalysisSum(@RequestBody @ApiParam(value="\u5546\u673adto") OpportunityDto dto) {
        return ApiResponse.success(this.leadsService.selectLeadsAnalysisSum(dto));
    }

    @PostMapping(value={"/selectCrmLeadsListDetails"})
    @ApiOperation(value="\u7ebf\u7d22\u8be6\u60c5\u9875\u67e5\u8be2\uff08web\u7aef\uff09", notes="\u7ebf\u7d22\u8be6\u60c5\u9875\u67e5\u8be2\uff08web\u7aef\uff09")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u7ebf\u7d22\u8be6\u60c5\u9875\u67e5\u8be2\uff08web\u7aef\uff09", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Leads> selectCrmLeadsListDetails(@RequestBody @ApiParam(value="\u7ebf\u7d22dto") LeadsDto dto) {
        return ApiResponse.success((Object)this.leadsService.selectCrmLeadsListDetails(dto));
    }

    @PostMapping(value={"/selectCrmLeadsDetails"})
    @ApiOperation(value="\u7ebf\u7d22\u8be6\u60c5\u9875\u67e5\u8be2\uff08\u79fb\u52a8\u7aef\uff09", notes="\u7ebf\u7d22\u8be6\u60c5\u9875\u67e5\u8be2\uff08\u79fb\u52a8\u7aef\uff09")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u7ebf\u7d22\u8be6\u60c5\u9875\u67e5\u8be2\uff08\u79fb\u52a8\u7aef\uff09", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Leads> selectCrmLeadsDetails(@RequestBody @ApiParam(value="\u7ebf\u7d22dto") LeadsDto dto) {
        return ApiResponse.success((Object)this.leadsService.selectCrmLeadsDetails(dto));
    }

    @PostMapping(value={"/updateDelFlagByLeadsIds"})
    @ApiOperation(value="\u7ebf\u7d22\u5220\u9664", notes="\u7ebf\u7d22\u5220\u9664")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u7ebf\u7d22\u5220\u9664", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Boolean> updateDelFlagByLeadsIds(@RequestBody @ApiParam(value="\u7ebf\u7d22dto") LeadsDto dto) {
        return ApiResponse.success((Object)this.leadsService.updateDelFlagByLeadsIds(dto.getLeadsIds()));
    }

    @PostMapping(value={"/updateState"})
    @ApiOperation(value="\u66f4\u65b0\u7ebf\u7d22\u72b6\u6001", notes="\u66f4\u65b0\u7ebf\u7d22\u72b6\u6001")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u66f4\u65b0\u7ebf\u7d22\u72b6\u6001", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> updateLeadsState(@RequestParam @ApiParam(value="\u7ebf\u7d22id") Long leadsId, @RequestParam @ApiParam(value="\u7ebf\u7d22\u72b6\u6001") String state) {
        LocalDateTime date = LocalDateTime.now();
        return ApiResponse.success((Object)this.leadsService.updateLeadsState(leadsId, state, date));
    }

    @PostMapping(value={"/transfer"})
    @ApiOperation(value="\u7ebf\u7d22\u8f6c\u79fb", notes="\u7ebf\u7d22\u8f6c\u79fb")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u7ebf\u7d22\u8f6c\u79fb", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<TransferBatchResultVo> leadsTransfer(@RequestBody @ApiParam(value="\u7ebf\u7d22dto\u96c6\u5408") List<LeadsDto> dto) {
        return ApiResponse.success((Object)this.leadsService.leadsTransfer(dto));
    }

    @PostMapping(value={"/change"})
    @ApiOperation(value="\u7ebf\u7d22\u8f6c\u6362", notes="\u7ebf\u7d22\u8f6c\u6362")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u7ebf\u7d22\u8f6c\u6362", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> leadsChange(@RequestBody @ApiParam(value="\u5546\u673adto") OpportunityEntityDto opportunityEntity) {
        return ApiResponse.success((Object)this.leadsService.leadsChange(opportunityEntity));
    }

    @PostMapping(value={"/Merge"})
    @ApiOperation(value="\u8f6c\u6362\u65f6\u5408\u5e76\u5ba2\u6237", notes="\u8f6c\u6362\u65f6\u5408\u5e76\u5ba2\u6237")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u8f6c\u6362\u65f6\u5408\u5e76\u5ba2\u6237", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> leadsMerge(@RequestBody @ApiParam(value="\u7ebf\u7d22dto") OpportunityEntityDto opportunityEntity) {
        return ApiResponse.success((Object)this.leadsService.leadsMerge(opportunityEntity));
    }

    @PostMapping(value={"/check"})
    @ApiOperation(value="\u6839\u636e\u624b\u673a\u53f7\u67e5\u91cd", notes="\u6839\u636e\u624b\u673a\u53f7\u67e5\u91cd")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u6839\u636e\u624b\u673a\u53f7\u67e5\u91cd", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<Leads>> selectCrmLeadsCheck(@RequestBody @ApiParam(value="\u7ebf\u7d22dto") LeadsDto dto) {
        Page<Leads> page = this.leadsService.selectCrmLeadsList(dto);
        if (StringUtil.isEmpty((Object)dto.getMobilePhone())) {
            return ApiResponse.success((String)"\u65e0\u91cd\u590d\u6570\u636e");
        }
        if (page.getTotal() > 0L) {
            return ApiResponse.fail((String)"\u7ebf\u7d22\u5df2\u5b58\u5728");
        }
        return ApiResponse.success((String)"\u65e0\u91cd\u590d\u6570\u636e");
    }

    @PostMapping(value={"/recheckExcept"})
    public ApiResponse selectRepeatNumber(@RequestBody LeadsDto dto) {
        int i = this.leadsService.selectRepeatNumber(dto);
        if (i > 0) {
            return ApiResponse.fail((String)"\u5f53\u524d\u5ba2\u6237\u5df2\u5b58\u5728");
        }
        return ApiResponse.success((String)"");
    }

    @RequestMapping(value={"/export"})
    public String marketingActivityExport(HttpServletResponse response, @RequestParam(value="leadsView") String leadsView, @RequestParam(value="leadsScreening") String leadsScreening, @RequestParam(value="highSeasId") String highSeasId) {
        LeadsDto dto = new LeadsDto();
        dto.setLeadsScreening(leadsScreening);
        dto.setLeadsView(leadsView);
        dto.setHighSeasId(highSeasId);
        String msg = this.leadsService.leadsExport(response, dto);
        return msg;
    }

    @RequestMapping(value={"/statisticsExport"})
    public String marketingActivityExport(HttpServletResponse response, @RequestParam(value="leadsStatistics ") String leadsStatistics, @RequestParam(value="highSeasId") String highSeasId, @RequestParam(value="leadsOrigin") String leadsOrigin, @RequestParam(value="leadsView") String leadsView, @RequestParam(value="trade") String trade, @RequestParam(value="isFunnelClick") String isFunnelClick, @RequestParam(value="createPerson") String createPerson, @RequestParam(value="organId") String organId) {
        LeadsDto dto = new LeadsDto();
        dto.setLeadsView(leadsView);
        dto.setHighSeasId(highSeasId);
        dto.setLeadsStatistics(leadsStatistics);
        dto.setLeadsOrigin(leadsOrigin);
        dto.setTrade(trade);
        dto.setIsFunnelClick(isFunnelClick);
        dto.setCreatePerson(createPerson);
        dto.setOrganId(organId);
        String msg = this.leadsService.leadsStatisticsExport(response, dto);
        return msg;
    }

    @RequestMapping(value={"/exportTemplate"})
    public String marketingActivityExportTemplate(HttpServletResponse response) {
        String msg = this.leadsService.leadsExportTemplate(response);
        return msg;
    }

    @PostMapping(value={"/updateLeadsByHighSeasId"})
    @ApiOperation(value="\u6295\u5165\u7ebf\u7d22\u516c\u6d77", notes="\u6295\u5165\u7ebf\u7d22\u516c\u6d77")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u6295\u5165\u7ebf\u7d22\u516c\u6d77", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Boolean> updateLeadsByHighSeasId(@RequestBody @ApiParam(value="\u7ebf\u7d22dto") LeadsDto dto) {
        return ApiResponse.success((Object)this.leadsService.updateLeadsByHighSeasId(dto));
    }

    @PostMapping(value={"/abandonedLeads"})
    @ApiOperation(value="\u7ebf\u7d22\u5e9f\u5f03", notes="\u7ebf\u7d22\u5e9f\u5f03")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u7ebf\u7d22\u5e9f\u5f03", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> abandonedLeads(@RequestBody @ApiParam(value="\u7ebf\u7d22dto") OpportunityDto dto) {
        return ApiResponse.success((Object)this.leadsService.abandonedLeads(dto));
    }

    @GetMapping(value={"operate"})
    @ApiOperation(value="\u5224\u65ad\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u64cd\u4f5c\u6743\u9650", notes="\u5224\u65ad\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u64cd\u4f5c\u6743\u9650")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u5224\u65ad\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u64cd\u4f5c\u6743\u9650", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Integer> isOperate(@RequestParam(value="leadsId") @ApiParam(value="\u7ebf\u7d22id") Long leadsId) {
        return ApiResponse.success((Object)this.leadsService.isOperate(leadsId));
    }

    @PostMapping(value={"add"})
    @ApiOperation(value="\u65b0\u589e\u7ebf\u7d22\uff0c\u5b98\u7f51\u65b0\u589e\uff0c\u767d\u540d\u5355", notes="\u65b0\u589e\u7ebf\u7d22\uff0c\u5b98\u7f51\u65b0\u589e\uff0c\u767d\u540d\u5355")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u65b0\u589e\u7ebf\u7d22\uff0c\u5b98\u7f51\u65b0\u589e\uff0c\u767d\u540d\u5355", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Boolean> addLeads(@RequestBody @ApiParam(value="\u7ebf\u7d22\u5b9e\u4f53") Leads leads) {
        return ApiResponse.success((Object)this.leadsService.addLeads(leads));
    }

    @PostMapping(value={"/leadsRepeatList"})
    @ApiOperation(value="\u7ebf\u7d22\u6839\u636e\u610f\u5411\u4ea7\u54c1\u3001\u5ba2\u6237\u540d\u79f0/\u624b\u673a\u53f7\u67e5\u8be2\u91cd\u590d\u7ebf\u7d22\u5217\u8868", notes="\u7ebf\u7d22\u6839\u636e\u610f\u5411\u4ea7\u54c1\u3001\u5ba2\u6237\u540d\u79f0/\u624b\u673a\u53f7\u67e5\u8be2\u91cd\u590d\u7ebf\u7d22\u5217\u8868")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u7ebf\u7d22\u6839\u636e\u610f\u5411\u4ea7\u54c1\u3001\u5ba2\u6237\u540d\u79f0/\u624b\u673a\u53f7\u67e5\u8be2\u91cd\u590d\u7ebf\u7d22\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse selectLeadsRepeatList(@RequestBody @ApiParam(value="\u7ebf\u7d22dto") OpportunityDto dto) {
        return ApiResponse.success(this.leadsService.selectLeadsRepeatList(dto));
    }

    @PostMapping(value={"/leadsCheckRepeat"})
    @ApiOperation(value="\u7ebf\u7d22\u6839\u636e\u610f\u5411\u4ea7\u54c1\u3001\u5ba2\u6237\u540d\u79f0/\u624b\u673a\u53f7\u67e5\u91cd", notes="\u7ebf\u7d22\u6839\u636e\u610f\u5411\u4ea7\u54c1\u3001\u5ba2\u6237\u540d\u79f0/\u624b\u673a\u53f7\u67e5\u91cd")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u7ebf\u7d22\u6839\u636e\u610f\u5411\u4ea7\u54c1\u3001\u5ba2\u6237\u540d\u79f0/\u624b\u673a\u53f7\u67e5\u91cd", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<String> leadsCheckRepeat(@RequestBody @ApiParam(value="\u7ebf\u7d22dto") OpportunityDto dto) {
        return ApiResponse.success((String)this.leadsService.leadsCheckRepeat(dto));
    }

    @GetMapping(value={"/selectLeadsProduct"})
    @ApiOperation(value="\u6839\u636e\u5546\u673aid\u67e5\u8be2\u5173\u8054\u5546\u673a\u4ea7\u54c1", notes="\u6839\u636e\u5546\u673aid\u67e5\u8be2\u5173\u8054\u5546\u673a\u4ea7\u54c1")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u6839\u636e\u5546\u673aid\u67e5\u8be2\u5173\u8054\u5546\u673a\u4ea7\u54c1", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OpportunityProductVo>> selectLeadsProducts(@RequestParam(value="opportunityId") @ApiParam(value="\u5546\u673a\u7ebf\u7d22id") Long opportunityId) {
        return ApiResponse.success(this.leadsService.selectLeadsProducts(opportunityId));
    }

    @PostMapping(value={"convert"})
    @ApiOperation(value="\u5546\u673a\u53ea\u8f6c\u5ba2\u6237", notes="\u5546\u673a\u53ea\u8f6c\u5ba2\u6237")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u7ebf\u7d22\u8f6c\u6362\uff0c\u6574\u5408\u65b0\u5efa\u3001\u5408\u5e76\u63a5\u53e3", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<LeadConvertDto> convert(@RequestBody @ApiParam(value="\u7ebf\u7d22\u8f6c\u6362dto") LeadConvertDto convertDto) {
        return ApiResponse.success((Object)this.leadsService.leadConvert(convertDto));
    }

    @GetMapping(value={"abandoned"})
    @ApiOperation(value="\u6839\u636e\u7ebf\u7d22\u5e9f\u5f03\u539f\u56e0\u67e5\u627e\u5e9f\u5f03\u63cf\u8ff0", notes="\u6839\u636e\u7ebf\u7d22\u5e9f\u5f03\u539f\u56e0\u67e5\u627e\u5e9f\u5f03\u63cf\u8ff0")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u6839\u636e\u7ebf\u7d22\u5e9f\u5f03\u539f\u56e0\u67e5\u627e\u5e9f\u5f03\u63cf\u8ff0", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<String>> leadsAbandonedTag(@RequestParam(value="abandonedReason") @ApiParam(value="\u7ebf\u7d22\u5e9f\u5f03\u539f\u56e0") String abandonedReason) {
        return ApiResponse.success(this.leadsService.leadsAbandonedTag(abandonedReason));
    }

    @PostMapping(value={"/leadsHighSeasExport"})
    @ApiOperation(value="\u5bfc\u51fa\u516c\u6d77\u7ebf\u7d22", notes="\u5bfc\u51fa\u516c\u6d77\u7ebf\u7d22")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u5bfc\u51fa\u516c\u6d77\u7ebf\u7d22", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public String leadsHighSeasExport(HttpServletResponse response, @RequestBody @ApiParam(value="\u7ebf\u7d22dto") LeadsOriginDto dto) {
        return this.leadsService.leadsHighSeasExport(response, dto);
    }

    @PostMapping(value={"highSeasImportTemplate"})
    @ApiOperation(value="\u4e0b\u8f7d\u516c\u6d77\u7ebf\u7d22\u5bfc\u5165\u6a21\u677f", notes="\u4e0b\u8f7d\u516c\u6d77\u7ebf\u7d22\u5bfc\u5165\u6a21\u677f")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u4e0b\u8f7d\u516c\u6d77\u7ebf\u7d22\u5bfc\u5165\u6a21\u677f", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.NULL_EVENT_TYPE)
    public void highSeasImportTemplate(@ApiParam(value="\u670d\u52a1\u5668\u54cd\u5e94\u7c7b") HttpServletResponse response) {
        this.leadsService.leadsHighSeasImportTemplate(response);
    }

    @GetMapping(value={"/formQuery"})
    @ApiOperation(value="\u8868\u5355\u67e5\u8be2", notes="\u8868\u5355\u67e5\u8be2")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u8868\u5355\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Leads> formQuery(@RequestParam(value="id") @ApiParam(value="\u7ebf\u7d22id") String id) {
        return ApiResponse.success((Object)this.leadsService.formQuery(id));
    }

    @PostMapping(value={"insertOrUpdate"})
    @ApiOperation(value="\u7ebf\u7d22\u65b0\u589e\u6216\u4fee\u6539", notes="\u7ebf\u7d22\u65b0\u589e\u6216\u4fee\u6539")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u65b0\u589e\u6216\u4fee\u6539", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<String> insertOrUpdate(@RequestBody Leads leads) {
        return this.leadsService.insertOrUpdate(leads);
    }

    @PostMapping(value={"/convertCustomer"})
    @ApiOperation(value="\u7ebf\u7d22\u53ea\u8f6c\u5ba2\u6237", notes="\u7ebf\u7d22\u53ea\u8f6c\u5ba2\u6237")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u7ebf\u7d22\u53ea\u8f6c\u5ba2\u6237", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<LeadConvertDto> convertCustomer(@RequestBody @ApiParam(value="\u7ebf\u7d22\u8f6c\u6362dto") LeadConvertDto convertDto) {
        return ApiResponse.success((Object)this.leadsService.convertCustomer(convertDto));
    }

    @PostMapping(value={"/abandoned"})
    @ApiOperation(value="\u79c1\u6d77\u7ebf\u7d22\u5e9f\u5f03\u3001\u652f\u6301\u6279\u91cf", notes="\u79c1\u6d77\u7ebf\u7d22\u5e9f\u5f03")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u79c1\u6d77\u7ebf\u7d22\u5e9f\u5f03\u3001\u652f\u6301\u6279\u91cf", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> abandonedLeads(@RequestBody @ApiParam(value="\u7ebf\u7d22dto\u96c6\u5408") List<LeadsDto> dto) {
        return ApiResponse.success((Object)this.leadsService.abandonedLeads(dto));
    }

    @GetMapping(value={"/selectLeadsProductByLeadsId"})
    @ApiOperation(value="\u6839\u636e\u5546\u673a\u7ebf\u7d22id\u67e5\u8be2\u610f\u5411\u4ea7\u54c1", notes="\u6839\u636e\u5546\u673a\u7ebf\u7d22id\u67e5\u8be2\u610f\u5411\u4ea7\u54c1")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u6839\u636e\u5546\u673a\u7ebf\u7d22id\u67e5\u8be2\u610f\u5411\u4ea7\u54c1", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<Product>> selectLeadsProductsByLeadsId(@RequestParam(value="leadsId") @ApiParam(value="\u5546\u673a\u7ebf\u7d22id") Long leadsId) {
        return ApiResponse.success(this.leadsService.selectLeadsProductsByLeadsId(leadsId));
    }

    @PostMapping(value={"/highSeasImport"})
    @ApiOperation(value="\u516c\u6d77\u7ebf\u7d22\u5bfc\u5165", notes="\u516c\u6d77\u7ebf\u7d22\u5bfc\u5165")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u516c\u6d77\u7ebf\u7d22\u5bfc\u5165", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.NULL_EVENT_TYPE)
    public ApiResponse<String> highSeasImport(@RequestPart(value="file") MultipartFile file, @RequestPart(value="highSeasId") String highSeasId) {
        String importResult = this.leadsService.leadsHighSeasImport(file, highSeasId);
        if (!Objects.equals(importResult, "\u5bfc\u5165\u6210\u529f")) {
            return ApiResponse.fail((String)importResult);
        }
        return ApiResponse.success((String)importResult);
    }

    @PostMapping(value={"/abandonedLeadsActivated"})
    @ApiOperation(value="\u79c1\u6d77\u7ebf\u7d22\u6fc0\u6d3b", notes="\u79c1\u6d77\u7ebf\u7d22\u6fc0\u6d3b")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u79c1\u6d77\u7ebf\u7d22\u6fc0\u6d3b", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> abandonedLeadsActivated(@RequestBody @ApiParam(value="\u7ebf\u7d22dto") LeadsDto dto) {
        return ApiResponse.success((Object)this.leadsService.activatedLeadsByBatch(dto));
    }

    @ApiOperation(value="\u7ebf\u7d22\u91cd\u590d\u5206\u6790(\u516c\u6d77\u3001\u79c1\u6d77)", notes="\u7ebf\u7d22\u91cd\u590d\u5206\u6790")
    @PostMapping(value={"/leadsRepeat"})
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u7ebf\u7d22\u91cd\u590d\u5206\u6790(\u516c\u6d77\u3001\u79c1\u6d77)", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<LeadsRepeatVo>> repeatLeads(@RequestBody @ApiParam(value="\u7ebf\u7d22dto") LeadsDto dto) {
        return ApiResponse.success(this.leadsService.repeatLeads(dto));
    }

    @ApiOperation(value="\u83b7\u53d6\u7ebf\u7d22\u91cd\u590d\u5217\u8868(\u516c\u6d77\u3001\u79c1\u6d77)", notes="\u83b7\u53d6\u7ebf\u7d22\u91cd\u590d\u5217\u8868")
    @PostMapping(value={"/repeatLeadsDetailList"})
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u83b7\u53d6\u7ebf\u7d22\u91cd\u590d\u5217\u8868(\u516c\u6d77\u3001\u79c1\u6d77)", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<LeadsRepeatDetailVo>> repeatLeadsList(@RequestBody @ApiParam(value="\u7ebf\u7d22dto") LeadsDto dto) {
        return ApiResponse.success(this.leadsService.repeatLeadsList(dto));
    }

    @PostMapping(value={"/associativeQuery"})
    @ApiOperation(value="\u7ebf\u7d22\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6", notes="\u7ebf\u7d22\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u7ebf\u7d22\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<AssociativeQueryVo>> associativeQuery(@RequestBody @ApiParam(value="\u7ebf\u7d22dto") LeadsAssociativeQueryDto dto) {
        return ApiResponse.success(this.leadsService.associativeQuery(dto));
    }

    @PostMapping(value={"/releaseLeads"})
    @ApiOperation(value="\u79c1\u6d77\u7ebf\u7d22\u91ca\u653e\u516c\u6d77", notes="\u79c1\u6d77\u7ebf\u7d22\u91ca\u653e\u516c\u6d77")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u79c1\u6d77\u7ebf\u7d22\u91ca\u653e\u516c\u6d77", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> releaseLeads(@RequestBody @ApiParam(value="\u7ebf\u7d22dto") LeadsDto dto) {
        return ApiResponse.success((Object)this.leadsService.releaseLeads(dto));
    }

    @GetMapping(value={"/getHighSeasId"})
    @ApiOperation(value="\u6839\u636e\u79c1\u6d77\u7ebf\u7d22\u67e5\u627e\u5bf9\u5e94\u516c\u6d77id(\u82e5\u6709\uff0c\u5426\u5219\u8fd4\u56de\u7a7a)", notes="\u6839\u636e\u79c1\u6d77\u7ebf\u7d22\u67e5\u627e\u5bf9\u5e94\u516c\u6d77id(\u82e5\u6709\uff0c\u5426\u5219\u8fd4\u56de\u7a7a)")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u6839\u636e\u79c1\u6d77\u7ebf\u7d22\u67e5\u627e\u5bf9\u5e94\u516c\u6d77id(\u82e5\u6709\uff0c\u5426\u5219\u8fd4\u56de\u7a7a)", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Long> getHighSeasIdByLeadsId(@RequestParam(value="leadsId") @ApiParam(value="\u7ebf\u7d22id") Long leadsId) {
        return ApiResponse.success((Object)this.leadsService.getOldHighSeasId(leadsId));
    }

    @PostMapping(value={"/convertOpportunity"})
    @ApiOperation(value="\u7ebf\u7d22\u8f6c\u6362\u5546\u673a\uff08\u4e3b\u7ebf\uff09", notes="\u7ebf\u7d22\u8f6c\u6362\u5546\u673a")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u7ebf\u7d22\u8f6c\u6362\u5546\u673a\uff08\u4e3b\u7ebf\uff09", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Long> convertOpportunity(@RequestBody @ApiParam(value="\u7ebf\u7d22\u8f6c\u6362dto") ImproveOpportunityDto dto) {
        return ApiResponse.success((Object)this.leadsService.convertOpportunity(dto));
    }

    @PostMapping(value={"/leadsChangeDeptBatch"})
    @ApiOperation(value="\u7ebf\u7d22\u6279\u91cf\u53d8\u66f4\u6240\u5c5e\u90e8\u95e8", notes="\u7ebf\u7d22\u6279\u91cf\u53d8\u66f4\u6240\u5c5e\u90e8\u95e8")
    @AuditLog(moduleName="\u7ebf\u7d22\u6279\u91cf\u53d8\u66f4\u6240\u5c5e\u90e8\u95e8", eventDesc="\u7ebf\u7d22\u6279\u91cf\u53d8\u66f4\u6240\u5c5e\u90e8\u95e8", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> leadsChangeDeptBatch(@RequestBody DeptChangeBatchDto dto) {
        return this.leadsService.leadsChangeDeptBatch(dto);
    }

    @PostMapping(value={"/leadsChangeDeptByChargePersonBatch"})
    @ApiOperation(value="\u7ebf\u7d22\u6279\u91cf\u53d8\u66f4\u6240\u5c5e\u90e8\u95e8\u4e3a\u8d1f\u8d23\u4eba\u6240\u5c5e\u90e8\u95e8", notes="\u7ebf\u7d22\u6279\u91cf\u53d8\u66f4\u6240\u5c5e\u90e8\u95e8\u4e3a\u8d1f\u8d23\u4eba\u6240\u5c5e\u90e8\u95e8")
    public ApiResponse<String> leadsChangeDeptByChargePersonBatch(@RequestBody DeptChangeBatchDto dto) {
        return this.leadsService.leadsChangeDeptByChargePersonBatch(dto);
    }
}

