/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.job.service.impl;

import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.job.model.EndTimeTimeoutCount;
import com.jxdinfo.crm.core.job.service.EndTimeTimeoutService;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EndTimeTimeoutServiceImpl
implements EndTimeTimeoutService {
    @Autowired
    private OpportunityService opportunityService;
    @Autowired
    private OpportunityMapper opportunityMapper;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private CommonMapper commonMapper;

    @Override
    public ProcessResult EndTimeTimeout() {
        List<EndTimeTimeoutCount> deptCountList;
        LocalDateTime date = LocalDateTime.now();
        List<EndTimeTimeoutCount> personCountList = this.opportunityMapper.getEndTimeTimeoutCountByChargePerson(date);
        if (CollectionUtil.isNotEmpty(personCountList)) {
            for (EndTimeTimeoutCount endTimeTimeoutCount : personCountList) {
                String mobileTitle = "\u3010CRM\u3011\u5546\u673a\u5f02\u5e38\u63d0\u9192";
                String mobileContent = "\u60a8\u540d\u4e0b\u5171\u6709" + endTimeTimeoutCount.getCount() + "\u6761\u5546\u673a\u7684\u9884\u8ba1\u6210\u4ea4\u65f6\u95f4\u5df2\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u8bf7\u53ca\u65f6\u4fee\u6b63\uff0c\u5426\u5219\u5f71\u54cd\u6570\u636e\u7edf\u8ba1\u53ca\u9884\u6d4b\u3002\u5f02\u5e38\u6570\u636e\u53ef\u767b\u5f55\u3010PC\u7aefCRM\u7cfb\u7edf-\u9996\u9875-\u9500\u552e\u63d0\u9192-\u6570\u636e\u5f02\u5e38\u63d0\u9192\u3011\u4e2d\u67e5\u770b\u3002";
                String content = "\u3010\u6570\u636e\u5f02\u5e38\u63d0\u9192\u3011\u60a8\u540d\u4e0b\u5171\u6709" + endTimeTimeoutCount.getCount() + "\u6761\u5546\u673a\u7684\u9884\u8ba1\u6210\u4ea4\u65f6\u95f4\u5df2\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u8bf7\u53ca\u65f6\u4fee\u6b63\uff0c\u5426\u5219\u5f71\u54cd\u6570\u636e\u7edf\u8ba1\u53ca\u9884\u6d4b\u3002\u5f02\u5e38\u6570\u636e\u53ef\u5728\u3010CRM\u7cfb\u7edf-\u9996\u9875-\u9500\u552e\u63d0\u9192-\u6570\u636e\u5f02\u5e38\u63d0\u9192\u3011\u4e2d\u67e5\u770b\u3002";
                EimPushUtil.pushJqxArticleMessage(mobileTitle, mobileContent, "/crm/sj/sjxq/xxzl", null, Collections.singletonList(endTimeTimeoutCount.getChargePersonId().toString()));
                AddSysMessageType addSysMessageType = new AddSysMessageType();
                String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/index";
                addSysMessageType.setMessageContent(content);
                addSysMessageType.setReleaseDate(date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                addSysMessageType.setMessageTypeId(CommonConstant.MESSAGE_TYPE_OTHER);
                addSysMessageType.setBusinessAddress(unifyWebUrl);
                addSysMessageType.setUserId(endTimeTimeoutCount.getChargePersonId().toString());
                addSysMessageType.setOpenWay("1");
                UnifyUtil.sendMessage(addSysMessageType);
            }
        }
        if (CollectionUtil.isNotEmpty(deptCountList = this.opportunityMapper.getEndTimeTimeoutCountByDept(date))) {
            HashMap<Long, Integer> deptCountMap = new HashMap<Long, Integer>();
            for (EndTimeTimeoutCount timeTimeoutCount : deptCountList) {
                deptCountMap.put(timeTimeoutCount.getDeptId(), timeTimeoutCount.getCount());
            }
            ArrayList<String> roleList = new ArrayList<String>();
            roleList.add(this.crmProperties.getRoles().getSalesGM());
            roleList.add(this.crmProperties.getRoles().getSalesDirector());
            List<Long> deptIdList = deptCountList.stream().map(EndTimeTimeoutCount::getDeptId).collect(Collectors.toList());
            List<SysUsers> sysUsersList = this.commonMapper.selectSysUserByDeptandRole(roleList, deptIdList);
            HashMap<Long, Integer> sysUsersCountTempMap = new HashMap<Long, Integer>();
            for (SysUsers sysUsers : sysUsersList) {
                long idTemp = sysUsers.getId();
                int count = (Integer)deptCountMap.get(sysUsers.getDepartmentId());
                if (HussarUtils.isEmpty(sysUsersCountTempMap.get(idTemp))) {
                    sysUsersCountTempMap.put(idTemp, count);
                    continue;
                }
                sysUsersCountTempMap.put(idTemp, (Integer)sysUsersCountTempMap.get(idTemp) + count);
            }
            for (Map.Entry entry : sysUsersCountTempMap.entrySet()) {
                Long key = (Long)entry.getKey();
                Integer value = (Integer)entry.getValue();
                String mobileTitle = "\u3010CRM\u3011\u5546\u673a\u5f02\u5e38\u63d0\u9192";
                String mobileContent = "\u60a8\u8d1f\u8d23\u7684\u90e8\u95e8\u5171\u6709" + value + "\u6761\u5546\u673a\u7684\u9884\u8ba1\u6210\u4ea4\u65f6\u95f4\u5df2\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u8bf7\u53ca\u65f6\u63d0\u9192\u5546\u673a\u8d1f\u8d23\u4eba\u4fee\u6b63\uff0c\u5426\u5219\u5f71\u54cd\u6570\u636e\u7edf\u8ba1\u53ca\u9884\u6d4b\u3002\u5f02\u5e38\u6570\u636e\u53ef\u5728\u3010PC\u7aefCRM\u7cfb\u7edf-\u9996\u9875-\u9500\u552e\u63d0\u9192-\u6570\u636e\u5f02\u5e38\u63d0\u9192\u3011\u4e2d\u67e5\u770b\u3002";
                String content = "\u3010\u6570\u636e\u5f02\u5e38\u63d0\u9192\u3011\u60a8\u8d1f\u8d23\u7684\u7701\u533a\u5171\u6709" + value + "\u6761\u5546\u673a\u7684\u9884\u8ba1\u6210\u4ea4\u65f6\u95f4\u5df2\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u8bf7\u53ca\u65f6\u63d0\u9192\u7701\u533a\u9500\u552e\u4fee\u6b63\uff0c\u5426\u5219\u5f71\u54cd\u6570\u636e\u7edf\u8ba1\u53ca\u9884\u6d4b\u3002\u5f02\u5e38\u6570\u636e\u53ef\u5728\u3010CRM\u7cfb\u7edf-\u9996\u9875-\u9500\u552e\u63d0\u9192-\u6570\u636e\u5f02\u5e38\u63d0\u9192\u3011\u4e2d\u67e5\u770b\u3002";
                EimPushUtil.pushJqxArticleMessage(mobileTitle, mobileContent, "/crm/sj/sjxq/xxzl", null, Collections.singletonList(String.valueOf(key)));
                AddSysMessageType addSysMessageType = new AddSysMessageType();
                String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/index";
                addSysMessageType.setMessageContent(content);
                addSysMessageType.setReleaseDate(date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                addSysMessageType.setMessageTypeId(CommonConstant.MESSAGE_TYPE_OTHER);
                addSysMessageType.setBusinessAddress(unifyWebUrl);
                addSysMessageType.setUserId(key.toString());
                addSysMessageType.setOpenWay("1");
                UnifyUtil.sendMessage(addSysMessageType);
            }
        }
        return new ProcessResult(true);
    }
}

