/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.comment.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordAPIVo;
import com.jxdinfo.crm.core.comment.dao.CrmCommentMapper;
import com.jxdinfo.crm.core.comment.model.CrmCommentEntity;
import com.jxdinfo.crm.core.comment.service.CrmCommentService;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.contact.dao.ContactMapper;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.customer.dao.CustomerMapper;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.fileinfo.dto.FileInfoDto;
import com.jxdinfo.crm.core.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.core.leads.dao.LeadsMapper;
import com.jxdinfo.crm.core.leads.model.Leads;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.task.dao.TaskMapper;
import com.jxdinfo.crm.core.task.model.TaskEntity;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrmCommentServiceImpl
extends ServiceImpl<CrmCommentMapper, CrmCommentEntity>
implements CrmCommentService {
    @Resource
    private FileInfoService fileInfoService;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private CrmCommentMapper commentMapper;
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private LeadsMapper leadsMapper;
    @Resource
    private CustomerMapper customerMapper;
    @Resource
    private ContactMapper contactMapper;
    @Resource
    private TaskMapper taskMapper;
    @Resource
    private UnifyProperties unifyProperties;

    @Override
    @Transactional
    public Boolean addComment(CrmCommentEntity commentEntity) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        Long commentId = Long.valueOf(CommonUtills.generateAssignId());
        commentEntity.setCommentId(commentId);
        if (CollectionUtil.isNotEmpty(commentEntity.getFileIds())) {
            FileInfoDto fileInfoDto = new FileInfoDto();
            fileInfoDto.setBusinessId(String.valueOf(commentId));
            fileInfoDto.setIds(commentEntity.getFileIds());
            this.fileInfoService.insertFileInfo(fileInfoDto);
        }
        commentEntity.setCreatePersion(user.getUserId());
        commentEntity.setCreatePersionName(user.getUserName());
        commentEntity.setOwnDepartment(user.getDeptId());
        commentEntity.setOwnDepartmentName(user.getDeptName());
        commentEntity.setCreateTime(date);
        commentEntity.setDelFlag("0");
        this.save((Object)commentEntity);
        try {
            this.sendMessage(commentEntity, date, user);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public Boolean deleteComment(Long commentId) {
        CrmCommentEntity commentEntity = new CrmCommentEntity();
        commentEntity.setCommentId(commentId);
        commentEntity.setDelFlag("1");
        return this.updateById((Object)commentEntity);
    }

    @Override
    public List<CrmCommentEntity> getCommentListByBusinessId(Long businessId) {
        return this.commentMapper.getCommentListByBusinessId(businessId);
    }

    private void sendMessage(CrmCommentEntity commentEntity, LocalDateTime date, SecurityUser user) {
        if ("1".equals(commentEntity.getBusinessType())) {
            String contentUnify;
            TrackRecordAPIVo trackRecord = this.trackRecordAPIService.getById(commentEntity.getBusinessId());
            if (trackRecord == null) {
                return;
            }
            String url = "/crm/sy/yddsy";
            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/index";
            String title = "\u8ddf\u8fdb\u8bb0\u5f55\u8bc4\u8bba";
            String content = commentEntity.getContent();
            String businessName = "";
            ArrayList<String> receiverIds = new ArrayList<String>();
            if (CrmBusinessTypeEnum.OPPORTUNITY.getId().equals(trackRecord.getBusinessType())) {
                OpportunityEntity opportunity = (OpportunityEntity)this.opportunityMapper.selectById(trackRecord.getTypeId());
                businessName = opportunity.getOpportunityName();
                url = "/crm/sj/sjxq/xxzl";
                unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + trackRecord.getTypeId() + "\"";
                title = "\u5546\u673a\u8ddf\u8fdb\u8bb0\u5f55";
            } else if (CrmBusinessTypeEnum.CUSTOMER.getId().equals(trackRecord.getBusinessType())) {
                CustomerEntity customer = (CustomerEntity)this.customerMapper.selectById(trackRecord.getTypeId());
                businessName = customer.getCustomerName();
                url = "/crm/kh/khxq";
                unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/clientDetails?row=" + "\"" + trackRecord.getTypeId() + "\"";
                title = "\u5ba2\u6237\u8ddf\u8fdb\u8bb0\u5f55";
            } else if (CrmBusinessTypeEnum.CONTACT.getId().equals(trackRecord.getBusinessType())) {
                ContactEntity contact = (ContactEntity)this.contactMapper.selectById(trackRecord.getTypeId());
                businessName = contact.getContactName();
                url = "/crm/lxr/lxrxq";
                unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/contactDetails?row=" + "\"" + trackRecord.getTypeId() + "\"";
                title = "\u8054\u7cfb\u4eba\u8ddf\u8fdb\u8bb0\u5f55";
            } else if (CrmBusinessTypeEnum.LEADS.getId().equals(trackRecord.getBusinessType())) {
                Leads leads = (Leads)this.leadsMapper.selectById(trackRecord.getTypeId());
                businessName = leads.getLeadsName();
                url = "/crm/schd/xsxq";
                title = "\u7ebf\u7d22\u8ddf\u8fdb\u8bb0\u5f55";
            } else if (CrmBusinessTypeEnum.TASK.getId().equals(trackRecord.getBusinessType())) {
                TaskEntity task = (TaskEntity)this.taskMapper.selectById(trackRecord.getTypeId());
                businessName = task.getContent();
                url = "/crm/rw/rwxq";
                unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/rw/todoTask";
                title = "\u4efb\u52a1\u8ddf\u8fdb\u8bb0\u5f55";
            }
            String contentIM = "\u3010" + businessName + "\u3011" + content;
            if (commentEntity.getTargeId() != null) {
                title = commentEntity.getCreatePersionName() + "\u56de\u590d\u4e86\u60a8\u7684" + title + "\u8bc4\u8bba";
                CrmCommentEntity replyEntity = (CrmCommentEntity)((Object)this.getById(commentEntity.getTargeId()));
                contentUnify = "\u3010\u56de\u590d\u63d0\u9192\u3011" + commentEntity.getCreatePersionName() + "\u8bc4\u8bba\u4e86\u60a8\u7684\u8bc4\u8bba\uff0c\u56de\u590d\u5185\u5bb9\uff1a" + content + "\uff0c\u5173\u8054\u4e1a\u52a1\uff1a" + businessName + "\uff0c\u8bf7\u77e5\u6089\u3002";
                receiverIds.add(replyEntity.getCreatePersion().toString());
            } else {
                title = commentEntity.getCreatePersionName() + "\u8bc4\u8bba\u4e86\u60a8\u7684" + title;
                contentUnify = "\u3010\u8bc4\u8bba\u63d0\u9192\u3011" + commentEntity.getCreatePersionName() + " \u8bc4\u8bba\u4e86\u60a8\u7684\u8ddf\u8fdb\u8bb0\u5f55\uff0c\u8bc4\u8bba\u5185\u5bb9\uff1a" + content + "\uff0c\u5173\u8054\u4e1a\u52a1\uff1a" + businessName + "\uff0c\u8bf7\u77e5\u6089\u3002";
                receiverIds.add(trackRecord.getCreatePerson().toString());
            }
            EimPushUtil.pushJqxArticleMessage(title, contentIM, url, trackRecord.getTypeId().toString(), receiverIds);
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            String userIdToString = StringUtil.join(receiverIds, (String)",");
            UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, userIdToString, user.getUserName(), unifyWebUrl, "");
            UnifyUtil.sendMessage(addSysMessageType);
        }
    }
}

