/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunity.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.core.common.dto.DeptChangeBatchDto;
import com.jxdinfo.crm.core.common.vo.AssociativeQueryVo;
import com.jxdinfo.crm.core.common.vo.TransferBatchResultVo;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.vo.CheckRepeat;
import com.jxdinfo.crm.core.opportunity.dto.ChangeOpportunityStageDto;
import com.jxdinfo.crm.core.opportunity.dto.ImproveCreateContactDto;
import com.jxdinfo.crm.core.opportunity.dto.ImproveCreateCustomerDto;
import com.jxdinfo.crm.core.opportunity.dto.ImproveOpportunityDto;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityAssociativeQueryDto;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityDto;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityEntityDto;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.service.ImproveOpportunityService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityImportAndExportService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunity.vo.OpportunityEntityVo;
import com.jxdinfo.crm.core.opportunity.vo.OpportunityRepeatVO;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u5546\u673a\u7ba1\u7406"})
@RestController
@RequestMapping(value={"opportunity"})
public class OpportunityController {
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private ImproveOpportunityService improveOpportunityService;
    @Resource
    private OpportunityImportAndExportService opportunityImportAndExport;

    @PostMapping(value={"/selectCrmOpportunityList"})
    @ApiOperation(value="\u67e5\u8be2\u5546\u673a\u5217\u8868", notes="\u67e5\u8be2\u5546\u673a\u5217\u8868")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page> selectCrmOpportunityList(@RequestBody @ApiParam(value="\u5546\u673adto") OpportunityDto dto) {
        Page<OpportunityEntity> page = this.opportunityService.selectCrmOpportunityList(dto);
        return ApiResponse.success(page);
    }

    @PostMapping(value={"/selectOpportunityAnalysisList"})
    @ApiOperation(value="\u67e5\u8be2\u5546\u673a\u7edf\u8ba1\u8ba1\u5212\u5217\u8868", notes="\u67e5\u8be2\u5546\u673a\u7edf\u8ba1\u8ba1\u5212\u5217\u8868")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page> selectOpportunityAnalysisList(@RequestBody @ApiParam(value="\u5546\u673adto") OpportunityDto dto) {
        Page<OpportunityEntity> page = this.opportunityService.selectOpportunityAnalysisList(dto);
        return ApiResponse.success(page);
    }

    @PostMapping(value={"/selectOpportunityAnalysisSum"})
    @ApiOperation(value="\u5546\u673a\u9636\u6bb5\u6570\u636e\u7edf\u8ba1", notes="\u5546\u673a\u9636\u6bb5\u6570\u636e\u7edf\u8ba1")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public Object selectOpportunityAnalysisSum(@RequestBody @ApiParam(value="\u5546\u673adto") OpportunityDto dto) {
        Object result = this.opportunityService.selectOpportunityAnalysisSum(dto);
        return ApiResponse.success((Object)result);
    }

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e\u5546\u673a", notes="\u65b0\u589e\u5546\u673a")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Long> addOpportunity(@RequestBody @ApiParam(value="\u5546\u673adto") OpportunityEntityDto opportunityEntityDto) {
        return ApiResponse.success((Object)this.opportunityService.addOpportunity(opportunityEntityDto));
    }

    @PostMapping(value={"/deleteCrmOpportunityByIds"})
    @ApiOperation(value="\u5220\u9664\u5546\u673a", notes="\u5220\u9664\u5546\u673a")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Boolean> deleteCrmOpportunityByIds(@RequestBody @ApiParam(value="\u5546\u673adto") OpportunityDto dto) {
        return ApiResponse.success((Object)this.opportunityService.updateDelFlagByIds(dto.getOpportunityIds()));
    }

    @PostMapping(value={"/opportunityTransfer"})
    @ApiOperation(value="\u8f6c\u79fb\u5546\u673a", notes="\u8f6c\u79fb\u5546\u673a\uff0c\u652f\u6301\u6279\u91cf")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<TransferBatchResultVo> opportunityTransfer(@RequestBody @ApiParam(value="\u5546\u673adto\u96c6\u5408") List<OpportunityDto> dto) {
        return ApiResponse.success((Object)this.opportunityService.opportunityTransferBatch(dto));
    }

    @PostMapping(value={"/selectOpportunityByContact"})
    @ApiOperation(value="\u6839\u636e\u8054\u7cfb\u4ebaid\u67e5\u8be2\u5546\u673a", notes="\u6839\u636e\u8054\u7cfb\u4ebaid\u67e5\u8be2\u5546\u673a")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse selectOpportunityByContact(@RequestBody @ApiParam(value="\u5546\u673adto") OpportunityDto dto) {
        Page<OpportunityEntity> page = this.opportunityService.selectOpportunityByContact(dto);
        return ApiResponse.success(page);
    }

    @PostMapping(value={"/selectStageInfo"})
    @ApiOperation(value="\u67e5\u8be2\u5546\u673a\u9636\u6bb5\u4fe1\u606f", notes="\u67e5\u8be2\u5546\u673a\u9636\u6bb5\u4fe1\u606f")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse selectStageInfo(@RequestBody @ApiParam(value="\u5546\u673adto") OpportunityDto dto) {
        List<Map<String, Object>> list = this.opportunityService.selectStageInfo(dto);
        return ApiResponse.success(list);
    }

    @PostMapping(value={"/selectStageByGroup"})
    @ApiOperation(value="\u6839\u636e\u5546\u673a\u7ec4id\u67e5\u8be2\u5546\u673a\u9636\u6bb5", notes="\u6839\u636e\u5546\u673a\u7ec4id\u67e5\u8be2\u5546\u673a\u9636\u6bb5")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse selectStageByGroupId(@RequestBody @ApiParam(value="\u5546\u673adto") OpportunityDto dto) {
        List<OpportunityStage> list = this.opportunityService.selectStageByGroupId(dto);
        return ApiResponse.success(list);
    }

    @PostMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51fa\u5546\u673a", notes="\u5bfc\u51fa\u5546\u673a")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public String marketingActivityExport(HttpServletResponse response, @RequestBody @ApiParam(value="\u5546\u673adto") OpportunityDto dto) {
        return this.opportunityService.opportunityExport(response, dto);
    }

    @RequestMapping(value={"/exportTemplate"})
    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u51fa\u5546\u673a\u6a21\u677f", notes="\u4e0b\u8f7d\u5bfc\u51fa\u5546\u673a\u6a21\u677f")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.NULL_EVENT_TYPE)
    public String marketingActivityExportTemplate(HttpServletResponse response) {
        String msg = this.opportunityService.opportunityExportTemplate(response);
        return msg;
    }

    @PostMapping(value={"/import"})
    @ApiOperation(value="\u5546\u673a\u5bfc\u5165", notes="\u5546\u673a\u5bfc\u5165")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u5bfc\u5165", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.NULL_EVENT_TYPE)
    public ApiResponse<String> opportunityImport(@RequestBody @ApiParam(value="\u6587\u4ef6\u7c7b") MultipartFile file) {
        return ApiResponse.success((String)this.opportunityImportAndExport.opportunityImport(file));
    }

    @PostMapping(value={"importTemplate"})
    @ApiOperation(value="\u4e0b\u8f7d\u7ebf\u7d22\u5bfc\u5165\u6a21\u677f", notes="\u4e0b\u8f7d\u7ebf\u7d22\u5bfc\u5165\u6a21\u677f")
    @AuditLog(moduleName="\u7ebf\u7d22\u7ba1\u7406", eventDesc="\u4e0b\u8f7d\u7ebf\u7d22\u5bfc\u5165\u6a21\u677f", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.NULL_EVENT_TYPE)
    public void opportunityImportTemplate(@ApiParam(value="\u670d\u52a1\u5668\u54cd\u5e94\u7c7b") HttpServletResponse response) {
        this.opportunityImportAndExport.opportunityImportTemplate(response);
    }

    @PostMapping(value={"/opportunityTissueTree"})
    public Object opportunityTissueTree() {
        String sParentId = "11";
        Object result = this.opportunityService.opportunityTissueTree(sParentId);
        return ApiResponse.success((Object)result);
    }

    @GetMapping(value={"detail"})
    @ApiOperation(value="\u83b7\u53d6\u5546\u673a\u8be6\u60c5", notes="\u83b7\u53d6\u5546\u673a\u8be6\u60c5")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<OpportunityEntityVo> getOpportunityDetail(@RequestParam(value="opportunityId") @ApiParam(value="\u5546\u673aid") Long opportunityId) {
        return ApiResponse.success((Object)this.opportunityService.getOpportunityDetail(opportunityId));
    }

    @GetMapping(value={"operate"})
    @ApiOperation(value="\u5224\u65ad\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u64cd\u4f5c\u6743\u9650", notes="\u5224\u65ad\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u64cd\u4f5c\u6743\u9650")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Integer> isOperate(@RequestParam(value="opportunityId") @ApiParam(value="\u5546\u673aid") Long opportunityId) {
        return ApiResponse.success((Object)this.opportunityService.isOperate(opportunityId));
    }

    @PostMapping(value={"/opportunityRepeatList"})
    @ApiOperation(value="\u6839\u636e\u5546\u673a\u540d\u79f0\u67e5\u627e\u91cd\u590d\u5546\u673a\u5217\u8868", notes="\u6839\u636e\u5546\u673a\u540d\u79f0\u67e5\u627e\u91cd\u590d\u5546\u673a\u5217\u8868")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OpportunityRepeatVO>> selectOpportunityRepeatList(@RequestBody @ApiParam(value="\u5546\u673adto") OpportunityDto dto) {
        return ApiResponse.success(this.opportunityService.selectOpportunityRepeatList(dto));
    }

    @PostMapping(value={"/opportunityCheckRepeat"})
    @ApiOperation(value="\u6839\u636e\u5546\u673a\u540d\u79f0\u67e5\u91cd", notes="\u6839\u636e\u5546\u673a\u540d\u79f0\u67e5\u91cd\uff0ctoastMsg \u6d88\u606f \uff0callowSaving \u662f\u5426\u5141\u8bb8\u4fdd\u5b58")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<CheckRepeat> opportunityCheckRepeat(@RequestBody @ApiParam(value="\u5546\u673adto") OpportunityDto dto) {
        return ApiResponse.success((Object)this.opportunityService.opportunityCheckRepeat(dto));
    }

    @PostMapping(value={"/selectRepeatOpportunityList"})
    @ApiOperation(value="\u7ebf\u7d22\u8f6c\u6362\u6839\u636e\u5ba2\u6237id\u67e5\u8be2\u5ba2\u6237\u4e0b\u7684\u5546\u673a", notes="\u7ebf\u7d22\u8f6c\u6362\u6839\u636e\u5ba2\u6237id\u67e5\u8be2\u5ba2\u6237\u4e0b\u7684\u5546\u673a")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OpportunityEntity>> selectRepeatOpportunityList(@RequestBody @ApiParam(value="\u5546\u673adto") OpportunityDto dto) {
        return ApiResponse.success(this.opportunityService.selectRepeatOpportunityList(dto));
    }

    @GetMapping(value={"/selectSuspectedOpportunityByCustomerName"})
    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u540d\u79f0\u67e5\u8be2\u7591\u4f3c\u5546\u673a")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<CheckRepeat> selectSuspectedOpportunityByCustomerName(@RequestParam(value="customerName") @ApiParam(value="\u5ba2\u6237\u540d\u79f0") String customerName) {
        return ApiResponse.success((Object)this.opportunityService.selectSuspectedOpportunityByCustomerName(customerName));
    }

    @GetMapping(value={"/selectSuspectedOpportunityByMobilePhone"})
    @ApiOperation(value="\u6839\u636e\u624b\u673a\u53f7\u67e5\u8be2\u7591\u4f3c\u5546\u673a")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<CheckRepeat> selectSuspectedOpportunityByTelephone(@RequestParam(value="mobilePhone") @ApiParam(value="\u624b\u673a\u53f7") String mobilePhone) {
        return ApiResponse.success((Object)this.opportunityService.selectSuspectedOpportunityByMobilePhone(mobilePhone));
    }

    @GetMapping(value={"/suspectedListByName"})
    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u540d\u79f0\u67e5\u8be2\u7591\u4f3c\u5546\u673a\u96c6\u5408")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<OpportunityRepeatVO>> suspectedOpportunityListByName(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @RequestParam(value="customerName") @ApiParam(value="\u5ba2\u6237\u540d\u79f0") String customerName) {
        return ApiResponse.success(this.opportunityService.suspectedOpportunityListByName(pageInfo, customerName));
    }

    @GetMapping(value={"/suspectedListByPhone"})
    @ApiOperation(value="\u6839\u636e\u624b\u673a\u53f7\u67e5\u8be2\u7591\u4f3c\u5546\u673a\u96c6\u5408")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<OpportunityRepeatVO>> suspectedOpportunityListByPhone(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @RequestParam(value="mobilePhone") @ApiParam(value="\u624b\u673a\u53f7") String mobilePhone) {
        return ApiResponse.success(this.opportunityService.suspectedOpportunityListByPhone(pageInfo, mobilePhone));
    }

    @PostMapping(value={"/associativeQuery"})
    @ApiOperation(value="\u5546\u673a\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6", notes="\u5546\u673a\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<AssociativeQueryVo>> associativeQuery(@RequestBody @ApiParam(value="\u5546\u673adto") OpportunityAssociativeQueryDto dto) {
        return ApiResponse.success(this.opportunityService.associativeQueryNew(dto));
    }

    @GetMapping(value={"/selectFollowCount"})
    @ApiOperation(value="\u6839\u636e\u8d1f\u8d23\u4ebaID\u67e5\u8be2\u5f85\u8ddf\u8fdb/\u8ddf\u8fdb\u4e2d\u5546\u673a\u6570\u91cf")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Long> selectFollowCount(@RequestParam(value="chargePersonId") @ApiParam(value="\u8d1f\u8d23\u4ebaId") Long chargePersonId) {
        return ApiResponse.success((Object)this.opportunityService.selectFollowCount(chargePersonId));
    }

    @PostMapping(value={"/improveOpportunity"})
    public ApiResponse<Boolean> improveOpportunity(@RequestBody ImproveOpportunityDto dto) {
        return ApiResponse.success((Object)this.improveOpportunityService.improveOpportunity(dto));
    }

    @PostMapping(value={"/createCustomerAndContact"})
    public ApiResponse<CustomerEntity> createCustomerAndContact(@RequestBody ImproveCreateCustomerDto dto) {
        return ApiResponse.success((Object)this.improveOpportunityService.improveCustomerContact(dto));
    }

    @PostMapping(value={"/createContact"})
    public ApiResponse<ContactEntity> createContact(@RequestBody ImproveCreateContactDto dto) {
        return ApiResponse.success((Object)this.improveOpportunityService.createContact(dto));
    }

    @PostMapping(value={"/opportunityDistribute"})
    public ApiResponse<TransferBatchResultVo> opportunityDistribute(@RequestBody List<OpportunityDto> dtos) {
        return ApiResponse.success((Object)this.opportunityService.opportunityDistributeBatch(dtos));
    }

    @PostMapping(value={"/opportunityChangeDeptBatch"})
    public ApiResponse<String> opportunityChangeDeptBatch(@RequestBody DeptChangeBatchDto dto) {
        return this.opportunityService.opportunityChangeDeptBatch(dto);
    }

    @PostMapping(value={"/selectOpportunityListByAgentId"})
    public ApiResponse<Page<OpportunityEntity>> selectOpportunityListByAgentId(@RequestBody OpportunityDto dto) {
        return this.opportunityService.selectOpportunityListByAgentId(dto);
    }

    @PostMapping(value={"/checkRecordContact"})
    public ApiResponse<Map<String, Object>> checkRecordContact(@RequestBody OpportunityDto dto) {
        return this.opportunityService.checkRecordContact(dto);
    }

    @GetMapping(value={"operateProcessState"})
    @ApiOperation(value="\u5224\u65ad\u5f53\u524d\u5546\u673a\u6d41\u7a0b\u662f\u5426\u6709\u64cd\u4f5c\u6743\u9650", notes="\u5224\u65ad\u5f53\u524d\u5546\u673a\u6d41\u7a0b\u662f\u5426\u6709\u64cd\u4f5c\u6743\u9650")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Map<String, Object>> isOperateProcessState(@RequestParam(value="opportunityId") @ApiParam(value="\u5546\u673aid") Long opportunityId) {
        return ApiResponse.success(this.opportunityService.isOperateProcessState(opportunityId));
    }

    @PostMapping(value={"updateLastTrackPerson"})
    @ApiOperation(value="\u66f4\u65b0\u6700\u65b0\u8ddf\u8fdb\u4eba", notes="\u66f4\u65b0\u6700\u65b0\u8ddf\u8fdb\u4eba")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> updateLastTrackPerson() {
        return ApiResponse.success((String)this.opportunityService.updateLastTrackPerson());
    }

    @PostMapping(value={"/opportunityChangeDeptByChargePersonBatch"})
    @ApiOperation(value="\u5546\u673a\u6279\u91cf\u53d8\u66f4\u6240\u5c5e\u90e8\u95e8\u4e3a\u8d1f\u8d23\u4eba\u6240\u5c5e\u90e8\u95e8", notes="\u5546\u673a\u6279\u91cf\u53d8\u66f4\u6240\u5c5e\u90e8\u95e8\u4e3a\u8d1f\u8d23\u4eba\u6240\u5c5e\u90e8\u95e8")
    public ApiResponse<String> opportunityChangeDeptByChargePersonBatch(@RequestBody DeptChangeBatchDto dto) {
        return this.opportunityService.opportunityChangeDeptByChargePersonBatch(dto);
    }

    @PostMapping(value={"/edit"})
    @ApiOperation(value="\u5546\u673a\u9636\u6bb5\u63a8\u8fdb\u524d\u4fe1\u606f\u4fdd\u5b58", notes="\u5546\u673a\u9636\u6bb5\u63a8\u8fdb\u524d\u4fe1\u606f\u4fdd\u5b58")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Object> editOpportunity(@RequestBody Map<String, Object> map) {
        return this.opportunityService.editOpportunity(map);
    }

    @PostMapping(value={"/changeOpportunityStage"})
    @ApiOperation(value="\u5546\u673a\u9636\u6bb5\u63a8\u8fdb", notes="\u5546\u673a\u9636\u6bb5\u63a8\u8fdb")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> changeOpportunityStage(@RequestBody ChangeOpportunityStageDto dto) {
        return this.opportunityService.changeOpportunityStage(dto);
    }

    @PostMapping(value={"/changeOpportunityStageWin"})
    @ApiOperation(value="\u5546\u673a\u9636\u6bb5\u63a8\u8fdb-\u6210\u529f", notes="\u5546\u673a\u9636\u6bb5\u63a8\u8fdb-\u6210\u529f")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> changeOpportunityStageWin(@RequestBody ChangeOpportunityStageDto dto) {
        return this.opportunityService.changeOpportunityStageWin(dto);
    }

    @PostMapping(value={"/changeOpportunityStageLose"})
    @ApiOperation(value="\u5546\u673a\u9636\u6bb5\u63a8\u8fdb-\u5931\u8d25", notes="\u5546\u673a\u9636\u6bb5\u63a8\u8fdb-\u5931\u8d25")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u5546\u673a\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> changeOpportunityStageLose(@RequestBody ChangeOpportunityStageDto dto) {
        return this.opportunityService.changeOpportunityStageLose(dto);
    }

    @PostMapping(value={"/opportunityPend"})
    @ApiOperation(value="\u6302\u8d77\u5546\u673a", notes="\u6302\u8d77\u5546\u673a")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u6302\u8d77\u5546\u673a", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> opportunityPend(@RequestBody @ApiParam(value="\u5546\u673adto") OpportunityDto dto) {
        return ApiResponse.success((String)this.opportunityService.opportunityPend(dto));
    }

    @PostMapping(value={"/opportunityActivate"})
    @ApiOperation(value="\u6fc0\u6d3b\u5546\u673a", notes="\u6fc0\u6d3b\u5546\u673a")
    @AuditLog(moduleName="\u5546\u673a\u7ba1\u7406", eventDesc="\u6fc0\u6d3b\u5546\u673a", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> opportunityActivate(@RequestBody @ApiParam(value="\u5546\u673adto") OpportunityDto dto) {
        return ApiResponse.success((String)this.opportunityService.opportunityActivate(dto));
    }
}

