/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.job.service.impl;

import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.job.dao.SyncOrganAndUserMapper;
import com.jxdinfo.crm.core.job.model.SyncSysStru;
import com.jxdinfo.crm.core.job.service.SyncOrgAndUserService;
import com.jxdinfo.crm.core.job.util.JDBCUtil;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.DateTimeUtil;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.workflow.task.datasync.config.SnowflakeIDGenerator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SyncOrgAndUserServiceImpl
implements SyncOrgAndUserService {
    private static Logger log = LogManager.getLogger(SyncOrgAndUserServiceImpl.class);
    @Resource
    private ISysOrganService organService;
    @Resource
    private ISysStruService struService;
    @Resource
    private ISysUsersService usersService;
    @Resource
    private SyncOrganAndUserMapper organAndUserMapper;
    @Autowired
    private SnowflakeIDGenerator idGenerator;
    @Resource
    private ISysUserRoleService sysUserRoleService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ProcessResult saveOrUpdateOrgAndUser() throws SQLException {
        log.info("\u540c\u6b65\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)DateUtil.formatDateTime((Date)new Date()));
        try (Connection conn = JDBCUtil.getConnection();){
            Map<String, Map<String, Object>> deptMap = this.getSyncOrg(conn);
            Map<String, Map<String, Object>> userMap = this.getSyncUser(conn);
            Map<String, Long> userIdMap = this.getLongIdMap(userMap);
            Map<String, Long> deptIdMap = this.getLongIdMap(deptMap);
            List<SyncSysStru> oldStruList = this.organAndUserMapper.getStruList(2);
            HashMap struUpdateMap = new HashMap();
            for (SyncSysStru stru : oldStruList) {
                if (!StringUtil.isNotBlank((CharSequence)stru.getStruId()) || !deptIdMap.containsKey(stru.getStruId())) continue;
                deptIdMap.put(stru.getStruId(), stru.getId());
                struUpdateMap.put(stru.getStruId(), null);
            }
            List oldUserList = this.usersService.list();
            HashMap userUpdateMap = new HashMap();
            for (SysUsers user : oldUserList) {
                if (!StringUtil.isNotBlank((CharSequence)user.getChar1()) || !userIdMap.containsKey(user.getChar1())) continue;
                userIdMap.put(user.getChar1(), user.getId());
                userUpdateMap.put(user.getChar1(), null);
            }
            ArrayList<SysOrgan> insertOrganList = new ArrayList<SysOrgan>();
            ArrayList<SysOrgan> updateOrganList = new ArrayList<SysOrgan>();
            ArrayList<Map<String, Object>> insertStruList = new ArrayList<Map<String, Object>>();
            ArrayList<SysStru> updateStruList = new ArrayList<SysStru>();
            for (Map.Entry<String, Map<String, Object>> dept : deptMap.entrySet()) {
                if (struUpdateMap.containsKey(dept.getKey()) && !dept.getKey().equals("5AA3D70B-14F9-4A44-8652-3C29DACB70DE")) {
                    updateOrganList.add(this.getUpdateOrganFromDept(dept.getValue(), deptIdMap));
                    updateStruList.add(this.getUpdateStruFromDept(dept.getValue(), deptIdMap));
                    continue;
                }
                if (dept.getKey().equals("5AA3D70B-14F9-4A44-8652-3C29DACB70DE")) continue;
                insertOrganList.add(this.getInsertOrganFromDept(dept.getValue(), deptIdMap));
                insertStruList.add(this.getInsertStruFromDept(dept.getValue(), deptIdMap));
            }
            ArrayList<SysUsers> insertUserList = new ArrayList<SysUsers>();
            ArrayList<SysUsers> updateUserList = new ArrayList<SysUsers>();
            for (Map.Entry<String, Map<String, Object>> user : userMap.entrySet()) {
                if (userUpdateMap.containsKey(user.getKey())) {
                    updateStruList.add(this.getUpdateStruFromUser(user.getValue(), userIdMap, deptIdMap));
                    updateUserList.add(this.getUpdateUserFromUser(user.getValue(), userIdMap, deptIdMap));
                    continue;
                }
                insertOrganList.add(this.getInsertOrgFromUser(user.getValue(), userIdMap, deptIdMap));
                insertStruList.add(this.getInsertStruFromUser(user.getValue(), userIdMap, deptIdMap));
                insertUserList.add(this.getInsertUserFromUser(user.getValue(), userIdMap, deptIdMap));
            }
            if (insertStruList.size() > 0) {
                this.organAndUserMapper.insertSysStru(insertStruList);
            }
            this.struService.saveOrUpdateBatch(updateStruList);
            updateOrganList.addAll(insertOrganList);
            this.organService.saveOrUpdateBatch(updateOrganList);
            updateUserList.addAll(insertUserList);
            this.usersService.saveOrUpdateBatch(updateUserList);
            if (insertUserList.size() > 0) {
                List<SysUserRole> userRoles = this.getInsertUserRole(insertUserList);
                this.sysUserRoleService.saveBatch(userRoles);
            }
            DataPermission.setStruCache();
            DataPermission.setStruCacheCopy();
            DataPermission.setLeadershipRoles();
            DataPermission.setLeadershipBGList();
            this.organAndUserMapper.updateLeaveDeptStatus();
            log.info("\u540c\u6b65\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)DateUtil.formatDateTime((Date)new Date()));
            String cacheKey = "hussarOrganizationJob";
            try {
                Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)cacheKey);
                if (flag != null) {
                    log.error("\u4e0a\u4e00\u6b21\u5237\u65b0\u7ec4\u7ec7\u673a\u6784\u8fd8\u672a\u6267\u884c\u5b8c\u6bd5\uff01");
                    throw new BaseException("\u4e0a\u4e00\u6b21\u5237\u65b0\u7ec4\u7ec7\u673a\u6784\u8fd8\u672a\u6267\u884c\u5b8c\u6bd5\uff01");
                }
                HussarCacheUtil.put((String)"refresh_organ", (Object)cacheKey, (Object)"hussarOrganizationJob");
                ((IHussarBaseOrganizationService)SpringContextHolder.getBean(IHussarBaseOrganizationService.class)).refreshOrgan();
            }
            catch (Exception var7) {
                log.error("\u5237\u65b0\u7ec4\u7ec7\u673a\u6784\u51fa\u9519", (Throwable)var7);
                throw var7;
            }
            finally {
                HussarCacheUtil.evict((String)"refresh_organ", (Object)cacheKey);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return new ProcessResult(false, e.getMessage());
        }
        return new ProcessResult(true);
    }

    private SysOrgan getUpdateOrganFromDept(Map<String, Object> deptMap, Map<String, Long> deptIdMap) {
        SysOrgan sysOrgan = new SysOrgan();
        sysOrgan.setId(deptIdMap.get(deptMap.get("orgId").toString()));
        sysOrgan.setOrganCode(deptMap.get("orgCode").toString());
        sysOrgan.setOrganName(deptMap.get("orgName").toString());
        sysOrgan.setBeginDate(deptMap.get("beginDate") == null ? "2022-01-01" : deptMap.get("beginDate").toString().substring(0, 10));
        sysOrgan.setEndDate(deptMap.get("endDate") == null ? "2032-01-01" : deptMap.get("endDate").toString().substring(0, 10));
        sysOrgan.setShortName(deptMap.get("shortName") == null ? "" : deptMap.get("shortName").toString());
        return sysOrgan;
    }

    private SysOrgan getInsertOrganFromDept(Map<String, Object> deptMap, Map<String, Long> deptIdMap) {
        SysOrgan sysOrgan = new SysOrgan();
        sysOrgan.setId(deptIdMap.get(deptMap.get("orgId").toString()));
        sysOrgan.setOrganCode(deptMap.get("orgCode").toString());
        sysOrgan.setOrganName(deptMap.get("orgName").toString());
        sysOrgan.setOrganType("2");
        sysOrgan.setBeginDate(deptMap.get("beginDate") == null ? "2022-01-01" : deptMap.get("beginDate").toString().substring(0, 10));
        sysOrgan.setEndDate(deptMap.get("endDate") == null ? "2032-01-01" : deptMap.get("endDate").toString().substring(0, 10));
        sysOrgan.setShortName(deptMap.get("shortName") == null ? "" : deptMap.get("shortName").toString());
        sysOrgan.setDelFlag("0");
        sysOrgan.setCreateTime(DateTimeUtil.parseDateTime((String)deptMap.get("createTime").toString()));
        return sysOrgan;
    }

    private SysStru getUpdateStruFromDept(Map<String, Object> deptMap, Map<String, Long> deptIdMap) {
        SysStru sysStru = new SysStru();
        sysStru.setId(deptIdMap.get(deptMap.get("orgId").toString()));
        sysStru.setOrganAlias(deptMap.get("orgName").toString());
        sysStru.setParentId(deptIdMap.get(deptMap.get("parentId").toString()));
        return sysStru;
    }

    private Map<String, Object> getInsertStruFromDept(Map<String, Object> deptMap, Map<String, Long> deptIdMap) {
        Map<String, Object> map = deptMap;
        map.put("isEmployee", "0");
        map.put("struType", "2");
        map.put("idLong", deptIdMap.get(deptMap.get("orgId").toString()));
        map.put("parentLong", deptMap.get("parentId") == null ? 11L : deptIdMap.get(deptMap.get("parentId").toString()));
        map.put("struLevel", 2);
        map.put("positionid", "");
        return map;
    }

    private SysOrgan getUpdateOrgFromUser(Map<String, Object> userMap, Map<String, Long> userIdMap, Map<String, Long> deptIdMap) {
        SysOrgan sysOrgan = new SysOrgan();
        sysOrgan.setId(userIdMap.get(userMap.get("userid").toString()));
        sysOrgan.setOrganName(userMap.get("orgName").toString());
        return sysOrgan;
    }

    private SysOrgan getInsertOrgFromUser(Map<String, Object> userMap, Map<String, Long> userIdMap, Map<String, Long> deptIdMap) {
        SysOrgan sysOrgan = new SysOrgan();
        sysOrgan.setId(userIdMap.get(userMap.get("userid").toString()));
        sysOrgan.setOrganName(userMap.get("username").toString());
        sysOrgan.setOrganType("9");
        sysOrgan.setBeginDate(userMap.get("starttime") == null ? "2022-01-01" : userMap.get("starttime").toString().substring(0, 10));
        sysOrgan.setEndDate(userMap.get("endtime") == null ? "2032-01-01" : userMap.get("endtime").toString().substring(0, 10));
        sysOrgan.setDelFlag("0");
        sysOrgan.setCreateTime(DateTimeUtil.parseDateTime((String)userMap.get("createdate").toString().substring(0, 19)));
        return sysOrgan;
    }

    private SysStru getUpdateStruFromUser(Map<String, Object> userMap, Map<String, Long> userIdMap, Map<String, Long> deptIdMap) {
        SysStru sysStru = new SysStru();
        sysStru.setId(userIdMap.get(userMap.get("userid").toString()));
        sysStru.setOrganAlias(userMap.get("username").toString());
        sysStru.setParentId(deptIdMap.get(userMap.get("deptid").toString()));
        sysStru.setStruOrder(Integer.valueOf(userMap.get("showOrder").toString()));
        sysStru.setStaffPosition(userMap.get("positionid").toString());
        return sysStru;
    }

    private Map<String, Object> getInsertStruFromUser(Map<String, Object> userMap, Map<String, Long> userIdMap, Map<String, Long> deptIdMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orgId", userMap.get("userid"));
        map.put("orgName", userMap.get("username"));
        map.put("createTime", DateTimeUtil.parseDateTime((String)(userMap.get("createdate").toString().length() < 19 ? userMap.get("createdate").toString() + " 00:00:00" : userMap.get("createdate").toString().substring(0, 19))));
        map.put("showOrder", userMap.get("showOrder"));
        map.put("positionid", userMap.get("positionid"));
        map.put("beginDate", userMap.get("starttime"));
        map.put("endDate", userMap.get("endtime"));
        map.put("isEmployee", "1");
        map.put("struType", "9");
        map.put("idLong", userIdMap.get(userMap.get("userid").toString()));
        map.put("parentLong", deptIdMap.get(userMap.get("deptid").toString()));
        map.put("struLevel", 4);
        return map;
    }

    private SysUsers getUpdateUserFromUser(Map<String, Object> userMap, Map<String, Long> userIdMap, Map<String, Long> deptIdMap) {
        SysUsers sysUsers = new SysUsers();
        sysUsers.setId(userIdMap.get(userMap.get("userid").toString()));
        sysUsers.setDepartmentId(deptIdMap.get(userMap.get("deptid").toString()));
        sysUsers.setCorporationId(deptIdMap.get(userMap.get("deptid").toString()));
        sysUsers.seteMail(userMap.get("email").toString());
        sysUsers.setTelephone(userMap.get("phone").toString());
        sysUsers.setMobile(userMap.get("phone").toString());
        sysUsers.setPassword(userMap.get("passwd").toString());
        sysUsers.setUserAccount(userMap.get("username").toString());
        sysUsers.setUserName(userMap.get("username").toString());
        sysUsers.setUserOrder(Integer.valueOf(userMap.get("showOrder").toString()));
        return sysUsers;
    }

    private SysUsers getInsertUserFromUser(Map<String, Object> userMap, Map<String, Long> userIdMap, Map<String, Long> deptIdMap) {
        SysUsers sysUsers = new SysUsers();
        sysUsers.setId(userIdMap.get(userMap.get("userid").toString()));
        sysUsers.setDepartmentId(deptIdMap.get(userMap.get("deptid").toString()));
        sysUsers.setCorporationId(deptIdMap.get(userMap.get("deptid").toString()));
        sysUsers.seteMail(userMap.get("email").toString());
        sysUsers.setTelephone(userMap.get("phone").toString());
        sysUsers.setMobile(userMap.get("phone").toString());
        sysUsers.setPassword(userMap.get("passwd").toString());
        if (StringUtil.isNotBlank((CharSequence)userMap.get("starttime").toString())) {
            sysUsers.setStartTime(DateTimeUtil.parseDateTime((String)(userMap.get("starttime").toString().length() < 19 ? userMap.get("starttime").toString() + " 00:00:00" : userMap.get("starttime").toString().substring(0, 19))));
        }
        sysUsers.setUserAccount(userMap.get("username").toString());
        sysUsers.setUserName(userMap.get("username").toString());
        sysUsers.setUserOrder(Integer.valueOf(userMap.get("showOrder").toString()));
        sysUsers.setCreateTime(DateTimeUtil.parseDateTime((String)(userMap.get("createdate").toString().length() < 19 ? userMap.get("createdate").toString() + " 00:00:00" : userMap.get("createdate").toString().substring(0, 19))));
        sysUsers.setChar1(userMap.get("userid").toString());
        sysUsers.setAccountStatus("1");
        sysUsers.setIsSys("0");
        sysUsers.setEmployeeId(userIdMap.get(userMap.get("userid").toString()));
        sysUsers.setLoginTimeLimit("0");
        sysUsers.setLoginIpLimit("0");
        sysUsers.setIsCpublic("0");
        sysUsers.setMaxSessions(Integer.valueOf("-1"));
        sysUsers.setTypeProperty("1");
        return sysUsers;
    }

    private List<SysUserRole> getInsertUserRole(List<SysUsers> usersList) {
        ArrayList<SysUserRole> userRoles = new ArrayList<SysUserRole>();
        for (SysUsers user : usersList) {
            SysUserRole userRole = new SysUserRole();
            userRole.setAdminOption("1");
            userRole.setUserId(user.getId());
            userRole.setGrantedRole(Long.valueOf(1450785135866925064L));
            userRoles.add(userRole);
        }
        return userRoles;
    }

    private Map<String, Long> getLongIdMap(Map<String, Map<String, Object>> map) {
        HashMap<String, Long> idMap = new HashMap<String, Long>();
        if (map != null && map.size() > 0) {
            for (String key : map.keySet()) {
                idMap.put(key, Long.valueOf(this.idGenerator.getNextId()));
            }
        }
        return idMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, Object>> getSyncOrg(Connection conn) throws SQLException {
        String querySql = this.getOrgSql();
        PreparedStatement psSelectNewUser = conn.prepareStatement(querySql);
        ResultSet deptRs = psSelectNewUser.executeQuery();
        HashMap<String, Map<String, Object>> orgMap = new HashMap<String, Map<String, Object>>();
        try {
            while (deptRs.next()) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                String orgId = deptRs.getString("ORGANISEID");
                resultMap.put("orgId", orgId);
                resultMap.put("orgName", deptRs.getString("ORGANISENAME"));
                resultMap.put("parentId", deptRs.getString("PREORGANISEID"));
                resultMap.put("orgCode", deptRs.getString("ORGANISELEVEL"));
                resultMap.put("orgType", deptRs.getInt("ORGANISETYPE"));
                resultMap.put("createTime", deptRs.getString("CREATEDATE"));
                resultMap.put("showOrder", deptRs.getInt("SHOWORDER"));
                resultMap.put("shortName", deptRs.getString("SHORTNAME"));
                resultMap.put("cnShortName", deptRs.getString("CNSHORTNAME"));
                resultMap.put("beginDate", deptRs.getString("STARTTIME"));
                resultMap.put("endDate", deptRs.getString("ENDTIME"));
                orgMap.put(orgId, resultMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            psSelectNewUser.close();
        }
        return orgMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, Object>> getSyncUser(Connection conn) throws SQLException {
        String querySql = this.getUserSql();
        PreparedStatement psSelectNewUser = conn.prepareStatement(querySql);
        HashMap<String, Map<String, Object>> userMap = new HashMap<String, Map<String, Object>>();
        try (ResultSet userRs = psSelectNewUser.executeQuery();){
            while (userRs.next()) {
                if (userRs.getString("str") == null) continue;
                String userId = userRs.getString("userId");
                String info = userRs.getString("str").replace(",", "','");
                info = info.replace("|", "");
                String[] infoArr = (info = info.replace("&", "")).split(",");
                if (infoArr.length <= 0) continue;
                HashMap<String, String> insertMap = new HashMap<String, String>();
                insertMap.put("userid", infoArr[2] == null ? "" : infoArr[2].replaceAll("'", ""));
                insertMap.put("username", infoArr[1] == null ? "" : infoArr[1].replaceAll("'", ""));
                insertMap.put("email", infoArr[3] == null ? "" : infoArr[3].replaceAll("'", ""));
                String createdate = infoArr[4] == null ? "" : infoArr[4].replaceAll("'", "");
                insertMap.put("createdate", "".equals(createdate) ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) : infoArr[4].replaceAll("'", ""));
                insertMap.put("starttime", "2000-01-01");
                insertMap.put("endtime", "9999-12-31");
                insertMap.put("phone", infoArr[6] == null ? "" : infoArr[6].replaceAll("'", ""));
                insertMap.put("deptid", infoArr[7] == null ? "" : infoArr[7].replaceAll("'", ""));
                insertMap.put("jobnum", infoArr[10] == null ? "" : infoArr[10].replaceAll("'", ""));
                insertMap.put("positionid", infoArr[12] == null ? "" : infoArr[12].replaceAll("'", ""));
                insertMap.put("positionname", infoArr[11] == null ? "" : infoArr[11].replaceAll("'", ""));
                insertMap.put("passwd", infoArr[13] == null ? "" : infoArr[13].replaceAll("'", ""));
                insertMap.put("showOrder", infoArr[14] == null ? "" : infoArr[14].replaceAll("'", ""));
                userMap.put(userId, insertMap);
            }
        }
        return userMap;
    }

    private String getOrgSql() {
        return " select o.ORGANISEID,o.ORGANISENAME,o.ORGANISEKINDID,o.ORGANISELEVEL,o.PREORGANISEID,o.ORGANISETYPE,o.CREATEUSERID,o.CREATEDATE,o.DATASTATUSID,o.SHOWORDER,o.SHORTNAME,o.STARTTIME,o.ENDTIME,o.CNSHORTNAME,o.UPDATE_TIME,o.ORGANISEADMINTYPE from jxd7_xt_organise o where (o.DATASTATUSID = 1 and ORGANISETYPE != 1) or o.ORGANISEID = '5AA3D70B-14F9-4A44-8652-3C29DACB70DE'";
    }

    private String getUserSql() {
        return "select c.SHEETID as userId, CONCAT_WS(',', ifnull(c.XM,''),+ifnull(c.XM,''), +c.SHEETID, +ifnull(c.YX,''), +ifnull(c.CREATEDATE,''), +ifnull(c.CREATEDATE,''), +ifnull(c.SJ,''), +ifnull(c.SZBM,''),+ifnull(o.ORGANISENAME,''), +ifnull(c.XMSZM,''), +c.GH,+ifnull(r.ZWMC,''), +ifnull(r.SHEETID,''), +ifnull(j.PASSWD,''), +ifnull(j.SHOWORDER,'')) as str from cbhs_rygl_ryxxxx c left JOIN JXD7_XT_USER j on c.SHEETID=j.USERID left JOIN JXD7_XT_ORGANISE o on c.SZBM=o.ORGANISEID left JOIN CBHS_RYGL_RYZW r on r.SHEETID=c.ZC  where (((c.sflz != '\u662f' or c.sflz is null) and c.szbm <> '9DD212BE-9EAE-A807-48CC-7938DFB84388') or c.lzsj > '2022-07-01')  and c.gh!='JXD-00000' order by c.GH desc";
    }
}

