/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.eim.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.eim.dto.EimResponse;
import com.jxdinfo.crm.core.eim.model.AdRecordEntity;
import com.jxdinfo.crm.core.eim.service.AdRecordService;
import com.jxdinfo.crm.core.eim.service.AdService;
import com.jxdinfo.crm.core.eim.vo.AdVo;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AdserviceImpl
implements AdService {
    @Resource
    private AdRecordService adRecordService;
    @Resource
    private CrmCommonProperties crmProperties;

    @Override
    public List<AdVo> getAdList(String clientType) {
        if (!this.crmProperties.getEim().isAd()) {
            return new ArrayList<AdVo>();
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        long count = this.adRecordService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarBaseEntity::getCreator, (Object)user.getId())).eq(AdRecordEntity::getClientType, (Object)clientType)).ge(HussarBaseEntity::getCreateTime, (Object)(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd") + " 00:00:00")));
        if (count > 0L) {
            return new ArrayList<AdVo>();
        }
        String postionId = "";
        if ("0".equals(clientType)) {
            postionId = "46E44071-DBDF-489B-BDA7-4C285AE82E18";
        } else if ("1".equals(clientType)) {
            postionId = "B159DCCD-9CB2-41DE-80B6-04C039F02ACE";
        }
        if (StringUtil.isEmpty((Object)postionId)) {
            return new ArrayList<AdVo>();
        }
        try {
            String result = HttpUtil.get((String)(this.crmProperties.getEim().getEimUrl() + "/ad/v1/ad/position" + "/" + postionId));
            EimResponse eimResponse = (EimResponse)JSONObject.parseObject((String)result, (TypeReference)new TypeReference<EimResponse<List<AdVo>>>(){}, (Feature[])new Feature[0]);
            if (CollectionUtil.isNotEmpty((Collection)((Collection)eimResponse.getData()))) {
                List list = (List)eimResponse.getData();
                for (AdVo adVo : list) {
                    adVo.setImageURL(this.crmProperties.getEim().getEimUrl() + "/file/v1" + "/" + adVo.getAdID());
                }
                return list;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ArrayList<AdVo>();
    }

    @Override
    public Boolean setTodayNoShow(String clientType) {
        AdRecordEntity adRecordEntity = new AdRecordEntity();
        adRecordEntity.setClientType(clientType);
        return this.adRecordService.save((Object)adRecordEntity);
    }
}

