/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.chanpinguanli.datasourcefolder.product5.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.chanpinguanli.datasourcefolder.product5.dao.Product5Mapper;
import com.jxdinfo.crm.core.chanpinguanli.datasourcefolder.product5.model.CrmProduct1Master;
import com.jxdinfo.crm.core.chanpinguanli.datasourcefolder.product5.model.Product5;
import com.jxdinfo.crm.core.chanpinguanli.datasourcefolder.product5.service.CrmProdouctPrice2Service;
import com.jxdinfo.crm.core.chanpinguanli.datasourcefolder.product5.service.CrmProduct1MasterService;
import com.jxdinfo.crm.core.chanpinguanli.datasourcefolder.product5.service.Product5Service;
import com.jxdinfo.crm.core.docbase.service.DocbaseService;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.product.model.ProductTargetProfileEntity;
import com.jxdinfo.crm.product.model.SpecificationEntity;
import com.jxdinfo.crm.product.model.SpecificationTypeEntity;
import com.jxdinfo.crm.product.service.IProductTargetProfileService;
import com.jxdinfo.crm.product.service.ISpecificationService;
import com.jxdinfo.crm.product.service.ISpecificationTypeService;
import com.jxdinfo.crm.product.service.ISpecificationTypeValueService;
import com.jxdinfo.crm.transaction.api.dto.ProductSpecification;
import com.jxdinfo.crm.transaction.api.dto.StandardPriceListProductsDto;
import com.jxdinfo.crm.transaction.api.service.StandardPriceListProductsService;
import com.jxdinfo.hussar.code.plus.dto.CodePlusDto;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="chanpinguanli.datasourcefolder.product5.Product5ServiceImpl")
@HussarDs(value="master")
public class Product5ServiceImpl
implements Product5Service {
    private static final Logger logger = LoggerFactory.getLogger(Product5ServiceImpl.class);
    private static final String RETURN_CODE = "0";
    @Autowired
    private CrmProduct1MasterService crmProduct1MasterService;
    @Autowired
    private Product5Mapper product5Mapper;
    @Autowired
    private CrmProdouctPrice2Service crmProdouctPrice2Service;
    @Resource
    private DocbaseService docbaseService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private ISpecificationTypeService specificationTypeService;
    @Resource
    private ISpecificationService specificationService;
    @Resource
    private IProductTargetProfileService productTargetProfileService;
    @Resource
    private ISysCodeRuleService sysCodeRuleRefService;
    @Resource
    private ISpecificationTypeValueService specificationTypeValueService;
    @Resource
    private StandardPriceListProductsService standardPriceListProductsService;

    @Override
    @DSTransactional
    public ApiResponse<String> insertOrUpdate(Product5 product5) {
        try {
            List<ProductTargetProfileEntity> profileEntityList;
            LocalDateTime date = LocalDateTime.now();
            CrmProduct1Master crmProduct1Master = product5.gainCrmProduct1Master();
            SecurityUser user = BaseSecurityUtil.getUser();
            if (this.crmProperties.getDocbase().isDocbaseEnable()) {
                JSONObject tokenObject = this.docbaseService.getToken(user.getUserName(), user.getUserName());
                String accessToken = "";
                if (tokenObject.get((Object)"code").equals("1")) {
                    accessToken = JSONObject.parseObject((String)tokenObject.get((Object)"result").toString()).get((Object)"accessToken").toString();
                }
                JSONObject resultObject = this.docbaseService.addFolder(user.getUserName(), user.getUserName(), accessToken, product5.getProductName(), this.crmProperties.getDocbase().getProductDataFolderId());
                String folderId = "";
                if (ToolUtil.isNotEmpty((Object)resultObject)) {
                    folderId = JSONObject.parseObject((String)resultObject.get((Object)"result").toString()).get((Object)"folderId").toString();
                    crmProduct1Master.setFolderId(folderId);
                }
                if (ToolUtil.isEmpty((Object)folderId)) {
                    throw new BaseException("\u6587\u5e93\u521b\u5efa\u76ee\u5f55\u5931\u8d25");
                }
            }
            crmProduct1Master.setCreateDepartment(user.getDeptId());
            crmProduct1Master.setCreateDepartmentName(user.getDeptName());
            crmProduct1Master.setIsSubsidy(RETURN_CODE);
            CodePlusDto codePlusDto1 = new CodePlusDto();
            codePlusDto1.setRuleCode("CRM_PRODUCT_ORDER_CODE");
            String productOrderCodeStr = this.sysCodeRuleRefService.getCurrentCodeByCache(codePlusDto1);
            int productOrderCodeInt = Integer.parseInt(productOrderCodeStr);
            crmProduct1Master.setOrderNumber(productOrderCodeInt);
            this.crmProduct1MasterService.saveOrUpdate(crmProduct1Master);
            StandardPriceListProductsDto standardPriceListProductsDto = new StandardPriceListProductsDto();
            standardPriceListProductsDto.setProductId(crmProduct1Master.getProductId());
            standardPriceListProductsDto.setProductName(crmProduct1Master.getProductName());
            standardPriceListProductsDto.setStandardPrice(BigDecimal.valueOf(crmProduct1Master.getProductPrice()));
            if ("1".equals(product5.getSpecificationSwitch())) {
                List<SpecificationTypeEntity> specificationTypeEntityList = product5.getSpecificationTypeList();
                List<SpecificationEntity> specificationEntityList = product5.getSpecificationList();
                if (CollectionUtil.isNotEmpty(specificationTypeEntityList)) {
                    specificationTypeEntityList.forEach(entity -> entity.createInit(crmProduct1Master.getProductId(), user, date));
                    this.specificationTypeService.saveBatch(specificationTypeEntityList);
                    ArrayList typeValueEntities = new ArrayList();
                    for (SpecificationTypeEntity st : specificationTypeEntityList) {
                        if (!CollectionUtil.isNotEmpty((Collection)st.getValueList())) continue;
                        List tempList = st.getValueList();
                        tempList.forEach(specificationTypeValueEntity -> {
                            specificationTypeValueEntity.setCreator(user.getUserId());
                            specificationTypeValueEntity.setCreatorName(user.getUserName());
                            specificationTypeValueEntity.setCreateTime(date);
                            specificationTypeValueEntity.setLastTime(date);
                            specificationTypeValueEntity.setLastEditor(user.getUserId());
                            specificationTypeValueEntity.setLastEditorName(user.getUserName());
                            specificationTypeValueEntity.setSpecificationTypeId(st.getSpecificationTypeId());
                            specificationTypeValueEntity.setProductId(crmProduct1Master.getProductId());
                        });
                        typeValueEntities.addAll(tempList);
                    }
                    if (CollectionUtil.isNotEmpty(typeValueEntities)) {
                        this.specificationTypeValueService.saveBatch(typeValueEntities);
                    }
                    specificationEntityList.forEach(entity -> {
                        entity.createInit(crmProduct1Master.getProductId(), user, date);
                        CodePlusDto codePlusDto = new CodePlusDto();
                        codePlusDto.setRuleCode("CRM_PRODUCT_SPEC_NUMBER");
                        String currentCode = this.sysCodeRuleRefService.getCurrentCodeByCache(codePlusDto);
                        entity.setSpecificationNumber(currentCode);
                    });
                    this.specificationService.saveBatch(specificationEntityList);
                    ArrayList<ProductSpecification> productSpecificationList = new ArrayList<ProductSpecification>();
                    for (SpecificationEntity specificationEntity : specificationEntityList) {
                        ProductSpecification productSpecification = new ProductSpecification();
                        productSpecification.setSpecId(specificationEntity.getSpecificationId());
                        productSpecification.setSpecName(specificationEntity.getSpecificationName());
                        productSpecification.setStandardPrice(specificationEntity.getPrice());
                        productSpecificationList.add(productSpecification);
                    }
                    standardPriceListProductsDto.setProductSpecifications(productSpecificationList);
                }
            }
            this.standardPriceListProductsService.addProducts(standardPriceListProductsDto);
            if ("1".equals(product5.getTargetProfileSwitch()) && CollectionUtil.isNotEmpty(profileEntityList = product5.getProductTargetProfileList())) {
                profileEntityList.forEach(entity -> entity.createInit(crmProduct1Master.getProductId(), user, date));
                this.productTargetProfileService.saveBatch(profileEntityList);
            }
            this.teamMeberService.insertTeamMember(crmProduct1Master.getProductManagerName(), crmProduct1Master.getProductManager(), crmProduct1Master.getProductId(), "1", "1", date, "10");
            return ApiResponse.success((Object)String.valueOf(crmProduct1Master.getProductId()), (String)"");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u65b0\u589e\u6216\u4fee\u6539\u5931\u8d25");
        }
    }

    @Override
    public ApiResponse<Product5> formQuery(String id) {
        try {
            return ApiResponse.success((Object)this.product5Mapper.formQuery(id));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u8868\u5355\u67e5\u8be2\u5931\u8d25");
        }
    }
}

