/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.product.service.Impl;

import com.jxdinfo.crm.core.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.core.associativeQuery.queryEnum.AssociativeQueryEnum;
import com.jxdinfo.crm.core.associativeQuery.service.AssociativeFiledQueryService;
import com.jxdinfo.crm.core.common.vo.AssociativeQueryVo;
import com.jxdinfo.crm.core.product.dto.ProductAssociativeQueryDto;
import com.jxdinfo.crm.core.product.dto.PruductDto;
import com.jxdinfo.crm.core.product.service.IProductAssociativeQueryService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ProductAssociativeQueryServiceImpl
implements IProductAssociativeQueryService {
    @Resource
    private AssociativeFiledQueryService associativeFiledQueryService;

    @Override
    public List<AssociativeQueryVo> getAssociativeQueryVo(String keyword, AssociativeQueryDto associativeQueryDto, Map<String, List<String>> excludeInfoMap) {
        ArrayList<AssociativeQueryVo> associativeQueryVoList = new ArrayList<AssociativeQueryVo>();
        ProductAssociativeQueryDto productAssociativeQueryDto = null;
        if (associativeQueryDto instanceof ProductAssociativeQueryDto) {
            productAssociativeQueryDto = (ProductAssociativeQueryDto)associativeQueryDto;
        }
        assert (productAssociativeQueryDto != null);
        PruductDto productDto = productAssociativeQueryDto.getDto();
        List<String> ownDepartmentList = null;
        List<String> chargePersonIdList = null;
        List<String> productTypes = null;
        if (productDto != null) {
            ownDepartmentList = productDto.getOwnDepartments();
            chargePersonIdList = productDto.getChargePersonIds();
            productTypes = productDto.getProductTypes();
        }
        List<String> selectedProductTypes = excludeInfoMap.get("selectedProductTypes");
        selectedProductTypes = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedProductTypes, productTypes, AssociativeQueryEnum.PRODUCT_TYPE);
        excludeInfoMap.put("selectedProductTypes", selectedProductTypes);
        List<String> selectedOwnDepartments = excludeInfoMap.get("selectedOwnDepartments");
        selectedOwnDepartments = this.associativeFiledQueryService.getOwnDepartmentAssociativeQuery(associativeQueryVoList, keyword, selectedOwnDepartments, ownDepartmentList, AssociativeQueryEnum.PRODUCT_OWN_DEPARTMENTS);
        excludeInfoMap.put("selectedOwnDepartments", selectedOwnDepartments);
        List<String> selectedChargePersonIds = excludeInfoMap.get("selectedChargePersonIds");
        selectedChargePersonIds = this.associativeFiledQueryService.getChargePersonAssociativeQuery(associativeQueryVoList, keyword, selectedChargePersonIds, chargePersonIdList, AssociativeQueryEnum.PRODUCT_CHARGE_PERSON);
        excludeInfoMap.put("selectedChargePersonIds", selectedChargePersonIds);
        return associativeQueryVoList;
    }
}

