/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunity.service.impl;

import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.core.api.opportunity.dto.StageRecordDto;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityStageRecordVo;
import com.jxdinfo.crm.core.opportunity.dao.StageRecordMapper;
import com.jxdinfo.crm.core.opportunity.model.StageRecord;
import com.jxdinfo.crm.core.opportunity.service.IOpportunityPermissionService;
import com.jxdinfo.crm.core.opportunity.service.IStageRecordService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.time.LocalDate;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class StageRecordServiceImpl
extends HussarServiceImpl<StageRecordMapper, StageRecord>
implements IStageRecordService {
    @Resource
    private IOpportunityPermissionService opportunityPermissionService;
    @Resource
    private StageRecordMapper stageRecordMapper;

    @Override
    public List<OpportunityStageRecordVo> getStageRecordList(StageRecordDto dto, String searchType) {
        dto = this.updateParameter(dto);
        return this.stageRecordMapper.getStageRecordList(dto, searchType);
    }

    @Override
    public List<OpportunityStageRecordVo> getStageRecordListByProduct(StageRecordDto stageRecordDto) {
        stageRecordDto = this.updateParameter(stageRecordDto);
        return this.stageRecordMapper.getStageRecordListByProduct(stageRecordDto);
    }

    @Override
    public int insertRecordAndUpdateLeaveTime(StageRecord stageRecord) {
        this.save((BaseEntity)stageRecord);
        List<StageRecord> stageRecordList = this.stageRecordMapper.selectEntryRecordByStageId(stageRecord);
        if (CollectionUtil.isNotEmpty(stageRecordList)) {
            StageRecord lastStageRecord = stageRecordList.get(0);
            stageRecord.setLeaveTime(stageRecord.getEntryTime());
            this.updateById((BaseEntity)lastStageRecord);
        }
        return 1;
    }

    private StageRecordDto updateParameter(StageRecordDto dto) {
        DateConvertVo dateConvertVo;
        String stageFinishTimeFlag;
        DateConvertVo dateConvertVo2;
        String successTimeFlag;
        DateConvertVo dateConvertVo3;
        String endTimeFlag;
        DateConvertVo dateConvertVo4;
        String createTimeFlag = dto.getCreateTimeFlag();
        if (StringUtil.isNotEmpty((Object)createTimeFlag) && !"6".equals(createTimeFlag) && (dateConvertVo4 = CrmDateUtils.getCurrentTime((String)createTimeFlag)) != null) {
            dto.setCreateTimeStart(LocalDate.parse(dateConvertVo4.getStartDate()));
            dto.setCreateTimeEnd(LocalDate.parse(dateConvertVo4.getEndDate()));
        }
        if (StringUtil.isNotEmpty((Object)(endTimeFlag = dto.getEndTimeFlag())) && !"6".equals(endTimeFlag) && (dateConvertVo3 = CrmDateUtils.getCurrentTime((String)endTimeFlag)) != null) {
            dto.setEndTimeStart(LocalDate.parse(dateConvertVo3.getStartDate()));
            dto.setEndTimeEnd(LocalDate.parse(dateConvertVo3.getEndDate()));
        }
        if (StringUtil.isNotEmpty((Object)(successTimeFlag = dto.getSuccessTimeFlag())) && !"6".equals(successTimeFlag) && (dateConvertVo2 = CrmDateUtils.getCurrentTime((String)successTimeFlag)) != null) {
            dto.setSuccessTimeStart(LocalDate.parse(dateConvertVo2.getStartDate()));
            dto.setSuccessTimeStart(LocalDate.parse(dateConvertVo2.getEndDate()));
        }
        if (StringUtil.isNotEmpty((Object)(stageFinishTimeFlag = dto.getStageFinishTimeFlag())) && !"6".equals(stageFinishTimeFlag) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)stageFinishTimeFlag)) != null) {
            dto.setStageFinishTimeStart(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setStageFinishTimeEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        return dto;
    }
}

