/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunity.external.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.core.api.opportunity.dto.QueryDateDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityStageMapper;
import com.jxdinfo.crm.core.opportunity.external.dao.OpportunitySalesKPIMapper;
import com.jxdinfo.crm.core.opportunity.external.dto.SalesKPIDto;
import com.jxdinfo.crm.core.opportunity.external.service.IOpportunitySalesKPIService;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.opportunity.vo.OpportunityEntityVo;
import com.jxdinfo.crm.core.utills.entity.DateConvertVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OpportunitySalesKPIServiceImpl
implements IOpportunitySalesKPIService {
    @Resource
    private OpportunitySalesKPIMapper opportunitySalesKPIMapper;
    @Resource
    private IOrganUserBoService organUserBoService;
    @Resource
    private OpportunityStageMapper opportunityStageMapper;
    @Resource
    private OpportunityStageService opportunityStageService;

    @Override
    public Page<OpportunityEntity> selectOpportunityList(SalesKPIDto dto) {
        Page<OpportunityEntity> page = this.opportunityPageHandling(dto);
        SalesKPIDto salesStatisticsDto = this.salesStatisticsDtoHandling(dto);
        List allWinStageList = this.opportunityStageMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityStage::getStageType, (Object)"20")).eq(OpportunityStage::getDelFlag, (Object)"0")).stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        ArrayList<Long> stageWin = new ArrayList<Long>();
        if (CollectionUtil.isNotEmpty(dto.getStageIds())) {
            for (Long winStage : allWinStageList) {
                for (Long stage : dto.getStageIds()) {
                    if (!Objects.equals(stage, winStage)) continue;
                    stageWin.add(stage);
                }
            }
        }
        List<OpportunityEntity> list = this.opportunitySalesKPIMapper.selectOpportunityList(salesStatisticsDto, page, stageWin);
        page.setRecords(list);
        return page;
    }

    @Override
    public Page<OpportunityEntityVo> selectOpportunityProductList(SalesKPIDto dto) {
        Page<OpportunityEntityVo> page = this.opportunityProductPageHandling(dto);
        SalesKPIDto salesStatisticsDto = this.salesStatisticsDtoHandling(dto);
        int stageContainsWinFlag = 48;
        if (CollectionUtil.isNotEmpty(dto.getStageIds())) {
            List opportunityStageList = this.opportunityStageService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(OpportunityStage::getCustomerStageId, dto.getStageIds())).eq(OpportunityStage::getDelFlag, (Object)"0"));
            for (OpportunityStage os : opportunityStageList) {
                if (!"20".equals(os.getStageType())) continue;
                stageContainsWinFlag = 49;
            }
        }
        List<OpportunityEntityVo> list = this.opportunitySalesKPIMapper.selectProductList(salesStatisticsDto, page, (char)stageContainsWinFlag);
        page.setRecords(list);
        return page;
    }

    private Page<OpportunityEntity> opportunityPageHandling(SalesKPIDto dto) {
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        return page;
    }

    private Page<OpportunityEntityVo> opportunityProductPageHandling(SalesKPIDto dto) {
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        return page;
    }

    private SalesKPIDto salesStatisticsDtoHandling(SalesKPIDto dto) {
        DateConvertVo dateConverVo;
        dto.setDelFlag("0");
        if (ToolUtil.isNotEmpty(dto.getCreateTimeList())) {
            for (QueryDateDto dateDto : dto.getCreateTimeList()) {
                if (!ToolUtil.isNotEmpty((Object)dateDto.getTimeRange()) || (dateConverVo = IndexUtil.getCurrentTime(dateDto.getTimeRange())) == null) continue;
                dateDto.setStartTime(LocalDate.parse(dateConverVo.getStartDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                dateDto.setEndTime(LocalDate.parse(dateConverVo.getEndDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
        }
        if (ToolUtil.isNotEmpty(dto.getEndTimeList())) {
            for (QueryDateDto dateDto : dto.getEndTimeList()) {
                if (!ToolUtil.isNotEmpty((Object)dateDto.getTimeRange()) || (dateConverVo = IndexUtil.getCurrentTime(dateDto.getTimeRange())) == null) continue;
                dateDto.setStartTime(LocalDate.parse(dateConverVo.getStartDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                dateDto.setEndTime(LocalDate.parse(dateConverVo.getEndDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
        }
        if (ToolUtil.isNotEmpty(dto.getSuccessTimeList())) {
            for (QueryDateDto dateDto : dto.getSuccessTimeList()) {
                if (!ToolUtil.isNotEmpty((Object)dateDto.getTimeRange()) || (dateConverVo = IndexUtil.getCurrentTime(dateDto.getTimeRange())) == null) continue;
                dateDto.setStartTime(LocalDate.parse(dateConverVo.getStartDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                dateDto.setEndTime(LocalDate.parse(dateConverVo.getEndDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
        }
        if (ToolUtil.isNotEmpty(dto.getDeptIds())) {
            dto.setDeptIds(this.organUserBoService.getOrganByParentIdContainsParent(dto.getDeptIds()));
        }
        if (ToolUtil.isNotEmpty(dto.getCreateDepartmentList())) {
            dto.setCreateDepartmentList(this.organUserBoService.getOrganByParentIdContainsParent(dto.getCreateDepartmentList()));
        }
        return dto;
    }
}

