/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.contact.service.impl;

import com.jxdinfo.crm.core.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.core.associativeQuery.queryEnum.AssociativeQueryEnum;
import com.jxdinfo.crm.core.associativeQuery.service.AssociativeFiledQueryService;
import com.jxdinfo.crm.core.common.vo.AssociativeQueryVo;
import com.jxdinfo.crm.core.contact.dto.ContactAssociativeQueryDto;
import com.jxdinfo.crm.core.contact.dto.ContactDto;
import com.jxdinfo.crm.core.contact.service.IContactAssociativeQueryService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ContactAssociativeQueryServiceImpl
implements IContactAssociativeQueryService {
    @Resource
    private AssociativeFiledQueryService associativeFiledQueryService;

    @Override
    public List<AssociativeQueryVo> getAssociativeQueryVo(String keyword, AssociativeQueryDto associativeQueryDto, Map<String, List<String>> excludeInfoMap) {
        ArrayList<AssociativeQueryVo> associativeQueryVoList = new ArrayList<AssociativeQueryVo>();
        ContactAssociativeQueryDto contactAssociativeQueryDto = null;
        if (associativeQueryDto instanceof ContactAssociativeQueryDto) {
            contactAssociativeQueryDto = (ContactAssociativeQueryDto)associativeQueryDto;
        }
        assert (contactAssociativeQueryDto != null);
        ContactDto contactDto = contactAssociativeQueryDto.getDto();
        List<String> ownDepartmentList = null;
        List<String> chargePersonIdList = null;
        if (contactDto != null) {
            ownDepartmentList = contactDto.getOwnDepartments();
            chargePersonIdList = contactDto.getChargePersonIds();
        }
        List<String> selectedOwnDepartments = excludeInfoMap.get("ownDepartments");
        selectedOwnDepartments = this.associativeFiledQueryService.getOwnDepartmentAssociativeQuery(associativeQueryVoList, keyword, selectedOwnDepartments, ownDepartmentList, AssociativeQueryEnum.CONTACT_OWN_DEPARTMENTS);
        excludeInfoMap.put("ownDepartments", selectedOwnDepartments);
        List<String> selectedChargePersonIds = excludeInfoMap.get("chargePersonIds");
        selectedChargePersonIds = this.associativeFiledQueryService.getChargePersonAssociativeQuery(associativeQueryVoList, keyword, selectedChargePersonIds, chargePersonIdList, AssociativeQueryEnum.CONTACT_CHARGE_PERSON);
        excludeInfoMap.put("chargePersonIds", selectedChargePersonIds);
        return associativeQueryVoList;
    }
}

