/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.vehicleapplication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.customer.dto.CustomerDto;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.vehicleapplication.dao.VehicleApplicationMapper;
import com.jxdinfo.crm.core.vehicleapplication.dto.VehicleApplicationDto;
import com.jxdinfo.crm.core.vehicleapplication.model.User;
import com.jxdinfo.crm.core.vehicleapplication.model.VehicleApplication;
import com.jxdinfo.crm.core.vehicleapplication.service.VehicleApplicationService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VehicleApplicationServiceImpl
extends ServiceImpl<VehicleApplicationMapper, VehicleApplication>
implements VehicleApplicationService {
    @Resource
    private VehicleApplicationMapper vehicleApplicationMapper;
    @Resource
    private CrmCommonProperties crmProperties;

    @Override
    @Transactional
    public boolean addVehicleApplication(VehicleApplicationDto dto) {
        if (StringUtil.isEmpty((Object)dto.getUserIdChar())) {
            throw new BaseException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((Object)dto.getRelevancyVehicle())) {
            throw new BaseException("\u5173\u8054\u7528\u8f66\u7533\u8bf7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        VehicleApplication vehicleApplication1 = (VehicleApplication)this.vehicleApplicationMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(VehicleApplication::getRelevancyVehicle, (Object)dto.getRelevancyVehicle())).eq(VehicleApplication::getDelFlag, (Object)"0"));
        if (StringUtil.isNotEmpty((Object)vehicleApplication1)) {
            this.vehicleApplicationMapper.update(null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(VehicleApplication::getRelevancyVehicle, (Object)dto.getRelevancyVehicle())).set(VehicleApplication::getDelFlag, (Object)"1"));
        }
        if ("1".equals(dto.getVehicleType())) {
            return true;
        }
        LocalDateTime date = LocalDateTime.now();
        User user = this.vehicleApplicationMapper.selectUserByChar1(dto.getUserIdChar());
        if (ToolUtil.isEmpty((Object)user)) {
            throw new BaseException("\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime vehicleStartTime = LocalDateTime.parse(dto.getVehicleStartTime(), df);
        LocalDateTime vehicleFinalTime = LocalDateTime.parse(dto.getVehicleFinalTime(), df);
        VehicleApplication vehicleApplication = new VehicleApplication();
        vehicleApplication.setApplicationId(Long.valueOf(CommonUtills.generateAssignId()));
        vehicleApplication.setRelevancyCustomerId(Long.valueOf(dto.getRelevancyCustomerId()));
        vehicleApplication.setRelevancyCustomerName(dto.getRelevancyCustomerName());
        vehicleApplication.setVehicleType(dto.getVehicleType());
        vehicleApplication.setVehicleStartTime(vehicleStartTime);
        vehicleApplication.setVehicleFinalTime(vehicleFinalTime);
        vehicleApplication.setVehicleReason(dto.getVehicleReason());
        vehicleApplication.setCreateTime(date);
        vehicleApplication.setCreatePerson(user.getUserId());
        vehicleApplication.setCreatePersonName(user.getUserName());
        vehicleApplication.setOwnDepartment(user.getDepartmentId());
        vehicleApplication.setOwnDepartmentName(user.getDepartmentName());
        vehicleApplication.setVehicleApplicationType("0");
        vehicleApplication.setRelevancyVehicle(dto.getRelevancyVehicle());
        vehicleApplication.setDelFlag("0");
        return this.save(vehicleApplication);
    }

    @Override
    public boolean updateVehicleApplicationType(String relevancyVehicle, String vehicleApplicationType) {
        this.vehicleApplicationMapper.updateVehicleApplicationType(relevancyVehicle, vehicleApplicationType, "0");
        return true;
    }

    @Override
    public List<CustomerEntity> selectCustomerListByUserId(CustomerDto dto) {
        if (StringUtil.isEmpty((Object)dto.getUserIdChar())) {
            throw new BaseException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        User user = this.vehicleApplicationMapper.selectUserByChar1(dto.getUserIdChar());
        if (ToolUtil.isEmpty((Object)user)) {
            throw new BaseException("\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (ToolUtil.isNotEmpty((Object)dto.getCustomerScreeningCustomerName())) {
            dto.setCustomerScreeningCustomerName(dto.getCustomerScreeningCustomerName().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        if (ToolUtil.isNotEmpty((Object)dto.getDelFlag())) {
            dto.setDelFlag("0");
        }
        SalesStatisticsDto salesStatisticsDto = new SalesStatisticsDto();
        this.currentUserRolePermissions(salesStatisticsDto, user.getUserId(), user.getDepartmentId());
        return this.vehicleApplicationMapper.selectCustomerByChargePersonId(dto, salesStatisticsDto);
    }

    @Override
    public void currentUserRolePermissions(SalesStatisticsDto dto, Long userId, Long deptId) {
        dto.setCurrentUserId(userId);
        List<Map<String, Long>> struList = DataPermission.getStruCache();
        List<Long> leadershipRoles = DataPermission.getLeadershipRoles();
        List<Long> roleList = this.vehicleApplicationMapper.getUserRoleList(userId);
        if (roleList.contains(Long.valueOf(this.crmProperties.getRoles().getCompanyLeader()))) {
            dto.setPermissionDeptIds(null);
        } else if (DataPermission.isLeadship(roleList, leadershipRoles)) {
            List<String> struIds = DataPermission.getLeadershipBGList(userId);
            ArrayList<String> deptIdList = new ArrayList<String>();
            if (CollectionUtil.isNotEmpty(struIds)) {
                for (String struId : struIds) {
                    List<String> deptIds = DataPermission.getAllDeptIdByParentId(struList, Long.valueOf(struId));
                    deptIdList.addAll(deptIds);
                }
            }
            List<Long> deptLongIds = deptIdList.stream().map(Long::valueOf).collect(Collectors.toList());
            dto.setPermissionDeptIds(deptLongIds);
        } else if (roleList.contains(Long.valueOf(this.crmProperties.getRoles().getBgLeader()))) {
            Long parentId = DataPermission.getParentIdByDeptId(struList, deptId);
            List<String> deptIds = DataPermission.getAllDeptIdByParentId(struList, parentId);
            List<Long> deptLongIds = deptIds.stream().map(Long::valueOf).collect(Collectors.toList());
            dto.setPermissionDeptIds(deptLongIds);
        } else if (roleList.contains(Long.valueOf(this.crmProperties.getRoles().getSalesGM())) || roleList.contains(Long.valueOf(this.crmProperties.getRoles().getSalesDirector()))) {
            dto.setPermissionDeptIds(Collections.singletonList(deptId));
        } else {
            dto.setPermissionDeptIds(null);
            dto.setPermissionUserId(userId);
        }
    }
}

