/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.productprice.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.productprice.dao.ProductPriceMapper;
import com.jxdinfo.crm.core.productprice.dto.ProductPriceDto;
import com.jxdinfo.crm.core.productprice.model.ProductPriceEntity;
import com.jxdinfo.crm.core.productprice.service.ProductPriceService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ProductPriceServiceImpl
extends ServiceImpl<ProductPriceMapper, ProductPriceEntity>
implements ProductPriceService {
    @Resource
    private ProductPriceMapper productPriceMapper;
    @Resource
    private CommonService commonService;

    @Override
    public Page<ProductPriceEntity> selectCrmProductPriceList(ProductPriceDto dto) {
        Page page = dto.getPage();
        dto.setDelFlag("0");
        List<ProductPriceEntity> list = this.productPriceMapper.selectCrmProductPriceList(dto, page);
        page.setRecords(list);
        return page;
    }

    @Override
    public boolean addProductPrice(ProductPriceEntity productPriceEntity) {
        productPriceEntity.setProdouctPriceId(CommonUtills.generateAssignId());
        productPriceEntity.setProductPriceNumber(this.commonService.getNumber("CP"));
        return this.saveOrUpdate(productPriceEntity);
    }

    @Override
    public Integer deleteCrmProductPriceByProductPriceIds(List<String> productPricelIds) {
        int i = this.productPriceMapper.deleteCrmProductPriceByProductPriceIds(productPricelIds, "1");
        return i;
    }

    @Override
    public Page<ProductPriceEntity> selectProductPrice(ProductPriceDto productPriceDto) {
        Page page = productPriceDto.getPage();
        if (ToolUtil.isNotEmpty((Object)productPriceDto.getProdouctPriceScreening())) {
            productPriceDto.setProdouctPriceScreening(productPriceDto.getProdouctPriceScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        ArrayList<String> userIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(productPriceDto.getChargePersonIds()) && productPriceDto.getChargePersonIds().size() > 0) {
            for (String userId : productPriceDto.getChargePersonIds()) {
                userIds.add(CommonUtills.translateUserId(userId));
            }
        }
        List<String> departments = productPriceDto.getOwnDepartments();
        ArrayList<String> odpIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(departments) && departments.size() > 0) {
            for (String odpId : departments) {
                ArrayList<String> Ids;
                String odpIsTemp = CommonUtills.translateDepId(odpId);
                List<String> idsTemp = CommonUtills.selectOpportunityTissueTreeUserId(odpIsTemp, Ids = new ArrayList<String>());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    odpIds.add(idsTemp.get(i));
                }
            }
        }
        productPriceDto.setDelFlag("0");
        if (ToolUtil.isNotEmpty((Object)productPriceDto.getTimeOrder())) {
            switch (productPriceDto.getTimeOrder()) {
                case "1": {
                    productPriceDto.setTimeOrder("CREATE_TIME");
                    break;
                }
                case "2": {
                    productPriceDto.setTimeOrder("CREATE_TIME DESC");
                    break;
                }
                case "3": {
                    productPriceDto.setTimeOrder("CHANGE_TIME");
                    break;
                }
                case "4": {
                    productPriceDto.setTimeOrder("CHANGE_TIME DESC");
                    break;
                }
                default: {
                    productPriceDto.setTimeOrder("CREATE_TIME DESC");
                    break;
                }
            }
        } else {
            productPriceDto.setTimeOrder("CREATE_TIME DESC");
        }
        List<String> productTypes = productPriceDto.getProductTypes();
        List<ProductPriceEntity> list = this.productPriceMapper.selectProductPrice(productPriceDto, userIds, productTypes, odpIds, page);
        page.setRecords(list);
        return page;
    }
}

