/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunity.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityDto;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.GlobalOpportunityService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class GlobalOpportunityServiceImpl
implements GlobalOpportunityService {
    @Resource
    CrmCommonProperties crmProperties;
    @Resource
    OpportunityMapper opportunityMapper;

    @Override
    public Page<OpportunityEntity> selectCrmOpportunityList(OpportunityDto dto, Boolean byPermission) {
        SecurityUser user = BaseSecurityUtil.getUser();
        SalesStatisticsDto permissionDto = null;
        if (byPermission.booleanValue()) {
            permissionDto = this.opportunityOperate(dto, user);
        }
        dto = this.opportunityQueryCondition(dto);
        Page page = dto.getPage();
        ArrayList<OpportunityDto> dtoList = new ArrayList<OpportunityDto>();
        if (ToolUtil.isEmpty((Object)dto.getOpportunityView())) {
            dto.setOpportunityView("excludeProcessing");
        }
        dtoList.add(dto);
        List<OpportunityEntity> list = this.opportunityMapper.selectCrmOpportunityList(page, user.getUserId(), dtoList, permissionDto, dto.getTimeOrder(), null, null);
        page.setRecords(list);
        return page;
    }

    @Override
    public List<OpportunityEntity> selectCrmOpportunityListNoPage(OpportunityDto dto, Boolean byPermission) {
        SecurityUser user = BaseSecurityUtil.getUser();
        SalesStatisticsDto permissionDto = null;
        if (byPermission.booleanValue()) {
            permissionDto = this.opportunityOperate(dto, user);
        }
        dto = this.opportunityQueryCondition(dto);
        ArrayList<OpportunityDto> dtoList = new ArrayList<OpportunityDto>();
        if (ToolUtil.isEmpty((Object)dto.getOpportunityView())) {
            dto.setOpportunityView("excludeProcessing");
        }
        dtoList.add(dto);
        return this.opportunityMapper.selectCrmOpportunityList(null, user.getUserId(), dtoList, permissionDto, dto.getTimeOrder(), null, null);
    }

    private OpportunityDto opportunityQueryCondition(OpportunityDto dto) {
        DateConvertVo dateConvertVo;
        if (StringUtil.isNotBlank((CharSequence)dto.getEndTime()) && !"6".equals(dto.getEndTime()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getEndTime())) != null) {
            dto.setStartDate(dateConvertVo.getStartDate());
            dto.setEndDate(dateConvertVo.getEndDate());
        }
        if (StringUtil.isNotBlank((CharSequence)dto.getSuccessTimeRange()) && !"6".equals(dto.getSuccessTimeRange()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getSuccessTimeRange())) != null) {
            dto.setSuccessStartDate(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setSuccessEndDate(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        dto.setDelFlag("0");
        return dto;
    }

    @Override
    public Long selectCrmOpportunityCount(OpportunityDto dto, Boolean byPermission) {
        SecurityUser user = BaseSecurityUtil.getUser();
        SalesStatisticsDto permissionDto = null;
        if (byPermission.booleanValue()) {
            permissionDto = this.opportunityOperate(dto, user);
        }
        ArrayList<OpportunityDto> dtoList = new ArrayList<OpportunityDto>();
        dto.setDelFlag("0");
        if (ToolUtil.isEmpty((Object)dto.getOpportunityView())) {
            dto.setOpportunityView("excludeProcessing");
        }
        dtoList.add(dto);
        return this.opportunityMapper.selectCrmOpportunityCount(user.getUserId(), dtoList, permissionDto);
    }

    @Override
    public Long selectCrmOpportunityCountAgent(OpportunityDto dto, Boolean byPermission) {
        SecurityUser user = BaseSecurityUtil.getUser();
        SalesStatisticsDto permissionDto = null;
        if (byPermission.booleanValue()) {
            permissionDto = this.opportunityOperate(dto, user);
        }
        ArrayList<OpportunityDto> dtoList = new ArrayList<OpportunityDto>();
        dto.setDelFlag("0");
        dtoList.add(dto);
        return this.opportunityMapper.selectCrmOpportunityCountAgent(user.getUserId(), dtoList, permissionDto);
    }

    private SalesStatisticsDto opportunityOperate(OpportunityDto dto, SecurityUser user) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        IndexUtil.currentUserRolePermissions(permissionDto, this.crmProperties);
        if (user == null || ToolUtil.isEmpty((Object)user.getUserId())) {
            CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
            user = commonMapper.selectSecurityByUserId(dto.getCurrentUserId());
        }
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
            permissionDto.setPermissionDeptIds(null);
            permissionDto.setPermissionUserId(null);
        }
        return permissionDto;
    }
}

