/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.index.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.dto.TrackRecordAPIDto;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordAPIVo;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageSelectDto;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageTypeDto;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.crm.core.competitor.dao.CompetitorMapper;
import com.jxdinfo.crm.core.competitor.dto.CompetitorDto;
import com.jxdinfo.crm.core.competitor.model.Competitor;
import com.jxdinfo.crm.core.contact.dao.ContactMapper;
import com.jxdinfo.crm.core.contact.dto.ContactDto;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.customer.dao.CustomerMapper;
import com.jxdinfo.crm.core.customer.dto.CustomerDto;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.index.dao.CrmIndexMapper;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.service.CrmIndexService;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.index.vo.AllTypesVo;
import com.jxdinfo.crm.core.index.vo.LoseReasonCountVo;
import com.jxdinfo.crm.core.index.vo.MobileResourceModuleVo;
import com.jxdinfo.crm.core.index.vo.RecordCountVo;
import com.jxdinfo.crm.core.index.vo.SalesAddCountVo;
import com.jxdinfo.crm.core.index.vo.SalesBigCustomerVo;
import com.jxdinfo.crm.core.index.vo.SalesCountVo;
import com.jxdinfo.crm.core.index.vo.SalesFunnelVo;
import com.jxdinfo.crm.core.index.vo.SalesIncreaseVo;
import com.jxdinfo.crm.core.index.vo.SalesOpportunityProductCountVo;
import com.jxdinfo.crm.core.index.vo.SalesProductVo;
import com.jxdinfo.crm.core.index.vo.SalesRecordCountVo;
import com.jxdinfo.crm.core.leads.dao.LeadsMapper;
import com.jxdinfo.crm.core.leads.model.Leads;
import com.jxdinfo.crm.core.marketingactivity.dao.MarketingActivityMapper;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityDto;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.vo.OpportunityEntityVo;
import com.jxdinfo.crm.core.task.dao.TaskMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CrmIndexServiceImpl
implements CrmIndexService {
    @Resource
    private CrmIndexMapper indexMapper;
    @Resource
    private CustomerMapper customerMapper;
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private ContactMapper contactMapper;
    @Resource
    private LeadsMapper leadsMapper;
    @Resource
    private MarketingActivityMapper marketingActivityMapper;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private ISysStruService struService;
    @Resource
    private TaskMapper taskMapper;
    @Resource
    private CompetitorMapper competitorMapper;
    @Resource
    private IStageProcessApiService stageProcessApiService;

    @Override
    public List<MobileResourceModuleVo> getMobileMenu() {
        return this.indexMapper.getMobileMenu();
    }

    @Override
    public Page<TrackRecordAPIVo> selectTodayList(TrackRecordAPIDto recordDto) {
        Page page = new Page();
        if (recordDto.getCurrent() != null) {
            page.setCurrent((long)recordDto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (recordDto.getSize() != null) {
            page.setSize((long)recordDto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        recordDto.setCreatePerson(user.getUserId());
        recordDto.setDelFlag("0");
        LocalDateTime date = LocalDateTime.now();
        List<TrackRecordAPIVo> list = this.indexMapper.selectRecordAndTaskList(recordDto, page);
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!list.get(i).getBusinessType().equals("8")) {
                ContactEntity contact;
                OpportunityEntity opportunity;
                CustomerEntity customer;
                if (list.get(i).getBusinessType().equals("1") && ToolUtil.isNotEmpty((Object)(customer = (CustomerEntity)this.customerMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerEntity::getCustomerId, (Object)list.get(i).getTypeId())).eq(CustomerEntity::getDelFlag, (Object)"0"))))) {
                    list.get(i).setBusinessName(customer.getCustomerName());
                }
                if (list.get(i).getBusinessType().equals("2") && ToolUtil.isNotEmpty((Object)(opportunity = (OpportunityEntity)this.opportunityMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityEntity::getOpportunityId, (Object)list.get(i).getTypeId())).eq(OpportunityEntity::getDelFlag, (Object)"0"))))) {
                    list.get(i).setBusinessName(opportunity.getOpportunityName());
                    list.get(i).setCustomerStageId(opportunity.getCustomerStageId());
                }
                if (list.get(i).getBusinessType().equals("3") && ToolUtil.isNotEmpty((Object)(contact = (ContactEntity)this.contactMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactEntity::getContactId, (Object)list.get(i).getTypeId())).eq(ContactEntity::getDelFlag, (Object)"0"))))) {
                    list.get(i).setBusinessName(contact.getContactName());
                }
                if (!list.get(i).getBusinessType().equals("4")) continue;
                list.remove(i);
                continue;
            }
            list.get(i).setOverDeadline(Boolean.valueOf(date.isAfter(list.get(i).getTaskLastTime())));
        }
        page.setRecords(list);
        return page;
    }

    @Override
    public SalesIncreaseVo increaseCount(SalesStatisticsDto dto) {
        dto.setDelFlag("0");
        dto.setLeadsState("4");
        dto.setVisitType("2");
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        dto.setWinStateIds(this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin());
        dto.setRecordProduceType(RecordProductTypeEnum.PRODUCE_SYSTEM.getId());
        IndexUtil.currentUserRolePermissions(dto, this.crmProperties);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
            dto.setPermissionDeptIds(null);
            dto.setPermissionUserId(null);
        }
        SalesIncreaseVo increaseVo = new SalesIncreaseVo();
        IndexUtil.getCurrentTimeRange(dto);
        StageTypeDto stageTypeDto2 = new StageTypeDto();
        stageTypeDto.setStageEnd(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto2);
        SalesAddCountVo currentCount = this.indexMapper.increaseCount(dto, stageSelectDto);
        IndexUtil.getLastTimeRange(dto);
        SalesAddCountVo lastCount = this.indexMapper.increaseCount(dto, stageSelectDto);
        dto.setTimeRange(null);
        dto.setStartTime(null);
        dto.setEndTime(null);
        SalesAddCountVo totalCount = this.indexMapper.increaseCount(dto, stageSelectDto);
        increaseVo.setCustomer(this.getSalesCountVo(Long.valueOf(currentCount.getCustomer()), Long.valueOf(lastCount.getCustomer()), "\u4e2a"));
        increaseVo.getCustomer().setTotal(String.valueOf(totalCount.getCustomer()));
        Double opportunityNum = currentCount.getOpportunity() != null ? Double.parseDouble(currentCount.getOpportunity().split("/")[1]) : 0.0;
        Double lastOpportunityNum = lastCount.getOpportunity() != null ? Double.parseDouble(lastCount.getOpportunity().split("/")[1]) : 0.0;
        SalesCountVo opportunity = this.getSalesCountVoForDouble(opportunityNum, lastOpportunityNum, "\u4e2a/\u4e07\u5143");
        String opportunityCount = "";
        if (currentCount.getOpportunity() == null) {
            opportunityCount = "0/0";
        } else {
            String addCount = currentCount.getOpportunity().split("/")[0];
            opportunityCount = addCount + "/" + new DecimalFormat("#,##0").format(opportunityNum / 10000.0);
        }
        opportunity.setAddCount(opportunityCount);
        increaseVo.setOpportunity(opportunity);
        Double totalOpportunityNum = totalCount.getOpportunity() != null ? Double.parseDouble(totalCount.getOpportunity().split("/")[1]) : 0.0;
        String totalOpportunityCount = "";
        if (totalCount.getOpportunity() == null) {
            totalOpportunityCount = "0/0";
        } else {
            String addCount = totalCount.getOpportunity().split("/")[0];
            totalOpportunityCount = addCount + "/" + new DecimalFormat("#,##0").format(totalOpportunityNum / 10000.0);
        }
        increaseVo.getOpportunity().setTotal(totalOpportunityCount);
        Double winOpportunityNum = currentCount.getWinOpportunity() != null ? Double.parseDouble(currentCount.getWinOpportunity().split("/")[1]) : 0.0;
        Double lastWinOpportunityNum = lastCount.getWinOpportunity() != null ? Double.parseDouble(lastCount.getWinOpportunity().split("/")[1]) : 0.0;
        SalesCountVo winOpportunity = this.getSalesCountVoForDouble(winOpportunityNum, lastWinOpportunityNum, "\u4e2a/\u4e07\u5143");
        String winOpportunityCount = "";
        if (currentCount.getWinOpportunity() == null) {
            winOpportunityCount = "0/0";
        } else {
            String winCount = currentCount.getWinOpportunity().split("/")[0];
            winOpportunityCount = winCount + "/" + new DecimalFormat("#,##0").format(winOpportunityNum / 10000.0);
        }
        winOpportunity.setAddCount(winOpportunityCount);
        increaseVo.setWinOpportunity(winOpportunity);
        Double totalWinOpportunityNum = totalCount.getWinOpportunity() != null ? Double.parseDouble(totalCount.getWinOpportunity().split("/")[1]) : 0.0;
        String totalWinOpportunityCount = "";
        if (totalCount.getWinOpportunity() == null) {
            totalWinOpportunityCount = "0/0";
        } else {
            String addCount = totalCount.getWinOpportunity().split("/")[0];
            totalWinOpportunityCount = addCount + "/" + new DecimalFormat("#,##0").format(totalWinOpportunityNum / 10000.0);
        }
        increaseVo.getWinOpportunity().setTotal(totalWinOpportunityCount);
        increaseVo.setRecord(this.getSalesCountVo(Long.valueOf(currentCount.getRecord()), Long.valueOf(lastCount.getRecord()), "\u6b21"));
        increaseVo.getRecord().setTotal(String.valueOf(totalCount.getRecord()));
        Double winProductNum = currentCount.getWinProduct() != null ? Double.parseDouble(currentCount.getWinProduct().split("/")[1]) : 0.0;
        Double lastWinProductNum = lastCount.getWinProduct() != null ? Double.parseDouble(lastCount.getWinProduct().split("/")[1]) : 0.0;
        SalesCountVo winProduct = this.getSalesCountVoForDouble(winProductNum, lastWinProductNum, "\u4e2a/\u4e07\u5143");
        String winProductCount = "";
        if (currentCount.getWinProduct() == null) {
            winProductCount = "0/0";
        } else {
            String winCount = currentCount.getWinProduct().split("/")[0];
            winProductCount = winCount + "/" + new DecimalFormat("#,##0").format(winProductNum / 10000.0);
        }
        winProduct.setAddCount(winProductCount);
        increaseVo.setWinProduct(winProduct);
        Double totalWinProductNum = totalCount.getWinProduct() != null ? Double.parseDouble(totalCount.getWinProduct().split("/")[1]) : 0.0;
        String totalWinProductCount = "";
        if (totalCount.getWinProduct() == null) {
            totalWinProductCount = "0/0";
        } else {
            String addCount = totalCount.getWinProduct().split("/")[0];
            totalWinProductCount = addCount + "/" + new DecimalFormat("#,##0").format(totalWinProductNum / 10000.0);
        }
        increaseVo.getWinProduct().setTotal(totalWinProductCount);
        Double followProductNum = currentCount.getFollowProduct() != null ? Double.parseDouble(currentCount.getFollowProduct().split("/")[1]) : 0.0;
        Double lastFollowProductNum = lastCount.getFollowProduct() != null ? Double.parseDouble(lastCount.getFollowProduct().split("/")[1]) : 0.0;
        SalesCountVo followProduct = this.getSalesCountVoForDouble(followProductNum, lastFollowProductNum, "\u4e2a/\u4e07\u5143");
        String followProductCount = "";
        if (currentCount.getFollowProduct() == null) {
            followProductCount = "0/0";
        } else {
            String winCount = currentCount.getFollowProduct().split("/")[0];
            followProductCount = winCount + "/" + new DecimalFormat("#,##0").format(followProductNum / 10000.0);
        }
        followProduct.setAddCount(followProductCount);
        increaseVo.setFollowProduct(followProduct);
        Double totalFollowProductNum = totalCount.getFollowProduct() != null ? Double.parseDouble(totalCount.getFollowProduct().split("/")[1]) : 0.0;
        String totalFollowProductCount = "";
        if (totalCount.getFollowProduct() == null) {
            totalFollowProductCount = "0/0";
        } else {
            String addCount = totalCount.getFollowProduct().split("/")[0];
            totalFollowProductCount = addCount + "/" + new DecimalFormat("#,##0").format(totalFollowProductNum / 10000.0);
        }
        increaseVo.getFollowProduct().setTotal(totalFollowProductCount);
        return increaseVo;
    }

    @Override
    public Page<CustomerEntity> increaseCustomer(SalesStatisticsDto dto) {
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        dto.setDelFlag("0");
        IndexUtil.currentUserRolePermissions(dto, this.crmProperties);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllCustomer()))) {
            dto.setPermissionDeptIds(null);
            dto.setPermissionUserId(null);
        }
        IndexUtil.getCurrentTimeRange(dto);
        List<CustomerEntity> list = this.indexMapper.getIncreaseCustomerPage(dto, (Page<CustomerEntity>)page);
        page.setRecords(list);
        return page;
    }

    @Override
    public Page<ContactEntity> increaseContact(SalesStatisticsDto dto) {
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        dto.setDelFlag("0");
        IndexUtil.currentUserRolePermissions(dto, this.crmProperties);
        IndexUtil.getCurrentTimeRange(dto);
        List<ContactEntity> list = this.indexMapper.getIncreaseContactPage(dto, (Page<ContactEntity>)page);
        page.setRecords(list);
        return page;
    }

    @Override
    public Page<Leads> increaseLeads(SalesStatisticsDto dto) {
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        dto.setDelFlag("0");
        IndexUtil.currentUserRolePermissions(dto, this.crmProperties);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
            dto.setPermissionDeptIds(null);
            dto.setPermissionUserId(null);
        }
        IndexUtil.getCurrentTimeRange(dto);
        List<Leads> list = this.indexMapper.getIncreaseLeadsPage(dto, (Page<Leads>)page);
        page.setRecords(list);
        return page;
    }

    @Override
    public Page<OpportunityEntity> increaseOpportunity(SalesStatisticsDto dto) {
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        dto.setDelFlag("0");
        IndexUtil.currentUserRolePermissions(dto, this.crmProperties);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
            dto.setPermissionDeptIds(null);
            dto.setPermissionUserId(null);
        }
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        stageTypeDto.setStageEnd(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
        List winStageIds = stageSelectDto.getStageWin();
        if (ToolUtil.isNotEmpty((Object)dto.getWinStateId()) && winStageIds.stream().map(String::valueOf).collect(Collectors.toList()).contains(dto.getWinStateId())) {
            IndexUtil.getCurrentTimeRange(dto);
        } else {
            dto.setTimeRange(null);
            dto.setStartTime(null);
            dto.setEndTime(null);
        }
        List stageEnd = stageSelectDto.getStageEnd();
        List<OpportunityEntity> list = this.indexMapper.getIncreaseOpportunityPage(dto, (Page<OpportunityEntity>)page, stageEnd);
        page.setRecords(list);
        return page;
    }

    @Override
    public Page<TrackRecordAPIVo> increaseRecord(SalesStatisticsDto dto) {
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        dto.setDelFlag("0");
        dto.setRecordProduceType(RecordProductTypeEnum.PRODUCE_SYSTEM.getId());
        IndexUtil.currentUserRolePermissions(dto, this.crmProperties);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
            dto.setPermissionDeptIds(null);
            dto.setPermissionUserId(null);
        }
        IndexUtil.getCurrentTimeRange(dto);
        if (dto.getDeptIds() != null && dto.getDeptIds().size() == 1 && StringUtil.isNotBlank((CharSequence)dto.getDeptIds().get(0).toString()) && !"1".equals(dto.getDeptIds().get(0).toString())) {
            SysStru sysStru = (SysStru)this.struService.getById((Serializable)((Object)dto.getDeptIds().get(0).toString()));
            if ("2".equals(sysStru.getStruType())) {
                List<String> deptIds = new ArrayList<String>();
                deptIds.add(dto.getDeptIds().get(0).toString());
                deptIds = IndexUtil.getSubDeptId(deptIds);
                List<Long> newDeptIds = deptIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                dto.setDeptIds(newDeptIds);
            }
        } else if (dto.getDeptIds() != null && dto.getDeptIds().size() == 1 && "100001".equals(dto.getDeptIds().get(0).toString())) {
            dto.setDeptIds(null);
        }
        List<TrackRecordAPIVo> record = this.indexMapper.getIncreaseRecordPage(dto, (Page<TrackRecordAPIVo>)page);
        page.setRecords(record);
        return page;
    }

    @Override
    public List<SalesFunnelVo> funnelCount(SalesStatisticsDto dto) {
        dto.setDelFlag("0");
        IndexUtil.getCurrentTimeRange(dto);
        IndexUtil.currentUserRolePermissions(dto, this.crmProperties);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
            dto.setPermissionDeptIds(null);
            dto.setPermissionUserId(null);
        }
        if (StringUtil.isBlank((CharSequence)dto.getChooseTime())) {
            dto.setChooseTime("1");
        }
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        stageTypeDto.setStageOnGoing(true);
        stageTypeDto.setStageStart(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
        ArrayList<Long> stageStartToWin = new ArrayList<Long>();
        stageStartToWin.addAll(stageSelectDto.getStageWin());
        stageStartToWin.addAll(stageSelectDto.getStageStart());
        stageStartToWin.addAll(stageSelectDto.getStageOnGoing());
        return this.indexMapper.funnelCount(dto, stageStartToWin);
    }

    @Override
    public List<SalesBigCustomerVo> bigCustomerCount(SalesStatisticsDto dto) {
        dto.setDelFlag("0");
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        dto.setWinStateIds(this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin());
        IndexUtil.getCurrentTimeRange(dto);
        IndexUtil.currentUserRolePermissions(dto, this.crmProperties);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllCustomer()))) {
            dto.setPermissionDeptIds(null);
            dto.setPermissionUserId(null);
        }
        return this.indexMapper.bigCustomerCount(dto);
    }

    @Override
    public List<SalesProductVo> productCount(SalesStatisticsDto dto) {
        dto.setDelFlag("0");
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        stageTypeDto.setStageLose(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
        IndexUtil.getCurrentTimeRange(dto);
        IndexUtil.currentUserRolePermissions(dto, this.crmProperties);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
            dto.setPermissionDeptIds(null);
            dto.setPermissionUserId(null);
        }
        if (StringUtil.isBlank((CharSequence)dto.getChooseQuery())) {
            dto.setChooseQuery("1");
        }
        List<SalesProductVo> productList = this.indexMapper.getProductStatisticsList(dto);
        List<SalesOpportunityProductCountVo> productCount = this.indexMapper.getOpportunityProductCount(dto);
        if (productList == null) {
            return null;
        }
        if (CollectionUtil.isNotEmpty(productCount)) {
            block0: for (SalesProductVo productVo : productList) {
                boolean winFlag = false;
                boolean unfinishFlag = false;
                for (SalesOpportunityProductCountVo countVo : productCount) {
                    if (productVo.getProductId().toString().equals(countVo.getProductId().toString()) && "1".equals(countVo.getStageId().toString())) {
                        unfinishFlag = true;
                        productVo.setUnfinishCount(countVo.getProductCount());
                        productVo.setUnFinishAmount(countVo.getProductAmount());
                    } else if (productVo.getProductId().toString().equals(countVo.getProductId().toString()) && stageSelectDto.getStageWin().contains(countVo.getStageId())) {
                        winFlag = true;
                        productVo.setWinCount(countVo.getProductCount());
                        productVo.setWinAmount(countVo.getProductAmount());
                    }
                    if (!winFlag || !unfinishFlag) continue;
                    continue block0;
                }
            }
        }
        productList = "1".equals(dto.getChooseQuery()) ? productList.stream().sorted(Comparator.comparing(SalesProductVo::getUnfinishCount).reversed()).collect(Collectors.toList()) : productList.stream().sorted(Comparator.comparing(SalesProductVo::getUnFinishAmount).reversed()).collect(Collectors.toList());
        return productList;
    }

    @Override
    public List<SalesRecordCountVo> recordCount(SalesStatisticsDto dto) {
        dto.setDelFlag("0");
        dto.setRecordProduceType(RecordProductTypeEnum.PRODUCE_SYSTEM.getId());
        IndexUtil.currentUserRolePermissions(dto, this.crmProperties);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
            dto.setPermissionDeptIds(null);
            dto.setPermissionUserId(null);
        }
        IndexUtil.getCurrentTimeRange(dto);
        return this.indexMapper.recordCount(dto);
    }

    @Override
    public Page<OpportunityEntityVo> increaseOpportunityProduct(SalesStatisticsDto dto) {
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        dto.setDelFlag("0");
        IndexUtil.currentUserRolePermissions(dto, this.crmProperties);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
            dto.setPermissionDeptIds(null);
            dto.setPermissionUserId(null);
        }
        IndexUtil.getCurrentTimeRange(dto);
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageOnGoing(true);
        stageTypeDto.setStageWin(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
        if ("1".equals(dto.getChooseProduct())) {
            dto.setStageIds(stageSelectDto.getStageWin());
        } else if ("2".equals(dto.getChooseProduct())) {
            dto.setStageIds(stageSelectDto.getStageOnGoing());
        }
        List<OpportunityEntityVo> getIncreaseOpportunityProduct = this.indexMapper.getIncreaseOpportunityProduct(dto, page);
        page.setRecords(getIncreaseOpportunityProduct);
        return page;
    }

    @Override
    public Page<TrackRecordAPIVo> recordList(SalesStatisticsDto dto) {
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        dto.setDelFlag("0");
        dto.setRecordProduceType(RecordProductTypeEnum.PRODUCE_SYSTEM.getId());
        dto.setRecordBusinessType("1");
        IndexUtil.getCurrentTimeRange(dto);
        if (dto.getDeptIds() != null && dto.getDeptIds().size() == 1 && StringUtil.isNotBlank((CharSequence)dto.getDeptIds().get(0).toString()) && !"1".equals(dto.getDeptIds().get(0).toString())) {
            SysStru sysStru = (SysStru)this.struService.getById((Serializable)((Object)dto.getDeptIds().get(0).toString()));
            if ("2".equals(sysStru.getStruType())) {
                List<String> deptIds = new ArrayList<String>();
                deptIds.add(dto.getDeptIds().get(0).toString());
                deptIds = IndexUtil.getSubDeptId(deptIds);
                List<Long> newDeptIds = deptIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                dto.setDeptIds(newDeptIds);
            }
        } else if (dto.getDeptIds() != null && dto.getDeptIds().size() == 1 && "100001".equals(dto.getDeptIds().get(0).toString())) {
            dto.setDeptIds(null);
        }
        List<TrackRecordAPIVo> record = this.indexMapper.getRecordVisitingPage(dto, (Page<TrackRecordAPIVo>)page);
        page.setRecords(record);
        return page;
    }

    @Override
    public List<LoseReasonCountVo> loseReason(SalesStatisticsDto dto) {
        dto.setDelFlag("0");
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageLose(true);
        List stageLose = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageLose();
        dto.setLoseStateIds(stageLose);
        dto.setLoseType("lost_type");
        IndexUtil.getCurrentTimeRange(dto);
        IndexUtil.currentUserRolePermissions(dto, this.crmProperties);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
            dto.setPermissionDeptIds(null);
            dto.setPermissionUserId(null);
        }
        if (dto.getDeptIds() != null && dto.getDeptIds().size() == 1 && StringUtil.isNotBlank((CharSequence)dto.getDeptIds().get(0).toString()) && !"100001".equals(dto.getDeptIds().get(0).toString())) {
            SysStru sysStru = (SysStru)this.struService.getById((Serializable)((Object)dto.getDeptIds().get(0).toString()));
            if ("2".equals(sysStru.getStruType())) {
                List<String> deptIds = new ArrayList<String>();
                deptIds.add(dto.getDeptIds().get(0).toString());
                deptIds = IndexUtil.getSubDeptId(deptIds);
                List<Long> newDeptIds = deptIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                dto.setDeptIds(newDeptIds);
            }
        } else if (dto.getDeptIds() != null && dto.getDeptIds().size() == 1 && "100001".equals(dto.getDeptIds().get(0).toString())) {
            dto.setDeptIds(null);
        }
        return this.indexMapper.loseReason(dto);
    }

    @Override
    public Page<OpportunityEntity> lostList(SalesStatisticsDto dto) {
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        dto.setDelFlag("0");
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageLose(true);
        List stageLose = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageLose();
        dto.setLoseStateIds(stageLose);
        IndexUtil.getCurrentTimeRange(dto);
        IndexUtil.currentUserRolePermissions(dto, this.crmProperties);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
            dto.setPermissionDeptIds(null);
            dto.setPermissionUserId(null);
        }
        if (dto.getDeptIds() != null && dto.getDeptIds().size() == 1 && StringUtil.isNotBlank((CharSequence)dto.getDeptIds().get(0).toString()) && !"100001".equals(dto.getDeptIds().get(0).toString())) {
            SysStru sysStru = (SysStru)this.struService.getById((Serializable)((Object)dto.getDeptIds().get(0).toString()));
            if ("2".equals(sysStru.getStruType())) {
                List<String> deptIds = new ArrayList<String>();
                deptIds.add(dto.getDeptIds().get(0).toString());
                deptIds = IndexUtil.getSubDeptId(deptIds);
                List<Long> newDeptIds = deptIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                dto.setDeptIds(newDeptIds);
            }
        } else if (dto.getDeptIds() != null && dto.getDeptIds().size() == 1 && "100001".equals(dto.getDeptIds().get(0).toString())) {
            dto.setDeptIds(null);
        }
        List<OpportunityEntity> list = this.indexMapper.loseListPage(dto, (Page<OpportunityEntity>)page);
        page.setRecords(list);
        return page;
    }

    @Override
    public List<RecordCountVo> selectRecordAndTaskCountList(String dateYearAndMonth) {
        SecurityUser user = BaseSecurityUtil.getUser();
        return this.indexMapper.selectRecordAndTaskCountList(dateYearAndMonth, user.getUserId());
    }

    private SalesCountVo getSalesCountVo(Long currentCount, Long lastCount, String measure) {
        SalesCountVo countVo = new SalesCountVo();
        countVo.setAddCount(String.valueOf(currentCount));
        countVo.setMeasure(measure);
        if (currentCount >= lastCount) {
            countVo.setRising(true);
            countVo.setSequential(this.calculatePercent(currentCount - lastCount, currentCount.longValue()));
        } else {
            countVo.setSequential(this.calculatePercent(lastCount - currentCount, lastCount.longValue()));
            countVo.setRising(false);
        }
        return countVo;
    }

    private SalesCountVo getSalesCountVoForDouble(Double currentCount, Double lastCount, String measure) {
        SalesCountVo countVo = new SalesCountVo();
        countVo.setAddCount(String.valueOf(currentCount));
        countVo.setMeasure(measure);
        if (currentCount >= lastCount) {
            countVo.setRising(true);
            countVo.setSequential(this.calculatePercent(currentCount - lastCount, currentCount));
        } else {
            countVo.setSequential(this.calculatePercent(lastCount - currentCount, lastCount));
            countVo.setRising(false);
        }
        return countVo;
    }

    private String calculatePercent(double number1, double number2) {
        if (number1 == 0.0) {
            return "0.00%";
        }
        return String.format("%.2f", number1 / number2 * 100.0) + "%";
    }

    @Override
    public AllTypesVo selectAllTypes(SalesStatisticsDto dto) {
        IndexUtil.currentUserRolePermissions(dto, this.crmProperties);
        SecurityUser user = BaseSecurityUtil.getUser();
        AllTypesVo allTypesVo = new AllTypesVo();
        String allName = dto.getAllName();
        ArrayList<CustomerDto> dtoList = new ArrayList<CustomerDto>();
        CustomerDto customerDto = new CustomerDto();
        customerDto.setAllType(allName);
        customerDto.setDelFlag("0");
        customerDto.setCurrentUserId(user.getUserId());
        dtoList.add(customerDto);
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllCustomer()))) {
            dto.setPermissionDeptIds(null);
            dto.setPermissionUserId(null);
        }
        List<CustomerEntity> customerEntityList = this.customerMapper.selectCustomerListCountOpportunity(dtoList, null, customerDto.getTimeOrder(), customerDto.getCurrentUserId(), dto);
        allTypesVo.setCustomerEntityList(customerEntityList);
        allTypesVo.setTotalCustomer(customerEntityList.size());
        IndexUtil.currentUserRolePermissions(dto, this.crmProperties);
        ContactDto contactDto = new ContactDto();
        contactDto.setContactScreening(allName);
        contactDto.setDelFlag("0");
        contactDto.setCurrentUserId(user.getUserId());
        ArrayList<ContactDto> contactDtoList = new ArrayList<ContactDto>();
        contactDtoList.add(contactDto);
        List<ContactEntity> contactList = this.contactMapper.selectContactList(contactDtoList, null, contactDto.getCurrentUserId(), contactDto.getTimeOrder(), dto);
        allTypesVo.setContactEntityList(contactList);
        allTypesVo.setTotalContact(contactList.size());
        OpportunityDto opportunityDto = new OpportunityDto();
        opportunityDto.setDelFlag("0");
        opportunityDto.setCurrentUserId(user.getUserId());
        opportunityDto.setAllType(allName);
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
            dto.setPermissionDeptIds(null);
            dto.setPermissionUserId(null);
        }
        ArrayList<OpportunityDto> opportunityDtoList = new ArrayList<OpportunityDto>();
        opportunityDtoList.add(opportunityDto);
        List<OpportunityEntity> opportunityEntityList = this.opportunityMapper.selectCrmOpportunityList(null, user.getUserId(), opportunityDtoList, dto, opportunityDto.getTimeOrder(), null, null);
        allTypesVo.setOpportunityEntityList(opportunityEntityList);
        allTypesVo.setTotalOpportunity(opportunityEntityList.size());
        CompetitorDto competitorDto = new CompetitorDto();
        competitorDto.setDelFlag("0");
        competitorDto.setCompetitorScreening(allName);
        competitorDto.setCurrentUserId(user.getUserId());
        List<Competitor> competitorList = this.competitorMapper.selectCrmCompetitorList(competitorDto, null);
        allTypesVo.setCompetitorList(competitorList);
        allTypesVo.setTotalCompetitor(competitorList.size());
        return allTypesVo;
    }
}

