/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.customer.service.impl;

import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.customer.dao.CustomerPermissionMapper;
import com.jxdinfo.crm.core.customer.service.ICustomerPermissionService;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CustomerPermissionServiceImpl
implements ICustomerPermissionService {
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private CustomerPermissionMapper customerPermissionMapper;

    @Override
    public List<Long> getCustomerIdListByPermission(Long userId) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        SecurityUser user = new SecurityUser();
        if (userId == null) {
            user = BaseSecurityUtil.getUser();
            IndexUtil.currentUserRolePermissions(permissionDto, this.crmProperties);
        } else {
            CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
            user = commonMapper.selectSecurityByUserId(userId);
            IndexUtil.getUserRolePermissionsByUserId(permissionDto, this.crmProperties, userId);
        }
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllCustomer()))) {
            permissionDto.setPermissionDeptIds(null);
            permissionDto.setPermissionUserId(null);
        }
        if (permissionDto.getPermissionDeptIds() == null && permissionDto.getPermissionUserId() == null) {
            return null;
        }
        List<Long> customerIdList = this.customerPermissionMapper.getCustomerIdList(permissionDto);
        if (CollectionUtil.isEmpty(customerIdList)) {
            customerIdList.add(-1L);
        }
        return customerIdList;
    }
}

