/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.yyzc.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.customer.dto.YyzcCustomerDto;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.customer.vo.YyzcCustomerVo;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.product.dto.YyzcProductDto;
import com.jxdinfo.crm.core.product.service.ProductService;
import com.jxdinfo.crm.core.product.vo.YyzcProductVo;
import com.jxdinfo.crm.core.vehicleapplication.dao.VehicleApplicationMapper;
import com.jxdinfo.crm.core.vehicleapplication.model.User;
import com.jxdinfo.crm.core.yyzc.client.OsApiClient;
import com.jxdinfo.crm.core.yyzc.client.conf.OsApiConf;
import com.jxdinfo.crm.core.yyzc.client.request.OsApiRequest;
import com.jxdinfo.crm.core.yyzc.dao.YyzcMapper;
import com.jxdinfo.crm.core.yyzc.dto.YyzcDto;
import com.jxdinfo.crm.core.yyzc.service.YyzcService;
import com.jxdinfo.crm.core.yyzc.vo.AssociatedBiddingVo;
import com.jxdinfo.crm.core.yyzc.vo.AssociatedContractVo;
import com.jxdinfo.crm.core.yyzc.vo.YyzcOpportunityVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.os.sdk.response.oauth2.OsResourceResponse;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class YyzcServiceImpl
implements YyzcService {
    @Resource
    private YyzcMapper yyzcMapper;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private VehicleApplicationMapper vehicleApplicationMapper;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private OsApiClient osApiClient;
    @Resource
    private OsApiConf osApiConf;
    @Resource
    private CustomerService customerService;
    @Resource
    private ProductService productService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;

    @Override
    public List<YyzcOpportunityVo> getOpportunityList(YyzcDto yyzcDto) {
        if (ToolUtil.isEmpty((Object)yyzcDto.getUserId())) {
            throw new BaseException("\u7528\u6237ID\u4e3a\u7a7a");
        }
        User user = this.vehicleApplicationMapper.selectUserByChar1(yyzcDto.getUserId());
        if (ToolUtil.isEmpty((Object)user)) {
            throw new BaseException("\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
        }
        SalesStatisticsDto permissionDto = this.yyzcOperate(user.getUserId());
        ArrayList<String> customerStageIds = new ArrayList<String>();
        String baseConfigKey = null;
        if (ToolUtil.isEmpty((Object)yyzcDto.getBusinessType())) {
            throw new BaseException("\u8bf7\u9009\u62e9\u67e5\u8be2\u7c7b\u578b");
        }
        Long chargeId = null;
        switch (yyzcDto.getBusinessType()) {
            case "1": {
                baseConfigKey = "stage_id_contract";
                break;
            }
            case "2": {
                baseConfigKey = "stage_id_bidding_info";
                break;
            }
            case "3": {
                chargeId = user.getUserId();
                break;
            }
        }
        if (StringUtil.isNotBlank((CharSequence)baseConfigKey)) {
            CrmBaseConfigVo crmBaseConfigVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey(baseConfigKey);
            String stageIds = crmBaseConfigVo.getConfigValue();
            customerStageIds.addAll(Arrays.asList(stageIds.split(",")));
        }
        List<YyzcOpportunityVo> list = this.yyzcMapper.selectYyzcOpportunityVoList(yyzcDto, permissionDto, customerStageIds, chargeId);
        this.translateOpportunity(list);
        return list;
    }

    @Override
    public Boolean updateOpportunityContractAmount(YyzcDto yyzcDto) {
        return null;
    }

    @Override
    public YyzcOpportunityVo getOpportunityStageById(YyzcDto yyzcDto) {
        if (ToolUtil.isEmpty((Object)yyzcDto.getOpportunityId())) {
            throw new BaseException("\u5546\u673aid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.yyzcMapper.selectOpportunityStageById(yyzcDto);
    }

    @Override
    public List<YyzcCustomerVo> getCustomerList(YyzcDto yyzcDto) {
        if (ToolUtil.isEmpty((Object)yyzcDto.getUserId())) {
            throw new BaseException("\u7528\u6237ID\u4e3a\u7a7a");
        }
        User user = this.vehicleApplicationMapper.selectUserByChar1(yyzcDto.getUserId());
        if (ToolUtil.isEmpty((Object)user)) {
            throw new BaseException("\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
        }
        SalesStatisticsDto permissionDto = this.yyzcOperate(user.getUserId());
        Long chargeId = user.getUserId();
        List<YyzcCustomerVo> getCustomerList = this.yyzcMapper.selectYyzcCustomerList(yyzcDto, permissionDto, chargeId);
        this.translateCustomer(getCustomerList);
        return getCustomerList;
    }

    private SalesStatisticsDto yyzcOperate(Long userId) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        IndexUtil.getUserRolePermissionsByUserId(permissionDto, this.crmProperties, userId);
        return permissionDto;
    }

    private void translateOpportunity(List<YyzcOpportunityVo> yyzcOpportunityVoList) {
        List states = this.sysDicRefService.getDicListByType("leads_state");
        List opportunityStageList = this.opportunityStageService.list();
        for (YyzcOpportunityVo yyzcOpportunityVo : yyzcOpportunityVoList) {
            if (ToolUtil.isNotEmpty((Object)yyzcOpportunityVo.getState())) {
                for (DicVo dicVo : states) {
                    if (!yyzcOpportunityVo.getState().equals(dicVo.getValue())) continue;
                    yyzcOpportunityVo.setState(dicVo.getLabel());
                }
            }
            if (!ToolUtil.isNotEmpty((Object)yyzcOpportunityVo.getCustomerStageId())) continue;
            for (OpportunityStage opportunityStage : opportunityStageList) {
                if (!yyzcOpportunityVo.getCustomerStageId().equals(String.valueOf(opportunityStage.getCustomerStageId()))) continue;
                yyzcOpportunityVo.setCustomerStageName(opportunityStage.getCustomerStageName());
            }
        }
    }

    private void translateCustomer(List<YyzcCustomerVo> yyzcCustomerVoList) {
        List customerTypes = this.sysDicRefService.getDicListByType("customerType");
        List customerOrigins = this.sysDicRefService.getDicListByType("customer_source");
        List customerLevels = this.sysDicRefService.getDicListByType("customer_level");
        List trades = this.sysDicRefService.getDicListByType("industry");
        for (YyzcCustomerVo yyzcCustomerVo : yyzcCustomerVoList) {
            if (ToolUtil.isNotEmpty((Object)yyzcCustomerVo.getCustomerType())) {
                String[] typeArray = yyzcCustomerVo.getCustomerType().split(",");
                List<String> typeList = Arrays.asList(typeArray);
                LinkedList<String> translateTypes = new LinkedList<String>();
                for (DicVo dicVo : customerTypes) {
                    if (!typeList.contains(dicVo.getValue())) continue;
                    translateTypes.add(dicVo.getLabel());
                }
                String customerType = StringUtil.join(translateTypes, (String)",");
                yyzcCustomerVo.setCustomerType(customerType);
            }
            if (ToolUtil.isNotEmpty((Object)yyzcCustomerVo.getCustomerOrigin())) {
                for (DicVo dicVo : customerOrigins) {
                    if (!yyzcCustomerVo.getCustomerOrigin().equals(dicVo.getValue())) continue;
                    yyzcCustomerVo.setCustomerOrigin(dicVo.getLabel());
                }
            }
            if (ToolUtil.isNotEmpty((Object)yyzcCustomerVo.getCustLevel())) {
                for (DicVo dicVo : customerLevels) {
                    if (!yyzcCustomerVo.getCustLevel().equals(dicVo.getValue())) continue;
                    yyzcCustomerVo.setCustLevel(dicVo.getLabel());
                }
            }
            if (!ToolUtil.isNotEmpty((Object)yyzcCustomerVo.getTrade())) continue;
            for (DicVo dicVo : trades) {
                if (!yyzcCustomerVo.getTrade().equals(dicVo.getValue())) continue;
                yyzcCustomerVo.setTrade(dicVo.getLabel());
            }
        }
    }

    @Override
    public List<AssociatedBiddingVo> getAssociatedBiddingList(Long opportunityId) {
        if (ToolUtil.isEmpty((Object)opportunityId)) {
            throw new BaseException("\u5546\u673aid\u4e3a\u7a7a");
        }
        LinkedList<AssociatedBiddingVo> associatedBiddingVoList = new LinkedList<AssociatedBiddingVo>();
        OsApiRequest request = new OsApiRequest();
        request.setOsApiRequestMapping("crmServiceImpl.getTbxxBySj");
        request.setParams("CRMSJ_ID", String.valueOf(opportunityId));
        List list = new ArrayList();
        try {
            if (this.osApiConf.isOsEnable()) {
                OsResourceResponse rep = this.osApiClient.execute(request);
                if (ToolUtil.isEmpty((Object)rep) || ToolUtil.isEmpty((Object)rep.getData())) {
                    return associatedBiddingVoList;
                }
                list = (List)JSON.parseObject((String)JSON.toJSONString((Object)rep.getData()), ArrayList.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String today = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date());
        if (CollectionUtil.isNotEmpty(list)) {
            for (Map queryMap : list) {
                String biddingNo = String.valueOf(queryMap.get("ZBBH"));
                String applicant = String.valueOf(queryMap.get("CREATEUSER"));
                String companyName = String.valueOf(queryMap.get("DWMC"));
                String biddingCompany = String.valueOf(queryMap.get("ZBGS"));
                String projectName = String.valueOf(queryMap.get("XMMC"));
                String createTime = String.valueOf(queryMap.get("CREATEDATE"));
                String bidOpenTime = String.valueOf(queryMap.get("KBRQ"));
                String bidStatus = "";
                if (ToolUtil.isNotEmpty(queryMap.get("KBRQ"))) {
                    bidStatus = bidOpenTime.compareTo(today) > 0 ? "\u672a\u5f00\u6807" : "\u5df2\u5f00\u6807";
                }
                String auditStatus = String.valueOf(queryMap.get("FLOWNODENAME"));
                String responseDepartment = String.valueOf(queryMap.get("YWBM"));
                String createDepartment = String.valueOf(queryMap.get("CREATEDEPT"));
                String description = String.valueOf(queryMap.get("XMMS"));
                AssociatedBiddingVo associatedBiddingVo = new AssociatedBiddingVo();
                associatedBiddingVo.setBiddingNo(biddingNo);
                associatedBiddingVo.setApplicant(applicant);
                associatedBiddingVo.setCompanyName(companyName);
                associatedBiddingVo.setBiddingCompany(biddingCompany);
                associatedBiddingVo.setProjectName(projectName);
                associatedBiddingVo.setCreateTime(createTime);
                associatedBiddingVo.setBidOpenTime(bidOpenTime);
                associatedBiddingVo.setBidStatus(bidStatus);
                associatedBiddingVo.setAuditStatus(auditStatus);
                associatedBiddingVo.setResponseDepartment(responseDepartment);
                associatedBiddingVo.setCreateDepartment(createDepartment);
                associatedBiddingVo.setDescription(description);
                associatedBiddingVoList.add(associatedBiddingVo);
            }
        }
        return associatedBiddingVoList;
    }

    @Override
    public List<AssociatedContractVo> getAssociatedContractList(Long opportunityId) {
        if (ToolUtil.isEmpty((Object)opportunityId)) {
            throw new BaseException("\u5546\u673aid\u4e3a\u7a7a");
        }
        OsApiRequest request = new OsApiRequest();
        ArrayList<AssociatedContractVo> associatedContractVoList = new ArrayList<AssociatedContractVo>();
        request.setOsApiRequestMapping("crmServiceImpl.getAssociationContractList");
        request.setParams("CRMSJ_ID", String.valueOf(opportunityId));
        List list = new ArrayList();
        try {
            if (this.osApiConf.isOsEnable()) {
                OsResourceResponse rep = this.osApiClient.execute(request);
                if (ToolUtil.isEmpty((Object)rep) || ToolUtil.isEmpty((Object)rep.getData())) {
                    return associatedContractVoList;
                }
                list = (List)JSON.parseObject((String)JSON.toJSONString((Object)rep.getData()), ArrayList.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List roleIds = user.getRolesList();
        boolean marketManager = false;
        if (roleIds.contains(Long.valueOf(this.crmProperties.getRoles().getMarketingManager()))) {
            marketManager = true;
        }
        if (CollectionUtil.isNotEmpty(list)) {
            for (Map map : list) {
                String contractNo = String.valueOf(map.get("HTBH"));
                String contractName = String.valueOf(map.get("HTMC"));
                String contractType = String.valueOf(map.get("HTFL"));
                String paper = String.valueOf(map.get("ZZHT"));
                String ownCompany = String.valueOf(map.get("GSGS"));
                String contractAmount = String.valueOf(map.get("HTJE"));
                String outsourcedAmount = String.valueOf(map.get("WGJE"));
                String netContractAmount = String.valueOf(map.get("JHTE"));
                String paymentRatio = String.valueOf(map.get("HKBL"));
                String approvalStatus = String.valueOf(map.get("FLOWNODENAME"));
                AssociatedContractVo associatedContractVo = new AssociatedContractVo();
                associatedContractVo.setContractNo(contractNo);
                associatedContractVo.setContractName(contractName);
                associatedContractVo.setContractType(contractType);
                associatedContractVo.setPaper(paper);
                associatedContractVo.setOwnCompany(ownCompany);
                associatedContractVo.setContractAmount(contractAmount);
                associatedContractVo.setOutsourcedAmount(outsourcedAmount);
                associatedContractVo.setNetContractAmount(netContractAmount);
                associatedContractVo.setPaymentRatio(paymentRatio);
                associatedContractVo.setApprovalStatus(approvalStatus);
                if (marketManager) {
                    String customizedAmount = String.valueOf(map.get("XMDZHHTJE"));
                    String registeredProductAmount = String.valueOf(map.get("CPJE"));
                    String manpowerContractAmount = String.valueOf(map.get("RLHTJE"));
                    String customerName = String.valueOf(map.get("QYKHMC"));
                    String projectContractName = String.valueOf(map.get("QHXMMC"));
                    String effectiveContractAmount = String.valueOf(map.get("HTJE"));
                    String signTime = String.valueOf(map.get("QDRQ"));
                    String signDepartment = String.valueOf(map.get("QDBM"));
                    String contractChargePersonName = String.valueOf(map.get("HTFZR"));
                    associatedContractVo.setCustomizedAmount(customizedAmount);
                    associatedContractVo.setRegisteredProductAmount(registeredProductAmount);
                    associatedContractVo.setManpowerContractAmount(manpowerContractAmount);
                    associatedContractVo.setCustomerName(customerName);
                    associatedContractVo.setProjectContractName(projectContractName);
                    associatedContractVo.setEffectiveContractAmount(effectiveContractAmount);
                    associatedContractVo.setSignTime(signTime);
                    associatedContractVo.setSignDepartment(signDepartment);
                    associatedContractVo.setContractChargePersonName(contractChargePersonName);
                }
                associatedContractVoList.add(associatedContractVo);
            }
        }
        return associatedContractVoList;
    }

    @Override
    public Page<YyzcCustomerVo> getCustomers(YyzcCustomerDto yyzcCustomerDto) {
        return this.customerService.selectCustomerListYyzc(yyzcCustomerDto);
    }

    @Override
    public Page<YyzcProductVo> getProducts(YyzcProductDto yyzcProductDto) {
        return this.productService.selectProductListYyzc(yyzcProductDto);
    }
}

